/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.probe;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.agent.probe.Probe;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.Mounts;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.identity.MainframeLinuxHWID;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ProbeLinux
extends Probe {
    private static final String PROC_DASD_DEVICES = "/proc/dasd/devices";
    private static final String PROC_PARTITIONS = "/proc/partitions";
    private static final int IDA_DRIVER = 1;
    private static final int CCISS_DRIVER = 2;
    private static Map deviceTypes;

    private static native void initIDs();

    private native int probeSCSIDevice(String var1, boolean var2, String var3);

    private native int probeIDEDevice(String var1, Controller var2, int var3, int var4);

    private native void probeDASD(Disk var1) throws LocalizableException;

    private native int probeVpathDevice(String var1, Controller var2, int var3);

    private native int getComputerConfig();

    private static native boolean findPartitions(Disk var0, String var1);

    private Controller findDASDController(String driverName, int instance) {
        Controller result = this.computer.cmpController;
        while (result != null && !result.ctlrDriverName.equals(driverName) && result.ctlrInstance != instance) {
            result = result.ctlrNext;
        }
        if (result == null) {
            result = new Controller();
            result.ctlrType = (short)12;
            result.ctlrDriverName = driverName;
            result.ctlrInstance = (short)instance;
            result.ctlrBusNumber = 0;
            result.ctlrTarget = (short)-1;
            result.ctlrDriverDescription = " ";
            result.ctlrNext = this.computer.cmpController;
            this.computer.cmpController = result;
        }
        return result;
    }

    private void findSCSIDisks() throws GeneralException {
        boolean useSG;
        int[] sgNum;
        int scsiDevices;
        int i;
        StringBuffer buf;
        block32: {
            File isRedHat;
            File isSuse;
            FileReader raw;
            buf = new StringBuffer("/proc/scsi");
            File dir1 = new File(buf.toString());
            buf.append('/');
            String[] dir1entries = dir1.list();
            if (dir1entries == null) {
                MessageLog.logMessage((String)"STA0214I");
                return;
            }
            for (i = 0; i < dir1entries.length; ++i) {
                buf.append(dir1entries[i]);
                File file = new File(buf.toString());
                String[] dirEntries = file.list();
                if (dirEntries == null) {
                    buf.setLength(11);
                    continue;
                }
                for (int j = 0; j < dirEntries.length; ++j) {
                    int x;
                    try {
                        x = Integer.parseInt(dirEntries[j]);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    Controller ctlr = new Controller();
                    ctlr.ctlrNext = this.computer.cmpController;
                    this.computer.cmpController = ctlr;
                    ctlr.ctlrDriverName = dir1entries[i];
                    ctlr.ctlrDriverDescription = null;
                    ctlr.ctlrTarget = (short)-1;
                    ctlr.ctlrType = 0;
                    ctlr.ctlrInstance = (short)x;
                    this.getHBAPortWWN(buf, ctlr);
                }
                buf.setLength(11);
            }
            buf.setLength(11);
            buf.append("scsi");
            try {
                raw = new FileReader(buf.toString());
            }
            catch (IOException e) {
                MessageLog.logException((String)"STA0121E", (Exception)e, (Object)buf.toString());
                throw new GeneralException();
            }
            scsiDevices = 0;
            int scsiDisks = 0;
            sgNum = new int[512];
            BufferedReader cooked = new BufferedReader(raw);
            try {
                String line;
                while ((line = cooked.readLine()) != null) {
                    if (line.startsWith("Host:")) {
                        sgNum[scsiDisks] = -1;
                        ++scsiDevices;
                    }
                    if (line.indexOf("Direct-Access") <= -1) continue;
                    sgNum[scsiDisks] = scsiDevices - 1;
                    ++scsiDisks;
                }
            }
            catch (IOException e) {
                MessageLog.logException((String)"STA0119E", (Exception)e, (Object)buf.toString());
                this.rc = 4;
            }
            try {
                cooked.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            useSG = false;
            String cpuType = this.computer.cmpProcessorType.toLowerCase();
            File tFile = new File(Variables.homeDirectory + "/config/useSGIO.config");
            if (cpuType.indexOf("power5") > -1 || tFile.isFile()) {
                File sgInq;
                File sgVersion = new File("/proc/scsi/sg/version");
                if (sgVersion.isFile()) {
                    useSG = true;
                }
                if ((sgInq = new File("/usr/bin/sg_inq")).isFile()) {
                    useSG = true;
                }
            }
            if ((isSuse = new File("/etc/SuSE-release")).isFile()) {
                File sgInq;
                File sgVersion = new File("/proc/scsi/sg/version");
                if (sgVersion.isFile()) {
                    useSG = true;
                }
                if ((sgInq = new File("/usr/bin/sg_inq")).isFile()) {
                    useSG = true;
                }
            }
            if ((isRedHat = new File("/etc/redhat-release")).isFile()) {
                try {
                    File sgVersion;
                    BufferedReader in = new BufferedReader(new FileReader("/etc/redhat-release"));
                    StringTokenizer st = new StringTokenizer(in.readLine());
                    String server = null;
                    String version = null;
                    while (st.hasMoreTokens()) {
                        if (st.countTokens() == 4) {
                            server = st.nextToken();
                            continue;
                        }
                        if (st.countTokens() == 2) {
                            version = st.nextToken();
                            continue;
                        }
                        st.nextToken();
                    }
                    if (server.equals("AS") && version.equals("4") && (sgVersion = new File("/proc/scsi/sg/version")).isFile()) {
                        useSG = true;
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof FileNotFoundException)) break block32;
                    MessageLog.logException((String)"STA0500E", (Exception)e);
                }
            }
        }
        buf.setLength(0);
        buf.append("/dev/sd");
        StringBuffer sgBuf = new StringBuffer("/dev/sg");
        for (i = 0; i < scsiDevices && this.rc <= 4; ++i) {
            if (i >= 26) {
                char c = (char)(97 + i / 26 - 1);
                buf.append(c);
            }
            char c = (char)(97 + i % 26);
            buf.append(c);
            sgBuf.append(sgNum[i]);
            if (Agent.stopNow) {
                this.rc = 8;
                continue;
            }
            boolean sgFlag = useSG;
            if (useSG && sgNum[i] < 0) {
                sgFlag = false;
            }
            int x = this.probeSCSIDevice(buf.toString(), sgFlag, sgBuf.toString());
            buf.setLength(7);
            sgBuf.setLength(7);
            if (x <= this.rc) continue;
            this.rc = x;
        }
        if (this.rc > 4) {
            throw new GeneralException();
        }
    }

    private void getHBAPortWWN(StringBuffer buf, Controller ctlr) {
        FileReader raw;
        String myFile = buf.toString() + "/" + Integer.toString(ctlr.ctlrInstance);
        if (!new File(myFile).isFile()) {
            return;
        }
        try {
            raw = new FileReader(myFile);
        }
        catch (IOException e) {
            MessageLog.logException((String)"STA0800W", (Exception)e, (Object)myFile);
            this.rc = 4;
            return;
        }
        BufferedReader cooked = new BufferedReader(raw);
        try {
            String line;
            while ((line = cooked.readLine()) != null) {
                int z = line.indexOf("adapter-port=");
                if (z > -1) {
                    try {
                        String wwn = line.substring(z + 13, z + 29);
                        ctlr.ctlrHBAPortWWN = this.parseWWN(wwn);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        System.out.println("Port Line = " + line);
                    }
                } else {
                    z = line.indexOf("Portname:");
                    if (z <= -1) continue;
                    try {
                        String wwn = line.substring(z + 10, z + 33);
                        ctlr.ctlrHBAPortWWN = this.parseWWN(wwn);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        System.out.println("Port Line = " + line);
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            MessageLog.logException((String)"STA0800E", (Exception)e, (Object)myFile);
            this.rc = 4;
        }
        try {
            cooked.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private long parseWWN(String wwn) {
        long result = 0L;
        if ((wwn = wwn.trim()).indexOf(58) > -1) {
            StringBuffer buf = new StringBuffer(16);
            buf.append(wwn.substring(0, 2));
            buf.append(wwn.substring(3, 5));
            buf.append(wwn.substring(6, 8));
            buf.append(wwn.substring(9, 11));
            buf.append(wwn.substring(12, 14));
            buf.append(wwn.substring(15, 17));
            buf.append(wwn.substring(18, 20));
            buf.append(wwn.substring(21, 23));
            wwn = buf.toString();
        }
        wwn = wwn.toUpperCase();
        try {
            result = Long.parseLong(wwn, 16);
        }
        catch (NumberFormatException e) {
            result = -2L;
        }
        return result;
    }

    private void findVpaths() throws GeneralException {
        FileReader raw;
        ArrayList<String> vpathList = new ArrayList<String>(20);
        StringBuffer buf = new StringBuffer(PROC_PARTITIONS);
        try {
            raw = new FileReader(buf.toString());
        }
        catch (IOException e) {
            MessageLog.logException((String)"STA0121E", (Exception)e, (Object)buf.toString());
            throw new GeneralException();
        }
        BufferedReader cooked = new BufferedReader(raw);
        try {
            String line;
            while ((line = cooked.readLine()) != null) {
                String token = null;
                StringTokenizer st = new StringTokenizer(line, " ");
                if (st.countTokens() <= 4) continue;
                for (int i = 0; i < 4; ++i) {
                    token = st.nextToken();
                }
                if (token == null || !token.startsWith("vpath") || Character.isDigit(token.charAt(token.length() - 1))) continue;
                vpathList.add(token);
            }
        }
        catch (IOException e) {
            MessageLog.logException((String)"STA0119E", (Exception)e, (Object)buf.toString());
            this.rc = 4;
        }
        try {
            cooked.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (vpathList.size() > 0) {
            Controller ctlr = new Controller();
            ctlr.ctlrNext = this.computer.cmpController;
            this.computer.cmpController = ctlr;
            ctlr.ctlrDriverName = "SDD";
            ctlr.ctlrDriverDescription = "IBM Subsystem Device Driver";
            ctlr.ctlrTarget = (short)-1;
            ctlr.ctlrType = (short)10;
            ctlr.ctlrInstance = (short)-1;
            for (int i = 0; i < vpathList.size() && this.rc <= 4; ++i) {
                buf.setLength(0);
                buf.append("/dev/");
                buf.append(vpathList.get(i));
                if (Agent.stopNow) {
                    this.rc = 8;
                    continue;
                }
                int x = this.probeVpathDevice(buf.toString(), ctlr, i);
                if (x <= this.rc) continue;
                this.rc = x;
            }
        }
        if (this.rc > 4) {
            throw new GeneralException();
        }
    }

    private void findIDEDisks() throws GeneralException {
        StringBuffer buf = new StringBuffer("/proc/ide");
        File topDir = new File(buf.toString());
        buf.append('/');
        String[] topDirEntries = topDir.list();
        if (topDirEntries == null) {
            MessageLog.logMessage((String)"STA0215I");
            return;
        }
        for (int i = 0; i < topDirEntries.length; ++i) {
            FileReader raw;
            int instance;
            if (!topDirEntries[i].startsWith("ide")) continue;
            try {
                instance = Integer.parseInt(topDirEntries[i].substring(3));
            }
            catch (NumberFormatException e) {
                continue;
            }
            buf.append(topDirEntries[i]);
            File ctlrDir = new File(buf.toString());
            buf.append('/');
            String[] ctlrDirEntries = ctlrDir.list();
            if (ctlrDirEntries == null) {
                MessageLog.logMessage((String)"STA0121E", (Object)buf.toString());
                throw new GeneralException();
            }
            Controller ctlr = new Controller();
            ctlr.ctlrNext = this.computer.cmpController;
            this.computer.cmpController = ctlr;
            ctlr.ctlrTarget = (short)-1;
            ctlr.ctlrType = 1;
            ctlr.ctlrInstance = (short)instance;
            ctlr.ctlrDriverName = "ide";
            ctlr.ctlrDriverDescription = " ";
            int length = buf.length();
            buf.append("model");
            BufferedReader cooked = null;
            try {
                raw = new FileReader(buf.toString());
                cooked = new BufferedReader(raw);
                String line = cooked.readLine();
                if (line != null) {
                    ctlr.ctlrDriverDescription = line;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (cooked != null) {
                try {
                    cooked.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            int seqNo = 0;
            for (int j = 0; j < ctlrDirEntries.length && this.rc <= 4; ++j) {
                buf.setLength(length);
                buf.append(ctlrDirEntries[j]);
                buf.append("/media");
                cooked = null;
                String deviceTypeString = null;
                try {
                    raw = new FileReader(buf.toString());
                    cooked = new BufferedReader(raw);
                    deviceTypeString = cooked.readLine();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (cooked == null) continue;
                try {
                    cooked.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (deviceTypeString == null) {
                    MessageLog.logMessage((String)"STA0119E", (Object)buf.toString());
                    throw new GeneralException();
                }
                Integer obj = (Integer)deviceTypes.get(deviceTypeString);
                int deviceType = obj != null ? obj : -1;
                if (Agent.stopNow) {
                    this.rc = 8;
                    continue;
                }
                if (deviceType == 1) continue;
                int rrc = this.probeIDEDevice("/dev/" + ctlrDirEntries[j], ctlr, seqNo, deviceType);
                if (rrc > this.rc) {
                    this.rc = rrc;
                }
                ++seqNo;
            }
            if (this.rc > 4) {
                throw new GeneralException();
            }
            buf.setLength(10);
        }
    }

    private static String readLine(BufferedReader in, String fileName) throws GeneralException {
        String result;
        try {
            result = in.readLine();
        }
        catch (IOException e) {
            MessageLog.logException((String)"GEN0133E", (Exception)e, (Object)fileName);
            try {
                in.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw new GeneralException();
        }
        return result;
    }

    private static long getNumber(String field, String line, int fieldNumber, char terminator, String fileName) throws GeneralException {
        int pos = field.indexOf(terminator);
        if (pos > 0) {
            field = field.substring(0, pos);
        }
        int result = -1;
        try {
            result = (int)Long.parseLong(field);
        }
        catch (NumberFormatException e) {
            Object[] parms = new Object[]{line, new Integer(fieldNumber), fileName};
            throw new GeneralException("STA0343E", parms);
        }
        return result;
    }

    private static BufferedReader openReader(String name) throws GeneralException {
        FileReader reader = null;
        try {
            reader = new FileReader(name);
        }
        catch (IOException e) {
            throw new GeneralException("GEN0029E", null, e.getMessage());
        }
        return new BufferedReader(reader);
    }

    private static void closeReader(Reader in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String makeDASDKey(int major, String dasdName) {
        StringBuffer buf = new StringBuffer(20);
        buf.append(major);
        buf.append('/');
        buf.append(dasdName);
        return buf.toString();
    }

    private static Map findDASDPartitions() throws GeneralException {
        String line;
        HashMap result = new HashMap();
        BufferedReader in = ProbeLinux.openReader(PROC_PARTITIONS);
        int lineCount = 0;
        String[] fields = new String[4];
        while ((line = ProbeLinux.readLine(in, PROC_PARTITIONS)) != null) {
            Chunk chunk;
            long x;
            int major;
            int i;
            if (lineCount <= 1) {
                ++lineCount;
                continue;
            }
            LinkedList list = Util.splitLine((String)line, (int)0);
            Iterator iterator = list.iterator();
            for (i = 0; i < fields.length && iterator.hasNext(); ++i) {
                fields[i] = (String)iterator.next();
            }
            if (i < fields.length) {
                ProbeLinux.closeReader(in);
                Object[] parms = new Object[]{line, PROC_PARTITIONS};
                throw new GeneralException("STA0344E", parms);
            }
            String partitionName = fields[3];
            for (i = partitionName.length(); i > 0 && Character.isDigit(partitionName.charAt(i - 1)); --i) {
            }
            if (i == partitionName.length()) continue;
            String diskName = partitionName.substring(0, i);
            String s = partitionName.substring(i);
            short partition = Short.parseShort(s);
            try {
                major = (int)ProbeLinux.getNumber(fields[0], line, 0, '\u0000', PROC_PARTITIONS);
                x = ProbeLinux.getNumber(fields[2], line, 2, '\u0000', PROC_PARTITIONS);
            }
            catch (GeneralException e) {
                ProbeLinux.closeReader(in);
                throw e;
            }
            x <<= 1;
            String key = ProbeLinux.makeDASDKey(major, diskName);
            list = (List)result.get(key);
            if (list == null) {
                list = new LinkedList();
                result.put(key, list);
            }
            boolean going = true;
            ListIterator<Chunk> listIterator = list.listIterator();
            while (going && listIterator.hasNext()) {
                chunk = (Chunk)listIterator.next();
                if (chunk.chkSeqno >= partition) continue;
                going = false;
            }
            if (!going) {
                listIterator.previous();
            }
            chunk = new Chunk();
            chunk.chkPartition = partition;
            chunk.chkUnitSize = 512;
            chunk.chkSize = x;
            listIterator.add(chunk);
        }
        ProbeLinux.closeReader(in);
        return result;
    }

    private void findDASD() throws GeneralException {
        String line;
        Map partitionMap = ProbeLinux.findDASDPartitions();
        BufferedReader in = ProbeLinux.openReader(PROC_DASD_DEVICES);
        while ((line = ProbeLinux.readLine(in, PROC_DASD_DEVICES)) != null) {
            String key;
            List list = Util.splitLine((String)line, (int)0);
            Iterator iterator = list.iterator();
            String path = null;
            String name = null;
            boolean foundAt = false;
            boolean foundIs = false;
            boolean foundBlocksize = false;
            int fieldNumber = -1;
            int major = -1;
            int blockSize = -1;
            long nBlocks = -1L;
            while (nBlocks < 0L && iterator.hasNext()) {
                ++fieldNumber;
                String field = (String)iterator.next();
                if (!foundAt) {
                    if (!field.equals("at")) continue;
                    foundAt = true;
                    continue;
                }
                if (major < 0) {
                    if (field.length() <= 1) continue;
                    if (field.charAt(0) == '(') {
                        field = field.substring(1);
                    }
                    try {
                        major = (int)ProbeLinux.getNumber(field, line, fieldNumber, ':', PROC_DASD_DEVICES);
                        continue;
                    }
                    catch (GeneralException e) {
                        ProbeLinux.closeReader(in);
                        throw e;
                    }
                }
                if (!foundIs) {
                    if (!field.equals("is")) continue;
                    foundIs = true;
                    continue;
                }
                if (path == null) {
                    int i = field.indexOf(58);
                    name = i > 0 ? field.substring(0, i) : field;
                    path = "/dev/" + name;
                    continue;
                }
                if (!foundBlocksize) {
                    if (!field.startsWith("blocksize")) continue;
                    foundBlocksize = true;
                    continue;
                }
                try {
                    if (blockSize < 0) {
                        blockSize = (int)ProbeLinux.getNumber(field, line, fieldNumber, ',', PROC_DASD_DEVICES);
                        continue;
                    }
                    nBlocks = ProbeLinux.getNumber(field, line, fieldNumber, ',', PROC_DASD_DEVICES);
                }
                catch (GeneralException e) {
                    ProbeLinux.closeReader(in);
                    throw e;
                }
            }
            if (path == null) {
                ProbeLinux.closeReader(in);
                Object[] parms = new Object[]{line, PROC_DASD_DEVICES};
                throw new GeneralException("STA0344E", parms);
            }
            DevAccess da = new DevAccess();
            da.daPath = path;
            Disk disk = new Disk();
            disk.initUnknown();
            da.daDevice = disk;
            disk.devControllers = da;
            disk.devType = 0;
            disk.devFirmwareRev = " ";
            disk.dskLogicalBlockSize = blockSize;
            disk.dskCapacity = nBlocks < 0L ? -1L : nBlocks * (long)blockSize >> 9;
            DiskHistory dkh = disk.dskHistory;
            dkh.dkhFreeSpace = -1L;
            if (Agent.stopNow) {
                throw new GeneralException("AGT0157E", (Object[])null);
            }
            try {
                this.probeDASD(disk);
            }
            catch (LocalizableException e) {
                disk = null;
                e.print();
                this.rc = 4;
            }
            if (disk == null) continue;
            dkh.dkhCapacity = disk.dskCapacity;
            if (MainframeLinuxHWID.underVM) {
                StringBuffer buf = new StringBuffer(64);
                buf.append(disk.devSerialNumber);
                buf.append(' ');
                buf.append(Agent.localName);
                buf.append(',');
                buf.append(name);
                disk.devSerialNumber = buf.toString();
            }
            if ((list = (List)partitionMap.get(key = ProbeLinux.makeDASDKey(major, name))) == null) continue;
            for (Chunk chunk : list) {
                chunk.chkDisk = disk;
                chunk.chkNextOnDisk = disk.dskChunk;
                disk.dskChunk = chunk;
            }
            long offset = 0L;
            for (Chunk chunk : list) {
                chunk.chkOffset = offset;
                offset += chunk.chkSize;
            }
            dkh.dkhFreeSpace = dkh.dkhCapacity - offset;
        }
        ProbeLinux.closeReader(in);
    }

    private static String stripLeadingSpace(String line, int pos) {
        int length = line.length();
        while (pos < length && Character.isWhitespace(line.charAt(pos))) {
            ++pos;
        }
        line = pos < length ? line.substring(pos) : " ";
        return line;
    }

    private static String extractCompaqDescription(String line) {
        String result = " ";
        int pos = line.indexOf(58);
        if (pos >= 0) {
            result = ProbeLinux.stripLeadingSpace(line, pos + 1);
        }
        return result;
    }

    private boolean parseCompaqVolume(Controller ctlr, String line, int pos, String ctlrSig, String firmwareRev, int driverType) {
        boolean ok;
        int diskNumber = -1;
        int pos2 = line.lastIndexOf(100, pos);
        if (pos2 > 0 && Character.isDigit(line.charAt(pos2 - 1))) {
            try {
                diskNumber = Integer.parseInt(line.substring(pos2 + 1, pos));
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        if (diskNumber < 0) {
            Object[] args = new Object[]{new Integer(ctlr.ctlrInstance), line};
            MessageLog.logMessage((String)"STA0261E", (Object[])args);
            return false;
        }
        int length = line.length();
        int sectorSize = -1;
        long nBlocks = -1L;
        String msgID = null;
        if (driverType == 1) {
            int pos3 = line.indexOf("blksz=", pos);
            if (pos3 > 0) {
                for (pos2 = pos3 += 6; pos2 < length && Character.isDigit(line.charAt(pos2)); ++pos2) {
                }
                try {
                    sectorSize = Integer.parseInt(line.substring(pos3, pos2));
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            if (sectorSize < 0) {
                msgID = "STA0262W";
            }
            if ((pos3 = line.indexOf("nr_blks=", pos)) > 0) {
                for (pos2 = pos3 += 8; pos2 < length && Character.isDigit(line.charAt(pos2)); ++pos2) {
                }
                try {
                    nBlocks = Long.parseLong(line.substring(pos3, pos2));
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            if (nBlocks < 0L) {
                msgID = "STA0263W";
            }
            if (msgID != null) {
                Object[] args = new Object[]{new Integer(ctlr.ctlrInstance), line};
                MessageLog.logMessage((String)msgID, (Object[])args);
                this.rc = 4;
            }
        } else {
            String devName = line.substring(0, pos);
            try {
                nBlocks = this.findCCISSDiskCapacity(devName);
                if (nBlocks > 0L) {
                    sectorSize = 512;
                }
            }
            catch (GeneralException ignored) {
                // empty catch block
            }
        }
        Disk disk = new Disk();
        disk.initUnknown();
        disk.devManufacturer = "COMPAQ";
        disk.devModel = "Logical Disk";
        disk.devFirmwareRev = firmwareRev;
        disk.devSerialNumber = ctlrSig + "-" + diskNumber;
        disk.devType = 0;
        disk.dskSectorSize = sectorSize;
        disk.dskLogicalBlockSize = sectorSize;
        if (nBlocks > 0L && sectorSize > 0) {
            nBlocks *= (long)sectorSize;
            nBlocks >>= 9;
        }
        disk.dskCapacity = nBlocks;
        disk.dskHistory.dkhCapacity = nBlocks;
        String path = "/dev/" + line.substring(0, pos);
        if (driverType == 2) {
            disk.devFlags = (short)2;
            disk.devSerialNumber = ComputerID.cachedCID.computerID + "-" + path;
        }
        if (ok = ProbeLinux.findPartitions(disk, path)) {
            DevAccess da = new DevAccess();
            da.daDevice = disk;
            disk.devControllers = da;
            da.daTarget = (short)diskNumber;
            da.daLUN = 0;
            da.daPath = path;
            da.daController = ctlr;
            da.daNextDevice = ctlr.ctlrDevices;
            ctlr.ctlrDevices = da;
            disk.devCanonicalName = "p";
            if (driverType == 2) {
                da.daDevice.devUnsupportedModel = true;
            }
        }
        return ok;
    }

    private void findCompaqArrays() throws GeneralException {
        String line = null;
        int driverType = 0;
        StringBuffer buf = new StringBuffer("/proc/driver/cpqarray");
        File dir = new File(buf.toString());
        buf.append('/');
        String[] dirEntries = dir.list();
        if (dirEntries == null) {
            buf = new StringBuffer("/proc/driver/cciss");
            dir = new File(buf.toString());
            buf.append('/');
            dirEntries = dir.list();
            if (dirEntries == null) {
                return;
            }
        }
        for (int i = 0; i < dirEntries.length; ++i) {
            FileReader raw;
            if (dirEntries[i].startsWith("ida")) {
                driverType = 1;
                buf.setLength(22);
            } else {
                if (!dirEntries[i].startsWith("cciss")) continue;
                driverType = 2;
                buf.setLength(19);
            }
            buf.append(dirEntries[i]);
            String name = buf.toString();
            int instanceNumber = -1;
            try {
                instanceNumber = driverType == 1 ? Integer.parseInt(dirEntries[i].substring(3)) : Integer.parseInt(dirEntries[i].substring(5));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (instanceNumber < 0) {
                MessageLog.logMessage((String)"STA0258W", (Object)name);
                this.rc = 4;
                continue;
            }
            try {
                raw = new FileReader(name);
            }
            catch (IOException e) {
                MessageLog.logException((String)"GEN0029E", (Exception)e);
                throw new GeneralException();
            }
            BufferedReader cooked = new BufferedReader(raw);
            String firmwareRev = " ";
            String controllerSignature = " ";
            String description = " ";
            boolean foundSequentialLine = false;
            boolean inHeader = true;
            while (inHeader && (line = ProbeLinux.readLine(cooked, name)) != null) {
                if ((line = ProbeLinux.stripLeadingSpace(line, 0)).startsWith(dirEntries[i])) {
                    description = ProbeLinux.extractCompaqDescription(line);
                    continue;
                }
                if (line.startsWith("Controller Sig: 0x") || line.startsWith("Board ID: 0x")) {
                    if (driverType == 1) {
                        controllerSignature = line.substring(18);
                        continue;
                    }
                    controllerSignature = line.substring(12);
                    continue;
                }
                if (line.startsWith("Firmware Revision: ") || line.startsWith("Firmware Version: ")) {
                    firmwareRev = line.substring(19);
                    continue;
                }
                if (line.startsWith("Logical Drive Info")) {
                    inHeader = false;
                    continue;
                }
                if (line.startsWith("Sequential access devices")) {
                    foundSequentialLine = true;
                    continue;
                }
                if (!line.startsWith(" ") || line.length() != 1 || !foundSequentialLine && driverType == 2) continue;
                inHeader = false;
            }
            boolean parseable = true;
            if (!inHeader && !Util.isEmpty((String)controllerSignature)) {
                int pos;
                Controller ctlr = new Controller();
                ctlr.ctlrInstance = (short)instanceNumber;
                ctlr.ctlrDriverName = driverType == 1 ? "ida" : "cciss";
                ctlr.ctlrDriverDescription = description;
                ctlr.ctlrTarget = (short)-1;
                ctlr.ctlrType = (short)7;
                while (parseable && (line = ProbeLinux.readLine(cooked, name)) != null && (pos = line.indexOf(58)) > 0) {
                    parseable = this.parseCompaqVolume(ctlr, line, pos, controllerSignature, firmwareRev, driverType);
                }
                if (parseable) {
                    ctlr.ctlrNext = this.computer.cmpController;
                    this.computer.cmpController = ctlr;
                }
            }
            try {
                cooked.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            if (inHeader) {
                throw new GeneralException();
            }
            if (Util.isEmpty((String)controllerSignature)) {
                MessageLog.logMessage((String)"STA0260E", (Object)name);
                throw new GeneralException();
            }
            if (parseable) continue;
            throw new GeneralException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findCCISSDiskCapacity(String devName) throws GeneralException {
        FileReader raw;
        StringBuffer buf = new StringBuffer(PROC_PARTITIONS);
        try {
            raw = new FileReader(buf.toString());
        }
        catch (IOException e) {
            MessageLog.logException((String)"STA0121E", (Exception)e, (Object)buf.toString());
            throw new GeneralException();
        }
        long capacity = -1L;
        BufferedReader cooked = new BufferedReader(raw);
        try {
            String line;
            boolean found = false;
            while (!found && (line = cooked.readLine()) != null) {
                if (line.indexOf(devName) <= 0) continue;
                String token = null;
                StringTokenizer st = new StringTokenizer(line, " ");
                if (st.countTokens() <= 4) continue;
                for (int i = 0; i < 4; ++i) {
                    token = st.nextToken();
                    if (i == 2) {
                        try {
                            capacity = Long.parseLong(token) * 2L;
                            continue;
                        }
                        catch (NumberFormatException ignored) {
                            Object[] parms = new Object[]{line, new Integer(3), buf.toString()};
                            throw new GeneralException("STA0343E", parms);
                        }
                    }
                    if (i != 3 || token.compareToIgnoreCase(devName) != 0) continue;
                    found = true;
                }
            }
        }
        catch (IOException e) {
            MessageLog.logException((String)"STA0119E", (Exception)e, (Object)buf.toString());
            this.rc = 4;
        }
        try {
            cooked.close();
        }
        catch (IOException ignored) {}
        finally {
            return capacity;
        }
    }

    protected LogicalDisk promoteChunk(Chunk chunk) {
        LogicalDisk logicalDisk = super.promoteChunk(chunk);
        if (logicalDisk.ldType == 0 && logicalDisk.ldPath == null) {
            Disk device = chunk.chkDisk;
            logicalDisk.ldPath = device.devCanonicalName == null ? device.devControllers.daPath + Integer.toString(chunk.chkPartition) : device.devControllers.daPath + device.devCanonicalName + Integer.toString(chunk.chkPartition);
        }
        return logicalDisk;
    }

    protected void platformSpecific() {
        this.rc = this.getComputerConfig();
        if (this.rc > 4) {
            return;
        }
        HardwareID hardwareID = Agent.hardwareID;
        this.computer.cmpManufacturer = hardwareID.manufacturer;
        this.computer.cmpModel = HardwareID.model != null ? HardwareID.model : " ";
        this.computer.cmpSerialNumber = HardwareID.serialNumber != null ? HardwareID.serialNumber : " ";
        try {
            if (Agent.hardwareID.cpuArchitecture == 5) {
                this.findDASD();
            } else {
                this.findSCSIDisks();
                this.findIDEDisks();
                this.findVpaths();
                this.findCompaqArrays();
            }
        }
        catch (GeneralException e) {
            if (e.messageID != null) {
                e.print();
            }
            this.rc = 8;
            return;
        }
        if (this.computer.cmpController == null) {
            MessageLog.logMessage((String)"STA0216E");
            this.rc = 8;
            return;
        }
        this.arrangeDevices();
        this.cleanUpPartitionsAndDisks();
        Mounts mounts = new Mounts();
        if (!mounts.openMnttab()) {
            this.rc = 8;
            return;
        }
        while (this.rc <= 4 && mounts.nextMount()) {
            if (mounts.type.startsWith("nfs") || mounts.type.startsWith("sanfs") || mounts.type.equals("rpc_pipefs") || mounts.type.equals("usbfs") || mounts.type.equals("sysfs")) continue;
            if (mounts.type.equals("tmpfs") || mounts.type.equals("shm")) {
                int r = this.handleTMPFS(mounts);
                if (r <= this.rc) continue;
                this.rc = r;
                continue;
            }
            LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
            while (logicalDisk != null && !mounts.special.equals(logicalDisk.ldPath)) {
                logicalDisk = logicalDisk.ldNext;
            }
            if (logicalDisk == null) {
                int pos;
                for (pos = mounts.special.length(); pos > 0 && Character.isDigit(mounts.special.charAt(pos - 1)); --pos) {
                }
                String stripped = mounts.special.substring(0, pos);
                boolean notRemovable = true;
                DevAccess access = this.removables;
                while (notRemovable && access != null) {
                    if (stripped.equals(access.daPath)) {
                        notRemovable = false;
                        continue;
                    }
                    access = access.daNextDevice;
                }
                if (notRemovable) {
                    MessageLog.logMessage((String)"STA0101W", (Object)mounts.mountPoint, (Object)mounts.type, (Object)mounts.special);
                    this.rc = 4;
                    logicalDisk = new LogicalDisk();
                    logicalDisk.ldPath = mounts.special;
                    logicalDisk.ldType = (byte)7;
                    logicalDisk.ldCapacity = -1L;
                    logicalDisk.ldNext = this.computer.cmpLogicalDisk;
                    this.computer.cmpLogicalDisk = logicalDisk;
                }
            }
            if (logicalDisk == null) continue;
            Filesystem filesystem = new Filesystem();
            if (mounts.statFS(filesystem) != 0) {
                this.rc = 4;
                continue;
            }
            if (logicalDisk.ldFilesystem != null) {
                MessageLog.logMessage((String)"STA0100W", (Object)mounts.special, (Object)mounts.mountPoint, (Object)logicalDisk.ldFilesystem.fsMountPoint);
                this.rc = 4;
                continue;
            }
            logicalDisk.ldFilesystem = filesystem;
            filesystem.fsLogicalDisk = logicalDisk;
            logicalDisk.ldIsSwap = false;
            filesystem.fsType = mounts.type.endsWith("msdos") || mounts.type.endsWith("fat") ? (short)0 : (mounts.type.startsWith("reiser") ? (short)20 : (mounts.type.startsWith("ext") ? (mounts.type.charAt(3) > '2' ? (short)5 : (short)4) : (short)-1));
            filesystem.fsMountPoint = mounts.mountPoint;
        }
    }

    static {
        ProbeLinux.initIDs();
        deviceTypes = new HashMap();
        deviceTypes.put("disk", new Integer(0));
        deviceTypes.put("floppy", new Integer(4));
        deviceTypes.put("cdrom", new Integer(1));
        deviceTypes.put("tape", new Integer(256));
    }
}

