/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.probe;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import org.eclipse.aperi.agent.probe.IPoller;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class UpTime
implements IPoller {
    public long downTime;
    public long beganMonitoring;
    public long powerCycles;
    private static final int MON_START_OFFSET = 0;
    private static final int BOOT_OFFSET = 8;
    private static final int DOWNTIME_OFFSET = 16;
    private static final int ALIVE_OFFSET = 24;
    private static final int BOOT_COUNT_OFFSET = 32;
    private String fileName;
    private RandomAccessFile file;
    private boolean resetMonStart;
    private Thread shutdownWaiter;
    private boolean up;
    private byte[] buf;

    private long longAt(int offset) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)UpTime.class.getName(), (String)"longAt", (String)"offset");
        }
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            long bite = (long)this.buf[offset + i] & 0xFFL;
            result |= bite << (i << 3);
        }
        long traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UpTime.class.getName(), (String)"longAt", (long)traceResult);
        }
        return traceResult;
    }

    private void dumpLong(long qty, int offset) {
        for (int i = 0; i < 8; ++i) {
            this.buf[offset + i] = (byte)qty;
            qty >>= 8;
        }
    }

    private boolean writeBuf() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)UpTime.class.getName(), (String)"writeBuf", (String)"");
        }
        this.dumpLong(System.currentTimeMillis(), 24);
        boolean result = true;
        try {
            this.file.seek(0L);
            this.file.write(this.buf);
            this.file.getFD().sync();
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)UpTime.class.getName(), (String)"writeBuf", (Throwable)e);
            }
            MessageLog.logException((String)"STA0118E", (Exception)e, (Object)this.fileName);
            result = false;
        }
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UpTime.class.getName(), (String)"writeBuf", (boolean)traceResult);
        }
        return traceResult;
    }

    private void checkPollInterval() {
        if (Agent.upTimePoll <= 0) {
            MessageLog.logMessage((String)"STA0117W");
        }
    }

    private boolean initialize() {
        long previousBoot;
        FileInputStream in;
        block23: {
            block21: {
                if (TraceLogger.enableTrace) {
                    TraceLogger.entry((String)UpTime.class.getName(), (String)"initialize", (String)"");
                }
                this.up = true;
                this.shutdownWaiter = null;
                this.resetMonStart = false;
                this.fileName = Variables.homeDirectory + File.separator + "UPTIME." + Agent.localName;
                in = null;
                try {
                    in = new FileInputStream(this.fileName);
                }
                catch (IOException e) {
                    if (!TraceLogger.enableTrace) break block21;
                    TraceLogger.exception((String)UpTime.class.getName(), (String)"initialize", (Throwable)e);
                }
            }
            previousBoot = Agent.systemBoot;
            this.buf = new byte[40];
            if (in != null) {
                int bytesRead = 0;
                String msg = MessageLog.getMessageNoID((String)"STA0120E", null);
                try {
                    bytesRead = ((InputStream)in).read(this.buf);
                }
                catch (IOException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)UpTime.class.getName(), (String)"initialize", (Throwable)e);
                    }
                    msg = e.getMessage();
                }
                if (bytesRead < 24) {
                    block22: {
                        MessageLog.logMessage((String)"STA0119E", (Object)this.fileName);
                        PrintWriter w = MessageLog.getThreadLog();
                        w.println("                         " + msg);
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e) {
                            if (!TraceLogger.enableTrace) break block22;
                            TraceLogger.exception((String)UpTime.class.getName(), (String)"initialize", (Throwable)e);
                        }
                    }
                    in = null;
                } else {
                    this.beganMonitoring = this.longAt(0);
                    previousBoot = this.longAt(8);
                    this.downTime = this.longAt(16);
                    this.powerCycles = this.longAt(32);
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        if (!TraceLogger.enableTrace) break block23;
                        TraceLogger.exception((String)UpTime.class.getName(), (String)"initialize", (Throwable)e);
                    }
                }
            }
        }
        if (in == null) {
            this.beganMonitoring = Agent.started;
            this.dumpLong(this.beganMonitoring, 0);
            this.dumpLong(previousBoot, 8);
            this.dumpLong(0L, 16);
            this.dumpLong(0L, 32);
        }
        try {
            this.file = new RandomAccessFile(this.fileName, "rw");
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)UpTime.class.getName(), (String)"initialize", (Throwable)e);
            }
            MessageLog.logException((String)"STA0069W", (Exception)e, (Object)this.fileName);
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)UpTime.class.getName(), (String)"initialize", (boolean)traceResult);
            }
            return traceResult;
        }
        if (Agent.systemBoot - previousBoot > 5000L) {
            this.dumpLong(Agent.systemBoot, 8);
            long delta = Agent.systemBoot - this.longAt(24);
            if (delta < 20000L) {
                delta = 20000L;
            }
            this.downTime += delta;
            this.dumpLong(this.downTime, 16);
            ++this.powerCycles;
            this.dumpLong(this.powerCycles, 32);
        }
        this.checkPollInterval();
        boolean traceResult = this.writeBuf();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UpTime.class.getName(), (String)"initialize", (boolean)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        UpTime upTime;
        block20: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)UpTime.class.getName(), (String)"run", (String)"");
            }
            boolean going = this.initialize();
            while (going) {
                boolean mustReset;
                upTime = this;
                synchronized (upTime) {
                    block19: {
                        if (this.shutdownWaiter == null) {
                            long interval = Agent.upTimePoll * 1000;
                            try {
                                if (interval > 0L) {
                                    this.wait(interval);
                                } else {
                                    this.wait();
                                }
                            }
                            catch (InterruptedException e) {
                                if (!TraceLogger.enableTrace) break block19;
                                TraceLogger.exception((String)UpTime.class.getName(), (String)"run", (Throwable)e);
                            }
                        }
                    }
                    mustReset = this.resetMonStart;
                }
                if (mustReset) {
                    this.resetMonStart = false;
                    this.dumpLong(this.beganMonitoring, 0);
                    this.dumpLong(this.downTime, 16);
                    this.dumpLong(this.powerCycles, 32);
                }
                going = this.writeBuf() && this.shutdownWaiter == null;
            }
            if (this.file != null) {
                try {
                    this.file.close();
                }
                catch (IOException e) {
                    if (!TraceLogger.enableTrace) break block20;
                    TraceLogger.exception((String)UpTime.class.getName(), (String)"run", (Throwable)e);
                }
            }
        }
        upTime = this;
        synchronized (upTime) {
            this.up = false;
        }
        if (this.shutdownWaiter != null) {
            this.shutdownWaiter.interrupt();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UpTime.class.getName(), (String)"run");
        }
    }

    public synchronized void timeoutChanged() {
        this.checkPollInterval();
        this.notify();
    }

    public synchronized void reset(long pBeganMonitoring) {
        this.beganMonitoring = pBeganMonitoring;
        this.downTime = 0L;
        this.powerCycles = 0L;
        this.resetMonStart = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        block8: {
            boolean wasUp;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)UpTime.class.getName(), (String)"shutdown", (String)"");
            }
            UpTime upTime = this;
            synchronized (upTime) {
                wasUp = this.up;
                this.shutdownWaiter = Thread.currentThread();
                this.notify();
            }
            if (wasUp) {
                try {
                    Thread.sleep(Long.MAX_VALUE);
                }
                catch (InterruptedException e) {
                    if (!TraceLogger.enableTrace) break block8;
                    TraceLogger.exception((String)UpTime.class.getName(), (String)"shutdown", (Throwable)e);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UpTime.class.getName(), (String)"shutdown");
        }
    }
}

