/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import com.tivoli.tec.event_delivery.TECEvent;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Hashtable;
import javax.jms.JMSException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class SRMTECEvent
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 20001130L;
    protected transient ILogger msgLogger;
    protected transient ILogger traceLogger;
    static final String TRACE_NAME = "tpc.eventTrace";
    static final String MESSAGE_NAME = "tpc.eventLog";
    public static final String className = TECEvent.class.getName();
    public String tecEventClass;
    public Hashtable tecAttributes;
    public String tecHostName;
    public String tecMessage;
    public String tecMessageId;
    public String tecSeverity;
    public String tecComponent;
    public String tecFunction;
    public String tecIPAddress;
    private long creationTime;
    public static final String EVENT_CLASS = "eventClass";
    public static final String HOSTNAME = "hostname";
    public static final String ORIGIN = "origin";
    public static final String SOURCE = "source";
    public static final String SUB_SOURCE = "sub_source";
    public static final String MSG = "msg";
    public static final String MSG_ID = "messageId";
    public static final String SEVERITY = "severity";
    public static final String FATAL = "FATAL";
    public static final String CRITICAL = "CRITICAL";
    public static final String WARNING = "WARNING";
    public static final String HARMLESS = "HARMLESS";
    public static final String MINOR = "MINOR";
    public static final String UNKNOWN = "UNKNOWN";
    private TECEvent tecEvent;
    public String tecSpecial;

    public SRMTECEvent() {
        block6: {
            this.msgLogger = null;
            this.traceLogger = null;
            this.tecEventClass = "ServiceEvent";
            this.tecAttributes = null;
            this.tecHostName = null;
            this.tecMessage = null;
            this.tecMessageId = null;
            this.tecSeverity = HARMLESS;
            this.tecComponent = null;
            this.tecFunction = null;
            this.tecIPAddress = null;
            this.creationTime = 0L;
            this.tecEvent = null;
            this.tecSpecial = "'";
            String methodName = "SRMTECEvent";
            this.creationTime = System.currentTimeMillis();
            this.traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, "SRMTECEvent");
            }
            this.msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
            try {
                String tecIPAddress = InetAddress.getLocalHost().getHostAddress();
                String tecHostName = InetAddress.getByName(tecIPAddress).getHostName();
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, "SRMTECEvent", "The TEC host name is " + tecHostName + " and the IP address is " + tecIPAddress + ".");
                }
            }
            catch (UnknownHostException e) {
                if (this.msgLogger != null) {
                    this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "SRMTECEvent", (Throwable)e);
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block6;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "SRMTECEvent", (Throwable)e);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "SRMTECEvent");
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getHostName() {
        return this.tecHostName;
    }

    public void setHostName(String hostname) {
        this.tecHostName = hostname;
    }

    public void setTECAttributes(String eventClass, String hostname, String origin, String source, String subSource, String msgId, String msg, String severity, Hashtable attributes) throws IllegalArgumentException {
        block6: {
            String methodName = "setTECAttributes";
            try {
                this.tecEventClass = eventClass;
                this.tecHostName = hostname;
                this.tecIPAddress = origin;
                this.tecComponent = source;
                this.tecFunction = subSource;
                this.tecMessageId = msgId;
                this.tecMessage = msg;
                this.tecSeverity = severity;
                this.tecAttributes = new Hashtable();
                if (attributes != null) {
                    this.tecAttributes.putAll(attributes);
                }
            }
            catch (NullPointerException npe) {
                if (this.msgLogger != null) {
                    this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "setTECAttributes", (Throwable)npe);
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block6;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "setTECAttributes", (Throwable)npe);
            }
        }
        try {
            this.loadDataToTECEvent();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getSerializetTECEvent() {
        if (this.tecEvent != null) {
            return this.tecEvent.toString();
        }
        return null;
    }

    public String toString() {
        return "SRMTECEvent (" + new Date(this.creationTime) + "): " + className;
    }

    private void logEvent(SRMTECEvent event) throws IOException, JMSException {
        String methodName = "logEvent";
        this.msgLogger.message(IRecordType.TYPE_INFO, (Object)className, "logEvent", "SANEventService_logEvent", (Object)event);
    }

    private void loadDataToTECEvent() throws IllegalArgumentException {
        String methodName = "loadTECEvent";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "loadTECEvent");
        }
        try {
            this.tecEvent = new TECEvent();
            this.setGeneralTECValues();
        }
        catch (Exception e) {
            this.tecEvent = null;
            throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
        }
        if (this.tecEventClass.equals("PhysicalEntityEvent")) {
            try {
                this.tecEvent.setSlot("uniqueId", this.verifyValue("uniqueId", (String)this.tecAttributes.get("uniqueId")));
                this.tecEvent.setSlot("entityType", this.verifyValue("entityType", (String)this.tecAttributes.get("entityType")));
                this.tecEvent.setSlot("label", this.verifyValue("label", (String)this.tecAttributes.get("HLDLabel")));
                this.tecEvent.setSlot("type", this.verifyValue("type", (String)this.tecAttributes.get("type")));
                this.tecEvent.setSlot("highLevelDevice", this.verifyValue("highLevelDevice", (String)this.tecAttributes.get("highLevelDevice")));
                this.tecEvent.setSlot("state", this.verifyValue("state", (String)this.tecAttributes.get("state")));
                this.tecEvent.setSlot("eventType", this.verifyValue("eventType", (String)this.tecAttributes.get("eventType")));
            }
            catch (NullPointerException npe) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "loadTECEvent", (Throwable)npe);
                this.tecEvent = null;
                throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
            }
        } else if (this.tecEventClass.equals("PhysicalRelationshipEvent")) {
            try {
                this.tecEvent.setSlot("uniqueId", this.verifyValue("uniqueId", (String)this.tecAttributes.get("uniqueId")));
                this.tecEvent.setSlot("entityType", this.verifyValue("entityType", (String)this.tecAttributes.get("entityType")));
                this.tecEvent.setSlot("toObjectUniqueId", this.verifyValue("toObjectHLDUniqueId", (String)this.tecAttributes.get("toObjectHLDUniqueId")));
                this.tecEvent.setSlot("toObjectLabel", this.verifyValue("toObjectHLDLabel", (String)this.tecAttributes.get("toObjectHLDLabel")));
                this.tecEvent.setSlot("toObjectType", this.verifyValue("toObjectHLDType", (String)this.tecAttributes.get("toObjectHLDType")));
                this.tecEvent.setSlot("toHighLevelDevice", this.verifyValue("toHighLevelDevice", (String)this.tecAttributes.get("toHighLevelDevice")));
                this.tecEvent.setSlot("fromObjectUniqueId", this.verifyValue("fromObjectHLDUniqueId", (String)this.tecAttributes.get("fromObjectHLDUniqueId")));
                this.tecEvent.setSlot("fromObjectLabel", this.verifyValue("fromObjectHLDLabel", (String)this.tecAttributes.get("fromObjectHLDLabel")));
                this.tecEvent.setSlot("fromObjectType", this.verifyValue("fromObjectHLDType", (String)this.tecAttributes.get("fromObjectHLDType")));
                this.tecEvent.setSlot("fromHighLevelDevice", this.verifyValue("fromHighLevelDevice", (String)this.tecAttributes.get("fromHighLevelDevice")));
                this.tecEvent.setSlot("state", this.verifyValue("state", (String)this.tecAttributes.get("state")));
                this.tecEvent.setSlot("eventType", this.verifyValue("eventType", (String)this.tecAttributes.get("eventType")));
            }
            catch (NullPointerException npe) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "loadTECEvent", (Throwable)npe);
                this.tecEvent = null;
                throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
            }
        } else if (this.tecEventClass.equals("LogicalEntityEvent")) {
            try {
                this.tecEvent.setSlot("uniqueId", this.verifyValue("uniqueId", (String)this.tecAttributes.get("uniqueId")));
                this.tecEvent.setSlot("entityType", this.verifyValue("entityType", (String)this.tecAttributes.get("entityType")));
                this.tecEvent.setSlot("label", this.verifyValue("label", (String)this.tecAttributes.get("label")));
                this.tecEvent.setSlot("type", this.verifyValue("type", (String)this.tecAttributes.get("type")));
                this.tecEvent.setSlot("highLevelDevice", this.verifyValue("highLevelDevice", (String)this.tecAttributes.get("highLevelDevice")));
                this.tecEvent.setSlot("state", this.verifyValue("state", (String)this.tecAttributes.get("state")));
                this.tecEvent.setSlot("eventType", this.verifyValue("eventType", (String)this.tecAttributes.get("eventType")));
            }
            catch (NullPointerException npe) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "loadTECEvent", (Throwable)npe);
                this.tecEvent = null;
                throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
            }
        } else if (this.tecEventClass.equals("LogicalRelationshipEvent")) {
            try {
                this.tecEvent.setSlot("uniqueId", this.verifyValue("uniqueId", (String)this.tecAttributes.get("uniqueId")));
                this.tecEvent.setSlot("entityType", this.verifyValue("entityType", (String)this.tecAttributes.get("entityType")));
                this.tecEvent.setSlot("toObjectUniqueId", this.verifyValue("toObjectUniqueId", (String)this.tecAttributes.get("toObjectUniqueId")));
                this.tecEvent.setSlot("toObjectLabel", this.verifyValue("toObjectLabel", (String)this.tecAttributes.get("toObjectLabel")));
                this.tecEvent.setSlot("toObjectType", this.verifyValue("toObjectType", (String)this.tecAttributes.get("toObjectType")));
                this.tecEvent.setSlot("toHighLevelDevice", this.verifyValue("toHighLevelDevice", (String)this.tecAttributes.get("toHighLevelDevice")));
                this.tecEvent.setSlot("fromObjectUniqueId", this.verifyValue("fromObjectUniqueId", (String)this.tecAttributes.get("fromObjectUniqueId")));
                this.tecEvent.setSlot("fromObjectLabel", this.verifyValue("fromObjectLabel", (String)this.tecAttributes.get("fromObjectLabel")));
                this.tecEvent.setSlot("fromObjectType", this.verifyValue("fromObjectType", (String)this.tecAttributes.get("fromObjectType")));
                this.tecEvent.setSlot("fromHighLevelDevice", this.verifyValue("fromHighLevelDevice", (String)this.tecAttributes.get("fromHighLevelDevice")));
                this.tecEvent.setSlot("state", this.verifyValue("state", (String)this.tecAttributes.get("state")));
                this.tecEvent.setSlot("eventType", this.verifyValue("eventType", (String)this.tecAttributes.get("eventType")));
            }
            catch (NullPointerException npe) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "loadTECEvent", (Throwable)npe);
                this.tecEvent = null;
                throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
            }
        } else if (this.tecEventClass.equals("SANManagerStatusEvent")) {
            try {
                this.tecEvent.setSlot("actionPerformed", this.verifyValue("actionPerformed", (String)this.tecAttributes.get("actionPerformed")));
            }
            catch (NullPointerException npe) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "loadTECEvent", (Throwable)npe);
                this.tecEvent = null;
                throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
            }
        } else if (this.tecEventClass.equals("SANRegionEvent")) {
            try {
                this.tecEvent.setSlot("SANName", this.verifyValue("SANName", (String)this.tecAttributes.get("SANName")));
                this.tecEvent.setSlot("zoneName", this.verifyValue("zoneName", (String)this.tecAttributes.get("zoneName")));
                this.tecEvent.setSlot("state", this.verifyValue("state", (String)this.tecAttributes.get("state")));
                this.tecEvent.setSlot("eventType", this.verifyValue("eventType", (String)this.tecAttributes.get("eventType")));
                this.tecEvent.setSlot("zoneSetName", this.verifyValue("zoneSetName", (String)this.tecAttributes.get("zoneSetName")));
                this.tecEvent.setSlot("active", this.verifyValue("active", (String)this.tecAttributes.get("active")));
            }
            catch (NullPointerException npe) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "loadTECEvent", (Throwable)npe);
                this.tecEvent = null;
                throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
            }
        } else if (this.tecEventClass.equals("ServiceEvent")) {
            try {
                this.tecEvent.setSlot("serviceName", this.verifyValue("serviceName", (String)this.tecAttributes.get("serviceName")));
                this.tecEvent.setSlot("serviceState", this.verifyValue("serviceState", (String)this.tecAttributes.get("serviceState")));
            }
            catch (NullPointerException npe) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "loadTECEvent", (Throwable)npe);
                this.tecEvent = null;
                throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "loadTECEvent", (Object)("Failed to create a TEC event: not a valid TECEvent type " + this.tecEventClass));
        }
        throw new IllegalArgumentException("Failed to create a TEC event: not a valid TECEvent type " + this.tecEventClass);
    }

    private void setGeneralTECValues() {
        this.tecEvent.setClassName(this.tecEventClass);
        this.tecEvent.setSlot(HOSTNAME, this.tecSpecial + this.tecHostName + this.tecSpecial);
        this.tecEvent.setSlot(ORIGIN, this.tecSpecial + this.tecIPAddress + this.tecSpecial);
        this.tecEvent.setSlot(SOURCE, this.tecSpecial + this.tecComponent + this.tecSpecial);
        this.tecEvent.setSlot(SUB_SOURCE, this.tecSpecial + this.tecFunction + this.tecSpecial);
        this.tecEvent.setSlot(MSG, this.tecSpecial + this.tecMessage + this.tecSpecial);
        this.tecEvent.setSlot(MSG_ID, this.tecSpecial + this.tecMessageId + this.tecSpecial);
        this.tecEvent.setSlot(SEVERITY, this.tecSpecial + this.tecSeverity + this.tecSpecial);
    }

    public Hashtable getTECAttributes() throws NullPointerException {
        return this.tecAttributes;
    }

    public String getTECComponent() {
        return this.tecComponent;
    }

    public String getTECFunction() {
        return this.tecFunction;
    }

    public String getTECIPAddress() {
        return this.tecIPAddress;
    }

    public String getTECMessage() {
        return this.tecMessage;
    }

    public String getTECMessageId() {
        return this.tecMessageId;
    }

    public String getTECSeverity() {
        return this.tecSeverity;
    }

    public String getTECEventClass() {
        return this.tecEventClass;
    }

    public void setTECComponent(String component) {
        this.tecComponent = component;
    }

    public void setTECFunction(String function) {
        this.tecFunction = function;
    }

    public void setTECIPAddress(String ip) {
        this.tecIPAddress = ip;
    }

    public void setTECMessage(String message) {
        this.tecMessage = message;
    }

    public void setTECMessageId(String messageId) {
        this.tecMessageId = messageId;
    }

    public void setTECSeverity(String severity) {
        this.tecSeverity = severity;
    }

    public void setTECEventClass(String tecClass) {
        this.tecEventClass = tecClass;
    }

    private String verifyValue(String ID, String inputValue) {
        String methodName = "verifyValue";
        String val = inputValue;
        if (val != null) {
            return this.tecSpecial + val + this.tecSpecial;
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_ERR, (Object)className, methodName, "Null value found for TEC attribute " + ID);
        }
        String returnValue = "";
        return returnValue;
    }
}

