/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event.data;

import com.tivoli.tec.event_delivery.TECEvent;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Hashtable;
import javax.jms.JMSException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.messagingimpl.TESTopicImpl;
import org.eclipse.aperi.snmp.SnmpTrap;

public class SANEvent
extends TESTopicImpl
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 20001130L;
    protected transient ILogger msgLogger;
    protected transient ILogger traceLogger;
    static final String TRACE_NAME = "aperi.logger.trace.event";
    static final String MESSAGE_NAME = "aperi.logger.message.event";
    public static final String className = SANEvent.class.getName();
    public String tecEventClass;
    public Hashtable tecAttributes;
    public String tecHostName;
    public String tecMessage;
    public String tecMessageId;
    public String tecSeverity;
    public String tecComponent;
    public String tecFunction;
    public String tecIPAddress;
    private long creationTime;
    public SnmpTrap sanTrap;
    public static final String EVENT_CLASS = "eventClass";
    public static final String HOSTNAME = "hostname";
    public static final String ORIGIN = "origin";
    public static final String SOURCE = "source";
    public static final String SUB_SOURCE = "sub_source";
    public static final String MSG = "msg";
    public static final String MSG_ID = "messageId";
    public static final String SEVERITY = "severity";
    public static final String UNIQUE_ID = "uniqueId";
    public static final String ENTITY_TYPE = "entityType";
    public static final String LABEL = "label";
    public static final String TYPE = "type";
    public static final String HLD = "highLevelDevice";
    public static final String STATE = "state";
    public static final String EVENT_TYPE = "eventType";
    public static final String FROM_OBJ_UID = "fromObjectUniqueId";
    public static final String FROM_OBJ_HLD_UID = "fromObjectHLDUniqueId";
    public static final String FROM_OBJ_TYPE = "fromObjectType";
    public static final String FROM_OBJ_LABEL = "fromObjectLabel";
    public static final String FROM_OBJ_HLD_TYPE = "fromObjectHLDType";
    public static final String FROM_OBJ_HLD_LABEL = "fromObjectHLDLabel";
    public static final String FROM_HLD = "fromHighLevelDevice";
    public static final String TO_OBJ_UID = "toObjectUniqueId";
    public static final String TO_OBJ_HLD_UID = "toObjectHLDUniqueId";
    public static final String TO_OBJ_TYPE = "toObjectType";
    public static final String TO_OBJ_LABEL = "toObjectLabel";
    public static final String TO_OBJ_HLD_TYPE = "toObjectHLDType";
    public static final String TO_OBJ_HLD_LABEL = "toObjectHLDLabel";
    public static final String TO_HLD = "toHighLevelDevice";
    public static final String ACTION_PERFORMED = "actionPerformed";
    public static final String SAN_NAME = "SANName";
    public static final String ZONE_NAME = "zoneName";
    public static final String ACTIVE = "Active";
    public static final String SERVICE_NAME = "serviceName";
    public static final String SERVICE_STATE = "serviceState";
    public static final String PHYSICAL_ENTITY_EVENT = "PhysicalEntityEvent";
    public static final String PHYSICAL_RELATIONSHIP_EVENT = "PhysicalRelationshipEvent";
    public static final String LOGICAL_ENTITY_EVENT = "LogicalEntityEvent";
    public static final String LOGICAL_RELATIONSHIP_EVENT = "LogicalRelationshipEvent";
    public static final String SAN_MANAGER_STATUS_EVENT = "SANManagerStatusEvent";
    public static final String SAN_REGION_EVENT = "SANRegionEvent";
    public static final String SERVICE_EVENT = "ServiceEvent";
    public static final String HLD_LABEL = "highLevelDeviceLabel";
    public static final String HLD_TYPE = "highLevelDeviceType";
    public static final String FROM_HLD_LABEL = "fromHighLevelDeviceLabel";
    public static final String FROM_HLD_TYPE = "fromHighLevelDeviceType";
    public static final String TO_HLD_LABEL = "toHighLevelDeviceLabel";
    public static final String TO_HLD_TYPE = "toHighLevelDeviceType";
    public static final String PORT_PHY_NUM = "portPhysicalNumber";
    public static final String FROM_PORT_PHY_NUM = "fromPortPhysicalNumber";
    public static final String TO_PORT_PHY_NUM = "toPortPhysicalNumber";
    public static final String ZONE_SET_NAME = "zoneSetName";
    public static final String ZONE_ALIAS_NAME = "zoneAliasName";
    public static final String ZONE_MEMBER_ID = "zoneMemberID";
    public static final String ZONE_MEMBER_TYPE = "zoneMemberType";
    public static final String ZONE_MEMBER_VENDORTYPE = "zoneMemberVendorType";
    public static final String FROM_STATE = "fromState";
    public static final String TO_STATE = "toState";
    public static final String FATAL = "FATAL";
    public static final String CRITICAL = "CRITICAL";
    public static final String WARNING = "WARNING";
    public static final String HARMLESS = "HARMLESS";
    public static final String MINOR = "MINOR";
    public static final String UNKNOWN = "UNKNOWN";
    public String serializedTEC;
    public String tecSpecial;

    public SANEvent() {
        block6: {
            this.msgLogger = null;
            this.traceLogger = null;
            this.tecEventClass = SERVICE_EVENT;
            this.tecAttributes = null;
            this.tecHostName = null;
            this.tecMessage = null;
            this.tecMessageId = null;
            this.tecSeverity = HARMLESS;
            this.tecComponent = null;
            this.tecFunction = null;
            this.tecIPAddress = null;
            this.creationTime = 0L;
            this.sanTrap = null;
            this.serializedTEC = null;
            this.tecSpecial = "'";
            String methodName = "SANEvent";
            this.creationTime = System.currentTimeMillis();
            this.traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, "SANEvent");
            }
            this.msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
            try {
                String tecIPAddress = InetAddress.getLocalHost().getHostAddress();
                String tecHostName = InetAddress.getByName(tecIPAddress).getHostName();
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, "SANEvent", "The TEC host name is " + tecHostName + " and the IP address is " + tecIPAddress + ".");
                }
            }
            catch (UnknownHostException e) {
                if (this.msgLogger != null) {
                    this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "SANEvent", (Throwable)e);
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block6;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "SANEvent", (Throwable)e);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "SANEvent");
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getHostName() {
        return this.tecHostName;
    }

    public SnmpTrap getsanTrap() {
        return this.sanTrap;
    }

    public void setHostName(String hostname) {
        this.tecHostName = hostname;
    }

    public void setsanTrap(SnmpTrap snmpTrap) {
        this.sanTrap = snmpTrap;
    }

    public void setTECAttributes(String eventClass, String hostname, String origin, String source, String subSource, String msgId, String msg, String severity, Hashtable attributes) throws IllegalArgumentException {
        block4: {
            String methodName = "setTECAttributes";
            try {
                this.tecEventClass = eventClass;
                this.tecHostName = hostname;
                this.tecIPAddress = origin;
                this.tecComponent = source;
                this.tecFunction = subSource;
                this.tecMessageId = msgId;
                this.tecMessage = msg;
                this.tecSeverity = severity;
                this.tecAttributes = new Hashtable();
                if (attributes != null) {
                    this.tecAttributes.putAll(attributes);
                }
            }
            catch (NullPointerException npe) {
                if (this.msgLogger != null) {
                    this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "setTECAttributes", (Throwable)npe);
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "setTECAttributes", (Throwable)npe);
            }
        }
        this.serializedTEC = this.createTECEvent();
    }

    public String toString() {
        return "SANEvent (" + new Date(this.creationTime) + "): " + className;
    }

    private void logEvent(SANEvent event) throws IOException, JMSException {
        String methodName = "logEvent";
        this.msgLogger.message(IRecordType.TYPE_INFO, (Object)className, "logEvent", "SANEventService_logEvent", (Object)event);
    }

    private String createTECEvent() throws IllegalArgumentException {
        String methodName = "createTECEvent";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            String msg = "tecMessage = " + this.tecMessage + ";\n" + "tecMessageId = " + this.tecMessageId + ";\n" + "tecComponent = " + this.tecComponent + ";\n" + "tecFunction = " + this.tecFunction + ";\n" + "tecHostName = " + this.tecHostName + ";\n" + "tecIPAddress = " + this.tecIPAddress + ";\n" + "tecSeverity = " + this.tecSeverity + ".\n";
            String messageInfo = "Creating a TEC Event with the following data:\n" + msg;
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "createTECEvent");
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "createTECEvent", messageInfo);
        }
        if (this.tecEventClass.equals(PHYSICAL_ENTITY_EVENT)) {
            TECEvent phEntityEvent;
            block30: {
                phEntityEvent = new TECEvent();
                this.setGeneralTECValues(phEntityEvent);
                try {
                    phEntityEvent.setSlot(UNIQUE_ID, this.verifyValue(UNIQUE_ID, (String)this.tecAttributes.get(UNIQUE_ID)));
                    phEntityEvent.setSlot(ENTITY_TYPE, this.verifyValue(ENTITY_TYPE, (String)this.tecAttributes.get(ENTITY_TYPE)));
                    phEntityEvent.setSlot(LABEL, this.verifyValue(LABEL, (String)this.tecAttributes.get(HLD_LABEL)));
                    phEntityEvent.setSlot(TYPE, this.verifyValue(TYPE, (String)this.tecAttributes.get(TYPE)));
                    phEntityEvent.setSlot(HLD, this.verifyValue(HLD, (String)this.tecAttributes.get(HLD)));
                    phEntityEvent.setSlot(STATE, this.verifyValue(STATE, (String)this.tecAttributes.get(STATE)));
                    phEntityEvent.setSlot(EVENT_TYPE, this.verifyValue(EVENT_TYPE, (String)this.tecAttributes.get(EVENT_TYPE)));
                }
                catch (NullPointerException npe) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "createTECEvent", (Throwable)npe);
                    if (phEntityEvent != null) break block30;
                    throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
                }
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "createTECEvent");
            }
            return phEntityEvent.toString();
        }
        if (this.tecEventClass.equals(PHYSICAL_RELATIONSHIP_EVENT)) {
            TECEvent phRelationshipEvent;
            block31: {
                phRelationshipEvent = new TECEvent();
                this.setGeneralTECValues(phRelationshipEvent);
                try {
                    phRelationshipEvent.setSlot(UNIQUE_ID, this.verifyValue(UNIQUE_ID, (String)this.tecAttributes.get(UNIQUE_ID)));
                    phRelationshipEvent.setSlot(ENTITY_TYPE, this.verifyValue(ENTITY_TYPE, (String)this.tecAttributes.get(ENTITY_TYPE)));
                    phRelationshipEvent.setSlot(TO_OBJ_UID, this.verifyValue(TO_OBJ_HLD_UID, (String)this.tecAttributes.get(TO_OBJ_HLD_UID)));
                    phRelationshipEvent.setSlot(TO_OBJ_LABEL, this.verifyValue(TO_OBJ_HLD_LABEL, (String)this.tecAttributes.get(TO_OBJ_HLD_LABEL)));
                    phRelationshipEvent.setSlot(TO_OBJ_TYPE, this.verifyValue(TO_OBJ_HLD_TYPE, (String)this.tecAttributes.get(TO_OBJ_HLD_TYPE)));
                    phRelationshipEvent.setSlot(TO_HLD, this.verifyValue(TO_HLD, (String)this.tecAttributes.get(TO_HLD)));
                    phRelationshipEvent.setSlot(FROM_OBJ_UID, this.verifyValue(FROM_OBJ_HLD_UID, (String)this.tecAttributes.get(FROM_OBJ_HLD_UID)));
                    phRelationshipEvent.setSlot(FROM_OBJ_LABEL, this.verifyValue(FROM_OBJ_HLD_LABEL, (String)this.tecAttributes.get(FROM_OBJ_HLD_LABEL)));
                    phRelationshipEvent.setSlot(FROM_OBJ_TYPE, this.verifyValue(FROM_OBJ_HLD_TYPE, (String)this.tecAttributes.get(FROM_OBJ_HLD_TYPE)));
                    phRelationshipEvent.setSlot(FROM_HLD, this.verifyValue(FROM_HLD, (String)this.tecAttributes.get(FROM_HLD)));
                    phRelationshipEvent.setSlot(STATE, this.verifyValue(STATE, (String)this.tecAttributes.get(STATE)));
                    phRelationshipEvent.setSlot(EVENT_TYPE, this.verifyValue(EVENT_TYPE, (String)this.tecAttributes.get(EVENT_TYPE)));
                }
                catch (NullPointerException npe) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "createTECEvent", (Throwable)npe);
                    if (phRelationshipEvent != null) break block31;
                    throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
                }
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "createTECEvent");
            }
            return phRelationshipEvent.toString();
        }
        if (this.tecEventClass.equals(LOGICAL_ENTITY_EVENT)) {
            TECEvent logEntityEvent;
            block32: {
                logEntityEvent = new TECEvent();
                this.setGeneralTECValues(logEntityEvent);
                try {
                    logEntityEvent.setSlot(UNIQUE_ID, this.verifyValue(UNIQUE_ID, (String)this.tecAttributes.get(UNIQUE_ID)));
                    logEntityEvent.setSlot(ENTITY_TYPE, this.verifyValue(ENTITY_TYPE, (String)this.tecAttributes.get(ENTITY_TYPE)));
                    logEntityEvent.setSlot(LABEL, this.verifyValue(LABEL, (String)this.tecAttributes.get(LABEL)));
                    logEntityEvent.setSlot(TYPE, this.verifyValue(TYPE, (String)this.tecAttributes.get(TYPE)));
                    logEntityEvent.setSlot(HLD, this.verifyValue(HLD, (String)this.tecAttributes.get(HLD)));
                    logEntityEvent.setSlot(STATE, this.verifyValue(STATE, (String)this.tecAttributes.get(STATE)));
                    logEntityEvent.setSlot(EVENT_TYPE, this.verifyValue(EVENT_TYPE, (String)this.tecAttributes.get(EVENT_TYPE)));
                }
                catch (NullPointerException npe) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "createTECEvent", (Throwable)npe);
                    if (logEntityEvent != null) break block32;
                    throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
                }
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "createTECEvent");
            }
            return logEntityEvent.toString();
        }
        if (this.tecEventClass.equals(LOGICAL_RELATIONSHIP_EVENT)) {
            TECEvent logRelationshipEvent;
            block33: {
                logRelationshipEvent = new TECEvent();
                this.setGeneralTECValues(logRelationshipEvent);
                try {
                    logRelationshipEvent.setSlot(UNIQUE_ID, this.verifyValue(UNIQUE_ID, (String)this.tecAttributes.get(UNIQUE_ID)));
                    logRelationshipEvent.setSlot(ENTITY_TYPE, this.verifyValue(ENTITY_TYPE, (String)this.tecAttributes.get(ENTITY_TYPE)));
                    logRelationshipEvent.setSlot(TO_OBJ_UID, this.verifyValue(TO_OBJ_UID, (String)this.tecAttributes.get(TO_OBJ_UID)));
                    logRelationshipEvent.setSlot(TO_OBJ_LABEL, this.verifyValue(TO_OBJ_LABEL, (String)this.tecAttributes.get(TO_OBJ_LABEL)));
                    logRelationshipEvent.setSlot(TO_OBJ_TYPE, this.verifyValue(TO_OBJ_TYPE, (String)this.tecAttributes.get(TO_OBJ_TYPE)));
                    logRelationshipEvent.setSlot(TO_HLD, this.verifyValue(TO_HLD, (String)this.tecAttributes.get(TO_HLD)));
                    logRelationshipEvent.setSlot(FROM_OBJ_UID, this.verifyValue(FROM_OBJ_UID, (String)this.tecAttributes.get(FROM_OBJ_UID)));
                    logRelationshipEvent.setSlot(FROM_OBJ_LABEL, this.verifyValue(FROM_OBJ_LABEL, (String)this.tecAttributes.get(FROM_OBJ_LABEL)));
                    logRelationshipEvent.setSlot(FROM_OBJ_TYPE, this.verifyValue(FROM_OBJ_TYPE, (String)this.tecAttributes.get(FROM_OBJ_TYPE)));
                    logRelationshipEvent.setSlot(FROM_HLD, this.verifyValue(FROM_HLD, (String)this.tecAttributes.get(FROM_HLD)));
                    logRelationshipEvent.setSlot(STATE, this.verifyValue(STATE, (String)this.tecAttributes.get(STATE)));
                    logRelationshipEvent.setSlot(EVENT_TYPE, this.verifyValue(EVENT_TYPE, (String)this.tecAttributes.get(EVENT_TYPE)));
                }
                catch (NullPointerException npe) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "createTECEvent", (Throwable)npe);
                    if (logRelationshipEvent != null) break block33;
                    throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
                }
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "createTECEvent");
            }
            return logRelationshipEvent.toString();
        }
        if (this.tecEventClass.equals(SAN_MANAGER_STATUS_EVENT)) {
            TECEvent managerStatusEvent;
            block34: {
                managerStatusEvent = new TECEvent();
                this.setGeneralTECValues(managerStatusEvent);
                try {
                    managerStatusEvent.setSlot(ACTION_PERFORMED, this.verifyValue(ACTION_PERFORMED, (String)this.tecAttributes.get(ACTION_PERFORMED)));
                }
                catch (NullPointerException npe) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "createTECEvent", (Throwable)npe);
                    if (managerStatusEvent != null) break block34;
                    throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
                }
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "createTECEvent");
            }
            return managerStatusEvent.toString();
        }
        if (this.tecEventClass.equals(SAN_REGION_EVENT)) {
            TECEvent regionEvent;
            block35: {
                regionEvent = new TECEvent();
                this.setGeneralTECValues(regionEvent);
                try {
                    regionEvent.setSlot(SAN_NAME, this.verifyValue(SAN_NAME, (String)this.tecAttributes.get(SAN_NAME)));
                    regionEvent.setSlot(ZONE_NAME, this.verifyValue(ZONE_NAME, (String)this.tecAttributes.get(ZONE_NAME)));
                    regionEvent.setSlot(STATE, this.verifyValue(STATE, (String)this.tecAttributes.get(STATE)));
                    regionEvent.setSlot(EVENT_TYPE, this.verifyValue(EVENT_TYPE, (String)this.tecAttributes.get(EVENT_TYPE)));
                    regionEvent.setSlot(ZONE_SET_NAME, this.verifyValue(ZONE_SET_NAME, (String)this.tecAttributes.get(ZONE_SET_NAME)));
                    regionEvent.setSlot(ACTIVE, this.verifyValue(ACTIVE, (String)this.tecAttributes.get(ACTIVE)));
                }
                catch (NullPointerException npe) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "createTECEvent", (Throwable)npe);
                    if (regionEvent != null) break block35;
                    throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
                }
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "createTECEvent");
            }
            return regionEvent.toString();
        }
        if (this.tecEventClass.equals(SERVICE_EVENT)) {
            TECEvent serviceEvent;
            block36: {
                serviceEvent = new TECEvent();
                this.setGeneralTECValues(serviceEvent);
                try {
                    serviceEvent.setSlot(SERVICE_NAME, this.verifyValue(SERVICE_NAME, (String)this.tecAttributes.get(SERVICE_NAME)));
                    serviceEvent.setSlot(SERVICE_STATE, this.verifyValue(SERVICE_STATE, (String)this.tecAttributes.get(SERVICE_STATE)));
                }
                catch (NullPointerException npe) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "createTECEvent", (Throwable)npe);
                    if (serviceEvent != null) break block36;
                    throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
                }
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "createTECEvent");
            }
            return serviceEvent.toString();
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "createTECEvent", (Object)("Failed to create a TEC event: not a valid TECEvent type " + this.tecEventClass));
        }
        throw new IllegalArgumentException("Failed to create a TEC event: not a valid TECEvent type " + this.tecEventClass);
    }

    private void setGeneralTECValues(TECEvent event) {
        event.setClassName(this.tecEventClass);
        event.setSlot(HOSTNAME, this.tecSpecial + this.tecHostName + this.tecSpecial);
        event.setSlot(ORIGIN, this.tecSpecial + this.tecIPAddress + this.tecSpecial);
        event.setSlot(SOURCE, this.tecSpecial + this.tecComponent + this.tecSpecial);
        event.setSlot(SUB_SOURCE, this.tecSpecial + this.tecFunction + this.tecSpecial);
        event.setSlot(MSG, this.tecSpecial + this.tecMessage + this.tecSpecial);
        event.setSlot(MSG_ID, this.tecSpecial + this.tecMessageId + this.tecSpecial);
        event.setSlot(SEVERITY, this.tecSpecial + this.tecSeverity + this.tecSpecial);
    }

    public Hashtable getTECAttributes() throws NullPointerException {
        return this.tecAttributes;
    }

    public String getTECComponent() {
        return this.tecComponent;
    }

    public String getTECFunction() {
        return this.tecFunction;
    }

    public String getTECIPAddress() {
        return this.tecIPAddress;
    }

    public String getTECMessage() {
        return this.tecMessage;
    }

    public String getTECMessageId() {
        return this.tecMessageId;
    }

    public String getTECSeverity() {
        return this.tecSeverity;
    }

    public String getTECEventClass() {
        return this.tecEventClass;
    }

    public void setTECComponent(String component) {
        this.tecComponent = component;
    }

    public void setTECFunction(String function) {
        this.tecFunction = function;
    }

    public void setTECIPAddress(String ip) {
        this.tecIPAddress = ip;
    }

    public void setTECMessage(String message) {
        this.tecMessage = message;
    }

    public void setTECMessageId(String messageId) {
        this.tecMessageId = messageId;
    }

    public void setTECSeverity(String severity) {
        this.tecSeverity = severity;
    }

    public void setTECEventClass(String tecClass) {
        this.tecEventClass = tecClass;
    }

    private String verifyValue(String ID, String inputValue) {
        String methodName = "verifyValue";
        String val = inputValue;
        if (val != null) {
            return this.tecSpecial + val + this.tecSpecial;
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_ERR, (Object)className, methodName, "Null value found for TEC attribute " + ID);
        }
        String returnValue = "";
        return returnValue;
    }
}

