/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.MessagingService;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.MessagingService;

public class TopicHandler
implements Runnable {
    private ILogger traceLogger = MessagingService.traceLogger;
    private ILogger msgLogger = MessagingService.msgLogger;
    private static String className = null;
    private String topic = null;
    private Hashtable<String, String[]> subscribers = null;
    private Vector messages = null;
    public boolean hasNoSubscribers = false;
    public boolean stopThread = false;

    public TopicHandler(String topic) {
        className = this.getClass().getName();
        String methodName = "TopicHandler()";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.topic = topic;
        this.subscribers = new Hashtable();
        this.messages = new Vector();
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(String url, String service) {
        String methodName = "addSubscriber(String url, String service)";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        Hashtable<String, String[]> hashtable = this.subscribers;
        synchronized (hashtable) {
            this.subscribers.put("localhost:" + service, new String[]{url, service});
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriber(String url, String service) {
        String methodName = "removeSubscriber(String url, String service)";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        Hashtable<String, String[]> hashtable = this.subscribers;
        synchronized (hashtable) {
            if (url == null) {
                this.subscribers.remove("localhost:" + service);
            } else {
                this.subscribers.remove(url + ":" + service);
            }
            if (this.subscribers.size() == 0) {
                this.hasNoSubscribers = true;
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(Message message) {
        String methodName = "addMessage(Message message)";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        Object object = this.messages;
        synchronized (object) {
            this.messages.add(message);
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread() {
        String methodName = "stopThread()";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.stopThread = true;
        TopicHandler topicHandler = this;
        synchronized (topicHandler) {
            this.notify();
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message getNextMessage() {
        String methodName = "getNextMessage()";
        Message message = null;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        while (!this.stopThread && message == null) {
            try {
                Vector vector = this.messages;
                synchronized (vector) {
                    message = (Message)this.messages.remove(0);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (this.stopThread) continue;
                try {
                    TopicHandler topicHandler = this;
                    synchronized (topicHandler) {
                        this.wait();
                    }
                }
                catch (InterruptedException e1) {
                    return null;
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Message message;
        String methodName = "run()";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        while (!this.stopThread && (message = this.getNextMessage()) != null) {
            Enumeration<String> keys;
            Hashtable<String, String[]> hashtable = this.subscribers;
            synchronized (hashtable) {
                keys = this.subscribers.keys();
            }
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String[] proxyInfo = this.subscribers.get(key);
                MessageListener proxy = this.getMessageListenerProxy(proxyInfo[0], proxyInfo[1]);
                if (proxy == null) continue;
                try {
                    proxy.onMessage(message);
                }
                catch (Throwable e) {
                    if (this.msgLogger != null && this.msgLogger.isLogging()) {
                        this.msgLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "MessagingService_OnMessageException", (Object)key);
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, e);
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public String getTopic() {
        String methodName = "getTopic()";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return this.topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getSubscribers() {
        Hashtable<String, String[]> subs;
        Hashtable<String, String[]> hashtable = this.subscribers;
        synchronized (hashtable) {
            subs = this.subscribers;
        }
        return subs;
    }

    public Vector getMessages() {
        return this.messages;
    }

    private MessageListener getMessageListenerProxy(String url, String service) {
        MessageListener proxy;
        block3: {
            String methodName = "getMessageListenerProxy";
            proxy = null;
            try {
                proxy = url == null ? (MessageListener)Activator._serviceHelper.bindLocal(service) : (MessageListener)ConnectorClient.getService((String)url, MessageListener.class, (String)service);
            }
            catch (Exception ex) {
                if (this.msgLogger != null && this.msgLogger.isLogging()) {
                    this.msgLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "MessagingService_GetProxyFailed", (Object)service);
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block3;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ex);
            }
        }
        return proxy;
    }
}

