/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms;

import java.net.InetAddress;
import java.util.Vector;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.interfaces.IMessagingService;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms.JMSImplLogInfo;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms.MSTopicSession;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms.MSTopicSubscriber;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;

public class MSTopicConnection
implements TopicConnection {
    private boolean started = false;
    private Vector subscribers = new Vector();
    private String hostName = null;
    private int port = 0;
    private ILogger traceLogger = JMSImplLogInfo.traceLogger;
    private ILogger msgLogger = JMSImplLogInfo.msgLogger;
    private static String className = null;

    public MSTopicConnection(String serverName, int serverPort) {
        className = this.getClass().getName();
        String methodName = "MSTopicConnection(String serverName, int serverPort)";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.hostName = serverName;
        this.port = serverPort;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public String getHostName() {
        String methodName = "getHostName()";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return this.hostName;
    }

    public void setPort(int port) {
        String methodName = "setPort(int port)";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.port = port;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public int getPort() {
        String methodName = "getPort()";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return this.port;
    }

    public ConnectionConsumer createConnectionConsumer(Topic arg0, String arg1, ServerSessionPool arg2, int arg3) throws JMSException {
        throw new JMSException("createConnectionConsumer not implemented");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic arg0, String arg1, String arg2, ServerSessionPool arg3, int arg4) throws JMSException {
        throw new JMSException("createDurableConnectionConsumer not implemented");
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        String methodName = "createTopicSession(boolean transacted, int acknowledgeMode)";
        MSTopicSession topicSes = null;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (transacted || acknowledgeMode != 0) {
            throw new JMSException("createTopicSession not implemented for transacted=true or acknowledgeMode!=0.");
        }
        topicSes = new MSTopicSession(this);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return topicSes;
    }

    public void close() throws JMSException {
        String methodName = "close()";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public String getClientID() throws JMSException {
        throw new JMSException("getClientID() not implemented");
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        throw new JMSException("getExceptionListener() not implemented");
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        throw new JMSException("getMetaData() not implemented");
    }

    public void setClientID(String arg0) throws JMSException {
        throw new JMSException("setClientID() not implemented");
    }

    public void setExceptionListener(ExceptionListener arg0) throws JMSException {
        throw new JMSException("setExceptionListener(ExceptionListener arg0) not implemented");
    }

    public void start() throws JMSException {
        String methodName = "start()";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (!this.started) {
            for (int i = 0; i < this.subscribers.size(); ++i) {
                this.subscribe((MSTopicSubscriber)this.subscribers.get(i));
            }
            this.started = true;
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void stop() throws JMSException {
        String methodName = "stop()";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (this.started) {
            for (int i = 0; i < this.subscribers.size(); ++i) {
                this.unsubscribe((MSTopicSubscriber)this.subscribers.get(i));
            }
            this.started = false;
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    protected void addSubscriber(MSTopicSubscriber topicSubscriber) throws JMSException {
        String methodName = "addSubscriber(MSTopicSubscriber topicSubscriber)";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.subscribers.add(topicSubscriber);
        if (this.started) {
            this.subscribe(topicSubscriber);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void subscribe(MSTopicSubscriber topicSubscriber) throws JMSException {
        String methodName = "subscribe(MSTopicSubscriber topicSubscriber)";
        IMessagingService msgProxy = null;
        String url = null;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        String service = ((IService)topicSubscriber.getMessageListener()).getName();
        String topic = topicSubscriber.getTopic().getTopicName();
        try {
            if (this.hostName.equals("localhost")) {
                msgProxy = (IMessagingService)Activator._serviceHelper.bindLocal("MessagingService");
            } else {
                msgProxy = (IMessagingService)ConnectorClient.getService((String)this.hostName, (int)this.port, IMessagingService.class, (String)"MessagingService");
                String localIP = InetAddress.getLocalHost().getHostAddress();
                IConfigService dbp = null;
                dbp = (IConfigService)Activator._serviceHelper.bindLocal("ConfigService");
                String localPort = dbp.getProperty("agent.port", "setup");
                int Port = Integer.parseInt(localPort);
                url = localIP + ":" + Port;
            }
            if (!msgProxy.isAlive()) {
                if (this.msgLogger != null && this.msgLogger.isLogging()) {
                    this.msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "MessagingService_Down");
                }
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Messaging Service is not running. Cannot subscribe to events.");
                }
                throw new JMSException("Messaging Service is not running. Cannot subscribe to events.");
            }
            msgProxy.subscribe(topic, url, service);
        }
        catch (Exception e) {
            if (this.msgLogger != null && this.msgLogger.isLogging()) {
                this.msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "subscribe_failed", (Object)service, (Object)topic);
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            throw new JMSException("Service cannot subscribe to topic. Exception: " + e.toString());
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void unsubscribe(MSTopicSubscriber topicSubscriber) {
        String methodName = "unsubscribe(MSTopicSubscriber topicSubscriber)";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }
}

