/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.messaging;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.aperi.sanmgmt.middleware.messaging.BaseFactory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.exception.FactoryCreationFailedException;
import org.eclipse.aperi.sanmgmt.middleware.messaging.exception.UnknownFactoryTypeException;

public class FactoryFactory {
    public static final int MQSERIES = 1;
    public static final int SRM_MESSAGING_SERVICE = 2;
    public static final int MESSAGINGSERVICE = 2;
    public static final int CURRENT_JMS_PROVIDER = 2;

    public static Factory createFactory(int factoryType, String configurationParameter) throws UnknownFactoryTypeException, FactoryCreationFailedException {
        return FactoryFactory.createFactory(factoryType, configurationParameter, null, null);
    }

    public static Factory createFactory(int factoryType, String configurationParameter, String messageLoggerName, String traceLoggerName) throws UnknownFactoryTypeException, FactoryCreationFailedException {
        String factoryClassName;
        Factory factory = null;
        switch (factoryType) {
            case 1: {
                factoryClassName = "org.eclipse.aperi.sanmgmt.middleware.messagingimpl.FactoryImpl";
                break;
            }
            case 2: {
                factoryClassName = "org.eclipse.aperi.sanmgmt.middleware.messagingimpl.MSFactoryImpl";
                break;
            }
            default: {
                throw new UnknownFactoryTypeException();
            }
        }
        Exception ex = null;
        int i = 0;
        if (i < 2) {
            try {
                factory = (Factory)FactoryFactory.getFactory(factoryClassName, configurationParameter, messageLoggerName, traceLoggerName);
            }
            catch (Exception e) {
                throw new FactoryCreationFailedException(e);
            }
        }
        if (factory == null) {
            throw new FactoryCreationFailedException(ex);
        }
        return factory;
    }

    private static BaseFactory getFactory(String factoryClassName, String configurationParameter, String messageLoggerName, String traceLoggerName) throws FactoryCreationFailedException {
        Constructor<?> factoryConstructor;
        Class<?> factoryClass = null;
        try {
            factoryClass = Class.forName(factoryClassName);
        }
        catch (ClassNotFoundException e) {
            throw new FactoryCreationFailedException(e);
        }
        try {
            Class<?> stringClass = Class.forName("java.lang.String");
            factoryConstructor = factoryClass.getDeclaredConstructor(stringClass, stringClass, stringClass);
        }
        catch (Exception e) {
            throw new FactoryCreationFailedException(e);
        }
        BaseFactory factory = null;
        try {
            factory = (BaseFactory)factoryConstructor.newInstance(configurationParameter, messageLoggerName, traceLoggerName);
        }
        catch (InvocationTargetException ex) {
            throw new FactoryCreationFailedException(ex);
        }
        catch (Exception e) {
            throw new FactoryCreationFailedException(e);
        }
        return factory;
    }
}

