/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control;

import org.eclipse.aperi.control.ControlThread;
import org.eclipse.aperi.control.data.ControlConstants;
import org.eclipse.aperi.control.interfaces.NoResourcesAvailableException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class ThreadPool {
    private Thread[] controlThreads = null;
    private Runnable nextJob = null;
    private String controllerName;
    ILogger msgLogger = ControlConstants.msgLogger;
    ILogger traceLogger = ControlConstants.traceLogger;
    static final String className = ThreadPool.class.getName();

    public ThreadPool(int size) {
        String methodName = "ThreadPool";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Starting " + size + " control threads...");
        }
        this.initializeThreadPool(size, "Controller");
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public ThreadPool(int size, String controllerName) {
        String methodName = "ThreadPool";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Starting " + size + " control threads...");
        }
        this.initializeThreadPool(size, controllerName);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    protected void initializeThreadPool(int size, String controllerName) {
        String methodName = "initializeThreadPool";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Starting " + size + " control threads for " + controllerName + "...");
        }
        this.controllerName = controllerName;
        this.controlThreads = new ControlThread[size];
        for (int i = 0; i < this.controlThreads.length; ++i) {
            this.controlThreads[i] = new ControlThread(this, i + 1);
            this.controlThreads[i].start();
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public synchronized void addJobToPool(Runnable job) throws NoResourcesAvailableException {
        String methodName = "addJobToPool";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        if (this.nextJob != null) {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "All control threads are being used.  Throwing NoResourcesAvailableException");
            }
            throw new NoResourcesAvailableException();
        }
        this.nextJob = job;
        this.notify();
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public synchronized Runnable getNextJob() {
        String methodName = "getNextJob";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        try {
            if (this.nextJob == null) {
                this.wait();
            }
            Runnable job = this.nextJob;
            this.nextJob = null;
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return job;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public void shutdown() {
        String methodName = "shutdown";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        for (int i = 0; i < this.controlThreads.length; ++i) {
            try {
                this.controlThreads[i].interrupt();
                this.controlThreads[i].join(30000L);
                continue;
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }
}

