/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.snmp.SessionInfo;
import org.eclipse.aperi.snmp.SessionInfoCommString;
import org.eclipse.aperi.snmp.SnmpBERlength;
import org.eclipse.aperi.snmp.SnmpDecodeException;
import org.eclipse.aperi.snmp.SnmpEncodeException;
import org.eclipse.aperi.snmp.SnmpMsgBuffer;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.SnmpV2PDU;
import org.eclipse.aperi.snmp.SnmpV2Trap;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.SnmpWrongVersion;
import org.eclipse.aperi.snmp.data.Counter;
import org.eclipse.aperi.snmp.data.Counter64;
import org.eclipse.aperi.snmp.data.EndOfMibView;
import org.eclipse.aperi.snmp.data.FullCounter64;
import org.eclipse.aperi.snmp.data.Gauge;
import org.eclipse.aperi.snmp.data.Hex;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.NoSuchInstance;
import org.eclipse.aperi.snmp.data.NoSuchObject;
import org.eclipse.aperi.snmp.data.Null;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.data.Opaque;
import org.eclipse.aperi.snmp.data.TimeTicks;

public abstract class SnmpAsn1 {
    private static final byte GET_TAG = -96;
    private static final byte GETNEXT_TAG = -95;
    private static final byte RESPONSE_TAG = -94;
    private static final byte SET_TAG = -93;
    private static final byte V1_TRAP_TAG = -92;
    private static final byte GETBULK_TAG = -91;
    private static final byte INFORM_TAG = -90;
    private static final byte V2_TRAP_TAG = -89;
    private static final byte REPORT_TAG = -88;
    protected static final byte SEQUENCE_TAG = 48;
    protected static final byte INTEGER_TAG = 2;
    private static final byte BIT_STRING = 3;
    protected static final byte OCTET_TAG = 4;
    private static final byte NULL_TAG = 5;
    private static final byte OID_TAG = 6;
    private static final byte IPADDRESS_TAG = 64;
    private static final byte COUNTER_TAG = 65;
    private static final byte GAUGE_TAG = 66;
    private static final byte TIMETICKS_TAG = 67;
    private static final byte OPAQUE_TAG = 68;
    private static final byte COUNTER64_TAG = 70;
    private static final byte CONSTRUCTED_FLAG = 32;
    private static final byte CLASS_MASK_TAG = -64;
    private static final byte CLASS_FLAG_MASK = -32;
    private static final byte UNIVERSAL = 0;
    private static final byte APPLICATION_WIDE = 64;
    private static final byte CONTEXT_SPECIFIC = -128;
    private static final byte PRIVATE_TAG = -64;
    private static final byte NOSUCHOBJECT_TAG = -128;
    private static final byte NOSUCHINSTANCE_TAG = -127;
    private static final byte ENDOFMIBVIEW_TAG = -126;
    private static Null nullInstance = new Null();
    private static final byte[] opType = new byte[]{-96, -95, -94, -93, -91, -90, -89, -88};

    public static int asnReadLen(SnmpMsgBuffer b) throws SnmpDecodeException {
        int totlen = 0;
        int i = b.index;
        if (b.buf[i] == -128) {
            throw new SnmpDecodeException("Indefinite Length not supported");
        }
        if ((b.buf[i] & 0x80) == 0) {
            b.lenLen = 1;
            b.len = b.buf[i] & 0x7F;
            return b.len;
        }
        b.lenLen = (b.buf[i] & 0x7F) + 1;
        if (b.lenLen > 5 || b.lenLen > b.buf.length - ++i + 1) {
            throw new SnmpDecodeException("Length of len too big (" + b.lenLen + ")");
        }
        int limit = b.index + b.lenLen - 1;
        totlen = 0;
        while (i <= limit) {
            totlen = totlen << 8 | b.buf[i] & 0xFF;
            ++i;
        }
        b.len = totlen;
        return totlen;
    }

    public static int asnDecodeLen(SnmpMsgBuffer b) throws SnmpDecodeException {
        int len = SnmpAsn1.asnReadLen(b);
        b.index += b.lenLen;
        if (b.buf.length - b.index < len) {
            throw new SnmpDecodeException("Data smaller than its encoded length!");
        }
        b.len = len;
        return len;
    }

    public static void asnEncodeLen(SnmpMsgBuffer b, int len) throws SnmpEncodeException {
        int i;
        if (len <= 127) {
            if (b.buf.length - b.index - len < 1) {
                throw new SnmpEncodeException("Buffer can't take this len+data! has: " + (b.buf.length - b.index) + " needs: " + (len + 1));
            }
            b.buf[b.index++] = (byte)(len & 0x7F);
            b.len = len;
            b.lenLen = 1;
            return;
        }
        if (len <= 254) {
            if (b.buf.length - (b.index + len) < 2) {
                throw new SnmpEncodeException("Buffer can't take this len+data!\n \thas: " + (b.buf.length - b.index) + " needs: " + (len + 2) + "\n");
            }
            b.buf[b.index++] = -127;
            b.buf[b.index++] = (byte)(len & 0xFF);
            b.len = len;
            b.lenLen = 2;
            return;
        }
        int mask = -8388608;
        int ind = 0;
        for (i = 4; i > 1 && (mask & len) == 0; --i) {
            mask >>>= 8;
        }
        if (b.buf.length - (b.index + len) < i) {
            throw new SnmpEncodeException("Buffer can't take this len+data! b.size=" + b.buf.length + " b.index=" + b.index + " b.len=" + b.len + " datalen=" + len + " lenLen=" + i);
        }
        b.len = len;
        b.lenLen = i;
        b.buf[b.index++] = (byte)(0x80 | i & 0x7F);
        b.index = ind = b.index + i;
        while (i-- > 0) {
            b.buf[--ind] = (byte)(len & 0xFF);
            len >>>= 8;
        }
    }

    public static byte asnDecodeHeader(SnmpMsgBuffer b) throws SnmpDecodeException {
        byte tag;
        if (((tag = b.buf[b.index++]) & 0x1F) == 31) {
            throw new SnmpDecodeException("Extended Tags not supported");
        }
        int len = SnmpAsn1.asnReadLen(b);
        if (b.index + len + b.lenLen > b.buf.length) {
            throw new SnmpDecodeException("Data len (" + (b.index + len + b.lenLen + 1) + ")" + " > buf.length (" + b.buf.length + ")?!");
        }
        b.index += b.lenLen;
        b.len = len;
        return tag;
    }

    public static void asnEncodeHeader(SnmpMsgBuffer b, byte tag, int len) throws SnmpEncodeException {
        if (b.buf.length - b.index < 1) {
            throw new SnmpEncodeException("No room in buf to take even a tag!");
        }
        b.buf[b.index++] = tag;
        SnmpAsn1.asnEncodeLen(b, len);
    }

    public static byte asnDecodeNull(SnmpMsgBuffer b) throws SnmpDecodeException {
        byte tag = b.buf[b.index++];
        if (b.buf[b.index++] != 0) {
            throw new SnmpDecodeException("Not ASN.1 NULL where expected");
        }
        return tag;
    }

    public static void asnEncodeNull(SnmpMsgBuffer b, byte tag) throws SnmpEncodeException {
        if (b.buf.length - b.index < 2) {
            throw new SnmpEncodeException("No room in the msg buffer!");
        }
        b.buf[b.index++] = tag;
        b.buf[b.index++] = 0;
    }

    public static int asnDecodeInt(SnmpMsgBuffer b) throws SnmpDecodeException {
        byte tag = SnmpAsn1.asnDecodeHeader(b);
        int value = (b.buf[b.index] & 0x80) > 0 ? -1 : 0;
        int limit = b.index + b.len;
        while (b.index < limit) {
            value = value << 8 | b.buf[b.index++] & 0xFF;
        }
        return value;
    }

    public static void asnEncodeInt(SnmpMsgBuffer b, byte tag, int i) throws SnmpEncodeException {
        int k;
        int mask = -8388608;
        int tmp = i >= 0 ? i : ~i;
        int len = 0;
        for (k = 4; k > 1 && (mask & tmp) == 0; --k) {
            mask >>>= 8;
        }
        len = k;
        SnmpAsn1.asnEncodeHeader(b, tag, k);
        while (k-- > 0) {
            b.buf[b.index + k] = (byte)(i & 0xFF);
            i >>>= 8;
        }
        b.index += len;
    }

    public static int asnDecodeUInt(SnmpMsgBuffer b) throws SnmpDecodeException {
        byte tag = SnmpAsn1.asnDecodeHeader(b);
        int limit = b.index + b.len;
        int value = 0;
        while (b.index < limit) {
            value = value << 8 | b.buf[b.index++] & 0xFF;
        }
        return value;
    }

    public static void asnEncodeUInt(SnmpMsgBuffer b, byte tag, int uin) throws SnmpEncodeException {
        int i;
        int mask = -8388608;
        int sign = Integer.MIN_VALUE;
        int len = 0;
        for (i = 4; i > 1 && (mask & uin) == 0; --i) {
            mask >>>= 8;
            sign >>>= 8;
        }
        if ((uin & sign) != 0) {
            ++i;
        }
        len = i;
        SnmpAsn1.asnEncodeHeader(b, tag, i);
        while (i-- > 0) {
            b.buf[b.index + i] = (byte)(uin & 0xFF);
            uin >>>= 8;
        }
        b.index += len;
    }

    public static byte[] asnDecodeOctetString(SnmpMsgBuffer b) throws SnmpDecodeException {
        byte tag = b.buf[b.index++];
        byte[] str = new byte[SnmpAsn1.asnDecodeLen(b)];
        System.arraycopy(b.buf, b.index, str, 0, str.length);
        b.index += str.length;
        return str;
    }

    public static void asnEncodeOctetString(SnmpMsgBuffer b, byte tag, byte[] str) throws SnmpEncodeException {
        if (str == null) {
            SnmpAsn1.asnEncodeNull(b, tag);
            return;
        }
        SnmpAsn1.asnEncodeHeader(b, tag, str.length);
        System.arraycopy(str, 0, b.buf, b.index, str.length);
        b.index += str.length;
    }

    public static long[] asnDecodeOid(SnmpMsgBuffer b) throws SnmpDecodeException {
        byte tag = SnmpAsn1.asnDecodeHeader(b);
        int numsubids = 2;
        int i = 0;
        int limit = 0;
        int len = b.len;
        if (len == 0) {
            long[] oid = new long[2];
            oid[1] = 0L;
            oid[0] = 0L;
            return oid;
        }
        limit = b.index + len;
        for (i = b.index; i < limit; ++i) {
            if (b.buf[i] < 0) continue;
            ++numsubids;
        }
        long[] oid = new long[--numsubids];
        int subids = 0;
        subids = 1;
        while (len > 0) {
            oid[subids] = 0L;
            while (len-- > 0) {
                oid[subids] = oid[subids] << 7 | (long)(b.buf[b.index] & 0x7F);
                if ((b.buf[b.index++] & 0x80) == 128) continue;
            }
            ++subids;
        }
        if (oid[1] / 40L >= 2L) {
            oid[0] = 2L;
            oid[1] = (byte)(oid[1] - 80L);
        } else {
            oid[0] = (byte)(oid[1] / 40L);
            oid[1] = (byte)(oid[1] % 40L);
        }
        return oid;
    }

    public static void asnEncodeOid(SnmpMsgBuffer b, byte tag, long[] oid) throws SnmpEncodeException {
        int len = 0;
        int i = 0;
        int ind = 0;
        int m = 0;
        long k = 0L;
        if (oid == null) {
            SnmpAsn1.asnEncodeNull(b, tag);
            return;
        }
        if (oid[0] > 2L || oid[1] > 39L && oid[1] <= 1L) {
            throw new SnmpEncodeException("Illegal OID! Shrink...");
        }
        oid[1] = oid[1] + oid[0] * 40L;
        len = 0;
        for (i = 1; i < oid.length; ++i) {
            if (oid[i] < 255L) {
                ++len;
                continue;
            }
            if (oid[i] < 65535L) {
                len += 2;
                continue;
            }
            if (oid[i] < 0xFFFFFFL) {
                len += 3;
                continue;
            }
            if (oid[i] < 0xFFFFFFFFL) {
                len += 4;
                continue;
            }
            if (oid[i] < 0xFFFFFFFFFFL) {
                len += 5;
                continue;
            }
            if (oid[i] < 0xFFFFFFFFFFFFL) {
                len += 6;
                continue;
            }
            if (oid[i] < 0xFFFFFFFFFFFFFFL) {
                len += 7;
                continue;
            }
            len += 8;
        }
        byte[] tmp = new byte[2 * ++len];
        ind = 2 * len - 1;
        len = 0;
        for (i = oid.length - 1; i >= 1; --i) {
            m = 1;
            k = oid[i];
            while (ind >= b.index) {
                tmp[ind] = (byte)(k & 0x7FL);
                k >>= 7;
                if (m > 1) {
                    int n = ind;
                    tmp[n] = (byte)(tmp[n] | 0xFFFFFF80);
                }
                --ind;
                if (k == 0L) break;
                ++m;
            }
            len += m;
        }
        SnmpAsn1.asnEncodeHeader(b, tag, len);
        System.arraycopy(tmp, ind + 1, b.buf, b.index, len);
        oid[1] = oid[1] - oid[0] * 40L;
        b.index += len;
        tmp = null;
    }

    public static Serializable asnDecodePrimitive(SnmpMsgBuffer b) throws SnmpDecodeException {
        byte type = b.buf[b.index];
        Serializable ret = null;
        ret = type == 2 ? new Integer(SnmpAsn1.asnDecodeInt(b)) : (type == 4 ? new OctetString(SnmpAsn1.asnDecodeOctetString(b)) : (type == 6 ? new OID(SnmpAsn1.asnDecodeOid(b)) : (type == 67 ? new TimeTicks(SnmpAsn1.asnDecodeUInt(b)) : (type == 65 ? new Counter(SnmpAsn1.asnDecodeUInt(b)) : (type == 66 ? new Gauge(SnmpAsn1.asnDecodeUInt(b)) : (type == -128 ? new NoSuchObject() : (type == -127 ? new NoSuchInstance() : (type == -126 ? new EndOfMibView() : (type == 64 ? new IPAddress(SnmpAsn1.asnDecodeOctetString(b), 0) : nullInstance)))))))));
        return ret;
    }

    public static void asnEncodePrimitive(SnmpMsgBuffer b, Serializable ss) throws SnmpEncodeException {
        if (ss instanceof Integer) {
            SnmpAsn1.asnEncodeInt(b, (byte)2, (Integer)ss);
        } else if (ss instanceof OctetString) {
            SnmpAsn1.asnEncodeOctetString(b, (byte)4, ((OctetString)ss).value);
        } else if (ss instanceof Gauge) {
            SnmpAsn1.asnEncodeUInt(b, (byte)66, (int)((Gauge)ss).getValue());
        } else if (ss instanceof Counter) {
            SnmpAsn1.asnEncodeUInt(b, (byte)65, (int)((Counter)ss).getValue());
        } else if (ss instanceof TimeTicks) {
            SnmpAsn1.asnEncodeUInt(b, (byte)67, (int)((TimeTicks)ss).getValue());
        } else if (ss instanceof IPAddress) {
            SnmpAsn1.asnEncodeOctetString(b, (byte)64, ((IPAddress)ss).getBytes());
        } else if (ss instanceof Null) {
            SnmpAsn1.asnEncodeNull(b, (byte)5);
        } else if (ss instanceof OID) {
            SnmpAsn1.asnEncodeOid(b, (byte)6, ((OID)ss).value);
        } else if (ss instanceof NoSuchObject) {
            SnmpAsn1.asnEncodeNull(b, (byte)-128);
        } else if (ss instanceof NoSuchInstance) {
            SnmpAsn1.asnEncodeNull(b, (byte)-127);
        } else if (ss instanceof EndOfMibView) {
            SnmpAsn1.asnEncodeNull(b, (byte)-126);
        }
    }

    public static void prettyPrint(byte[] msg, int len) {
        SnmpMsgBuffer b = new SnmpMsgBuffer(msg);
        SnmpAsn1.prettyPrint(b, 0, len);
    }

    public static void uriPrettyPrint(SnmpMsgBuffer b, int indent, int offset, int elementEnd) {
        int saveindex = b.index;
        if (offset >= b.buf.length) {
            System.err.println("prettyPrint: Offset beyond the buffer end!\n(offset=" + offset + " buf.length=" + b.buf.length + "\n");
            return;
        }
        b.index = offset;
        SnmpAsn1.prettyPrint(b, indent, elementEnd);
        b.index = saveindex;
    }

    public static void prettyPrint(SnmpMsgBuffer b, int indent, int elementEnd) {
        if (b.index > b.buf.length) {
            System.err.println("prettyPrint: index beyond the buffer end!\n(b.index=" + b.index + " buf.length=" + b.buf.length + "\n");
            return;
        }
        if (b.index == b.buf.length) {
            return;
        }
        StringBuffer space = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            space.append(" ");
        }
        String initialSpace = space.toString();
        int len = 0;
        block27: while (b.index < elementEnd) {
            try {
                switch (b.buf[b.index]) {
                    case 0: {
                        len = SnmpAsn1.asnDecodeLen(b);
                        if (len != 0) continue block27;
                        return;
                    }
                    case 48: {
                        ++b.index;
                        len = SnmpAsn1.asnDecodeLen(b);
                        System.out.println(initialSpace + "Sequence [" + len + "]");
                        SnmpAsn1.prettyPrint(b, indent + 2, elementEnd);
                        continue block27;
                    }
                    case -96: {
                        ++b.index;
                        len = SnmpAsn1.asnDecodeLen(b);
                        System.out.println(initialSpace + "GET [" + len + "]");
                        SnmpAsn1.prettyPrint(b, indent + 2, elementEnd);
                        continue block27;
                    }
                    case -93: {
                        ++b.index;
                        len = SnmpAsn1.asnDecodeLen(b);
                        System.out.println(initialSpace + "SET [" + len + "]");
                        SnmpAsn1.prettyPrint(b, indent + 2, elementEnd);
                        continue block27;
                    }
                    case -95: {
                        ++b.index;
                        len = SnmpAsn1.asnDecodeLen(b);
                        System.out.println(initialSpace + "GET NEXT [" + len + "]");
                        SnmpAsn1.prettyPrint(b, indent + 2, elementEnd);
                        continue block27;
                    }
                    case -91: {
                        ++b.index;
                        len = SnmpAsn1.asnDecodeLen(b);
                        System.out.println(initialSpace + "GET BULK [" + len + "]");
                        SnmpAsn1.prettyPrint(b, indent + 2, elementEnd);
                        continue block27;
                    }
                    case -94: {
                        ++b.index;
                        len = SnmpAsn1.asnDecodeLen(b);
                        System.out.println(initialSpace + "RESPONSE [" + len + "]");
                        SnmpAsn1.prettyPrint(b, indent + 2, elementEnd);
                        continue block27;
                    }
                    case -92: {
                        ++b.index;
                        len = SnmpAsn1.asnDecodeLen(b);
                        System.out.println(initialSpace + "V1 Trap [" + len + "]");
                        SnmpAsn1.prettyPrint(b, indent + 2, elementEnd);
                        continue block27;
                    }
                    case -89: {
                        ++b.index;
                        len = SnmpAsn1.asnDecodeLen(b);
                        System.out.println(initialSpace + "V2 Trap [" + len + "]");
                        SnmpAsn1.prettyPrint(b, indent + 2, elementEnd);
                        continue block27;
                    }
                    case -88: {
                        ++b.index;
                        len = SnmpAsn1.asnDecodeLen(b);
                        System.out.println(initialSpace + "Report [" + len + "]");
                        SnmpAsn1.prettyPrint(b, indent + 2, elementEnd);
                        continue block27;
                    }
                    case -90: {
                        ++b.index;
                        len = SnmpAsn1.asnDecodeLen(b);
                        System.out.println(initialSpace + "Inform [" + len + "]");
                        SnmpAsn1.prettyPrint(b, indent + 2, elementEnd);
                        continue block27;
                    }
                    case 2: {
                        System.out.println(initialSpace + "Int =" + SnmpAsn1.asnDecodeInt(b));
                        continue block27;
                    }
                    case 4: {
                        ++b.index;
                        System.out.print(initialSpace + "OctetString [0x" + Integer.toHexString(SnmpAsn1.asnReadLen(b)) + "] =");
                        --b.index;
                        System.out.println(Hex.toString(SnmpAsn1.asnDecodeOctetString(b)));
                        continue block27;
                    }
                    case 6: {
                        System.out.println(initialSpace + "OID =" + new OID(SnmpAsn1.asnDecodeOid(b)).toString());
                        continue block27;
                    }
                    case 67: {
                        System.out.println(initialSpace + "TIMETICKS =" + SnmpAsn1.asnDecodeUInt(b));
                        continue block27;
                    }
                    case 65: {
                        System.out.println(initialSpace + "Counter =" + SnmpAsn1.asnDecodeUInt(b));
                        continue block27;
                    }
                    case 66: {
                        System.out.println(initialSpace + "Gauge =" + SnmpAsn1.asnDecodeUInt(b));
                        continue block27;
                    }
                    case 64: {
                        System.out.println(initialSpace + "IP Address =" + Hex.toString(SnmpAsn1.asnDecodeOctetString(b)));
                        continue block27;
                    }
                    case -127: {
                        System.out.println(initialSpace + "NoSuchInstance");
                        SnmpAsn1.asnDecodeNull(b);
                        continue block27;
                    }
                    case -128: {
                        System.out.println(initialSpace + "NoSuchObject");
                        SnmpAsn1.asnDecodeNull(b);
                        continue block27;
                    }
                    case -126: {
                        System.out.println(initialSpace + "EndOfMibView");
                        SnmpAsn1.asnDecodeNull(b);
                        continue block27;
                    }
                    case 5: {
                        System.out.println(initialSpace + "Null");
                        SnmpAsn1.asnDecodeNull(b);
                        continue block27;
                    }
                }
                System.out.print(initialSpace + b.buf[b.index] + " --- Huh?!");
                SnmpAsn1.asnDecodeHeader(b);
                System.out.println(" (len=" + b.len);
                b.index += b.len;
            }
            catch (Exception e) {
                System.out.println("Error in parse:");
                e.printStackTrace();
            }
        }
    }

    static boolean matchByte(byte[] e1, byte[] e2) {
        if (e1 == null || e2 == null) {
            return false;
        }
        if (e1.length != e2.length) {
            return false;
        }
        for (int i = 0; i < e1.length; ++i) {
            if (e1[i] == e2[i]) continue;
            return false;
        }
        return true;
    }

    public static void dump(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            if (i % 16 == 0) {
                System.out.println();
            }
            System.out.print(Integer.toHexString(0xFF & b[i]) + " ");
        }
    }

    public static void dump(byte[] b, int len) {
        int end = 0;
        end = len > b.length ? b.length : len;
        for (int i = 0; i < end; ++i) {
            if (i % 16 == 0) {
                System.out.println();
            }
            System.out.print(Integer.toHexString(0xFF & b[i]) + " ");
        }
    }

    public static int calculate_vb_length(SnmpPDU pdu) {
        int length = 0;
        int limit = pdu.varBindList.size();
        if (pdu.operation == 0 || pdu.operation == 1) {
            for (int i = 0; i < limit; ++i) {
                int oidLength = SnmpAsn1.getOIDlength((SnmpVarBind)pdu.varBindList.elementAt(i));
                oidLength += 3 + SnmpBERlength.size(oidLength);
                length += oidLength + 1 + SnmpBERlength.size(oidLength);
            }
        } else {
            for (int i = 0; i < limit; ++i) {
                int vbLength = SnmpAsn1.getBERlength((SnmpVarBind)pdu.varBindList.elementAt(i));
                length += vbLength + 1 + SnmpBERlength.size(vbLength);
            }
        }
        return length;
    }

    public static int getBERlength(SnmpVarBind vb) {
        if (vb.oidBERlength == 0) {
            SnmpAsn1.getOIDlength(vb);
        }
        int berLength = vb.oidBERlength + 1 + SnmpBERlength.size(vb.oidBERlength);
        if (vb.varBERlength == 0) {
            SnmpAsn1.getVarLength(vb);
        }
        return berLength += vb.varBERlength + 1 + SnmpBERlength.size(vb.varBERlength);
    }

    public static int getOIDlength(SnmpVarBind vb) {
        if (vb.oidBERlength == 0) {
            vb.oidBERlength = vb.oid.getBERlength();
        }
        return vb.oidBERlength;
    }

    public static int getVarLength(SnmpVarBind vb) {
        if (vb.varBERlength == 0) {
            if (vb.variable instanceof Integer) {
                int val = (Integer)vb.variable;
                vb.varBERlength = val < 128 && val >= -128 ? 1 : (val < 32768 && val >= Short.MIN_VALUE ? 2 : (val < 0x800000 && val >= -8388608 ? 3 : 4));
            } else if (vb.variable instanceof OctetString) {
                vb.varBERlength = ((OctetString)vb.variable).value.length;
            } else if (vb.variable instanceof Gauge) {
                long val = ((Gauge)vb.variable).value;
                vb.varBERlength = SnmpAsn1.getLongLength(val);
            } else if (vb.variable instanceof TimeTicks) {
                long val = ((TimeTicks)vb.variable).value;
                vb.varBERlength = SnmpAsn1.getLongLength(val);
            } else if (vb.variable instanceof IPAddress) {
                vb.varBERlength = 4;
            } else if (vb.variable instanceof Null) {
                vb.varBERlength = 0;
            } else if (vb.variable instanceof Counter) {
                long val = ((Counter)vb.variable).value;
                vb.varBERlength = SnmpAsn1.getLongLength(val);
            } else if (vb.variable instanceof Counter64) {
                long val = ((Counter64)vb.variable).value;
                vb.varBERlength = SnmpAsn1.getLongLength(val);
            } else if (vb.variable instanceof FullCounter64) {
                BigInteger val = ((FullCounter64)vb.variable).value;
                vb.varBERlength = val.toByteArray().length;
            } else if (vb.variable instanceof OID) {
                vb.varBERlength = ((OID)vb.variable).getBERlength();
            } else if (vb.variable instanceof NoSuchObject) {
                vb.varBERlength = 0;
            } else if (vb.variable instanceof NoSuchInstance) {
                vb.varBERlength = 0;
            } else if (vb.variable instanceof EndOfMibView) {
                vb.varBERlength = 0;
            }
        }
        return vb.varBERlength;
    }

    public static int getLongLength(long val) {
        if (val < 0L) {
            return 9;
        }
        if (val < 128L) {
            return 1;
        }
        if (val < 32768L) {
            return 2;
        }
        if (val < 0x800000L) {
            return 3;
        }
        if (val < 0x80000000L) {
            return 4;
        }
        if (val < 0x8000000000L) {
            return 5;
        }
        if (val < 0x800000000000L) {
            return 6;
        }
        if (val < 0x80000000000000L) {
            return 7;
        }
        if (val <= 0x7F00000000000000L) {
            return 8;
        }
        return 9;
    }

    protected static int getMessageId(byte[] buffer) {
        int index = 0;
        try {
            if (48 == buffer[index]) {
                ++index;
                if (2 == buffer[index += SnmpBERlength.size(buffer, index)]) {
                    index += SnmpAsn1.nextField(buffer, index);
                } else {
                    SnmpAsn1.decodeError("Version required for SNMP messages", index, buffer, -1);
                }
                if (48 == buffer[index]) {
                    ++index;
                    if (2 == buffer[index += SnmpBERlength.size(buffer, index)]) {
                        return SnmpAsn1.decode_int(buffer, index);
                    }
                    SnmpAsn1.decodeError("MessageID is not tagged as an Integer", index, buffer, -1);
                }
            }
        }
        catch (Exception e) {
            return -1;
        }
        return -1;
    }

    private static long[] decode_OID(byte[] BERbuffer, int startindex) {
        int length = SnmpBERlength.decode(BERbuffer, ++startindex);
        startindex += SnmpBERlength.size(BERbuffer, startindex);
        int numsubids = 2;
        int limit = length + startindex;
        for (int i = 1 + startindex; i < limit; ++i) {
            if (BERbuffer[i] < 0) continue;
            ++numsubids;
        }
        long[] value = new long[numsubids];
        if (BERbuffer[startindex] == 43) {
            value[0] = 1L;
            value[1] = 3L;
        } else {
            value[0] = BERbuffer[startindex] / 40;
            value[1] = BERbuffer[startindex] % 40;
        }
        ++startindex;
        for (int i = 2; i < numsubids; ++i) {
            if (BERbuffer[startindex] >= 0) {
                value[i] = BERbuffer[startindex++];
                continue;
            }
            value[i] = 0L;
            do {
                value[i] = value[i] << 7 | (long)(BERbuffer[startindex] & 0x7F);
            } while (BERbuffer[startindex++] < 0);
        }
        return value;
    }

    private static Serializable decode_snmp_var(byte[] BERbuffer, int startindex) {
        byte type = BERbuffer[startindex];
        Serializable ret = null;
        if (type == 65) {
            ret = new Counter(SnmpAsn1.decode_long(BERbuffer, startindex));
        } else if (type == 66) {
            ret = new Gauge(SnmpAsn1.decode_long(BERbuffer, startindex));
        } else if (type == 2) {
            ret = new Integer(SnmpAsn1.decode_int(BERbuffer, startindex));
        } else if (type == 70) {
            ret = SnmpV1API.isCounter64Full() ? new FullCounter64(SnmpAsn1.decode_big_int(BERbuffer, startindex)) : new Counter64(SnmpAsn1.decode_long(BERbuffer, startindex));
        } else if (type == 67) {
            ret = new TimeTicks(SnmpAsn1.decode_long(BERbuffer, startindex));
        } else if (type == 4) {
            byte[] b = new byte[SnmpBERlength.decode(BERbuffer, ++startindex)];
            System.arraycopy(BERbuffer, startindex + SnmpBERlength.size(BERbuffer, startindex), b, 0, b.length);
            ret = new OctetString(b);
        } else if (type == 64) {
            ret = new IPAddress(BERbuffer, startindex + 2);
        } else if (type == 6) {
            ret = new OID(SnmpAsn1.decode_OID(BERbuffer, startindex), true);
        } else if (type == 5) {
            ret = nullInstance;
        } else if (type == -128) {
            ret = new NoSuchObject();
        } else if (type == -127) {
            ret = new NoSuchInstance();
        } else if (type == -126) {
            ret = new EndOfMibView();
        } else if (type == 68) {
            byte[] b = new byte[SnmpBERlength.decode(BERbuffer, ++startindex)];
            System.arraycopy(BERbuffer, startindex + SnmpBERlength.size(BERbuffer, startindex), b, 0, b.length);
            ret = new Opaque(b);
        } else {
            ret = nullInstance;
        }
        return ret;
    }

    protected static int decode_int(byte[] buffer, int index) {
        int value = 0;
        int len_len = 0;
        int startNum = 0;
        int limit = 0;
        if (buffer[index + 1] >= 0) {
            len_len = 1;
            startNum = index + 2;
            limit = buffer[index + 1] + startNum;
        } else {
            len_len = SnmpBERlength.size(buffer, index + 1);
            startNum = index + 1 + len_len;
            limit = startNum + SnmpBERlength.decode(buffer, index + 1);
        }
        value = buffer[index + 1 + len_len] >= 0 ? 0 : -1;
        for (int i = startNum; i < limit; ++i) {
            value = value << 8 | buffer[i] & 0xFF;
        }
        return value;
    }

    private static long decode_long(byte[] buffer, int index) {
        long value = 0L;
        int len_len = 0;
        int startNum = 0;
        int limit = 0;
        if (buffer[index + 1] >= 0) {
            len_len = 1;
            startNum = index + 2;
            limit = buffer[index + 1] + startNum;
        } else {
            len_len = SnmpBERlength.size(buffer, index + 1);
            startNum = index + 1 + len_len;
            limit = startNum + SnmpBERlength.decode(buffer, index + 1);
        }
        value = buffer[index + 1 + len_len] >= 0 ? 0L : -1L;
        for (int i = startNum; i < limit; ++i) {
            value = value << 8 | (long)(buffer[i] & 0xFF);
        }
        return value;
    }

    private static BigInteger decode_big_int(byte[] buffer, int index) {
        BigInteger value = null;
        int len_len = 0;
        int startNum = 0;
        int limit = 0;
        if (buffer[index + 1] >= 0) {
            len_len = 1;
            startNum = index + 2;
            limit = buffer[index + 1] + startNum;
        } else {
            len_len = SnmpBERlength.size(buffer, index + 1);
            startNum = index + 1 + len_len;
            limit = startNum + SnmpBERlength.decode(buffer, index + 1);
        }
        byte[] valArray = new byte[limit - startNum];
        int j = 0;
        int i = startNum;
        while (i < limit) {
            valArray[j] = buffer[i];
            ++i;
            ++j;
        }
        value = new BigInteger(valArray);
        return value;
    }

    protected static int nextField(byte[] buffer, int index) {
        int length;
        if (buffer[++index] >= 0) {
            length = 2 + buffer[index];
        } else {
            int length_of_length = buffer[index] & 0x7F;
            length = 0;
            for (int i = 0; i < length_of_length; ++i) {
                length = length << 8 | buffer[++index] & 0xFF;
            }
            length += 2 + length_of_length;
        }
        return length;
    }

    private static int encode_oid(byte[] BERbuffer, int startindex, OID oid, int oidLen) {
        BERbuffer[startindex++] = 6;
        startindex = SnmpBERlength.encode(oidLen, BERbuffer, startindex);
        long[] value = oid.value;
        int limit = value.length;
        BERbuffer[startindex++] = (byte)(value[0] * 40L + value[1]);
        for (int i = 2; i < limit; ++i) {
            int bitshift;
            long val = value[i];
            if (val < 0L) {
                bitshift = 49;
            } else {
                if (val < 128L) {
                    BERbuffer[startindex++] = (byte)val;
                    continue;
                }
                bitshift = val < 16384L ? 7 : (val < 0x200000L ? 14 : (val < 0x10000000L ? 21 : (val < 0x800000000L ? 28 : (val < 0x40000000000L ? 35 : (val < 0x2000000000000L ? 42 : 49)))));
            }
            while (bitshift > 0) {
                BERbuffer[startindex++] = (byte)(val >>> bitshift | 0x80L);
                bitshift -= 7;
            }
            BERbuffer[startindex++] = (byte)(val & 0x7FL);
        }
        return startindex;
    }

    private static int encode_snmp_var(byte[] buffer, int index, Serializable variable, int varLen) {
        if (variable instanceof Integer) {
            buffer[index++] = 2;
            buffer[index++] = (byte)varLen;
            int val = (Integer)variable;
            int i = 0;
            int bitshift = (varLen - 1) * 8;
            while (i < varLen) {
                buffer[index++] = (byte)(val >> bitshift);
                ++i;
                bitshift -= 8;
            }
        } else if (variable instanceof OctetString) {
            byte[] b = ((OctetString)variable).value;
            buffer[index++] = 4;
            index = SnmpBERlength.encode(varLen, buffer, index);
            System.arraycopy(b, 0, buffer, index, varLen);
            index += varLen;
        } else if (variable instanceof Gauge) {
            buffer[index++] = 66;
            long val = ((Gauge)variable).value;
            index = SnmpAsn1.encode_long(buffer, index, varLen, val);
        } else if (variable instanceof TimeTicks) {
            buffer[index++] = 67;
            long val = ((TimeTicks)variable).value;
            index = SnmpAsn1.encode_long(buffer, index, varLen, val);
        } else if (variable instanceof IPAddress) {
            index = SnmpAsn1.encodeIpAddressAndTag(((IPAddress)variable).getIpAddress(), buffer, index);
        } else if (variable instanceof Null) {
            buffer[index++] = 5;
            buffer[index++] = 0;
        } else if (variable instanceof Counter) {
            buffer[index++] = 65;
            long val = ((Counter)variable).value;
            index = SnmpAsn1.encode_long(buffer, index, varLen, val);
        } else if (variable instanceof Counter64) {
            buffer[index++] = 70;
            long val = ((Counter64)variable).value;
            index = SnmpAsn1.encode_long(buffer, index, varLen, val);
        } else if (variable instanceof FullCounter64) {
            buffer[index++] = 70;
            BigInteger val = ((FullCounter64)variable).value;
            index = SnmpAsn1.encode_big_int(buffer, index, varLen, val);
        } else if (variable instanceof OID) {
            index = SnmpAsn1.encode_oid(buffer, index, (OID)variable, varLen);
        } else if (variable instanceof NoSuchObject) {
            buffer[index++] = -128;
            buffer[index++] = 0;
        } else if (variable instanceof NoSuchInstance) {
            buffer[index++] = -127;
            buffer[index++] = 0;
        } else if (variable instanceof EndOfMibView) {
            buffer[index++] = -126;
            buffer[index++] = 0;
        } else if (variable instanceof Opaque) {
            byte[] b = ((Opaque)variable).value;
            buffer[index++] = 68;
            index = SnmpBERlength.encode(varLen, buffer, index);
            System.arraycopy(b, 0, buffer, index, varLen);
            index += varLen;
        }
        return index;
    }

    public static int intLength(int i) {
        if (i < 128 && i >= -128) {
            return 1;
        }
        if (i < 32768 && i > Short.MIN_VALUE) {
            return 2;
        }
        if (i < 0x800000 && i > -8388608) {
            return 3;
        }
        return 4;
    }

    protected static int encodeInt(int BERlength, int val, byte[] buf, int index) {
        int i = 0;
        int bitshift = (BERlength - 1) * 8;
        while (i < BERlength) {
            buf[index++] = (byte)(val >> bitshift);
            ++i;
            bitshift -= 8;
        }
        return index;
    }

    private static int encode_long(byte[] BERbuffer, int startindex, int BERlength, long value) {
        BERbuffer[startindex++] = (byte)BERlength;
        int i = 0;
        int bitshift = (BERlength - 1) * 8;
        while (i < BERlength) {
            BERbuffer[startindex++] = bitshift == 64 ? (byte)0 : (byte)(value >> bitshift & 0xFFL);
            ++i;
            bitshift -= 8;
        }
        return startindex;
    }

    private static int encode_big_int(byte[] BERbuffer, int startindex, int BERlength, BigInteger value) {
        byte[] bytes = value.toByteArray();
        BERbuffer[startindex++] = (byte)bytes.length;
        for (int i = 0; i < bytes.length; ++i) {
            BERbuffer[startindex++] = bytes[i];
        }
        return startindex;
    }

    private static int encodeIpAddressAndTag(String address, byte[] buffer, int index) {
        buffer[index++] = 64;
        buffer[index++] = 4;
        StringTokenizer strtok = new StringTokenizer(address, ".");
        String s = strtok.nextToken();
        buffer[index++] = (byte)Integer.parseInt(s);
        s = strtok.nextToken();
        buffer[index++] = (byte)Integer.parseInt(s);
        s = strtok.nextToken();
        buffer[index++] = (byte)Integer.parseInt(s);
        s = strtok.nextToken();
        buffer[index++] = (byte)Integer.parseInt(s);
        return index;
    }

    public static SnmpTrap decodeTrap(byte[] buffer) throws SnmpDecodeException {
        byte type;
        SnmpTrap trap = new SnmpTrap();
        int index = 0;
        if (48 == buffer[index]) {
            ++index;
            if (2 == buffer[index += SnmpBERlength.size(buffer, index)]) {
                trap.version = buffer[index + 2];
                index += 3;
            } else {
                SnmpAsn1.decodeError("RequestID not tagged as INTEGER", index, buffer, -1);
            }
            if (4 == buffer[index]) {
                trap.communityString = new OctetString(buffer, index + 2, SnmpBERlength.decode(buffer, index + 1));
                index += SnmpAsn1.nextField(buffer, index);
            } else {
                SnmpAsn1.decodeError("CommunityName not tagged as OCTET STRING", index, buffer, -1);
            }
        }
        if ((type = buffer[index]) != -92) {
            SnmpAsn1.decodeError("Trap not tagged as a TRAP", index, buffer, -1);
        }
        ++index;
        if (6 == buffer[index += SnmpBERlength.size(buffer, index)]) {
            trap.enterprise = new OID(SnmpAsn1.decode_OID(buffer, index), true);
            index += SnmpAsn1.nextField(buffer, index);
        } else {
            SnmpAsn1.decodeError("Enterprise not tagged as OID", index, buffer, -1);
        }
        if (64 == buffer[index]) {
            trap.agentAddr = new IPAddress(buffer, index + 2);
            index += SnmpAsn1.nextField(buffer, index);
        } else {
            SnmpAsn1.decodeError("Agent Address not tagged as IP Address", index, buffer, -1);
        }
        if (2 == buffer[index]) {
            if (buffer[index + 1] == 1) {
                trap.genericTrap = buffer[index + 2];
                index += 3;
            } else {
                trap.genericTrap = SnmpAsn1.decode_int(buffer, index);
                index += SnmpAsn1.nextField(buffer, index);
            }
        } else {
            SnmpAsn1.decodeError("Generic Trap value not tagged as an INTEGER", index, buffer, -1);
        }
        if (2 == buffer[index]) {
            if (buffer[index + 1] == 1) {
                trap.specificTrap = buffer[index + 2];
                index += 3;
            } else {
                trap.specificTrap = SnmpAsn1.decode_int(buffer, index);
                index += SnmpAsn1.nextField(buffer, index);
            }
        } else {
            SnmpAsn1.decodeError("Specific Trap value not tagged as an INTEGER", index, buffer, -1);
        }
        if (67 == buffer[index]) {
            trap.timeStamp = new TimeTicks(SnmpAsn1.decode_long(buffer, index));
            index += SnmpAsn1.nextField(buffer, index);
        } else {
            SnmpAsn1.decodeError("Time Stamp value not tagged as a Time Tick", index, buffer, -1);
        }
        if (48 == buffer[index]) {
            trap.varBindList = new Vector();
            int varBindListEnd = index + SnmpAsn1.nextField(buffer, index);
            ++index;
            index += SnmpBERlength.size(buffer, index);
            while (index < varBindListEnd) {
                if (48 == buffer[index]) {
                    ++index;
                    index += SnmpBERlength.size(buffer, index);
                    long[] longArray = SnmpAsn1.decode_OID(buffer, index);
                    OID oid = new OID(longArray, true);
                    index += SnmpAsn1.nextField(buffer, index);
                    Serializable value = SnmpAsn1.decode_snmp_var(buffer, index);
                    index += SnmpAsn1.nextField(buffer, index);
                    SnmpVarBind varBind = new SnmpVarBind(oid, value);
                    trap.varBindList.addElement(varBind);
                    continue;
                }
                SnmpAsn1.decodeError("VarBind not tagged as a SEQUENCE", index, buffer, -1);
            }
        } else {
            SnmpAsn1.decodeError("Var Bind list not tagged as a SEQUENCE", index, buffer, -1);
        }
        return trap;
    }

    public static byte[] encode(SnmpTrap trap, SessionInfo securityInfo) {
        int i;
        int length = 0;
        int limit = trap.varBindList.size();
        for (i = 0; i < limit; ++i) {
            int vbLength = SnmpAsn1.getBERlength((SnmpVarBind)trap.varBindList.elementAt(i));
            length += vbLength + 1 + SnmpBERlength.size(vbLength);
        }
        int varBindLen = length;
        length += 1 + SnmpBERlength.size(length);
        int entLen = trap.enterprise.getBERlength();
        int agentAddrLen = 4;
        int genericTrapLen = SnmpAsn1.intLength(trap.genericTrap);
        int specificTrapLen = SnmpAsn1.intLength(trap.specificTrap);
        int timeStampLen = SnmpAsn1.getLongLength(trap.timeStamp.value);
        length += 2 + entLen;
        length += 2 + agentAddrLen;
        length += 2 + genericTrapLen;
        length += 2 + specificTrapLen;
        int reqDataLen = length += 2 + timeStampLen;
        length += 1 + SnmpBERlength.size(length);
        length += 3;
        int commLen = trap.communityString.value.length;
        int pduDataLen = length += 2 + commLen;
        length += 1 + SnmpBERlength.size(length);
        byte[] buffer = new byte[length];
        buffer[0] = 48;
        int index = 1;
        index = SnmpBERlength.encode(pduDataLen, buffer, index);
        buffer[index++] = 2;
        buffer[index++] = 1;
        buffer[index++] = 0;
        buffer[index++] = 4;
        index = SnmpBERlength.encode(commLen, buffer, index);
        for (i = 0; i < commLen; ++i) {
            buffer[index++] = trap.communityString.value[i];
        }
        buffer[index++] = -92;
        index = SnmpBERlength.encode(reqDataLen, buffer, index);
        index = SnmpAsn1.encode_oid(buffer, index, trap.enterprise, entLen);
        index = SnmpAsn1.encodeIpAddressAndTag(trap.agentAddr.getIpAddress(), buffer, index);
        buffer[index++] = 2;
        index = SnmpBERlength.encode(genericTrapLen, buffer, index);
        index = SnmpAsn1.encodeInt(genericTrapLen, trap.genericTrap, buffer, index);
        buffer[index++] = 2;
        index = SnmpBERlength.encode(specificTrapLen, buffer, index);
        index = SnmpAsn1.encodeInt(specificTrapLen, trap.specificTrap, buffer, index);
        buffer[index++] = 67;
        index = SnmpAsn1.encode_long(buffer, index, timeStampLen, trap.timeStamp.value);
        buffer[index++] = 48;
        index = SnmpBERlength.encode(varBindLen, buffer, index);
        for (i = 0; i < limit; ++i) {
            buffer[index++] = 48;
            SnmpVarBind vb = (SnmpVarBind)trap.varBindList.elementAt(i);
            int seqLen = SnmpAsn1.getBERlength(vb);
            index = SnmpBERlength.encode(seqLen, buffer, index);
            index = SnmpAsn1.encode_oid(buffer, index, vb.oid, vb.oidBERlength);
            index = SnmpAsn1.encode_snmp_var(buffer, index, vb.variable, vb.varBERlength);
        }
        return buffer;
    }

    public static byte[] encode(SnmpPDU pdu) throws SnmpEncodeException {
        return SnmpAsn1.encode(pdu, null);
    }

    public static byte[] encode(SnmpPDU pdu, SessionInfo secInfo) throws SnmpEncodeException {
        int i;
        int length = 0;
        OctetString useCommunityString = secInfo != null ? (pdu.operation == 3 ? ((SessionInfoCommString)secInfo).setCommunityNameOctet : ((SessionInfoCommString)secInfo).getCommunityNameOctet) : pdu.communityString;
        int varBindLen = length = SnmpAsn1.calculate_vb_length(pdu);
        length += 1 + SnmpBERlength.size(length);
        int limit = pdu.varBindList.size();
        int reqLen = SnmpAsn1.intLength(pdu.requestId);
        int statLen = SnmpAsn1.intLength(pdu.errorStatus);
        int indexLen = SnmpAsn1.intLength(pdu.errorIndex);
        length += 2 + reqLen;
        length += 2 + statLen;
        int reqDataLen = length += 2 + indexLen;
        length += 1 + SnmpBERlength.size(length);
        length += 3;
        int commLen = useCommunityString.value.length;
        length += 1 + SnmpBERlength.size(commLen);
        if (SnmpBERlength.size(commLen) != 1) {
            System.out.println("CommunityNameLen != 1 -- actual is " + SnmpBERlength.size(commLen));
        }
        int pduDataLen = length += commLen;
        length += 1 + SnmpBERlength.size(length);
        byte[] buffer = new byte[length];
        buffer[0] = 48;
        int index = 1;
        index = SnmpBERlength.encode(pduDataLen, buffer, index);
        buffer[index++] = 2;
        buffer[index++] = 1;
        buffer[index++] = secInfo != null ? (secInfo.version == 0 ? (byte)0 : 1) : (pdu instanceof SnmpV2PDU ? (byte)1 : 0);
        buffer[index++] = 4;
        index = SnmpBERlength.encode(commLen, buffer, index);
        for (i = 0; i < commLen; ++i) {
            buffer[index++] = useCommunityString.value[i];
        }
        buffer[index++] = opType[pdu.operation];
        index = SnmpBERlength.encode(reqDataLen, buffer, index);
        buffer[index++] = 2;
        pdu.requestIdPos = index = SnmpBERlength.encode(reqLen, buffer, index);
        index = SnmpAsn1.encodeInt(reqLen, pdu.requestId, buffer, index);
        buffer[index++] = 2;
        index = SnmpBERlength.encode(statLen, buffer, index);
        index = SnmpAsn1.encodeInt(statLen, pdu.errorStatus, buffer, index);
        buffer[index++] = 2;
        index = SnmpBERlength.encode(indexLen, buffer, index);
        index = SnmpAsn1.encodeInt(indexLen, pdu.errorIndex, buffer, index);
        buffer[index++] = 48;
        index = SnmpBERlength.encode(varBindLen, buffer, index);
        if (pdu.operation == 0 || pdu.operation == 1) {
            for (i = 0; i < limit; ++i) {
                buffer[index++] = 48;
                SnmpVarBind vb = (SnmpVarBind)pdu.varBindList.elementAt(i);
                int oidLen = SnmpAsn1.getOIDlength(vb);
                int seqLen = 3 + oidLen + SnmpBERlength.size(oidLen);
                index = SnmpBERlength.encode(seqLen, buffer, index);
                index = SnmpAsn1.encode_oid(buffer, index, vb.oid, vb.oidBERlength);
                buffer[index++] = 5;
                buffer[index++] = 0;
            }
        } else {
            for (i = 0; i < limit; ++i) {
                buffer[index++] = 48;
                SnmpVarBind vb = (SnmpVarBind)pdu.varBindList.elementAt(i);
                int seqLen = SnmpAsn1.getBERlength(vb);
                index = SnmpBERlength.encode(seqLen, buffer, index);
                index = SnmpAsn1.encode_oid(buffer, index, vb.oid, vb.oidBERlength);
                index = SnmpAsn1.encode_snmp_var(buffer, index, vb.variable, vb.varBERlength);
            }
        }
        return buffer;
    }

    public static SnmpPDU decodePDU(byte[] buffer, int messageLength) {
        SnmpPDU pdu = new SnmpPDU();
        SnmpAsn1.decode(pdu, buffer, messageLength);
        return pdu;
    }

    private static void decode(SnmpPDU pdu, byte[] buffer, int messageLength) {
        int index = 0;
        try {
            if (48 == buffer[index]) {
                ++index;
                if (2 == buffer[index += SnmpBERlength.size(buffer, index)]) {
                    if (buffer[index + 1] == 1) {
                        pdu.version = buffer[index + 2];
                        index += 3;
                    } else {
                        pdu.version = SnmpAsn1.decode_int(buffer, index);
                        index += SnmpAsn1.nextField(buffer, index);
                    }
                } else {
                    SnmpAsn1.decodeError("RequestID is not tagged as an Integer", index, buffer, messageLength);
                }
                if (4 == buffer[index]) {
                    pdu.communityString = new OctetString(buffer, index + 2, SnmpBERlength.decode(buffer, index + 1));
                    index += SnmpAsn1.nextField(buffer, index);
                } else {
                    if (pdu.version != 0) {
                        throw new SnmpWrongVersion("Version 1 PDU contains version : " + pdu.version);
                    }
                    SnmpAsn1.decodeError("CommunityName is not tagged as an OctetString", index, buffer, messageLength);
                }
            }
            byte type = buffer[index];
            switch (type) {
                case -94: {
                    pdu.operation = 2;
                    break;
                }
                case -96: {
                    pdu.operation = 0;
                    break;
                }
                case -95: {
                    pdu.operation = 1;
                    break;
                }
                case -93: {
                    pdu.operation = 3;
                    break;
                }
                default: {
                    pdu.operation = 7;
                }
            }
            ++index;
            index += SnmpBERlength.size(buffer, index);
            if (2 == buffer[index]) {
                pdu.requestId = SnmpAsn1.decode_int(buffer, index);
                index += SnmpAsn1.nextField(buffer, index);
            } else {
                SnmpAsn1.decodeError("RequestID is not tagged as an Integer", index, buffer, messageLength);
            }
            if (2 == buffer[index]) {
                if (buffer[index + 1] == 1) {
                    pdu.errorStatus = buffer[index + 2];
                    index += 3;
                } else {
                    pdu.errorStatus = SnmpAsn1.decode_int(buffer, index);
                    index += SnmpAsn1.nextField(buffer, index);
                }
            } else {
                SnmpAsn1.decodeError("ErrorStatus is not tagged as an Integer", index, buffer, messageLength);
            }
            if (2 == buffer[index]) {
                if (buffer[index + 1] == 1) {
                    pdu.errorIndex = buffer[index + 2];
                    index += 3;
                } else {
                    pdu.errorIndex = SnmpAsn1.decode_int(buffer, index);
                    index += SnmpAsn1.nextField(buffer, index);
                }
            } else {
                SnmpAsn1.decodeError("ErrorIndex is not tagged as an Integer", index, buffer, messageLength);
            }
            pdu.varBindList = SnmpAsn1.decode_varBindList(buffer, index, messageLength);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Vector decode_varBindList(byte[] buffer, int index, int messageLength) throws Exception {
        if (48 == buffer[index]) {
            Vector<SnmpVarBind> varBindList = new Vector<SnmpVarBind>();
            int varBindListEnd = index + SnmpAsn1.nextField(buffer, index);
            ++index;
            index += SnmpBERlength.size(buffer, index);
            while (index < varBindListEnd) {
                if (48 == buffer[index]) {
                    ++index;
                    index += SnmpBERlength.size(buffer, index);
                    long[] longArray = SnmpAsn1.decode_OID(buffer, index);
                    OID oid = new OID(longArray, true);
                    index += SnmpAsn1.nextField(buffer, index);
                    Serializable value = SnmpAsn1.decode_snmp_var(buffer, index);
                    index += SnmpAsn1.nextField(buffer, index);
                    SnmpVarBind varBind = new SnmpVarBind(oid, value);
                    varBindList.addElement(varBind);
                    continue;
                }
                SnmpAsn1.decodeError("Var Bind is not tagged as a Sequence", index, buffer, messageLength);
            }
            return varBindList;
        }
        SnmpAsn1.decodeError("Var Bind List is not tagged as a Sequence", index, buffer, messageLength);
        return null;
    }

    private static void decodeError(String mess, int offset, byte[] buffer, int len) throws SnmpDecodeException {
        SnmpDecodeException e = new SnmpDecodeException(mess + " at location " + offset + " - it contains " + Hex.toString(buffer[offset]) + " total PDU length = " + len);
        if (SnmpV1API.isTracing()) {
            String ms = e.toString();
            ms = len > 0 ? ms + Hex.toString(buffer, 0, len) : ms + Hex.toString(buffer, 0, buffer.length < offset ? buffer.length : offset + 6) + "...";
            SnmpV1API.trace(ms);
        } else {
            System.out.println(e.toString());
            if (len > 0) {
                System.out.println(Hex.toString(buffer, 0, len));
            } else {
                System.out.println(Hex.toString(buffer, 0, buffer.length < offset ? buffer.length : offset + 6) + "...");
            }
        }
        throw e;
    }

    private static int encode_V2_pdu(SnmpV2PDU pdu, byte[] buffer, int index, int pduDataLen, int requestIdLen, int intOneLen, int intTwoLen, int vb_length) {
        buffer[index++] = opType[pdu.operation];
        index = SnmpBERlength.encode(pduDataLen, buffer, index);
        buffer[index++] = 2;
        index = SnmpBERlength.encode(requestIdLen, buffer, index);
        index = SnmpAsn1.encodeInt(requestIdLen, pdu.requestId, buffer, index);
        if (pdu.operation == 4) {
            buffer[index++] = 2;
            index = SnmpBERlength.encode(intOneLen, buffer, index);
            index = SnmpAsn1.encodeInt(intOneLen, pdu.nonRepeaters, buffer, index);
            buffer[index++] = 2;
            index = SnmpBERlength.encode(intTwoLen, buffer, index);
            index = SnmpAsn1.encodeInt(intTwoLen, pdu.maxRepetitions, buffer, index);
        } else {
            buffer[index++] = 2;
            index = SnmpBERlength.encode(intOneLen, buffer, index);
            index = SnmpAsn1.encodeInt(intOneLen, pdu.errorStatus, buffer, index);
            buffer[index++] = 2;
            index = SnmpBERlength.encode(intTwoLen, buffer, index);
            index = SnmpAsn1.encodeInt(intTwoLen, pdu.errorIndex, buffer, index);
        }
        buffer[index++] = 48;
        index = SnmpBERlength.encode(vb_length, buffer, index);
        int limit = pdu.varBindList.size();
        if (pdu.operation == 0 || pdu.operation == 1 || pdu.operation == 4) {
            for (int i = 0; i < limit; ++i) {
                buffer[index++] = 48;
                SnmpVarBind vb = (SnmpVarBind)pdu.varBindList.elementAt(i);
                int oidLen = SnmpAsn1.getOIDlength(vb);
                int seqLen = 3 + oidLen + SnmpBERlength.size(oidLen);
                index = SnmpBERlength.encode(seqLen, buffer, index);
                index = SnmpAsn1.encode_oid(buffer, index, vb.oid, vb.oidBERlength);
                buffer[index++] = 5;
                buffer[index++] = 0;
            }
        } else {
            for (int i = 0; i < limit; ++i) {
                buffer[index++] = 48;
                SnmpVarBind vb = (SnmpVarBind)pdu.varBindList.elementAt(i);
                int seqLen = SnmpAsn1.getBERlength(vb);
                index = SnmpBERlength.encode(seqLen, buffer, index);
                index = SnmpAsn1.encode_oid(buffer, index, vb.oid, vb.oidBERlength);
                index = SnmpAsn1.encode_snmp_var(buffer, index, vb.variable, vb.varBERlength);
            }
        }
        return index;
    }

    public static byte[] encodeV2PDU(SnmpV2PDU pdu, SessionInfo secInfo) throws SnmpEncodeException {
        int intTwoLen;
        int intOneLen;
        int length;
        int index = 0;
        OctetString communityString = pdu.operation == 3 ? ((SessionInfoCommString)secInfo).setCommunityNameOctet : ((SessionInfoCommString)secInfo).getCommunityNameOctet;
        int vb_length = length = SnmpAsn1.calculate_vb_length(pdu);
        length = vb_length + 1 + SnmpBERlength.size(vb_length);
        int requestIdLen = SnmpAsn1.intLength(pdu.requestId);
        length += 2 + requestIdLen;
        if (pdu.operation != 4) {
            intOneLen = SnmpAsn1.intLength(pdu.errorStatus);
            intTwoLen = SnmpAsn1.intLength(pdu.errorIndex);
        } else {
            intOneLen = SnmpAsn1.intLength(pdu.nonRepeaters);
            intTwoLen = SnmpAsn1.intLength(pdu.maxRepetitions);
        }
        length += 2 + intOneLen;
        int pduDataLen = length += 2 + intTwoLen;
        length += 1 + SnmpBERlength.size(length);
        length += 3;
        int commLen = communityString.value.length;
        int totalDataLen = length += 2 + commLen;
        length += 1 + SnmpBERlength.size(length);
        byte[] buffer = new byte[length];
        buffer[index++] = 48;
        index = SnmpBERlength.encode(totalDataLen, buffer, index);
        buffer[index++] = 2;
        buffer[index++] = 1;
        buffer[index++] = 1;
        buffer[index++] = 4;
        index = SnmpBERlength.encode(commLen, buffer, index);
        for (int i = 0; i < commLen; ++i) {
            buffer[index++] = communityString.value[i];
        }
        SnmpAsn1.encode_V2_pdu(pdu, buffer, index, pduDataLen, requestIdLen, intOneLen, intTwoLen, vb_length);
        return buffer;
    }

    private static SnmpV2PDU decode_V2_pdu(SnmpV2PDU pdu, byte[] buffer, int index, int messageLength) {
        try {
            byte type = buffer[index];
            switch (type) {
                case -94: {
                    pdu.operation = 2;
                    break;
                }
                case -96: {
                    pdu.operation = 0;
                    break;
                }
                case -95: {
                    pdu.operation = 1;
                    break;
                }
                case -93: {
                    pdu.operation = 3;
                    break;
                }
                case -91: {
                    pdu.operation = 4;
                    break;
                }
                case -90: {
                    pdu.operation = 5;
                    break;
                }
                case -89: {
                    pdu.operation = 6;
                    break;
                }
                case -88: {
                    pdu.operation = 7;
                    break;
                }
                default: {
                    pdu.operation = 99;
                }
            }
            ++index;
            index += SnmpBERlength.size(buffer, index);
            if (2 == buffer[index]) {
                pdu.requestId = SnmpAsn1.decode_int(buffer, index);
                index += SnmpAsn1.nextField(buffer, index);
            } else {
                SnmpAsn1.decodeError("SNMP V2 - RequestID must be tagged as an Integer", index, buffer, messageLength);
            }
            if (2 == buffer[index]) {
                if (pdu.operation != 4) {
                    pdu.errorStatus = buffer[index + 2];
                    index += 3;
                } else if (buffer[index + 1] == 1) {
                    pdu.nonRepeaters = buffer[index + 2];
                    index += 3;
                } else {
                    pdu.nonRepeaters = SnmpAsn1.decode_int(buffer, index);
                    index += SnmpAsn1.nextField(buffer, index);
                }
            } else {
                SnmpAsn1.decodeError("SNMP V2 - ErrorStatus/Non-Repeaters must be tagged as an Integer", index, buffer, messageLength);
            }
            if (2 == buffer[index]) {
                if (buffer[index + 1] == 1) {
                    if (pdu.operation != 4) {
                        pdu.errorIndex = buffer[index + 2];
                    } else {
                        pdu.maxRepetitions = buffer[index + 2];
                    }
                    index += 3;
                } else {
                    if (pdu.operation != 4) {
                        pdu.errorIndex = SnmpAsn1.decode_int(buffer, index);
                    } else {
                        pdu.maxRepetitions = SnmpAsn1.decode_int(buffer, index);
                    }
                    index += SnmpAsn1.nextField(buffer, index);
                }
            } else {
                SnmpAsn1.decodeError("SNMP V2 - ErrorIndex/Max-Repeaters must be tagged as an Integer", index, buffer, messageLength);
            }
            pdu.varBindList = SnmpAsn1.decode_varBindList(buffer, index, messageLength);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pdu;
    }

    protected static SnmpV2PDU decodeV2PDU(byte[] buffer, int messageLength) {
        return SnmpAsn1.decodeV2PDU(buffer, messageLength, true);
    }

    protected static SnmpV2PDU decodeV2PDU(byte[] buffer, int messageLength, boolean makePDU) {
        int index = 0;
        SnmpV2PDU pdu = makePDU ? new SnmpV2PDU() : new SnmpV2Trap();
        try {
            if (48 == buffer[index]) {
                ++index;
                if (2 == buffer[index += SnmpBERlength.size(buffer, index)]) {
                    pdu.version = buffer[index + 2];
                    index += 3;
                } else {
                    SnmpAsn1.decodeError("SNMP V2 - RequestID must be tagged as an Integer", index, buffer, messageLength);
                }
                if (4 == buffer[index]) {
                    pdu.communityString = new OctetString(buffer, index + 2, SnmpBERlength.decode(buffer, index + 1));
                    index += SnmpAsn1.nextField(buffer, index);
                } else {
                    SnmpAsn1.decodeError("SNMP V2 -communityString must be tagged as an OctetString", index, buffer, messageLength);
                }
            }
            SnmpAsn1.decode_V2_pdu(pdu, buffer, index, messageLength);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pdu;
    }
}

