/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import org.eclipse.aperi.snmp.SessionInfo;
import org.eclipse.aperi.snmp.SnmpAsn1;
import org.eclipse.aperi.snmp.SnmpEncodeException;
import org.eclipse.aperi.snmp.SnmpMetaPDU;
import org.eclipse.aperi.snmp.SnmpSocketException;
import org.eclipse.aperi.snmp.SnmpTarget;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpUnknownHostException;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.SnmpV2PDU;

public class SnmpTrapSession
extends SnmpTarget {
    protected SnmpTrapSession(String address, int port) throws SnmpUnknownHostException {
        super(address, port);
    }

    public static SnmpTrapSession open(String destination) throws SnmpUnknownHostException, SnmpSocketException {
        return SnmpTrapSession.open(destination, 162);
    }

    public static SnmpTrapSession open(String destination, int port) throws SnmpUnknownHostException, SnmpSocketException {
        if (!SnmpV1API.initialized) {
            throw new SnmpSocketException("SnmpV1API not available");
        }
        try {
            SnmpV1API.initializeTraps();
        }
        catch (Exception e) {
            throw new SnmpSocketException(e.getMessage());
        }
        return new SnmpTrapSession(destination, port);
    }

    public void changeRemotePort(int port) {
        this.port = port;
    }

    public void close() {
        SnmpV1API.terminateTraps();
    }

    public static void send(SnmpTrap trap, String destination, int port) throws SnmpUnknownHostException, IOException {
        InetAddress address;
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("==> Sending Trap \n" + trap.toString());
        }
        if (SnmpV1API.trapSocket != null) {
            try {
                address = InetAddress.getByName(destination);
            }
            catch (Exception e) {
                throw new SnmpUnknownHostException();
            }
        } else {
            throw new SnmpSocketException("SnmpV1API traps not available");
        }
        byte[] buffer = SnmpAsn1.encode(trap, (SessionInfo)null);
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length, address, port);
        SnmpV1API.trapSocket.send(packet);
    }

    public static void sendTrapOrInform(SnmpMetaPDU trap, String destination, int port) throws SnmpUnknownHostException, IOException, SnmpEncodeException {
        InetAddress address;
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("==> Sending Trap \n" + trap.toString());
        }
        if (SnmpV1API.trapSocket != null) {
            try {
                address = InetAddress.getByName(destination);
            }
            catch (Exception e) {
                throw new SnmpUnknownHostException();
            }
        } else {
            throw new SnmpSocketException("SnmpV1API traps not available");
        }
        byte[] buffer = SnmpTrapSession.encodeTrapOrInform(trap, null);
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length, address, port);
        SnmpV1API.trapSocket.send(packet);
    }

    public static void send(SnmpTrap trap, String destination) throws SnmpUnknownHostException, IOException {
        try {
            SnmpTrapSession.sendTrapOrInform(trap, destination, 162);
        }
        catch (SnmpEncodeException s) {
            throw new SnmpSocketException("Problem encoding message" + s.toString());
        }
    }

    public void sendTrapOrInform(SnmpMetaPDU trap) throws IOException, SnmpEncodeException {
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("==> Sending Trap at \n" + trap.toString());
        }
        if (SnmpV1API.trapSocket == null) {
            throw new SnmpSocketException("SnmpV1API traps not available");
        }
        byte[] buffer = SnmpTrapSession.encodeTrapOrInform(trap, null);
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length, this.destination, this.port);
        SnmpV1API.trapSocket.send(packet);
    }

    private static byte[] encodeTrapOrInform(SnmpMetaPDU pdu, SessionInfo s) throws SnmpEncodeException {
        byte[] buffer = null;
        if (pdu instanceof SnmpTrap) {
            buffer = SnmpAsn1.encode((SnmpTrap)pdu, s);
        } else if (pdu instanceof SnmpV2PDU) {
            buffer = SnmpAsn1.encode((SnmpV2PDU)pdu, s);
        }
        return buffer;
    }
}

