/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.Serializable;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpV1API;

public class SnmpV2PDU
extends SnmpPDU
implements Serializable {
    public int nonRepeaters;
    public int maxRepetitions;

    protected SnmpV2PDU() {
        this.version = 1;
    }

    protected SnmpV2PDU(SnmpV2PDU other) {
        super(other);
        this.version = 1;
    }

    public SnmpV2PDU clone(SnmpV2PDU other) {
        return new SnmpV2PDU(other);
    }

    public String toString() {
        try {
            StringBuffer buffer = new StringBuffer("Message :");
            buffer.append(" version=" + this.version);
            if (SnmpV1API.exposeSecurityInfo) {
                if (this.communityString != null) {
                    buffer.append(" communityString=" + this.communityString.toDisplayString());
                } else {
                    buffer.append(" communityString=<value for V2 Session>");
                }
            }
            if (this.operation != 4) {
                if (this.errorStatus >= 0 && this.errorStatus < errorStatusString.length) {
                    buffer.append("\n          errorStatus=" + errorStatusString[this.errorStatus]);
                } else if (this.errorStatus == 100) {
                    buffer.append("\n          errorStatus=Timeout");
                } else if (this.errorStatus == 101) {
                    buffer.append("\n          errorStatus=SendError");
                } else if (this.errorStatus == 102) {
                    buffer.append("\n          errorStatus=Session Terminated");
                } else if (this.errorStatus == 103) {
                    buffer.append("\n          errorStatus=Decode Error");
                } else {
                    buffer.append("\n          errorStatus=" + this.errorStatus);
                }
                if (this.errorStatus != 0) {
                    buffer.append(" errorIndex=" + this.errorIndex);
                }
            } else {
                buffer.append("\n          nonRepeaters=" + this.nonRepeaters);
                buffer.append(" maxRepetitions=" + this.maxRepetitions);
            }
            buffer.append("\n          operation=" + operationString[this.operation]);
            buffer.append(" requestId=" + this.requestId);
            buffer.append(" correlator=" + this.correlator);
            buffer.append("       ");
            buffer.append(this.varBindListToString());
            return buffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "V2 Message cannot be formatted";
        }
    }
}

