/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.Serializable;
import org.eclipse.aperi.snmp.data.Counter;
import org.eclipse.aperi.snmp.data.Counter64;
import org.eclipse.aperi.snmp.data.EndOfMibView;
import org.eclipse.aperi.snmp.data.FullCounter64;
import org.eclipse.aperi.snmp.data.Gauge;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.NoSuchInstance;
import org.eclipse.aperi.snmp.data.NoSuchObject;
import org.eclipse.aperi.snmp.data.Null;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.data.Opaque;
import org.eclipse.aperi.snmp.data.TimeTicks;

public class SnmpVarBind
implements Serializable {
    private static final byte SEQUENCE_TAG = 48;
    private static final byte INTEGER_TAG = 2;
    private static final byte BIT_STRING = 3;
    private static final byte OCTET_TAG = 4;
    private static final byte NULL_TAG = 5;
    private static final byte OID_TAG = 6;
    private static final byte IPADDRESS_TAG = 64;
    private static final byte COUNTER_TAG = 65;
    private static final byte GAUGE_TAG = 66;
    private static final byte TIMETICKS_TAG = 67;
    private static final byte OPAQUE_TAG = 68;
    private static final byte COUNTER64_TAG = 70;
    private static final byte NOSUCHOBJECT_TAG = -128;
    private static final byte NOSUCHINSTANCE_TAG = -127;
    private static final byte ENDOFMIBVIEW_TAG = -126;
    public OID oid;
    public Serializable variable;
    public int oidBERlength;
    public int varBERlength;
    private static Null nullInstance = new Null();

    public SnmpVarBind() {
        this.oid = null;
        this.variable = nullInstance;
    }

    public SnmpVarBind(OID oid) {
        this.oid = oid;
        this.variable = nullInstance;
    }

    public SnmpVarBind(SnmpVarBind vb) {
        this.oid = new OID(vb.oid);
        this.variable = vb.variable;
    }

    public SnmpVarBind(OID oid, Serializable variable) {
        this.oid = oid;
        this.variable = variable;
        if (this.variable instanceof String) {
            this.variable = new OctetString((String)((Object)variable), true);
        }
    }

    public String toString() {
        if (this.variable instanceof OctetString && ((OctetString)this.variable).isDisplayString()) {
            return "\n\t" + this.oid.toString() + ":" + ((OctetString)this.variable).toDisplayString();
        }
        StringBuffer s = new StringBuffer("\n\t");
        if (this.oid == null) {
            s.append("null");
        } else {
            s.append(this.oid.toString());
        }
        s.append(":");
        if (this.variable == null) {
            s.append("null");
        } else {
            s.append(this.variable.toString());
        }
        return s.toString();
    }

    public OID get_oid() {
        return this.oid;
    }

    public OID getOID() {
        return this.oid;
    }

    public Serializable get_value() {
        return this.variable;
    }

    public Serializable getVar() {
        return this.variable;
    }

    public void set_oid(OID oid) {
        this.oid = oid;
        this.oidBERlength = 0;
    }

    public void set_value(Serializable var) {
        this.variable = var;
        this.varBERlength = 0;
    }

    public void set_null() {
    }

    public int get_syntax() {
        int type = 5;
        if (this.variable instanceof Null) {
            type = 5;
        } else if (this.variable instanceof Counter) {
            type = 65;
        } else if (this.variable instanceof Integer) {
            type = 2;
        } else if (this.variable instanceof OctetString) {
            type = 4;
        } else if (this.variable instanceof OID) {
            type = 6;
        } else if (this.variable instanceof IPAddress) {
            type = 64;
        } else if (this.variable instanceof Gauge) {
            type = 66;
        } else if (this.variable instanceof TimeTicks) {
            type = 67;
        } else if (this.variable instanceof Counter64) {
            type = 70;
        } else if (this.variable instanceof FullCounter64) {
            type = 70;
        } else if (this.variable instanceof NoSuchObject) {
            type = -128;
        } else if (this.variable instanceof NoSuchInstance) {
            type = -127;
        } else if (this.variable instanceof EndOfMibView) {
            type = -126;
        } else if (this.variable instanceof Opaque) {
            type = 68;
        }
        return type;
    }

    public String get_printable_value() {
        return this.variable.toString();
    }

    public String get_printable_oid() {
        return this.oid.toString();
    }

    boolean valid() {
        return true;
    }
}

