/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.data;

public class Hex {
    private static final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toString(byte[] value) {
        StringBuffer strbuf = new StringBuffer();
        for (int i = 0; i < value.length; ++i) {
            int first = value[i] >> 4 & 0xF;
            int second = value[i] & 0xF;
            strbuf.append(hexchars[first]);
            strbuf.append(hexchars[second]);
        }
        return strbuf.toString();
    }

    public static String toString(byte[] value, int offset) {
        StringBuffer strbuf = new StringBuffer();
        for (int i = offset; i < value.length; ++i) {
            int first = value[i] >> 4 & 0xF;
            int second = value[i] & 0xF;
            strbuf.append(hexchars[first]);
            strbuf.append(hexchars[second]);
        }
        return strbuf.toString();
    }

    public static String toString(byte[] value, int offset, int len) {
        StringBuffer strbuf = new StringBuffer();
        int limit = offset + len;
        for (int i = offset; i < limit; ++i) {
            int first = value[i] >> 4 & 0xF;
            int second = value[i] & 0xF;
            strbuf.append(hexchars[first]);
            strbuf.append(hexchars[second]);
        }
        return strbuf.toString();
    }

    public static String toUnsignedDec(byte[] value, int offset, int len) {
        StringBuffer strbuf = new StringBuffer();
        int limit = offset + len;
        long longval = 0L;
        for (int i = offset; i < limit; ++i) {
            longval = longval << 8 | (long)(value[i] & 0xFF);
        }
        strbuf.append(Long.toString(longval));
        return strbuf.toString();
    }

    public static String toString(byte[] value, int offset, int len, int radix) {
        StringBuffer strbuf = new StringBuffer();
        int limit = offset + len;
        switch (radix) {
            case 16: {
                strbuf.append(Hex.toString(value, offset, len));
                break;
            }
            case 10: {
                long longval = value[offset] >= 0 ? 0L : -1L;
                for (int i = offset; i < limit; ++i) {
                    longval = longval << 8 | (long)(value[i] & 0xFF);
                }
                strbuf.append(Long.toString(longval));
                break;
            }
            case 8: {
                long longval = value[offset] >= 0 ? 0L : -1L;
                for (int i = offset; i < limit; ++i) {
                    longval = longval << 8 | (long)(value[i] & 0xFF);
                }
                strbuf.append(Long.toOctalString(longval));
                break;
            }
            case 2: {
                long longval = value[offset] >= 0 ? 0L : -1L;
                for (int i = offset; i < limit; ++i) {
                    longval = longval << 8 | (long)(value[i] & 0xFF);
                }
                strbuf.append(Long.toBinaryString(longval));
                break;
            }
            default: {
                System.out.println("Error: Unknown radix passed to Hex.toString(); valid radix values are 16, 10, 8, and 2");
            }
        }
        return strbuf.toString();
    }

    public static String toString(byte value) {
        StringBuffer strbuf = new StringBuffer();
        int first = value >> 4 & 0xF;
        int second = value & 0xF;
        strbuf.append(hexchars[first]);
        strbuf.append(hexchars[second]);
        return strbuf.toString();
    }
}

