/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.data;

import java.io.Serializable;
import java.util.StringTokenizer;

public class IPAddress
implements Serializable {
    private String ipaddr;
    private byte[] ipaddrBytes = new byte[]{0, 0, 0, 0};

    public IPAddress(IPAddress ip) {
        this.ipaddr = ip.ipaddr;
        for (int i = 0; i < 4; ++i) {
            this.ipaddrBytes[i] = ip.ipaddrBytes[i];
        }
    }

    public IPAddress(int ipAddress) {
        int i1 = ipAddress >> 24 & 0xFF;
        int i2 = ipAddress >> 16 & 0xFF;
        int i3 = ipAddress >> 8 & 0xFF;
        int i4 = ipAddress & 0xFF;
        this.ipaddrBytes[0] = (byte)i1;
        this.ipaddrBytes[1] = (byte)i2;
        this.ipaddrBytes[2] = (byte)i3;
        this.ipaddrBytes[3] = (byte)i4;
        StringBuffer buf = new StringBuffer();
        buf.append(i1);
        buf.append(".");
        buf.append(i2);
        buf.append(".");
        buf.append(i3);
        buf.append(".");
        buf.append(i4);
        this.ipaddr = buf.toString();
    }

    public IPAddress(byte[] ipAddress, int offset) {
        int i1 = ipAddress[offset] & 0xFF;
        int i2 = ipAddress[offset + 1] & 0xFF;
        int i3 = ipAddress[offset + 2] & 0xFF;
        int i4 = ipAddress[offset + 3] & 0xFF;
        this.ipaddrBytes[0] = ipAddress[offset];
        this.ipaddrBytes[1] = ipAddress[offset + 1];
        this.ipaddrBytes[2] = ipAddress[offset + 2];
        this.ipaddrBytes[3] = ipAddress[offset + 3];
        StringBuffer buf = new StringBuffer();
        buf.append(i1);
        buf.append(".");
        buf.append(i2);
        buf.append(".");
        buf.append(i3);
        buf.append(".");
        buf.append(i4);
        this.ipaddr = buf.toString();
    }

    public IPAddress(String ipAddress) {
        this.ipaddr = ipAddress;
        StringTokenizer strtok = new StringTokenizer(ipAddress, ".");
        this.ipaddrBytes[0] = (byte)Integer.parseInt(strtok.nextToken());
        this.ipaddrBytes[1] = (byte)Integer.parseInt(strtok.nextToken());
        this.ipaddrBytes[2] = (byte)Integer.parseInt(strtok.nextToken());
        this.ipaddrBytes[3] = (byte)Integer.parseInt(strtok.nextToken());
    }

    public String toString() {
        return this.ipaddr;
    }

    public String getIpAddress() {
        return this.ipaddr;
    }

    public byte[] getBytes() {
        return this.ipaddrBytes;
    }

    public boolean equals(IPAddress ip) {
        byte[] ipaddrBytes2 = ip.getBytes();
        boolean same = true;
        for (int i = 0; i < 4; ++i) {
            if (this.ipaddrBytes[i] == ipaddrBytes2[i]) continue;
            same = false;
            break;
        }
        return same;
    }

    public IPAddress applyMask(IPAddress mask) {
        byte[] newBytes = new byte[4];
        byte[] maskBytes = mask.getBytes();
        for (int i = 0; i < 4; ++i) {
            newBytes[i] = (byte)(this.ipaddrBytes[i] & maskBytes[i]);
        }
        return new IPAddress(newBytes, 0);
    }
}

