/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.data;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.aperi.snmp.data.OID;

public class Mib {
    private Vector mibObjs = new Vector();

    public Object getObject(OID oid) {
        Object result = null;
        int[] nextOid = new int[1];
        int index = this.findOid(oid, nextOid);
        if (index >= 0) {
            result = ((MibObj)this.mibObjs.elementAt((int)index)).value;
        }
        return result;
    }

    public void setObject(OID oid, Object value) {
        this.createObject(oid, value, true);
    }

    public void createObject(OID oid, Object value) {
        this.createObject(oid, value, false);
    }

    public void createObject(OID oid, Object value, boolean allowExisting) {
        int[] nextOid = new int[1];
        int index = this.findOid(oid, nextOid);
        MibObj obj = new MibObj(oid, value);
        if (index >= 0) {
            if (allowExisting) {
                this.mibObjs.setElementAt(obj, index);
            } else {
                System.out.println("Create object failed: already in MIB");
            }
        } else {
            int insertPos = nextOid[0];
            if (insertPos < 0) {
                this.mibObjs.addElement(obj);
            } else {
                this.mibObjs.insertElementAt(obj, insertPos);
            }
        }
    }

    public void deleteObject(OID oid) {
        int[] nextOid = new int[1];
        int index = this.findOid(oid, nextOid);
        if (index >= 0) {
            this.mibObjs.removeElementAt(index);
        }
    }

    public Object getNextObject(OID oid) {
        Object result = null;
        int[] nextOid = new int[1];
        int index = this.findOid(oid, nextOid);
        if (nextOid[0] >= 0) {
            result = ((MibObj)this.mibObjs.elementAt((int)nextOid[0])).value;
        }
        return result;
    }

    public int indexOf(OID oid) {
        int[] nextOid = new int[1];
        return this.findOid(oid, nextOid);
    }

    private int findOid(OID oid, int[] nextOid) {
        int result = -1;
        int min = 0;
        int max = this.mibObjs.size() - 1;
        int mid = 0;
        if (this.mibObjs.size() == 0) {
            nextOid[0] = -1;
            return -1;
        }
        if (oid.compareTo(((MibObj)this.mibObjs.lastElement()).oid) > 0) {
            nextOid[0] = -1;
            return -1;
        }
        if (oid.compareTo(((MibObj)this.mibObjs.firstElement()).oid) < 0) {
            nextOid[0] = 0;
            return -1;
        }
        int nextOidNdx = 0;
        while (min <= max) {
            mid = (max - min) / 2 + min;
            MibObj mibObj = (MibObj)this.mibObjs.elementAt(mid);
            int comparison = oid.compareTo(mibObj.oid);
            if (comparison == 0) {
                result = mid;
                nextOidNdx = mid + 1;
                break;
            }
            if (comparison < 0) {
                max = mid - 1;
                nextOidNdx = mid;
                continue;
            }
            nextOidNdx = min = mid + 1;
        }
        if (nextOidNdx >= this.mibObjs.size()) {
            nextOidNdx = -1;
        }
        nextOid[0] = nextOidNdx;
        return result;
    }

    public int size() {
        return this.mibObjs.size();
    }

    public void removeElementAt(int i) {
        this.mibObjs.removeElementAt(i);
    }

    public void removeAll() {
        this.mibObjs.removeAllElements();
    }

    public OID getOidAt(int i) {
        OID result = null;
        MibObj obj = (MibObj)this.mibObjs.elementAt(i);
        if (obj != null) {
            result = obj.oid;
        }
        return result;
    }

    public Object getValueAt(int i) {
        Object result = null;
        MibObj obj = (MibObj)this.mibObjs.elementAt(i);
        if (obj != null) {
            result = obj.value;
        }
        return result;
    }

    public void dump() {
        System.out.println(this.mibObjs.size() + " MIB Objects:");
        Enumeration e = this.mibObjs.elements();
        while (e.hasMoreElements()) {
            MibObj obj = (MibObj)e.nextElement();
            System.out.print("\t" + obj.oid + ":  " + obj.value.toString());
        }
    }

    class MibObj {
        public OID oid;
        public Object value;

        public MibObj(OID oid, Object value) {
            this.oid = oid;
            this.value = value;
        }
    }
}

