/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.data;

import java.io.Serializable;
import org.eclipse.aperi.snmp.Ebcdic;
import org.eclipse.aperi.snmp.Translate;
import org.eclipse.aperi.snmp.data.Hex;

public class OctetString
implements Serializable {
    private static byte[] convert = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public byte[] value;

    public OctetString(String stringValue) {
        this(stringValue, false);
    }

    public OctetString(String stringValue, boolean isDisplayString) {
        if (isDisplayString) {
            this.value = stringValue.getBytes();
            if (Ebcdic.useEBCDIC) {
                for (int i = 0; i < this.value.length; ++i) {
                    this.value[i] = Translate.toAscii(this.value[i]);
                }
            }
        } else {
            int pos = 0;
            if (stringValue != null) {
                int i;
                byte[] buffer;
                String copy = stringValue;
                if (stringValue.length() % 2 != 0) {
                    copy = stringValue + "0";
                }
                if (Ebcdic.useEBCDIC) {
                    buffer = copy.getBytes();
                    for (i = 0; i < buffer.length; ++i) {
                        buffer[i] = Translate.toAscii(buffer[i]);
                    }
                } else {
                    buffer = copy.getBytes();
                }
                this.value = new byte[copy.length() / 2];
                for (i = 0; i < copy.length(); i += 2) {
                    this.value[pos++] = (byte)(convert[buffer[i]] << 4 | convert[buffer[i + 1]]);
                }
            } else {
                this.value = new byte[0];
            }
        }
    }

    public OctetString(byte[] octetString) {
        this.value = octetString;
    }

    public OctetString(OctetString that) {
        if (that.value == null) {
            this.value = new byte[0];
            return;
        }
        this.value = new byte[that.value.length];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = that.value[i];
        }
    }

    public OctetString(byte[] octetString, int offset, int length) {
        if (octetString == null || length == 0) {
            this.value = new byte[0];
            return;
        }
        this.value = new byte[length];
        for (int i = 0; i < length; ++i) {
            this.value[i] = octetString[offset++];
        }
    }

    public boolean equals(Object object) {
        if (object instanceof OctetString) {
            OctetString other = (OctetString)object;
            boolean retval = true;
            if (this.value == null && other.value == null) {
                return true;
            }
            if (this.value == null || other.value == null) {
                return false;
            }
            if (this.value.length == other.value.length) {
                for (int i = 0; retval && i < this.value.length; ++i) {
                    retval = this.value[i] == other.value[i];
                }
            } else {
                retval = false;
            }
            return retval;
        }
        return false;
    }

    public String toString() {
        if (this.value == null || this.value.length == 0) {
            return "";
        }
        return Hex.toString(this.value);
    }

    public String toDisplayString() {
        if (this.value == null || this.value.length == 0) {
            return "";
        }
        if (Ebcdic.useEBCDIC) {
            byte[] copy = new byte[this.value.length];
            for (int i = 0; i < this.value.length; ++i) {
                copy[i] = Translate.toEbcdic(this.value[i]);
            }
            return new String(copy, 0, copy.length);
        }
        return new String(this.value, 0, this.value.length);
    }

    public boolean isDisplayString() {
        if (this.value == null || this.value.length == 0) {
            return true;
        }
        for (int i = 0; i < this.value.length; ++i) {
            if (this.value[i] >= 32 && this.value[i] <= 126) continue;
            return false;
        }
        return true;
    }
}

