/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.test;

import java.io.Serializable;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpTrapSession;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.data.Counter;
import org.eclipse.aperi.snmp.data.Gauge;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.data.TimeTicks;

public class TrapSenderSample {
    private boolean result = true;

    public static void main(String[] args) {
        int time = 8976;
        if (args.length != 2) {
            System.out.println("Usage:\n java TrapSenderSample <destination host name> <destination port>");
            return;
        }
        try {
            TrapSenderSample t = new TrapSenderSample();
            SnmpV1API.initialize(-1);
            SnmpTrapSession session = SnmpTrapSession.open(args[0], Integer.parseInt(args[1]));
            SnmpTrap fred = new SnmpTrap();
            fred.enterprise = new OID("1.2.3.4.5.6.7.8.9");
            fred.communityString = new OctetString("public", true);
            fred.agentAddr = new IPAddress("9.67.222.98");
            fred.genericTrap = 2;
            fred.specificTrap = 3;
            fred.timeStamp = new TimeTicks(time);
            fred.addVarBind("1.3.18", (Serializable)new Counter(34L));
            fred.addVarBind("1.3.18", (Serializable)new OctetString("A test for the pointy-haired boss", true));
            fred.addVarBind("1.3.18.1", (Serializable)new Counter(3L));
            fred.addVarBind("1.3.18.2", (Serializable)new Gauge(34L));
            fred.addVarBind("1.3.18.3", (Serializable)new Gauge(3L));
            fred.addVarBind("1.3.5", (Serializable)new OID("1.3.4.6.34"));
            fred.addVarBind("1.0.0.0.2");
            SnmpTrap coldStart = new SnmpTrap();
            coldStart.enterprise = new OID("1.2.3.4.5.6.7.8.9");
            coldStart.communityString = new OctetString("public", true);
            coldStart.agentAddr = new IPAddress("9.67.222.99");
            coldStart.genericTrap = 0;
            coldStart.specificTrap = 3;
            coldStart.timeStamp = new TimeTicks(time);
            coldStart.addVarBind("1.3.18", (Serializable)new Counter(34L));
            SnmpTrap warmStart = new SnmpTrap();
            warmStart.enterprise = new OID("1.2.3.4.5.6.7.8.9");
            warmStart.communityString = new OctetString("public", true);
            warmStart.agentAddr = new IPAddress("9.67.222.100");
            warmStart.genericTrap = 1;
            warmStart.specificTrap = 3;
            warmStart.timeStamp = new TimeTicks(time);
            warmStart.addVarBind("1.3.18", (Serializable)new Counter(34L));
            while (true) {
                int i;
                System.out.println("hit enter to start sending traps");
                try {
                    int flag = System.in.read();
                    if (flag == 113) break;
                    int count = System.in.available();
                    for (i = 0; i < count; ++i) {
                        System.in.read();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                long begin = System.currentTimeMillis();
                for (i = 0; i < 3; ++i) {
                    System.out.print("+");
                    session.send(fred);
                    session.send(coldStart);
                    session.send(warmStart);
                    fred.timeStamp = new TimeTicks(time += 7);
                    coldStart.timeStamp = new TimeTicks(time);
                    warmStart.timeStamp = new TimeTicks(time);
                }
                long end = System.currentTimeMillis();
                System.out.println("elapsed time = " + (end - begin));
                System.out.println("");
            }
            SnmpV1API.terminate();
        }
        catch (Exception e) {
            System.out.println("error:" + e.toString());
        }
    }
}

