/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.utils;

import org.eclipse.aperi.snmp.utils.DispatchMessage;
import org.eclipse.aperi.snmp.utils.Orderable;
import org.eclipse.aperi.snmp.utils.OrderedQueue;

public class DispatchQueue
extends Thread {
    private static int instanceCount = 0;
    OrderedQueue q = new OrderedQueue(true);
    boolean alive = true;

    private static synchronized int incrementInstanceCount() {
        return ++instanceCount;
    }

    public DispatchQueue() {
        super("DispatchQueue " + DispatchQueue.incrementInstanceCount());
        this.start();
    }

    public void run() {
        while (this.alive) {
            DispMsgContainer msgContainer = (DispMsgContainer)this.q.dequeue();
            try {
                msgContainer.msg.dispatch();
            }
            catch (Throwable e) {
                System.out.println("Recovered from the following exception:");
                e.printStackTrace();
            }
        }
    }

    public static synchronized int getInstanceCount() {
        return instanceCount;
    }

    public synchronized void post(DispatchMessage msg) {
        DispMsgContainer msgContainer = new DispMsgContainer(msg);
        this.q.enqueue(msgContainer);
    }

    public synchronized void dispose() {
        this.alive = false;
    }

    private class DispMsgContainer
    implements Orderable {
        protected DispatchMessage msg;

        public DispMsgContainer(DispatchMessage msg) {
            this.msg = msg;
        }

        public int compare(Orderable other) {
            if (other instanceof DispMsgContainer) {
                DispMsgContainer theOther = (DispMsgContainer)other;
                if (this.msg.getPriority() == theOther.msg.getPriority()) {
                    return 1;
                }
                if (this.msg.getPriority() < theOther.msg.getPriority()) {
                    return 2;
                }
                return 0;
            }
            return 1;
        }
    }
}

