/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.utils;

import java.util.Vector;

public class Queue {
    protected Vector q = new Vector();
    private boolean waiting;
    private boolean blocking;

    public Queue() {
        this.blocking = false;
    }

    public Queue(boolean isBlocking) {
        this.blocking = isBlocking;
    }

    public final synchronized boolean isEmpty() {
        return this.q.isEmpty();
    }

    public final synchronized Object peek() {
        Object first = null;
        if (!this.q.isEmpty()) {
            first = this.q.firstElement();
        }
        return first;
    }

    public final synchronized Object dequeue() {
        Object first = null;
        if (!this.q.isEmpty()) {
            first = this.q.firstElement();
            this.q.removeElementAt(0);
        } else if (this.blocking) {
            this.waiting = true;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.waiting = false;
            if (!this.q.isEmpty()) {
                first = this.q.firstElement();
                this.q.removeElementAt(0);
            }
        }
        return first;
    }

    public final synchronized Object dequeue(int msecWait) {
        Object first = null;
        if (!this.q.isEmpty()) {
            first = this.q.firstElement();
            this.q.removeElementAt(0);
        } else if (this.blocking) {
            this.waiting = true;
            try {
                this.wait(msecWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.waiting = false;
            if (!this.q.isEmpty()) {
                first = this.q.firstElement();
                this.q.removeElementAt(0);
            }
        }
        return first;
    }

    public final synchronized boolean dequeue(Object o) {
        return this.q.removeElement(o);
    }

    public final synchronized void enqueue(Object o) {
        this.q.addElement(o);
        if (this.blocking && this.waiting && 1 == this.q.size()) {
            this.notify();
        }
    }
}

