/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector;

import java.io.IOException;
import java.net.Socket;
import org.eclipse.aperi.connector.Config;
import org.eclipse.aperi.connector.internal.SecurityContext;
import org.eclipse.aperi.connector.internal.UserSecurityContext;
import org.eclipse.aperi.connector.internal.client.RawSocketClient;
import org.eclipse.aperi.connector.internal.client.SoapServiceProxy;
import org.eclipse.aperi.connector.log.LogHelper;

public class ConnectorClient {
    public static Object getService(String host, int port, Class serviceClass) {
        String serviceName = serviceClass.getName();
        return SoapServiceProxy.newInstance(host, port, serviceName, serviceClass, SecurityContext.getDefaultContext());
    }

    public static Object getService(String host, int port, Class serviceClass, String serviceName) {
        return SoapServiceProxy.newInstance(host, port, serviceName, serviceClass, SecurityContext.getDefaultContext());
    }

    public static Object getService(String hostURL, Class serviceClass, String serviceName) {
        String[] hostPort = hostURL.split(":");
        if (hostPort.length != 2) {
            throw new IllegalArgumentException("Invalid host URL: " + hostURL);
        }
        String host = hostPort[0];
        int port = Integer.parseInt(hostPort[1]);
        return SoapServiceProxy.newInstance(host, port, serviceName, serviceClass, SecurityContext.getDefaultContext());
    }

    public static Object getService(String hostURL, Class serviceClass, String serviceName, String user, String password) {
        String[] hostPort = hostURL.split(":");
        if (hostPort.length != 2) {
            throw new IllegalArgumentException("Invalid host URL: " + hostURL);
        }
        String host = hostPort[0];
        int port = Integer.parseInt(hostPort[1]);
        return SoapServiceProxy.newInstance(host, port, serviceName, serviceClass, new UserSecurityContext(user, password));
    }

    public static Object getService(String hostURL, Class serviceClass) {
        String[] hostPort = hostURL.split(":");
        if (hostPort.length != 2) {
            throw new IllegalArgumentException("Invalid host URL: " + hostURL);
        }
        String host = hostPort[0];
        int port = Integer.parseInt(hostPort[1]);
        String serviceName = serviceClass.getName();
        return SoapServiceProxy.newInstance(host, port, serviceName, serviceClass, SecurityContext.getDefaultContext());
    }

    public static Object getService(Class serviceClass) {
        String host = Config.getProperty("connector.target.host");
        String portString = Config.getProperty("connector.target.port");
        int port = 80;
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            LogHelper.logException(e, ConnectorClient.class, "getService");
        }
        return ConnectorClient.getService(host, port, serviceClass);
    }

    public static Socket getSocket(String host, int port, String serviceName) throws IOException {
        Socket s = null;
        s = RawSocketClient.post(host, port, serviceName);
        return s;
    }

    public static Socket getSocket(String serviceName) throws IOException {
        String host = Config.getProperty("connector.target.host");
        String portString = Config.getProperty("connector.target.port");
        int port = 80;
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            LogHelper.logException(e, ConnectorClient.class, "getSocket");
        }
        return ConnectorClient.getSocket(host, port, serviceName);
    }
}

