/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import org.eclipse.aperi.connector.SocketHandler;
import org.eclipse.aperi.connector.internal.server.BiModalHttpConnection;
import org.eclipse.aperi.connector.internal.server.SocketHandlerMgr;
import org.eclipse.aperi.connector.log.LogHelper;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.SocketListener;

public class BiModalSocketListener
extends SocketListener {
    private static final long serialVersionUID = -7719187749632876608L;
    private int lowResourcePersistTimeMs = 2000;

    BiModalSocketListener() {
    }

    public void handle(Object job) {
        Socket socket = (Socket)job;
        try {
            this.handleConnection(socket);
        }
        catch (Exception e) {
            LogHelper.logException(e, ((Object)((Object)this)).getClass(), "handle");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnection(Socket socket) throws IOException {
        String METHOD = "handleConnection";
        BiModalHttpConnection connection = this.createConnection(socket);
        try {
            if (this.lowResourcePersistTimeMs > 0 && this.isLowOnResources()) {
                socket.setSoTimeout(this.lowResourcePersistTimeMs);
                connection.setThrottled(true);
            } else {
                socket.setSoTimeout(this.getMaxIdleTimeMs());
                connection.setThrottled(false);
            }
        }
        catch (Exception e) {
            LogHelper.traceException(e, ((Object)((Object)this)).getClass(), "handleConnection");
        }
        connection.readRequest();
        HttpRequest request = connection.getRequest();
        String contentType = request.getHeader().get("Content-Type");
        if ("RawSocket".equals(contentType)) {
            String socketService = request.getHeader().get("RawSocket-Service");
            this.handleRawSocketRequest(socketService, socket);
        } else {
            try {
                connection.handle();
            }
            catch (RuntimeException e) {
                LogHelper.traceException(e, ((Object)((Object)this)).getClass(), "handleConnection");
            }
            finally {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    LogHelper.traceException(e, ((Object)((Object)this)).getClass(), "handleConnection");
                }
            }
        }
    }

    public int getLowResourcePersistTimeMs() {
        return this.lowResourcePersistTimeMs;
    }

    public void setLowResourcePersistTimeMs(int ms) {
        this.lowResourcePersistTimeMs = ms;
    }

    private void handleRawSocketRequest(String serviceName, Socket socket) {
        String METHOD = "handleRawSocketRequest";
        try {
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            out.println("OK");
            SocketHandler sh = null;
            SocketHandlerMgr mgr = SocketHandlerMgr.getInstance();
            sh = mgr.getSocketHandler(serviceName);
            sh.handleSocket(socket);
        }
        catch (Throwable e) {
            Exception ee = new Exception(e);
            LogHelper.logException(ee, ((Object)((Object)this)).getClass(), "handleRawSocketRequest");
        }
    }

    protected BiModalHttpConnection createConnection(Socket socket) throws IOException {
        BiModalHttpConnection c = new BiModalHttpConnection((HttpListener)this, socket.getInetAddress(), socket.getInputStream(), socket.getOutputStream(), socket);
        return c;
    }
}

