/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.server;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.aperi.connector.Config;
import org.eclipse.aperi.connector.internal.server.BiModalSSLSocketListener;
import org.eclipse.aperi.connector.internal.server.BiModalSocketListener;
import org.eclipse.aperi.connector.log.LogHelper;
import org.eclipse.equinox.http.servlet.HttpServiceServlet;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class ServletActivator
implements BundleActivator {
    private HttpServer server;

    public void start(BundleContext context) throws Exception {
        String METHOD = "start";
        LogHelper.traceEntry(this.getClass(), METHOD);
        this.server = new HttpServer();
        SocketListener httpListener = this.createListener(context);
        if (httpListener != null) {
            this.server.addListener((HttpListener)httpListener);
        } else {
            LogHelper.log("CNT016W", this.getClass(), METHOD);
        }
        ServletHandler servlets = new ServletHandler();
        servlets.setAutoInitializeServlets(true);
        ServletHolder holder = servlets.addServlet("/*", HttpServiceServlet.class.getName());
        holder.setInitOrder(0);
        HttpContext httpContext = this.createHttpContext(context);
        httpContext.addHandler((HttpHandler)servlets);
        this.server.addContext(httpContext);
        this.server.start();
        LogHelper.log("CNT002I", this.getClass(), METHOD);
        LogHelper.traceExit(this.getClass(), METHOD);
    }

    public void stop(BundleContext context) throws Exception {
        this.server.stop();
    }

    private SocketListener createListener(BundleContext context) {
        String METHOD = "createListener";
        LogHelper.traceEntry(this.getClass(), METHOD);
        BiModalSocketListener listener = null;
        int httpPort = 80;
        String httpPortProperty = Config.getProperty("org.osgi.service.http.port");
        if (httpPortProperty != null) {
            try {
                httpPort = Integer.parseInt(httpPortProperty);
            }
            catch (NumberFormatException nfe) {
                LogHelper.trace("The property -Dorg.osgi.service.http.port should be a number: " + httpPortProperty, this.getClass(), METHOD);
                LogHelper.traceException(nfe, this.getClass(), METHOD);
            }
        }
        if (httpPort > 0) {
            String sslProp = Config.getProperty("connector.ssl.enabled");
            if (sslProp == null || "false".equals(sslProp)) {
                listener = new BiModalSocketListener();
            } else {
                listener = new BiModalSSLSocketListener();
                LogHelper.log("CNT015I", this.getClass(), METHOD);
            }
            listener.setPort(httpPort);
            String host = listener.getHost();
            try {
                if (host == null) {
                    InetAddress[] ia = InetAddress.getAllByName(host);
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < ia.length; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(ia[i].getHostName());
                    }
                    host = sb.toString();
                }
            }
            catch (UnknownHostException e) {
                LogHelper.traceException(e, this.getClass(), METHOD);
            }
            LogHelper.log("CNT001I", this.getClass(), METHOD, new String[]{"" + httpPort, host});
        } else {
            LogHelper.trace("The property -Dorg.osgi.service.http.port returned a value < 0, it returned a value of " + httpPort, this.getClass(), METHOD);
        }
        return listener;
    }

    private HttpContext createHttpContext(BundleContext context) {
        String contextPathProperty = "/";
        HttpContext httpContext = new HttpContext();
        httpContext.setClassLoader(this.getClass().getClassLoader());
        httpContext.setContextPath(contextPathProperty);
        File jettyWorkDir = new File(context.getDataFile(""), Config.getProperty("connector.dir.data"));
        jettyWorkDir.mkdir();
        httpContext.setTempDirectory(jettyWorkDir);
        return httpContext;
    }
}

