/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.AssociatorCIMQuery;
import org.eclipse.aperi.discovery.SimpleCIMDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.api.IDiskCollectionService;
import org.eclipse.aperi.disk.api.impl.DiskManager;
import org.eclipse.aperi.disk.api.impl.DiskOperations;
import org.eclipse.aperi.disk.collection.DiskProbeDispatcher;
import org.eclipse.aperi.disk.collection.ProbeCompleteSubsystem;
import org.eclipse.aperi.disk.collection.ProbeGenericArraySubsystemProcess;
import org.eclipse.aperi.disk.collection.ProbeGenericMaskingMappingProcess;
import org.eclipse.aperi.disk.collection.ProbeGenericSubsystemProcess;
import org.eclipse.aperi.disk.collection.ProbeGenericVolumeProcess;
import org.eclipse.aperi.disk.collection.ProbeHDS11SubsystemProcess;
import org.eclipse.aperi.disk.collection.ProbeSVCLegacySubsystemProcess;
import org.eclipse.aperi.disk.collection.ProbeSVCMaskingMappingProcess;
import org.eclipse.aperi.disk.collection.ProbeSVCNonLegacySubsystemProcess;
import org.eclipse.aperi.disk.collection.ProbeSVCSubsystemProcess;
import org.eclipse.aperi.disk.collection.ProbeSunArraySubsystemProcess;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.ParameterChecker;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.disk.discovery.TopLevelDiscoveryProcess;
import org.eclipse.aperi.disk.discovery.TopLevelProcess;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.util.osgi.ServiceHelper;
import org.sblim.wbem.cim.CIMInstance;

public class DiskCollectionOperations
extends DiskOperations
implements IDiskCollectionService,
DiscoveryConstants {
    public DiskCollectionOperations(DiskManager pDiskManager) {
        super(pDiskManager);
    }

    public void handleServiceShutdown() {
        super.handleServiceShutdown();
    }

    protected void initialize() {
        this.registerDiskManagerProcesses();
    }

    private IDiscover getDiscoverProxy() {
        return (IDiscover)this.cDM.getServiceHelper().bindLocal(IDiscover.class);
    }

    private void registerDiskManagerProcesses() {
        ServiceHelper mServiceHelper = this.cDM.getServiceHelper();
        IDiscoverRouterService mRouter = (IDiscoverRouterService)mServiceHelper.bindLocal(IDiscoverRouterService.class);
        mRouter.addProcess("collectStorageSubsystemsFromCIMOM", (IDiscoverProcess)new TopLevelDiscoveryProcess("collectStorageSubsystemsFromCIMOM", true));
        mRouter.addProcess("dispatchDiscoveryProcess", (IDiscoverProcess)new TopLevelProcess("dispatchDiscoveryProcess", false));
        ProbeGenericSubsystemProcess.registerSteps(mRouter);
        ProbeGenericArraySubsystemProcess.registerSteps(mRouter);
        ProbeGenericMaskingMappingProcess.registerSteps(mRouter);
        ProbeSVCMaskingMappingProcess.registerSteps(mRouter);
        ProbeSVCSubsystemProcess.registerSteps(mRouter);
        ProbeSVCLegacySubsystemProcess.registerSteps(mRouter);
        ProbeSVCNonLegacySubsystemProcess.registerSteps(mRouter);
        ProbeHDS11SubsystemProcess.registerSteps(mRouter);
        ProbeSunArraySubsystemProcess.registerSteps(mRouter);
        ProbeGenericVolumeProcess.registerSteps(mRouter);
        mRouter.addProcess("probeDiskDispatcher", (IDiscoverProcess)new DiskProbeDispatcher("probeDiskDispatcher", false));
        mRouter.addProcess("collectCompleteStorageSubsystem", (IDiscoverProcess)new ProbeCompleteSubsystem("collectCompleteStorageSubsystem", true));
        mRouter.addProcess("RegisteredProfile", (IDiscoverProcess)new SimpleCIMDiscoverProcess("Discover All CIM_RegisteredProfile ", false, new Query[]{Query.enumerateInstancesQuery((String)"CIM_RegisteredProfile")}, false));
        mRouter.addProcess("ENUM_COMPUTERSYSTEM", (IDiscoverProcess)new SimpleCIMDiscoverProcess("Discover All CIM_COMPUTERSYSTEMS ", false, new Query[]{Query.enumerateInstancesQuery((String)"CIM_ComputerSystem")}, false));
        mRouter.addProcess("OBJECTMANAGER", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM ObjectManager", Query.associators((String)"CIM_RegisteredProfile", (String)"CIM_ElementConformsToProfile", (String)"CIM_ObjectManager", null, null), "IN_SYSTEM_OBJECTMANAGER", CIMInstance.class.getName(), false));
        mRouter.addProcess("SUBPROFILE", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM SubProfile ", Query.associators((String)"CIM_RegisteredProfile", (String)"CIM_SubProfileRequiresProfile", (String)"CIM_RegisteredSubProfile", null, null), "IN_SYSTEM_SUBPROFILE", CIMInstance.class.getName(), false));
        mRouter.addProcess("COMPUTERSYSTEM", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM Computersystem ", Query.associators((String)"CIM_RegisteredProfile", (String)"CIM_ElementConformsToProfile", (String)"CIM_ComputerSystem", null, null), "IN_SYSTEM_COMPUTERSYSTEM", CIMInstance.class.getName(), false));
        mRouter.addProcess("product", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM Product ", Query.associators((String)"CIM_PhysicalPackage", (String)"CIM_ProductPhysicalComponent", (String)"CIM_Product", null, null), "IN_SYSTEM_product", CIMInstance.class.getName(), false));
        mRouter.addProcess("PHYSICALPACKAGING", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM PhysicalPackaging ", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemPackaging", (String)"CIM_PhysicalPackage", null, null), "IN_SYSTEM_PHYSICALPACKAGING", CIMInstance.class.getName(), false));
        mRouter.addProcess("REMOTESERVICE", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM RemoteServiceAccessPoint ", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SAPAvailableForElement", (String)"CIM_RemoteServiceAccessPoint", null, null), "IN_SYSTEM_REMOTESERVICE", CIMInstance.class.getName(), false));
        mRouter.addProcess("NOTESOFCLUSTER", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM Notes ", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_ComponentCS", (String)"CIM_ComputerSystem", null, null), "IN_SYSTEM_NOTESOFCLUSTER", CIMInstance.class.getName(), false));
        mRouter.addProcess("SOFTWAREIDENTITY", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM SoftwareIdentiy ", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_InstalledSoftwareIdentity", (String)"CIM_SoftwareIdentity", null, null), "IN_SYSTEM_SOFTWAREIDENTITY", CIMInstance.class.getName(), false));
        mRouter.addProcess("remoteCluster", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM RemoteCluster ", Query.associators((String)"CIM_ComputerSystem", (String)"IBMTSSVC_RemotePartnership", (String)"IBMTSSVC_RemoteCluster", null, null), "IN_SYSTEM_remoteCluster", CIMInstance.class.getName(), false));
        mRouter.addProcess("ESSCLUSTER", (IDiscoverProcess)new AssociatorCIMQuery("Discover ESS Cluster ", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_ComponentCS", (String)"IBMTSESS_Cluster", null, null), "IN_SYSTEM_ESSCLUSTER", CIMInstance.class.getName(), false));
        mRouter.addProcess("CAPABILITIES", (IDiscoverProcess)new AssociatorCIMQuery("Discover MaskingCapabilities ", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_ElementCapabilities", (String)"CIM_ProtocolControllerMaskingCapabilities", null, null), "IN_SYSTEM_CAPABILITIES", CIMInstance.class.getName(), false));
        mRouter.addProcess("CONFIGURATIONSERVICE", (IDiscoverProcess)new AssociatorCIMQuery("Discover StorageConfigurationService ", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_HostedService", (String)"CIM_StorageConfigurationService", null, null), "IN_SYSTEM_CONFIGURATIONSERVICE", CIMInstance.class.getName(), false));
        mRouter.addProcess("CONFIGURATIONCAPABILITIES", (IDiscoverProcess)new AssociatorCIMQuery("Discover CONFIGURATIONCAPABILITIES ", Query.associators((String)"CIM_StorageConfigurationService", (String)"CIM_ElementCapabilities", (String)"CIM_StorageConfigurationCapabilities", null, null), "IN_SYSTEM_CONFIGURATIONCAPABILITIES", CIMInstance.class.getName(), false));
        mRouter.addProcess("CIMOMVersion", (IDiscoverProcess)new SimpleCIMDiscoverProcess("Discover the CIMOMVersion ", false, new Query[]{Query.enumerateInstancesQuery((String)"LSISSI_Provider")}, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult discoverStorageSubsystems(String[] pCimomIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"discoverStorageSubsystems", (Object[])new Object[]{pCimomIDs});
        Object mResult = null;
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"CimomIDs", (Object)pCimomIDs, (LogTraceHelper)mLTH);
            Hashtable<String, Object> mParams = new Hashtable<String, Object>();
            AsyncResult mReturn = new AsyncResult(0, -1);
            mParams.put("CIMOMID_PARAM", pCimomIDs);
            mParams.put("Type", "ToplevelStorageSubsystem");
            String mJob = this.getDiscoverProxy().discover("dispatchDiscoveryProcess", mParams);
            AsyncResult asyncResult = mReturn = this.getDiscoverProxy().getJobStatus(mJob);
            return asyncResult;
        }
        finally {
            mLTH.exit(mResult);
        }
    }

    private Object getCimomParams(CIMOM pMcimom) {
        String[] mCIMOM = new String[]{pMcimom.getServiceUrl(), pMcimom.getInteropSchemaNamespace(), pMcimom.getUserId(), pMcimom.getPassword(), pMcimom.getSoftwareLevel()};
        return mCIMOM;
    }

    public AsyncResult probeStorageSubsystems(String[] pSubsystemIDs, Integer pCollectionType) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.probeStorageSubsystems(pSubsystemIDs, (int)pCollectionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult probeStorageSubsystems(String[] pSubsystemIDs, int pCollectionType) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"probeStorageSubsystems", (Object[])new Object[]{pSubsystemIDs, new Integer(pCollectionType)});
        AsyncResult mResult = null;
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"SubsystemIDs", (Object)pSubsystemIDs, (LogTraceHelper)mLTH);
            ParameterChecker.assertValidPrimitiveParameterInt_BitMask((int)2, (String)"CollectionType", (int)pCollectionType, (int)6, (LogTraceHelper)mLTH);
            String[] mDeviceIDs = new String[pSubsystemIDs.length];
            for (int mLoop = 0; mLoop < pSubsystemIDs.length; ++mLoop) {
                String bSubsystemID = pSubsystemIDs[mLoop];
                DBConnection mDBConn = null;
                StorageSubsystem mSubsys = null;
                try {
                    mDBConn = ServiceUtils.getConnection();
                    mSubsys = ExternalKeyManager.getStorageSubsystem((String)bSubsystemID, (DBConnection)mDBConn);
                    mDBConn.commit();
                    mDBConn.close();
                }
                catch (SQLException bSQLEx) {
                    if (mDBConn != null) {
                        try {
                            mDBConn.close();
                        }
                        catch (Exception bEx) {
                            // empty catch block
                        }
                    }
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)bSQLEx, (LogTraceHelper)mLTH);
                }
                catch (EntityNotFoundException mEX) {
                    throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021657E", (Object)mEX.getID(), (LogTraceHelper)mLTH);
                }
                catch (IDParseException idpEx) {
                    throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)("SubsystemID [" + mLoop + "] : " + bSubsystemID), (LogTraceHelper)mLTH);
                }
                if (mSubsys == null) {
                    throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)("SubsystemID [" + mLoop + "] : " + bSubsystemID), (LogTraceHelper)mLTH);
                }
                mDeviceIDs[mLoop] = String.valueOf(mSubsys.getSubsystemId());
            }
            Hashtable<String, Object> mParams = new Hashtable<String, Object>();
            mParams.put("SUBSYSTEMIDS_PARAM", pSubsystemIDs);
            mParams.put("DEVICEIDS_PARAM", mDeviceIDs);
            mParams.put("COLLECTIONTYPE_PARAM", new Integer(pCollectionType));
            String mJob = this.getDiscoverProxy().discover("probeDiskDispatcher", mParams);
            asyncResult = mResult = this.getDiscoverProxy().getJobStatus(mJob);
        }
        catch (Throwable throwable) {
            mLTH.exit(mResult);
            throw throwable;
        }
        mLTH.exit((Object)mResult);
        return asyncResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult probeStorageVolume(String pSubsystemID, String pVolumeID, int pCollectionType) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"probeStorageVolumes", (Object[])new Object[]{pVolumeID, pSubsystemID, new Integer(pCollectionType)});
        AsyncResult mResult = null;
        DBConnection mDBConn = null;
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"SubsystemID", (Object)pSubsystemID, (LogTraceHelper)mLTH);
            ParameterChecker.assertMandatoryParameter((int)2, (String)"VolumeID", (Object)pVolumeID, (LogTraceHelper)mLTH);
            ParameterChecker.assertValidPrimitiveParameterInt_BitMask((int)3, (String)"CollectionType", (int)pCollectionType, (int)6, (LogTraceHelper)mLTH);
            String mDeviceID = null;
            String bSubsystemID = pSubsystemID;
            StorageSubsystem mSubsys = null;
            try {
                mDBConn = ServiceUtils.getConnection();
                mSubsys = ExternalKeyManager.getStorageSubsystem((String)bSubsystemID, (DBConnection)mDBConn);
            }
            catch (EntityNotFoundException mEX) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021657E", (Object)mEX.getID(), (LogTraceHelper)mLTH);
            }
            catch (IDParseException idpEx) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)("SubsystemID: " + bSubsystemID), (LogTraceHelper)mLTH);
            }
            if (mSubsys == null) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)("SubsystemID : " + bSubsystemID), (LogTraceHelper)mLTH);
            }
            mDeviceID = String.valueOf(mSubsys.getSubsystemId());
            StorageVolume mVolume = null;
            String mVolumeID = null;
            try {
                mVolume = ExternalKeyManager.getStorageVolume((String)pVolumeID, (int)mSubsys.getSubsystemId(), (DBConnection)mDBConn);
                mVolumeID = String.valueOf(mVolume.getSvid());
            }
            catch (EntityNotFoundException mEX) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021504E", (Object)mEX.getID(), (LogTraceHelper)mLTH);
            }
            catch (IDParseException idpEx) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)("VolumeID : " + pVolumeID), (LogTraceHelper)mLTH);
            }
            Hashtable<String, Object> mParams = new Hashtable<String, Object>();
            mParams.put("SUBSYSTEMID", pSubsystemID);
            mParams.put("DEVICEID", mDeviceID);
            mParams.put("VOLUMEID_PARAM", mVolumeID);
            mParams.put("COLLECTIONTYPE_PARAM", new Integer(pCollectionType));
            String mJob = this.getDiscoverProxy().discover("probeVolumeProcessName", mParams);
            asyncResult = mResult = this.getDiscoverProxy().getJobStatus(mJob);
        }
        catch (Throwable throwable) {
            try {
                mDBConn.close();
            }
            catch (Throwable pEx) {
                // empty catch block
            }
            mLTH.exit(mResult);
            throw throwable;
        }
        try {
            mDBConn.close();
        }
        catch (Throwable pEx) {
            // empty catch block
        }
        mLTH.exit((Object)mResult);
        return asyncResult;
    }
}

