/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.SVCBackendControllerUpdatePostProcess;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.BackendController;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.interfaces.ParameterException;

public class BackendControllerUpdatePostProcess
extends SVCBackendControllerUpdatePostProcess {
    public BackendControllerUpdatePostProcess() {
        this("BackendController Update Post Processing");
    }

    protected BackendControllerUpdatePostProcess(String pName) {
        super(pName);
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"BackendControllerUpdatePostProcess", null);
        mLTH.exit(null);
    }

    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        return new DiscoverProcess.RegistrationData[]{new DiscoverProcess.RegistrationData("BackendControllerPostProcess", null, "Array", null, null, null)};
    }

    public Result process(Request pRequest, Map pParameters) throws ParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{pRequest, pParameters});
        Result mReturn = new Result(1);
        DBConnection mCon = null;
        try {
            int mDeviceID = Integer.parseInt((String)pParameters.get("DEVICEID"));
            String mSSID = (String)pParameters.get("SUBSYSTEMID");
            mCon = ServiceUtils.getConnection();
            StorageSubsystem mStorageSubsystem = ExternalKeyManager.getStorageSubsystem((String)mSSID, (DBConnection)mCon);
            this.setBackendController(Integer.toString(mStorageSubsystem.getSubsystemId()), mCon);
            mCon.commit();
            mReturn = new Result(0);
        }
        catch (Exception pEx) {
            if (mCon != null) {
                try {
                    mCon.rollback();
                }
                catch (SQLException pInnerEx) {
                    // empty catch block
                }
            }
            mReturn = new Result(1);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            if (mCon != null) {
                try {
                    mCon.close();
                }
                catch (SQLException pInnerEx) {}
            }
            mLTH.exit((Object)mReturn);
        }
        return mReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBackendController(String pSSID, DBConnection pCon) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"setBackendController", (Object[])new Object[]{pCon, pSSID});
        try {
            String mSQLStatement = "UPDATE " + BackendController.getTablename() + " set REFERENCED_SUBSYSTEM_ID= " + pSSID + " where SUBSTR(PORT_WWNS,2,16)  in (select  " + "NAME" + " from " + Port.getTablename() + " where " + "SUBSYSTEM_ID" + " = " + pSSID + ")";
            mLTH.traceHigh("Invoking query " + mSQLStatement);
            int mReturn = DiskCIMProcessor.updateComplexQueryDeadlockRetry((DBConnection)pCon, (String)mSQLStatement, null);
            pCon.commit();
            mLTH.traceInfo("Updated rows : " + mReturn);
        }
        finally {
            mLTH.exit(null);
        }
    }
}

