/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import com.ibm.log.Level;
import org.eclipse.aperi.discovery.IProgressLogger;
import org.eclipse.aperi.discovery.ProgressLogger;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class DiskProgressLogger
extends ProgressLogger
implements IProgressLogger {
    private LogTraceHelper cLTH;

    public DiskProgressLogger(LogTraceHelper pLTH, String pSystemName, String pEntryMessage, String pProgressMessage, String pCompleteMessage, String pFailedMessage) {
        super(null, pSystemName, pEntryMessage, pProgressMessage, pCompleteMessage, pFailedMessage);
        this.cLTH = pLTH;
    }

    public void entry() {
        this.cElementCount = 0;
        this.cComplete = false;
        this.log(IRecordType.TYPE_INFO, "entry", this.cEntryMessage, this.cSystemName);
    }

    public void elementDiscovered() {
        if (!this.isHierarchical()) {
            this.advance();
        }
    }

    protected void advance() {
        if (++this.cElementCount % this.getInterval() == 0) {
            this.log(IRecordType.TYPE_INFO, "increment", this.cProgressMessage, Integer.toString(this.cElementCount));
        }
    }

    public void complete() {
        this.cComplete = true;
        this.log(IRecordType.TYPE_INFO, "complete", this.cCompleteMessage, Integer.toString(this.cElementCount));
    }

    public void exit() {
        if (!this.cComplete) {
            this.log(IRecordType.TYPE_ERROR, "exit", this.cFailedMessage, Integer.toString(this.cElementCount));
        }
    }

    protected void log(Level pRecordType, String pMethod, String pMsgId, Object pObj) {
        this.log(pRecordType, pMethod, pMsgId, new Object[]{pObj});
    }

    protected void log(Level pRecordType, String pMethod, String pMsgId, Object[] pObjects) {
        if (pMsgId != null && pMsgId.length() > 0) {
            this.cLTH.logMsg(pMsgId, pObjects);
        }
    }
}

