/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.interfaces.ParameterException;

public class ProbeCompleteSubsystem
extends DiscoverProcess
implements CIMNames,
DiscoveryConstants {
    public ProbeCompleteSubsystem(String description, boolean mainProcess) {
        super(description, mainProcess, new String[]{"DEVICEID", "SUBSYSTEMID"}, new String[]{String.class.getName(), String.class.getName()});
    }

    public Result process(Request pDiscoverRequest, Map pParameters) throws ParameterException {
        boolean mStatus = true;
        int mRC = 0;
        Result mResult = new Result();
        try {
            String[] mJobID = this.getDiscoverRouterService().perform("collectDataFromStorageSubsystem", pParameters, new Integer(pDiscoverRequest.getId()).toString());
            if (mJobID == null) {
                mStatus = false;
                mRC = 1;
            } else {
                this.getDiscoverRouterService().waitTilComplete(mJobID);
                mRC = pDiscoverRequest.getReturnCode();
                if (mRC != 0 && mRC != -1000) {
                    mStatus = false;
                }
            }
            if (mStatus) {
                mJobID = this.getDiscoverRouterService().perform("collectSHWIDsFromStorageSubsystem", pParameters, new Integer(pDiscoverRequest.getId()).toString());
                if (mJobID == null) {
                    mStatus = false;
                    mRC = 1;
                } else {
                    this.getDiscoverRouterService().waitTilComplete(mJobID);
                    int bRC = pDiscoverRequest.getReturnCode();
                    if (mRC != 0 && mRC != -1000) {
                        mStatus = false;
                    }
                }
            }
        }
        catch (SRMRuntimeException bEx) {
            mResult.setRc(1);
            mResult.setSRMMessage(bEx.getSRMMessage());
        }
        catch (Exception bEx) {
            mResult.setRc(1);
            mResult.setSRMMessage(new SRMMessage("HWN021503E", null));
        }
        return mResult;
    }

    public String getProcessInfoForJobLog(Map parameters) {
        try {
            String subsystemId = (String)ProbeCompleteSubsystem.getParameter((Map)parameters, (String)"SUBSYSTEMID", (String)String.class.getName());
            return "probeSubsystem+" + subsystemId;
        }
        catch (Throwable t) {
            return null;
        }
    }
}

