/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.AssociatorCIMQuery;
import org.eclipse.aperi.discovery.DiscoverStep;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.discovery.IProgressLogger;
import org.eclipse.aperi.discovery.ProbePerfTracker;
import org.eclipse.aperi.discovery.ProgressLogger;
import org.eclipse.aperi.discovery.TrackProbePerformance;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.api.DiskManagerRCs;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.DiskProgressLogger;
import org.eclipse.aperi.disk.collection.MappingMaskingProcessor;
import org.eclipse.aperi.disk.collection.ProbeGenericSubsystemProcess;
import org.eclipse.aperi.disk.collection.step.COPCacheStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class ProbeGenericMaskingMappingProcess
extends DiscoverProcess
implements CIMNames,
DiscoveryConstants,
DiskManagerRCs {
    protected static final String COLLECTNODESFROMCOMPUTERSYSTEM = "collectNodesFromComputerSystem";
    protected static final String COLLECT_SCSIPROTCOLCONTROLLER = "collectSCSIProtocolController";
    protected static final String COLLECT_AUTHORIZEDPRIVILEGE = "collectAuthorizedPrivilege";
    protected static final String COLLECT_PRIVILEGE = "collectPrivilege";
    protected static final String COLLECT_SHWIDS = "collectSHWIDs";
    protected static final String COLLECT_SHWIDS_CLIENTSETTINGDATA = "collectSHWIDs_ClientSettingData";
    protected static final String COLLECT_SHWIDS_COLLECTION = "collectSHWIDs_Collection";
    protected static final String COLLECT_COLLECTION_OF_SHWIDS = "collectCollectionOfSHWIDs";
    protected static final String COLLECT_SHWIDS_FROM_COLLECTION = "collectSHWIDsFromCollection";
    protected static final String COLLECT_PROTCOLCONTROLLER_FOR_PORT = "collect_ProtocolControllerForPort";
    protected static final String COLLECT_PROTCOLCONTROLLER_FOR_UNIT = "collectProtocolControllerForUnit";
    protected static final String COLLECT_SHWID_MGMTSERVICE = "collectStorageHardwareIDManagementService";
    protected static final String COLLECT_SHWIDS_FROM_MGMTSERVICE = "collectSHWIDSfromStorageHardwareIDManagementService";
    protected static final String COLLECT_SVC_PROTOCOLCONTROLLER_FROM_VIEW = "collectSVCProtocolControllerFromView";

    public static void registerSteps(IDiscoverRouterService pRouter) {
        pRouter.addProcess(COLLECT_SCSIPROTCOLCONTROLLER, (IDiscoverProcess)new AssociatorCIMQuery("Collect SCSIProtocolController", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemDevice", (String)"CIM_SCSIProtocolController", null, null), "CIM_ComputerSystem", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_AUTHORIZEDPRIVILEGE, (IDiscoverProcess)new AssociatorCIMQuery("Collect Authorized Privilege from ProtocolController", Query.associators((String)"CIM_SCSIProtocolController", (String)"CIM_AuthorizedTarget", (String)"CIM_AuthorizedPrivilege", null, null), "CIM_SCSIProtocolController", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_PRIVILEGE, (IDiscoverProcess)new AssociatorCIMQuery("Collect Privilege from ProtocolController", Query.associators((String)"CIM_SCSIProtocolController", (String)"CIM_AuthorizedTarget", (String)"CIM_Privilege", null, null), "CIM_SCSIProtocolController", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_SHWIDS, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageHardwareIds", Query.associators((String)"CIM_AuthorizedPrivilege", (String)"CIM_AuthorizedSubject", (String)"CIM_StorageHardwareID", null, null), "CIM_AuthorizedPrivilege", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_SHWIDS_CLIENTSETTINGDATA, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageClientSettingData for SHWIDS", Query.associators((String)"CIM_StorageHardwareID", (String)"CIM_ElementSettingData", (String)"CIM_StorageClientSettingData", null, null), "CIM_StorageHardwareID", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_SHWIDS_COLLECTION, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageHardwareIds: SystemSpecificCollection", Query.associators((String)"CIM_StorageHardwareID", (String)"CIM_MemberOfCollection", (String)"CIM_SystemSpecificCollection", null, null), "CIM_StorageHardwareID", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_COLLECTION_OF_SHWIDS, (IDiscoverProcess)new AssociatorCIMQuery("Collect SystemSpecificCollection of StorageHardwareIds", Query.associators((String)"CIM_AuthorizedPrivilege", (String)"CIM_AuthorizedSubject", (String)"CIM_SystemSpecificCollection", null, null), "CIM_AuthorizedPrivilege", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_SHWIDS_FROM_COLLECTION, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageHardwareIds from SystemSpecificCollection", Query.associators((String)"CIM_SystemSpecificCollection", (String)"CIM_MemberOfCollection", (String)"CIM_StorageHardwareID", null, null), "CIM_SystemSpecificCollection", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_PROTCOLCONTROLLER_FOR_PORT, (IDiscoverProcess)new AssociatorCIMQuery("Collect Ports of ProtocolController: ProtocolControllerForPort", Query.references((String)"CIM_ProtocolController", (String)"CIM_ProtocolControllerForPort", null), "CIM_SCSIProtocolController", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_PROTCOLCONTROLLER_FOR_UNIT, (IDiscoverProcess)new AssociatorCIMQuery("Collect Volumes Assignment for ProtocolController: ProtocolControllerForUnit", Query.references((String)"CIM_ProtocolController", (String)"CIM_ProtocolControllerForUnit", null), "CIM_SCSIProtocolController", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_SHWID_MGMTSERVICE, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageHardwareManagementService", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_HostedService", (String)"CIM_StorageHardwareIDManagementService", null, null), "CIM_ComputerSystem", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_SHWIDS_FROM_MGMTSERVICE, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageHardwareIds from StorageHardwareManagementService", Query.associators((String)"CIM_StorageHardwareIDManagementService", (String)"CIM_ConcreteDependency", (String)"CIM_StorageHardwareID", null, null), "CIM_StorageHardwareIDManagementService", CIMInstance.class.getName(), false));
    }

    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        return new DiscoverProcess.RegistrationData[]{new DiscoverProcess.RegistrationData("collectSHWIDsFromStorageSubsystem", null, null, null, null, null)};
    }

    public ProbeGenericMaskingMappingProcess(String description, boolean mainProcess) {
        super(description, mainProcess, new String[]{"DEVICEID", "SUBSYSTEMID", "CIMOM", "CAPABILITY", "TL_CS", "MODEL", "VENDOR", "CIMOMSWLVL"}, new String[]{String.class.getName(), String.class.getName(), String[].class.getName(), CapabilityData.class.getName(), CIMObjectPath.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
    }

    public ProbeGenericMaskingMappingProcess() {
        this("collectSHWIDsFromStorageSubsystem", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result process(Request pDiscoverRequest, Map pParameters) throws ParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)pDiscoverRequest, (Object)((Object)this), (String)"process", (Object[])new Object[]{pParameters});
        Result mResult = new Result(10010);
        try {
            String mSubSystemLogName;
            block30: {
                mSubSystemLogName = (String)pParameters.get("SUBSYSTEMID");
                mLTH.logMsg("HWN021708I", new Object[]{mSubSystemLogName});
                pParameters = DiscoverUtils.setProbeTimeout((Map)pParameters, (long)DiskManagerConfigSvc.getLongConfigValue((String)"Probe.Timeout.LMM", (long)0L), (LogTraceHelper)mLTH);
                MappingMaskingProcessor mProcessor = new MappingMaskingProcessor(pDiscoverRequest.getScannerId());
                mProcessor.initializeForSubsystemProbe(pParameters);
                try {
                    boolean mStatus;
                    String mSubsystemID;
                    block29: {
                        DiskProgressLogger mViewProgressLogger = new DiskProgressLogger(mLTH, mSubSystemLogName, "HWN021740I", "HWN021741I", "HWN021741I", null);
                        mViewProgressLogger.setInterval(10);
                        mViewProgressLogger.enableHierarchicalMode();
                        IStep collectSCSIProtocolController = this.getStepCollectSCSIProtocolController(mProcessor, mLTH);
                        COPCacheStep cacheSCSIProtocolController = new COPCacheStep("CIM_SCSIProtocolController", mProcessor, false);
                        cacheSCSIProtocolController.setProgressLogger((IProgressLogger)new ProgressLogger.InnerProgressLogger((ProgressLogger)mViewProgressLogger));
                        IStep collectAuthorizedPrivilege = this.getStepPrivilegeFromProtocolController(mProcessor, mLTH);
                        COPCacheStep cacheAuthorizedPrivilege = new COPCacheStep("CIM_AuthorizedPrivilege", mProcessor, false);
                        DiscoverStep collectSHWIDs = new DiscoverStep(COLLECT_SHWIDS, "CIM_StorageHardwareID", (CIMProcessor)mProcessor, mLTH);
                        COPCacheStep cacheSHWID = new COPCacheStep("CIM_StorageHardwareID", mProcessor, false);
                        DiscoverStep collectSHWIDs_ClientSettingData = new DiscoverStep(COLLECT_SHWIDS_CLIENTSETTINGDATA, null, (CIMProcessor)mProcessor, mLTH);
                        DiscoverStep collectSHWIDs_Collection = new DiscoverStep(COLLECT_SHWIDS_COLLECTION, "CIM_SystemSpecificCollection", (CIMProcessor)mProcessor, mLTH);
                        DiscoverStep collectSystemSpecificCollectionOfSHWIDs = new DiscoverStep(COLLECT_COLLECTION_OF_SHWIDS, "CIM_SystemSpecificCollection", (CIMProcessor)mProcessor, mLTH);
                        DiscoverStep collectSHWIDsFromCollection = new DiscoverStep(COLLECT_SHWIDS_FROM_COLLECTION, "CIM_StorageHardwareID", (CIMProcessor)mProcessor, mLTH);
                        COPCacheStep cacheSHWIDforCollection = new COPCacheStep(cacheSHWID);
                        DiscoverStep collectProtocollControllerForPort = new DiscoverStep(COLLECT_PROTCOLCONTROLLER_FOR_PORT, null, (CIMProcessor)mProcessor, mLTH);
                        IStep collectProtocollControllerForUnit = this.getStepCollectProtocollControllerForUnit(mProcessor, mLTH);
                        IStep collectSCSIProtocolControllerForNode = this.getStepCollectSCSIProtocolControllerForNode(collectSCSIProtocolController, mLTH);
                        DiscoverStep collectSHWIDMGMTService = new DiscoverStep(COLLECT_SHWID_MGMTSERVICE, "CIM_StorageHardwareIDManagementService", (CIMProcessor)mProcessor, mLTH);
                        DiscoverStep collectSHWIDsFromManagementService = new DiscoverStep(COLLECT_SHWIDS_FROM_MGMTSERVICE, "CIM_StorageHardwareID", (CIMProcessor)mProcessor, mLTH);
                        collectSCSIProtocolController.addNextStep((IStep)cacheSCSIProtocolController);
                        cacheSCSIProtocolController.addNextStep(collectAuthorizedPrivilege);
                        collectAuthorizedPrivilege.addNextStep((IStep)cacheAuthorizedPrivilege);
                        cacheAuthorizedPrivilege.addNextStep((IStep)collectSHWIDs);
                        collectSHWIDs.addNextStep((IStep)cacheSHWID);
                        cacheSHWID.addNextStep((IStep)collectSHWIDs_ClientSettingData);
                        if (((CapabilityData)pParameters.get("CAPABILITY")).getControllerSuppColl() == 1) {
                            cacheSHWID.addNextStep((IStep)collectSHWIDs_Collection);
                        }
                        if (((CapabilityData)pParameters.get("CAPABILITY")).getSmisVersion().compareToIgnoreCase("1.1.0") != 0 && ((CapabilityData)pParameters.get("CAPABILITY")).getControllerSuppColl() == 1) {
                            cacheAuthorizedPrivilege.addNextStep((IStep)collectSystemSpecificCollectionOfSHWIDs);
                            collectSystemSpecificCollectionOfSHWIDs.addNextStep((IStep)collectSHWIDsFromCollection);
                            collectSHWIDsFromCollection.addNextStep((IStep)cacheSHWIDforCollection);
                            cacheSHWIDforCollection.addNextStep((IStep)collectSHWIDs_ClientSettingData);
                        }
                        cacheSCSIProtocolController.addNextStep((IStep)collectProtocollControllerForPort);
                        cacheSCSIProtocolController.addNextStep(collectProtocollControllerForUnit);
                        collectSHWIDMGMTService.addNextStep((IStep)collectSHWIDsFromManagementService);
                        mSubsystemID = (String)pParameters.get("SUBSYSTEMID");
                        CIMObjectPath mCIMObjPath = (CIMObjectPath)pParameters.get("TL_CS");
                        CIMInstance mCIMSubsystem = new CIMInstance(mCIMObjPath);
                        pParameters.put("CIM_ComputerSystem", mCIMSubsystem);
                        Hashtable mRefDBKeys = (Hashtable)mProcessor.getDBReferences().get(mCIMSubsystem.getClassName());
                        Hashtable<String, Hashtable> mDBKeys = new Hashtable<String, Hashtable>();
                        mProcessor.start(pDiscoverRequest.getId());
                        mStatus = true;
                        try {
                            if (mStatus) {
                                ProbeGenericSubsystemProcess.setCollectionStatus(mSubsystemID, 16, false, true);
                                mLTH.logMsg("HWN021715I", new Object[]{mSubSystemLogName});
                                mResult.setRc(10019);
                                mViewProgressLogger.entry();
                                mStatus = collectSCSIProtocolController.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                            }
                            if (mStatus) {
                                mDBKeys = new Hashtable();
                                mDBKeys.put(mCIMSubsystem.getClassName(), mRefDBKeys);
                                mProcessor.setDBReferences(mDBKeys);
                                mResult.setRc(10020);
                                collectSCSIProtocolControllerForNode.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                                mViewProgressLogger.complete();
                            } else {
                                mViewProgressLogger.exit();
                            }
                            if (mStatus) {
                                mDBKeys = new Hashtable();
                                mDBKeys.put(mCIMSubsystem.getClassName(), mRefDBKeys);
                                mProcessor.setDBReferences(mDBKeys);
                                pParameters.put("CIM_ComputerSystem", mCIMSubsystem);
                                mResult.setRc(10021);
                                collectSHWIDMGMTService.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                            }
                        }
                        catch (Throwable bEx) {
                            this.checkException(bEx, mLTH, pParameters);
                            mStatus = false;
                        }
                        finally {
                            mProcessor.end(pDiscoverRequest.getId());
                        }
                        if (!mStatus) break block29;
                        mLTH.logMsg("HWN021719I", new Object[]{mSubSystemLogName});
                        mResult.setRc(10016);
                        ProbePerfTracker.ProbeAction bProbePostProcessing = TrackProbePerformance.startProbeAction((String)this.getScannerId(pParameters), (int)ProbePerfTracker.POST_PROCESSING);
                        this.getDiscoverRouterService().perform("ExtentUpdatePostProcess", pParameters, new Integer(pDiscoverRequest.getId()).toString());
                        this.getDiscoverRouterService().perform("ISAssignedUpdatePostProcess", pParameters, new Integer(pDiscoverRequest.getId()).toString());
                        this.getDiscoverRouterService().perform("StoragePoolUpdatePostProcess", pParameters, new Integer(pDiscoverRequest.getId()).toString());
                        TrackProbePerformance.finishedProbeAction((ProbePerfTracker.ProbeAction)bProbePostProcessing);
                        mResult.setRc(0);
                    }
                    try {
                        ProbeGenericSubsystemProcess.setCollectionStatus(mSubsystemID, mStatus ? 0 : 8, false, true);
                    }
                    catch (Exception bEx) {
                        mResult.setRc(10017);
                        mLTH.traceError("HWN021503E", (Throwable)bEx);
                        mLTH.logMsg("HWN021503E", null);
                        mStatus = false;
                    }
                    break block30;
                    catch (Throwable bEx) {
                        try {
                            this.checkException(bEx, mLTH, pParameters);
                            mStatus = false;
                        }
                        catch (Throwable throwable) {
                            try {
                                ProbeGenericSubsystemProcess.setCollectionStatus(mSubsystemID, mStatus ? 0 : 8, false, true);
                            }
                            catch (Exception bEx2) {
                                mResult.setRc(10017);
                                mLTH.traceError("HWN021503E", (Throwable)bEx2);
                                mLTH.logMsg("HWN021503E", null);
                                mStatus = false;
                            }
                            throw throwable;
                        }
                        try {
                            ProbeGenericSubsystemProcess.setCollectionStatus(mSubsystemID, mStatus ? 0 : 8, false, true);
                        }
                        catch (Exception bEx3) {
                            mResult.setRc(10017);
                            mLTH.traceError("HWN021503E", (Throwable)bEx3);
                            mLTH.logMsg("HWN021503E", null);
                            mStatus = false;
                        }
                    }
                }
                finally {
                    if (mProcessor != null) {
                        mProcessor.shutdown(pDiscoverRequest.getId());
                        mProcessor = null;
                    }
                }
            }
            mLTH.logMsg("HWN021709I", new Object[]{mSubSystemLogName});
        }
        finally {
            mLTH.exit((Object)mResult);
        }
        return mResult;
    }

    public String getScannerId(Map pParameters) throws ParameterException {
        String prefix = "PS2";
        String[] mCIMOM = (String[])pParameters.get("CIMOM");
        if (mCIMOM == null || mCIMOM.length < 1) {
            throw new ParameterException("Missing parameter: CIMOM");
        }
        String mCIMOMServiceURL = mCIMOM[0];
        String mSubsystemID = (String)pParameters.get("DEVICEID");
        if (mSubsystemID == null) {
            throw new ParameterException("Missing parameter: DEVICEID");
        }
        String mScannerId = prefix + ":" + mCIMOMServiceURL + "+" + mSubsystemID;
        return mScannerId;
    }

    public int getAuthoritativeReferenceType(Map pParameters) throws ParameterException {
        return 1;
    }

    public int getAuthoritativeReferenceId(Map pParameters) throws ParameterException {
        String mStorageSubsystemDBId = (String)pParameters.get("DEVICEID");
        if (mStorageSubsystemDBId == null) {
            throw new ParameterException("Missing parameter: DEVICEID");
        }
        return Integer.parseInt(mStorageSubsystemDBId);
    }

    protected IStep getStepPrivilegeFromProtocolController(DiskCIMProcessor pProcessor, LogTraceHelper pLTH) {
        return new DiscoverStep(COLLECT_AUTHORIZEDPRIVILEGE, "CIM_AuthorizedPrivilege", (CIMProcessor)pProcessor, pLTH);
    }

    protected IStep getStepCollectSCSIProtocolController(DiskCIMProcessor pProcessor, LogTraceHelper pLTH) {
        DiscoverStep collectSCSIProtocolController = new DiscoverStep(COLLECT_SCSIPROTCOLCONTROLLER, "CIM_SCSIProtocolController", (CIMProcessor)pProcessor, pLTH);
        return collectSCSIProtocolController;
    }

    protected IStep getStepCollectSCSIProtocolControllerForNode(IStep pCollectSCSIProtocolController, LogTraceHelper pLTH) {
        DiscoverStep collectSCSIProtocolControllerForNode = new DiscoverStep(COLLECTNODESFROMCOMPUTERSYSTEM, "CIM_ComputerSystem", null, pLTH);
        collectSCSIProtocolControllerForNode.addNextStep(pCollectSCSIProtocolController);
        return collectSCSIProtocolControllerForNode;
    }

    protected IStep getStepCollectProtocollControllerForUnit(DiskCIMProcessor pProcessor, LogTraceHelper pLTH) {
        return new DiscoverStep(COLLECT_PROTCOLCONTROLLER_FOR_UNIT, null, (CIMProcessor)pProcessor, pLTH);
    }
}

