/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.AssociatorCIMQuery;
import org.eclipse.aperi.discovery.DiscoverStep;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.discovery.ProbePerfTracker;
import org.eclipse.aperi.discovery.TrackProbePerformance;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.api.DiskManagerRCs;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.ProbeGenericInBandVirtualizerProcess;
import org.eclipse.aperi.disk.collection.SvcPostCollectionProcess;
import org.eclipse.aperi.disk.collection.step.COPCacheStep;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.client.CIMEnumeration;

public class ProbeSVCSubsystemProcess
extends ProbeGenericInBandVirtualizerProcess
implements DiscoveryConstants,
DiskManagerRCs {
    protected static final String COLLECT_SUBSYSTEM_GETINSTANCE = "collectSubsystemGetInstance";
    protected static final String COLLECT_SVC_BACKENDCONTROLLER = "collectSVCBackendController";
    protected static final String COLLECT_SVC_BACKENDVOLUME_FROM_BACKENDCONTROLLER = "collectSVCBackendVolumeFromBackendController";
    protected static final String SVCPOSTCOLLECTIONPROCESS = "SvcPostCollectionProcess";

    public static void registerSteps(IDiscoverRouterService pRouter) {
        pRouter.addProcess(COLLECT_SUBSYSTEM_GETINSTANCE, (IDiscoverProcess)new AssociatorCIMQuery("Collect Subsystem getInstance", Query.getInstanceQuery((String)"CIM_ComputerSystem"), "CIM_ComputerSystem", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_SVC_BACKENDCONTROLLER, (IDiscoverProcess)new AssociatorCIMQuery("Collect SVC Backend Controller", Query.associators((String)"CIM_ComputerSystem", (String)"IBMTSSVC_ConnectedBackendController", (String)"IBMTSSVC_BackendController", null, null), "CIM_ComputerSystem", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_SVC_BACKENDVOLUME_FROM_BACKENDCONTROLLER, (IDiscoverProcess)new AssociatorCIMQuery("collect SVCBackendVolume from SVCBackendController", Query.associatorNames((String)"IBMTSSVC_BackendController", (String)"IBMTSSVC_BackendControllerForVolume", (String)"IBMTSSVC_BackendVolume", null, null), "IBMTSSVC_BackendController", CIMInstance.class.getName(), false));
        pRouter.addProcess(SVCPOSTCOLLECTIONPROCESS, (IDiscoverProcess)new SvcPostCollectionProcess());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result process(Request pDiscoverRequest, Map pParameters) throws ParameterException {
        Result mResult;
        block24: {
            boolean mStatus;
            DiskCIMProcessor mProcessor;
            String mSubsystemID;
            String mSubSystemLogName;
            LogTraceHelper mLTH;
            block22: {
                mLTH = LogTraceHelper.entry((Request)pDiscoverRequest, (Object)((Object)this), (String)"process", (Object[])new Object[]{pParameters});
                mResult = new Result(10010);
                mSubSystemLogName = (String)pParameters.get("SUBSYSTEMID");
                mSubsystemID = (String)pParameters.get("SUBSYSTEMID");
                mLTH.logMsg("HWN021708I", new Object[]{mSubSystemLogName});
                pParameters = DiscoverUtils.setProbeTimeout((Map)pParameters, (long)DiskManagerConfigSvc.getLongConfigValue((String)"Probe.Timeout.SVC", (long)0L), (LogTraceHelper)mLTH);
                mProcessor = new DiskCIMProcessor(pDiscoverRequest.getScannerId());
                mStatus = false;
                CapabilityData mCapabData = (CapabilityData)pParameters.get("CAPABILITY");
                DiscoverStep collectFCPortsFromComputerSystem = new DiscoverStep("collectFCPortsFromComputerSystem", null, (CIMProcessor)mProcessor);
                DiscoverStep collectComputerSystemGetInstance = new DiscoverStep(COLLECT_SUBSYSTEM_GETINSTANCE, "CIM_ComputerSystem_DUMMY", (CIMProcessor)mProcessor);
                collectComputerSystemGetInstance.addNextStep((IStep)collectFCPortsFromComputerSystem);
                IStep collectPoolsFromComputerSystem = this.getStepCollectPoolsFromComputerSystem(mProcessor, mCapabData, mSubSystemLogName, mLTH);
                IStep collectSVCBackendController = this.getStepCollectSVCBackendController(mProcessor);
                IStep collectVolumeSettings = this.getStepCollectVolumeSettings(mProcessor, mLTH);
                DiscoverStep collectClientSettingDataFromComputerSystem = new DiscoverStep("collectClientSettingDataFromComputerSystem", null, (CIMProcessor)mProcessor);
                CIMObjectPath mCIMObjPath = (CIMObjectPath)pParameters.get("TL_CS");
                mProcessor.initializeForSubsystemProbe(pParameters);
                String mMigrated = this.checkAndHandleMigratedSubsystem(mSubsystemID);
                CIMInstance mCIMSubsystem = new CIMInstance(mCIMObjPath);
                pParameters.put("CIM_ComputerSystem", mCIMSubsystem);
                Hashtable mRefDBKeys = (Hashtable)mProcessor.getDBReferences().get(mCIMSubsystem.getClassName());
                mRefDBKeys.put("ref_subsystem_migrated", mMigrated);
                String mRefSystemName = mSubSystemLogName.substring(0, mSubSystemLogName.indexOf(58));
                mRefDBKeys.put("ref_system_name", mRefSystemName);
                Hashtable<String, Hashtable> mDBKeys = new Hashtable<String, Hashtable>();
                mProcessor.start(pDiscoverRequest.getId());
                mStatus = true;
                try {
                    this.requestDiscovery(mSubsystemID, mCIMObjPath, (String[])pParameters.get("CIMOM"), mLTH);
                    ProbeSVCSubsystemProcess.setCollectionStatus(mSubsystemID, 2, true, false);
                    if (mStatus) {
                        mDBKeys = new Hashtable();
                        mDBKeys.put(mCIMSubsystem.getClassName(), mRefDBKeys);
                        mProcessor.setDBReferences(mDBKeys);
                        mLTH.logMsg("HWN021713I", new Object[]{mSubSystemLogName});
                        mResult.setRc(10012);
                        mStatus = collectComputerSystemGetInstance.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                    }
                    if (mStatus) {
                        mDBKeys = new Hashtable();
                        mDBKeys.put(mCIMSubsystem.getClassName(), mRefDBKeys);
                        mProcessor.setDBReferences(mDBKeys);
                        mLTH.logMsg("HWN021716I", new Object[]{mSubSystemLogName});
                        mResult.setRc(10013);
                        mStatus = collectPoolsFromComputerSystem.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                    }
                    if (mStatus) {
                        mDBKeys = new Hashtable();
                        mDBKeys.put(mCIMSubsystem.getClassName(), mRefDBKeys);
                        mProcessor.setDBReferences(mDBKeys);
                        mResult.setRc(10018);
                        mStatus = collectSVCBackendController.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                    }
                    if (mStatus) {
                        mDBKeys = new Hashtable();
                        mDBKeys.put(mCIMSubsystem.getClassName(), mRefDBKeys);
                        mProcessor.setDBReferences(mDBKeys);
                        mLTH.logMsg("HWN021717I", new Object[]{mSubSystemLogName});
                        mResult.setRc(10014);
                        mStatus = collectVolumeSettings.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                    }
                    if (mStatus) {
                        mDBKeys = new Hashtable();
                        mDBKeys.put(mCIMSubsystem.getClassName(), mRefDBKeys);
                        mProcessor.setDBReferences(mDBKeys);
                        mLTH.logMsg("HWN021718I", new Object[]{mSubSystemLogName});
                        mResult.setRc(10015);
                        mStatus = collectClientSettingDataFromComputerSystem.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                    }
                }
                catch (Throwable bEx) {
                    this.checkException(bEx, mLTH, pParameters);
                    mStatus = false;
                }
                finally {
                    mProcessor.end(pDiscoverRequest.getId());
                }
                if (!mStatus) break block22;
                mLTH.logMsg("HWN021719I", new Object[]{mSubSystemLogName});
                mResult.setRc(10016);
                ProbePerfTracker.ProbeAction bProbePostProcessing = TrackProbePerformance.startProbeAction((String)this.getScannerId(pParameters), (int)ProbePerfTracker.POST_PROCESSING);
                this.getDiscoverRouterService().perform(SVCPOSTCOLLECTIONPROCESS, pParameters, new Integer(pDiscoverRequest.getId()).toString());
                this.getDiscoverRouterService().perform("CapabilityUpdatePostProcess", pParameters, new Integer(pDiscoverRequest.getId()).toString());
                this.getDiscoverRouterService().perform("SVCBackendControllerPostProcess", pParameters, new Integer(pDiscoverRequest.getId()).toString());
                TrackProbePerformance.finishedProbeAction((ProbePerfTracker.ProbeAction)bProbePostProcessing);
                mResult.setRc(0);
            }
            Object var25_26 = null;
            try {
                ProbeSVCSubsystemProcess.setCollectionStatus(mSubsystemID, mStatus ? 0 : 1, true, false);
            }
            catch (Exception bEx2) {
                mResult.setRc(10017);
                mLTH.traceError("HWN021503E", (Throwable)bEx2);
                mLTH.logMsg("HWN021503E", null);
            }
            if (mProcessor != null) {
                mProcessor.shutdown(pDiscoverRequest.getId());
                mProcessor = null;
            }
            mLTH.logMsg("HWN021709I", new Object[]{mSubSystemLogName});
            mLTH.exit((Object)mResult);
            {
                break block24;
                catch (Throwable bEx) {
                    this.checkException(bEx, mLTH, pParameters);
                    mStatus = false;
                    Object var25_27 = null;
                    try {
                        ProbeSVCSubsystemProcess.setCollectionStatus(mSubsystemID, mStatus ? 0 : 1, true, false);
                    }
                    catch (Exception bEx2) {
                        mResult.setRc(10017);
                        mLTH.traceError("HWN021503E", (Throwable)bEx2);
                        mLTH.logMsg("HWN021503E", null);
                    }
                    if (mProcessor != null) {
                        mProcessor.shutdown(pDiscoverRequest.getId());
                        mProcessor = null;
                    }
                    mLTH.logMsg("HWN021709I", new Object[]{mSubSystemLogName});
                    mLTH.exit((Object)mResult);
                }
            }
            catch (Throwable throwable) {
                Object var25_28 = null;
                try {
                    ProbeSVCSubsystemProcess.setCollectionStatus(mSubsystemID, mStatus ? 0 : 1, true, false);
                }
                catch (Exception bEx2) {
                    mResult.setRc(10017);
                    mLTH.traceError("HWN021503E", (Throwable)bEx2);
                    mLTH.logMsg("HWN021503E", null);
                }
                if (mProcessor != null) {
                    mProcessor.shutdown(pDiscoverRequest.getId());
                    mProcessor = null;
                }
                mLTH.logMsg("HWN021709I", new Object[]{mSubSystemLogName});
                mLTH.exit((Object)mResult);
                throw throwable;
            }
        }
        return mResult;
    }

    public IStep getStepCollectExtentData(DiskCIMProcessor pProcessor, CapabilityData pCapabData, IStep pCollectDiskDriveFromExtent, LogTraceHelper pLTH) {
        COPCacheStep cacheExtents = new COPCacheStep("CIM_StorageExtent", pProcessor, true);
        return cacheExtents;
    }

    public IStep getStepCollectSVCBackendController(DiskCIMProcessor pProcessor) {
        DiscoverStep collectSVCBackendController = new DiscoverStep(COLLECT_SVC_BACKENDCONTROLLER, "IBMTSSVC_BackendController", (CIMProcessor)pProcessor);
        DiscoverStep collectSVCBackendVolume = new DiscoverStep(COLLECT_SVC_BACKENDVOLUME_FROM_BACKENDCONTROLLER, null, (CIMProcessor)pProcessor);
        collectSVCBackendController.addNextStep((IStep)collectSVCBackendVolume);
        return collectSVCBackendController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDiscovery(String pSVCid, CIMObjectPath pSvcCop, String[] pCIMOM, LogTraceHelper pLTH) {
        pLTH.traceInfo("requestDiscovery for SVC " + pSVCid);
        pLTH.logMsg("HWN021710I", new Object[]{pSVCid});
        CIMObjectPath mService = null;
        CIMEnumeration mServices = null;
        CIMClientWrapper mCimClient = CIMClientPool.getClient((String)pCIMOM[2], (String)pCIMOM[3], (String)pCIMOM[0], (String)pCIMOM[1]);
        try {
            mServices = (CIMEnumeration)mCimClient.associatorNames(pSvcCop, "CIM_HostedService", "CIM_StorageConfigurationService", null, null, pLTH);
            if (!mServices.hasMoreElements()) {
                pLTH.logMsg("HWN021711I", new Object[]{pSVCid, "No CIM_StorageConfigurationService"});
            } else {
                mService = (CIMObjectPath)mServices.nextElement();
                Vector bInParams = new Vector();
                Vector bOutParams = new Vector();
                bInParams.removeAllElements();
                bOutParams.removeAllElements();
                CIMValue bResult = mCimClient.invokeMethod(mService, "RequestDiscovery", bInParams, bOutParams, pLTH);
                if (((Number)bResult.getValue()).intValue() != 0) {
                    ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021514E", (Object)"RequestDiscovery", (Object)mCimClient.toString(), (Object)bResult.getValue(), (LogTraceHelper)pLTH);
                    pLTH.traceError("invokeMethod returned failure returncode", (Throwable)bEx);
                    pLTH.logMsg("HWN021711I", new Object[]{pSVCid, bEx.getMessage()});
                }
            }
        }
        catch (CIMException bEx) {
            pLTH.traceError("Internal error: CIMException", (Throwable)bEx);
            pLTH.logMsg("HWN021711I", new Object[]{pSVCid, bEx.getMessage()});
        }
        catch (DiskManagerTimeoutException bEx) {
            pLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)bEx);
            pLTH.logMsg("HWN021711I", new Object[]{pSVCid, bEx.getMessage()});
        }
        finally {
            try {
                if (mServices != null) {
                    mServices.close();
                }
            }
            catch (IOException e) {}
            mCimClient.close();
        }
    }

    public IStep getStepCollectPoolsFromComputerSystem(DiskCIMProcessor pProcessor, CapabilityData pCapabData, String pLogSystemName, LogTraceHelper pLTH) {
        return super.getStepCollectPoolsFromComputerSystem(pProcessor, pCapabData, pLogSystemName, pLTH);
    }
}

