/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DBHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.monitor.DiskMonitorHelper;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetection;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class SubProbeSVCExtent
extends DiscoverProcess {
    public Result process(Request pDiscoverRequest, Map pParameters) throws ParameterException, Exception {
        return null;
    }

    public SubProbeSVCExtent() {
        super("subProbeSvcExtent", false, new String[]{"DEVICEID", "SUBSYSTEMID", "CIMOM", "CAPABILITY", "TL_CS", "MODEL", "VENDOR", "CIMOMSWLVL"}, new String[]{String.class.getName(), String.class.getName(), String[].class.getName(), CapabilityData.class.getName(), CIMObjectPath.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
    }

    public SubProbeSVCExtent(String description, boolean mainProcess) {
        super(description, mainProcess, new String[]{"DEVICEID", "SUBSYSTEMID", "CIMOM", "CAPABILITY", "TL_CS", "MODEL", "VENDOR", "CIMOMSWLVL"}, new String[]{String.class.getName(), String.class.getName(), String[].class.getName(), CapabilityData.class.getName(), CIMObjectPath.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
    }

    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        return new DiscoverProcess.RegistrationData[]{new DiscoverProcess.RegistrationData("subProbeSvcExtent", null, "In Band Virtualization", "IBM", null, null)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performProbe(CIMClientWrapper pCimClient, StorageSubsystem pSubsystem, CIMOM pCimom, CapabilityData pCapability, ArrayList pExtentCOPs) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"performProbe", (Object[])new Object[]{pCimClient, pSubsystem, pCimom, pCapability, pExtentCOPs});
        try {
            IDBAttributeMapper mMapper = MapperRouter.getMapperRouter().findMapper("IBMTSSVC_BackendVolume", pCapability.getSmisVersion(), pSubsystem.getModel(), pCimom.getSoftwareLevel());
            if (mMapper == null) {
                RuntimeException e = new RuntimeException("Could not retrieve mapper for IBMTSSVC_BackendVolume.");
                mLTH.traceError("SVC extent subprobe failed.", (Throwable)e);
                throw e;
            }
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                ChangeDetection mChangeDetection = new ChangeDetection(mConnection);
                try {
                    for (int i = 0; i < pExtentCOPs.size(); ++i) {
                        CIMObjectPath mExtentPath = (CIMObjectPath)pExtentCOPs.get(i);
                        CIMInstance mExtentInstance = pCimClient.getInstance(mExtentPath, false, false, false, mLTH);
                        Hashtable mParam = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)mExtentInstance);
                        DBHelper.putObjectIntoHashtable(mParam, "ref_toplevelsystem_id", Integer.toString(pSubsystem.getSubsystemId()));
                        DBHelper.putObjectIntoHashtable(mParam, "ref_storagepool_id", this.getPoolIdFromExtent(mConnection, pCimClient, pSubsystem, mExtentPath, mExtentInstance));
                        MapperResult mResult = mMapper.persist(mConnection, mParam, null);
                        HashMap mTouchedEntities = new HashMap();
                        DiskMonitorHelper.addEntriesToInternalList(mTouchedEntities, MapperResult.convertRowsToIdentifiers((Map)mResult.getUpdatedRows()));
                        mConnection.commit();
                        mChangeDetection.complete(mConnection, mTouchedEntities, "C" + CIMOMManager.getUniqueNumberString());
                        mConnection.commit();
                    }
                    mChangeDetection = null;
                }
                catch (Exception e) {
                    if (mConnection != null) {
                        mConnection.rollback();
                    }
                    mLTH.traceError("Extent db update failed.", (Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    if (mChangeDetection != null) {
                        mChangeDetection.cancel();
                    }
                }
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPoolIdFromExtent(DBConnection pConnection, CIMClientWrapper pCimClient, StorageSubsystem pSubsystem, CIMObjectPath pExtentCop, CIMInstance pExtentInstance) throws SQLException, DiskManagerTimeoutException {
        StoragePool mPool;
        String mResult;
        LogTraceHelper mLTH;
        block5: {
            Enumeration mPoolEnum;
            block4: {
                String string;
                mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"getPoolIdFromExtent", (Object[])new Object[]{pConnection, pCimClient, pSubsystem, pExtentCop, pExtentInstance});
                mResult = null;
                try {
                    mPoolEnum = pCimClient.associatorNames(pExtentCop, "CIM_ConcreteComponent", "CIM_StoragePool", null, null, mLTH);
                    if (mPoolEnum.hasMoreElements()) break block4;
                    mLTH.traceWarning("No pool associated to backend volume " + pExtentCop.toString());
                    mLTH.exit(null);
                    string = null;
                }
                catch (Throwable throwable) {
                    mLTH.exit(mResult);
                    throw throwable;
                }
                mLTH.exit(mResult);
                return string;
            }
            CIMObjectPath mPoolCop = (CIMObjectPath)mPoolEnum.nextElement();
            mPool = new StoragePool();
            mPool.setInstanceId(mPoolCop.getKey("InstanceID").getValue().getValue().toString());
            mPool.setSubsystemId(pSubsystem.getSubsystemId());
            mPool.setClassName(mPoolCop.getObjectName());
            if (mPool.retrieve(pConnection)) break block5;
            mLTH.traceWarning("Associated pool not found in database: " + mPoolCop.toString());
            mLTH.exit(null);
            String string = null;
            mLTH.exit((Object)mResult);
            return string;
        }
        String string = mResult = Integer.toString(mPool.getPoolId());
        mLTH.exit((Object)mResult);
        return string;
    }
}

