/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection.step;

import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.step.AbstractDiscoverStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.sblim.wbem.cim.CIMInstance;

public class PersistInstanceStep
extends AbstractDiscoverStep
implements IStep,
CIMNames {
    protected String cInstanceName = null;
    protected DiskCIMProcessor cDiskCIMProcessor = null;

    public PersistInstanceStep(String pInstanceName, DiskCIMProcessor pDiskCIMProcessor) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"PersistInstanceStep", (Object[])new Object[]{pInstanceName});
        this.cDiskCIMProcessor = pDiskCIMProcessor;
        this.cInstanceName = pInstanceName;
        mLTH.exit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(String pDiscoverRequest, Map pParameters) throws Exception {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{pDiscoverRequest});
        Result mReturn = new Result(1);
        try {
            CIMInstance mCIMInstance = (CIMInstance)pParameters.get(this.cInstanceName);
            mReturn = this.persistInstance(mCIMInstance, this.cInstanceName, pParameters, mLTH);
            if (mReturn.getRc() == 0) {
                boolean bResult = this.processNext(pDiscoverRequest, pParameters);
                mReturn.setRc(bResult ? 0 : 1);
            }
        }
        finally {
            mLTH.exit((Object)mReturn);
        }
        return mReturn.getRc() == 0;
    }

    protected Result persistInstance(CIMInstance pCIMInstance, String pOrigCIMCLassname, Map pParameters, LogTraceHelper mLTH) {
        Result mReturn = new Result(0);
        if (this.cDiskCIMProcessor != null) {
            try {
                String bCIMServiceURL = ((String[])pParameters.get("CIMOM"))[0];
                JobInfo bJob = new JobInfo();
                bJob.setResourceId(bCIMServiceURL);
                Hashtable mInstanceProperties = DiskCIMProcessor.convertPropertiesToHashtable((Vector)pCIMInstance.getAllProperties(), new Hashtable());
                mInstanceProperties.put("originalcimclassname", pOrigCIMCLassname);
                this.cDiskCIMProcessor.handleEntity(bJob, pCIMInstance.getClassName(), mInstanceProperties);
            }
            catch (Throwable bEx) {
                mLTH.traceError("HWN021503E", bEx);
                mReturn.setRc(-1001);
            }
        }
        return mReturn;
    }
}

