/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection.step;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.ProbePerfTracker;
import org.eclipse.aperi.discovery.TrackProbePerformance;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.step.AbstractDiscoverStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.sblim.wbem.cim.CIMInstance;

public class PersistStorageSettingForVolume
extends AbstractDiscoverStep
implements IStep,
CIMNames {
    private String instanceName = null;
    private DiskCIMProcessor cDiskCIMProcessor = null;
    private String cNamespaceID = null;

    public PersistStorageSettingForVolume(DiskCIMProcessor pDiskCIMProcessor) {
        this.cDiskCIMProcessor = pDiskCIMProcessor;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"PersistStorageSettingForVolume", null);
        mLTH.exit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(String pDiscoverRequest, Map pParameters) throws Exception {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{pDiscoverRequest});
        ProbePerfTracker.ProbeAction mProbeAction = TrackProbePerformance.startProbeAction((String)Router.getRouter().getRequest(pDiscoverRequest).getScannerId(), (int)ProbePerfTracker.STEP_PERSIST_STORAGESETTING);
        Result mReturn = new Result(0);
        Integer mVolumeID = new Integer(Integer.MIN_VALUE);
        Object mVolumeName = null;
        Object mDBConn1 = null;
        String mCIMServiceURL = null;
        String mCIMNamespace = null;
        CIMInstance mStorageVolumeInstance = (CIMInstance)pParameters.get("CIM_StorageVolume");
        String mVolumeCOP = mStorageVolumeInstance.getObjectPath().toString();
        Hashtable mStorageVolumeProperties = CIMProcessor.convertPropertiesToHashtable((Vector)mStorageVolumeInstance.getAllProperties(), new Hashtable());
        CIMInstance mStorageSettingInstance = (CIMInstance)pParameters.get("CIM_StorageSetting");
        Hashtable mStorageSettingProperties = CIMProcessor.convertPropertiesToHashtable((Vector)mStorageSettingInstance.getAllProperties(), new Hashtable());
        try {
            int mSubsystemID = Integer.parseInt((String)pParameters.get("DEVICEID"));
            if (this.cNamespaceID == null) {
                mCIMServiceURL = ((String[])pParameters.get("CIMOM"))[0];
                mCIMNamespace = ((String[])pParameters.get("CIMOM"))[1];
                this.cNamespaceID = this.cDiskCIMProcessor.getNamespaceID(mCIMServiceURL, mCIMNamespace, mLTH);
            }
            if (this.cNamespaceID != null) {
                Object[] mVolKeys = this.cDiskCIMProcessor.getVolumeKeys(mStorageVolumeProperties, Integer.parseInt(this.cNamespaceID));
                if (mVolKeys != null) {
                    if ((Integer)mVolKeys[2] == mSubsystemID) {
                        JobInfo bJob = new JobInfo();
                        bJob.setResourceId(mCIMServiceURL);
                        mStorageSettingProperties.put("ref_name", (String)mVolKeys[0]);
                        mStorageSettingProperties.put("ref_name_format", ((Integer)mVolKeys[1]).toString());
                        mStorageSettingProperties.put("ref_storagevolume_id", ((Integer)mVolKeys[3]).toString());
                        mStorageSettingProperties.put("originalcimclassname", "CIM_StorageSetting");
                        mLTH.traceInfo("update StorageSettingData for Volume " + mVolumeID);
                        this.cDiskCIMProcessor.handleEntity(bJob, mStorageSettingInstance.getClassName(), mStorageSettingProperties);
                    } else {
                        mLTH.traceInfo("Volume " + mVolumeCOP + " does not belong to subsystem " + mSubsystemID);
                    }
                } else {
                    mLTH.traceInfo("Volume " + mVolumeCOP + " not found in CIM_KEY_VOLUME.");
                }
            } else {
                mLTH.traceWarning("Namespace ID not found for Volume: " + mVolumeCOP);
            }
        }
        catch (SQLException bSQLEx) {
            try {
                this.cDiskCIMProcessor.handleSQLException(mLTH, bSQLEx, "PersistStorageSettingForVolume.process");
            }
            catch (SQLException bInnerEx) {
                mLTH.traceError("HWN021503E", (Throwable)bSQLEx);
                mReturn.setRc(-1001);
            }
        }
        catch (Throwable bEx) {
            mLTH.traceError("HWN021503E", bEx);
            mReturn.setRc(-1001);
        }
        finally {
            TrackProbePerformance.finishedProbeAction((ProbePerfTracker.ProbeAction)mProbeAction);
            mLTH.exit((Object)mReturn);
        }
        if (mReturn.getRc() == 0) {
            boolean bReturn = this.processNext(pDiscoverRequest, pParameters);
            mReturn.setRc(bReturn ? 0 : -1001);
        }
        return mReturn.getRc() == 0;
    }
}

