/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection.step;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.MappingMaskingProcessor;
import org.eclipse.aperi.disk.collection.step.SimpleStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class SVCProtocolControllerForUnitCollectionStep
extends SimpleStep {
    private String cMapName = null;
    private MappingMaskingProcessor cProcessor = null;

    public SVCProtocolControllerForUnitCollectionStep(DiskCIMProcessor pProcessor, String pMapName) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"SVCProtocolControllerForUnitCollectionStep", (Object[])new Object[]{pMapName});
        this.cMapName = pMapName;
        this.cProcessor = (MappingMaskingProcessor)pProcessor;
        mLTH.exit(null);
    }

    public boolean process(String pDiscoverRequest, Map pParameters) throws Exception {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{pDiscoverRequest});
        boolean mReturn = true;
        HashMap mMap = (HashMap)pParameters.get(this.cMapName);
        CIMInstance mControllerInst = (CIMInstance)pParameters.get("CIM_SCSIProtocolController");
        if (mControllerInst != null) {
            CIMObjectPath mControllerCOPfromInst = mControllerInst.getObjectPath();
            mLTH.traceInfo("Getting VolumeInfos for Controller " + mControllerCOPfromInst.toString());
            List mVolumeInfo = (List)mMap.get(mControllerCOPfromInst);
            if (mVolumeInfo != null) {
                Iterator mListIt = mVolumeInfo.iterator();
                mLTH.traceInfo("Number of VolumeInfos: " + mVolumeInfo.size());
                while (mListIt.hasNext()) {
                    String[] mThisVolume = (String[])mListIt.next();
                    if (mThisVolume != null) {
                        this.cProcessor.addVolumeToDataPathForSVC(mThisVolume[0], mThisVolume[1]);
                        continue;
                    }
                    mLTH.traceWarning("A VolumeInfo was null");
                }
                mLTH.traceInfo("Finished with all VolumeInfos");
            } else {
                mLTH.traceWarning("List of VolumeInfos was null");
            }
        }
        mLTH.exit((Object)new Boolean(mReturn));
        return mReturn;
    }
}

