/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection.step;

import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.step.COPCacheStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class StorageExtentCacheStep
extends COPCacheStep
implements IStep {
    protected IStep cCollectVolumesStep = null;

    public StorageExtentCacheStep(String pInstanceName, DiskCIMProcessor pDiskCIMProcessor, boolean pPersistInstance) {
        super(pInstanceName, pDiskCIMProcessor, pPersistInstance);
    }

    public StorageExtentCacheStep(COPCacheStep pCOPCacheStep) {
        super(pCOPCacheStep);
    }

    public StorageExtentCacheStep(COPCacheStep pCOPCacheStep, boolean pPersistInstance) {
        super(pCOPCacheStep, pPersistInstance);
    }

    protected boolean handleCacheHit(String pDiscoverRequest, CIMInstance mCIMExtent, Hashtable mExtentDBRefs, Map mProcessProperties, LogTraceHelper mLTH) throws Exception {
        boolean mReturn = true;
        Result mResult = new Result(1);
        CIMObjectPath mObjPath = mCIMExtent.getObjectPath();
        mLTH.traceInfo("Cache hit for " + this.cInstanceName + " with COP " + mObjPath.toString());
        CIMInstance mCIMPool = (CIMInstance)mProcessProperties.get("CIM_StoragePool");
        if (mCIMPool != null) {
            boolean bIsPrimordial = this.checkPrimoridalPool(mCIMPool);
            if (!bIsPrimordial) {
                // empty if block
            }
            mLTH.traceInfo("persist " + this.cInstanceName + " with COP " + mObjPath.toString());
            mResult = this.persistInstance(mCIMExtent, this.cInstanceName, mProcessProperties, mLTH);
            mReturn = mResult.getRc() == 0 ? this.cCollectVolumesStep.process(pDiscoverRequest, mProcessProperties) : false;
        }
        this.cDiskCIMProcessor.getDBReferences().put(this.cInstanceName, mExtentDBRefs);
        return mReturn;
    }

    protected boolean checkPrimoridalPool(CIMInstance mCIMPool) {
        Hashtable mPoolProperties = DiskCIMProcessor.convertPropertiesToHashtable((Vector)mCIMPool.getAllProperties(), new Hashtable());
        String bPrimordial = (String)mPoolProperties.get("primordial");
        boolean bIsPrimordial = bPrimordial != null && bPrimordial.equalsIgnoreCase("true");
        return bIsPrimordial;
    }

    public void addCollectVolumesStep(IStep pCollectVolumesStep) {
        this.cCollectVolumesStep = pCollectVolumesStep;
    }

    protected boolean processNext(String pDiscoverRequest, Map pParameters) throws Exception {
        CIMInstance mCIMPool;
        boolean mReturn = super.processNext(pDiscoverRequest, pParameters);
        if (mReturn && (mCIMPool = (CIMInstance)pParameters.get("CIM_StoragePool")) != null && !this.checkPrimoridalPool(mCIMPool)) {
            mReturn = this.cCollectVolumesStep.process(pDiscoverRequest, pParameters);
        }
        return mReturn;
    }
}

