/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.CIMManagement;
import org.eclipse.aperi.disk.common.CIM.PrivilegeManagement;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DBHelperCreateAndUpdate;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.IDGenerator;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationResultHelper;
import org.eclipse.aperi.disk.control.util.PrivilegeToWWPNs;
import org.eclipse.aperi.disk.control.util.ProtocolControllerToPrivileges;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt16;

public class MappingManagement
extends CIMManagement {
    private CIMObjectPath cControllerConfigurationService = null;
    protected CapabilityData cCapablities;
    private HashMap cFCPortsOfProtocolController = new HashMap();
    private HashMap cDeviceNumbersOfProtocolController = new HashMap();

    public MappingManagement(StorageConfigurationPlugin pPlugin, CIMClientWrapper pCIMClient, CIMObjectPath pStorageSystem, CapabilityData pCapablities, String pStorageSystemID, Token pToken) {
        super(pPlugin, pCIMClient, pStorageSystem, pStorageSystemID, pToken);
        this.cCapablities = pCapablities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CIMObjectPath retrieveAssociatedControllerConfigurationService() throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveAssociatedControllerConfigurationService", null);
        try {
            this.cControllerConfigurationService = this.retrieveAssociatedService("CIM_ControllerConfigurationService", "CIM_HostedService", "Antecedent", "Dependent");
        }
        finally {
            mLTH.exit((Object)this.cControllerConfigurationService);
        }
        return this.cControllerConfigurationService;
    }

    public String[] getDeviceNumbers(CIMObjectPath pProtocolController, CIMObjectPath[] pVolumeCOPs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getDeviceNumbers", (Object[])new Object[]{pProtocolController, pVolumeCOPs});
        String[] mDeviceNumbers = new String[pVolumeCOPs.length];
        HashMap<CIMObjectPath, String> mDeviceNumbersHash = new HashMap<CIMObjectPath, String>();
        try {
            int i;
            Enumeration mProtocolControllerForUnit = this.cCimClient.references(pProtocolController, "CIM_ProtocolControllerForUnit", null, true, true, null, mLTH);
            while (mProtocolControllerForUnit.hasMoreElements()) {
                CIMInstance bProtocolControllerForUnit = (CIMInstance)mProtocolControllerForUnit.nextElement();
                CIMObjectPath bCurrentVolumeCOP = (CIMObjectPath)CIMInstanceHelper.getCIMProperyValue((CIMInstance)bProtocolControllerForUnit, (String)"Dependent");
                for (i = 0; i < pVolumeCOPs.length; ++i) {
                    if (!bCurrentVolumeCOP.equals((Object)pVolumeCOPs[i])) continue;
                    String bDeviceNumber = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)bProtocolControllerForUnit, (String)"DeviceNumber");
                    mDeviceNumbersHash.put(pVolumeCOPs[i], bDeviceNumber);
                }
            }
            if (mDeviceNumbersHash.size() != pVolumeCOPs.length) {
                ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021529E", (Object)this.cCimClient.toString(), (LogTraceHelper)mLTH);
                mLTH.traceError("CIMOM did not return a ProtocolControllerForUnit for each volume", (Throwable)bEx);
                String[] stringArray = mDeviceNumbers;
                return stringArray;
            }
            for (i = 0; i < pVolumeCOPs.length; ++i) {
                mDeviceNumbers[i] = (String)mDeviceNumbersHash.get(pVolumeCOPs[i]);
            }
        }
        catch (CIMException e) {
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"references", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit((Object)mDeviceNumbers);
        }
        return mDeviceNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList retrieveProtocolControllersForStorageHardwareIDs(ArrayList pStorageHardwareIDs, ArrayList pStorageHardwareIDsWithoutProtocolController) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveProtocolControllersForStorageHardwareIDs", (Object[])new Object[]{pStorageHardwareIDs, pStorageHardwareIDsWithoutProtocolController});
        ArrayList mProtocolControllers = null;
        try {
            PrivilegeManagement mPrivilegeManagement = this.cPlugin.getPrivilegeManagement();
            ArrayList bPrivileges = mPrivilegeManagement.retrievePrivilegesForInitiators(pStorageHardwareIDs, pStorageHardwareIDsWithoutProtocolController);
            ArrayList mPrivilegesWithoutPC = null;
            if (pStorageHardwareIDsWithoutProtocolController != null) {
                mPrivilegesWithoutPC = new ArrayList();
            }
            mProtocolControllers = this.retrieveProtocolControllersForPrivileges(bPrivileges, mPrivilegesWithoutPC);
            if (mPrivilegesWithoutPC != null && !mPrivilegesWithoutPC.isEmpty()) {
                for (int i = 0; i < mPrivilegesWithoutPC.size(); ++i) {
                    PrivilegeToWWPNs bPrivToWWPN = (PrivilegeToWWPNs)mPrivilegesWithoutPC.get(i);
                    ArrayList bStorageHardwareIDs = bPrivToWWPN.getStorageHardwareIDs();
                    pStorageHardwareIDsWithoutProtocolController.addAll(bStorageHardwareIDs);
                }
            }
        }
        catch (Throwable throwable) {
            mLTH.exit(mProtocolControllers);
            throw throwable;
        }
        mLTH.exit((Object)mProtocolControllers);
        return mProtocolControllers;
    }

    public ArrayList retrieveProtocolControllersForPrivileges(ArrayList pPrivilegeToWWPNs, ArrayList pPrivilegeToWWPNsWithoutProtocolController) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveProtocolControllersForPrivileges", (Object[])new Object[]{pPrivilegeToWWPNs, pPrivilegeToWWPNsWithoutProtocolController});
        ArrayList<ProtocolControllerToPrivileges> mAssociatedProtocolControllers = new ArrayList<ProtocolControllerToPrivileges>();
        try {
            for (int i = 0; i < pPrivilegeToWWPNs.size(); ++i) {
                ProtocolControllerToPrivileges mPCToPriv;
                PrivilegeToWWPNs mPrivilegeToWWPNs = (PrivilegeToWWPNs)pPrivilegeToWWPNs.get(i);
                boolean bFound = false;
                for (int j = 0; j < mAssociatedProtocolControllers.size(); ++j) {
                    mPCToPriv = (ProtocolControllerToPrivileges)mAssociatedProtocolControllers.get(j);
                    bFound = mPCToPriv.containsPrivilege(mPrivilegeToWWPNs);
                }
                if (bFound) continue;
                Enumeration mProtocolControllers = this.cCimClient.associatorNames(mPrivilegeToWWPNs.getPrivilege(), null, "CIM_SCSIProtocolController", "Privilege", "TargetElement", this.cLogTraceHelper);
                if (!mProtocolControllers.hasMoreElements()) {
                    if (pPrivilegeToWWPNsWithoutProtocolController == null) {
                        ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021614E", (Object)mPrivilegeToWWPNs.getWWPNs(), (Object)this.cPlugin.getParams().getStorageSubsystemID(), (LogTraceHelper)mLTH);
                        mLTH.traceError("Privilege has no ProtocolController assigned, its StorageHardwareIDs have no mappings", (Throwable)bEx);
                        throw bEx;
                    }
                    pPrivilegeToWWPNsWithoutProtocolController.add(pPrivilegeToWWPNs.get(i));
                    continue;
                }
                while (mProtocolControllers.hasMoreElements()) {
                    CIMObjectPath bProtocolController = (CIMObjectPath)mProtocolControllers.nextElement();
                    if (this.validateProtocolController(bProtocolController) == null) continue;
                    if (((AssignmentParameter)this.cPlugin.getParams()).getCapability().getOneHwIdPerView() != 1) {
                        ArrayList bPrivilegesOfPC = this.cPlugin.getPrivilegeManagement().retrievePrivilegesForProtocolController(bProtocolController, pPrivilegeToWWPNs);
                        mPCToPriv = new ProtocolControllerToPrivileges(bProtocolController, bPrivilegesOfPC);
                        mAssociatedProtocolControllers.add(mPCToPriv);
                        continue;
                    }
                    mPCToPriv = new ProtocolControllerToPrivileges(bProtocolController, (PrivilegeToWWPNs)pPrivilegeToWWPNs.get(i));
                    mAssociatedProtocolControllers.add(mPCToPriv);
                }
            }
        }
        catch (CIMException e) {
            e.printStackTrace();
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mAssociatedProtocolControllers);
        }
        return mAssociatedProtocolControllers;
    }

    public ArrayList retrieveProtocolControllersForVolumes(CIMObjectPath[] pVolumeCOPs, ArrayList pVolumesWithoutProtocolController) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveProtocolControllersForVolumes", (Object[])new Object[]{pVolumeCOPs, pVolumesWithoutProtocolController});
        ArrayList<ProtocolControllerToPrivileges> mAssociatedPCs = new ArrayList<ProtocolControllerToPrivileges>();
        try {
            if (pVolumeCOPs == null) {
                ArrayList<ProtocolControllerToPrivileges> arrayList = mAssociatedPCs;
                return arrayList;
            }
            for (int i = 0; i < pVolumeCOPs.length; ++i) {
                Enumeration mPCs = this.cCimClient.associatorNames(pVolumeCOPs[i], "CIM_ProtocolControllerForUnit", "CIM_ProtocolController", "Dependent", "Antecedent", this.cLogTraceHelper);
                if (!mPCs.hasMoreElements()) {
                    if (pVolumesWithoutProtocolController == null) {
                        ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021529E", (Object)this.cCimClient.toString(), (LogTraceHelper)mLTH);
                        mLTH.traceError("Volume has no ProtocolControllers. Volume COP: " + pVolumeCOPs[i], (Throwable)bEx);
                        throw bEx;
                    }
                    pVolumesWithoutProtocolController.add(pVolumeCOPs[i]);
                    continue;
                }
                while (mPCs.hasMoreElements()) {
                    CIMObjectPath mPC = (CIMObjectPath)mPCs.nextElement();
                    if (this.validateProtocolController(mPC) == null || mAssociatedPCs.contains(new ProtocolControllerToPrivileges(mPC))) continue;
                    mAssociatedPCs.add(new ProtocolControllerToPrivileges(mPC));
                }
            }
        }
        catch (CIMException e) {
            e.printStackTrace();
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mAssociatedPCs);
        }
        return mAssociatedPCs;
    }

    public ArrayList retrieveFCPortsOfProtocolController(CIMObjectPath pProtocolController) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveFCPortsOfProtocolController", (Object[])new Object[]{pProtocolController});
        ArrayList<CIMInstance> mFCPorts = new ArrayList<CIMInstance>();
        try {
            Enumeration mFCPortEnum = this.cCimClient.associators(pProtocolController, "CIM_ProtocolControllerForPort", "CIM_FCPort", "Antecedent", "Dependent", true, true, null, this.cLogTraceHelper);
            while (mFCPortEnum.hasMoreElements()) {
                CIMInstance bFCPort = (CIMInstance)mFCPortEnum.nextElement();
                mFCPorts.add(bFCPort);
            }
        }
        catch (CIMException e) {
            e.printStackTrace();
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associators", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mFCPorts);
        }
        return mFCPorts;
    }

    public ArrayList retrieveProtocolControllerForUnit(CIMObjectPath pProtocolController) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveProtocolControllerForUnit", (Object[])new Object[]{pProtocolController});
        ArrayList<CIMInstance> mProtocolControllerForUnit = new ArrayList<CIMInstance>();
        try {
            Enumeration mProtocolControllerForUnitEnum = this.cCimClient.references(pProtocolController, "CIM_ProtocolControllerForUnit", "Antecedent", true, true, null, this.cLogTraceHelper);
            while (mProtocolControllerForUnitEnum.hasMoreElements()) {
                CIMInstance bProtocolControllerForUnit = (CIMInstance)mProtocolControllerForUnitEnum.nextElement();
                mProtocolControllerForUnit.add(bProtocolControllerForUnit);
            }
        }
        catch (CIMException e) {
            e.printStackTrace();
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associators", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mProtocolControllerForUnit);
        }
        return mProtocolControllerForUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMObjectPath[] exposePaths(CapabilityData pCapablities, CIMObjectPath pProtocolController, String[] pLUNames, String[] pInitiatorWWPNs, String[] pTargetPorts, String[] pDeviceNumers) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"exposePaths", (Object[])new Object[]{pProtocolController, pLUNames, pInitiatorWWPNs, pTargetPorts, pDeviceNumers});
        CIMObjectPath[] mCreatedPCs = new CIMObjectPath[1];
        Vector<CIMArgument> mInParams = new Vector<CIMArgument>();
        Vector mOutParams = new Vector();
        try {
            int i;
            if (pLUNames != null) {
                mInParams.add(new CIMArgument("LUNames", new CIMValue((Object)pLUNames, CIMDataType.getPredefinedType((int)24))));
            }
            if (pInitiatorWWPNs != null) {
                mInParams.add(new CIMArgument("InitiatorPortIDs", new CIMValue((Object)pInitiatorWWPNs, CIMDataType.getPredefinedType((int)24))));
            }
            UnsignedInt16[] bDeviceAccesses = new UnsignedInt16[]{new UnsignedInt16(2)};
            if (pLUNames != null) {
                bDeviceAccesses = new UnsignedInt16[pLUNames.length];
                for (i = 0; i < bDeviceAccesses.length; ++i) {
                    bDeviceAccesses[i] = new UnsignedInt16(2);
                }
                mInParams.add(new CIMArgument("DeviceAccesses", new CIMValue((Object)bDeviceAccesses, CIMDataType.getPredefinedType((int)18))));
            }
            if (pProtocolController != null) {
                mInParams.add(new CIMArgument("ProtocolControllers", new CIMValue((Object)new CIMObjectPath[]{pProtocolController}, CIMDataType.getPredefinedType((int)30))));
            }
            if (pCapablities.getPortsPerView() != 4 && pTargetPorts != null) {
                mInParams.add(new CIMArgument("TargetPortIDs", new CIMValue((Object)pTargetPorts, CIMDataType.getPredefinedType((int)24))));
            }
            if (pDeviceNumers != null) {
                for (i = 0; i < pDeviceNumers.length; ++i) {
                    if (pDeviceNumers[i] != null) continue;
                    pDeviceNumers = null;
                    break;
                }
                if (pDeviceNumers != null) {
                    mInParams.add(new CIMArgument("DeviceNumbers", new CIMValue((Object)pDeviceNumers, CIMDataType.getPredefinedType((int)24))));
                }
            }
            this.invokeAsyncCIMMethod(this.getControllerConfigurationService(), "ExposePaths", mInParams, mOutParams, "ProtocolControllers", "CIM_ProtocolController", new Vector());
            for (int j = 0; j < mOutParams.size(); ++j) {
                CIMArgument bOut = (CIMArgument)mOutParams.get(j);
                if (bOut.getName().compareTo("ProtocolControllers") == 0) {
                    mCreatedPCs[0] = (CIMObjectPath)((Vector)bOut.getValue().getValue()).elementAt(0);
                }
                if (bOut.getName().compareTo("ProtocolController") != 0) continue;
                mCreatedPCs[0] = (CIMObjectPath)bOut.getValue().getValue();
            }
        }
        finally {
            mLTH.exit((Object)mCreatedPCs);
        }
        return mCreatedPCs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMObjectPath[] hidePaths(CIMObjectPath[] pProtocolControllers, CapabilityData pCapablities, String[] pLUNames, String[] pInitiatorWWPNs, String[] pTargetPorts) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"hidePaths", (Object[])new Object[]{pProtocolControllers, pCapablities, pLUNames, pInitiatorWWPNs, pTargetPorts});
        CIMObjectPath[] mModifiedPCs = new CIMObjectPath[1];
        Vector<CIMArgument> mInParams = new Vector<CIMArgument>();
        Vector mOutParams = new Vector();
        try {
            if (pInitiatorWWPNs != null && pInitiatorWWPNs.length != 0) {
                mInParams.add(new CIMArgument("InitiatorPortIDs", new CIMValue((Object)pInitiatorWWPNs, CIMDataType.getPredefinedType((int)24))));
                mInParams.add(new CIMArgument("ProtocolControllers", new CIMValue((Object)pProtocolControllers, CIMDataType.getPredefinedType((int)30))));
                this.invokeAsyncCIMMethod(this.getControllerConfigurationService(), "HidePaths", mInParams, mOutParams, "ProtocolControllers", "CIM_ProtocolController", new Vector());
            }
            if (pLUNames != null && pLUNames.length != 0) {
                mInParams.clear();
                mOutParams.clear();
                mInParams.add(new CIMArgument("LUNames", new CIMValue((Object)pLUNames, CIMDataType.getPredefinedType((int)24))));
                mInParams.add(new CIMArgument("ProtocolControllers", new CIMValue((Object)pProtocolControllers, CIMDataType.getPredefinedType((int)30))));
                this.invokeAsyncCIMMethod(this.getControllerConfigurationService(), "HidePaths", mInParams, mOutParams, "ProtocolControllers", "CIM_ProtocolController", new Vector());
            }
            if (!(pInitiatorWWPNs != null && pInitiatorWWPNs.length != 0 || pLUNames != null && pLUNames.length != 0)) {
                mInParams.add(new CIMArgument("TargetPortIDs", new CIMValue((Object)pTargetPorts, CIMDataType.getPredefinedType((int)24))));
                mInParams.add(new CIMArgument("ProtocolControllers", new CIMValue((Object)pProtocolControllers, CIMDataType.getPredefinedType((int)30))));
                this.invokeAsyncCIMMethod(this.getControllerConfigurationService(), "HidePaths", mInParams, mOutParams, "ProtocolControllers", "CIM_ProtocolController", new Vector());
            }
            for (int j = 0; j < mOutParams.size(); ++j) {
                CIMArgument bOut = (CIMArgument)mOutParams.get(j);
                if (bOut.getName().compareTo("ProtocolControllers") != 0 || bOut.getValue() == null) continue;
                Vector bPCs = (Vector)bOut.getValue().getValue();
                for (int i = 0; i < bPCs.size(); ++i) {
                    mModifiedPCs[0] = (CIMObjectPath)bPCs.elementAt(i);
                }
            }
        }
        finally {
            mLTH.exit((Object)mModifiedPCs);
        }
        return mModifiedPCs;
    }

    public ArrayList attachDevices(ProtocolControllerToPrivileges pProtocolController, CIMObjectPath[] pVolumeCOPs, String[] pVolumeIDs, String[] pDeviceNumbers, AssignStorageVolumesParameter pParams) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"attachDevices", (Object[])new Object[]{pProtocolController, pVolumeCOPs, pVolumeIDs, pDeviceNumbers});
        ArrayList mNewVolumeAssignments = new ArrayList();
        String[] mDeviceNumbers = new String[pVolumeCOPs.length];
        String[] mFCPortWWPNs = null;
        int bCurrentVolumes = 0;
        try {
            mFCPortWWPNs = this.getFCPortWWPNs(pProtocolController.getProtocolController());
            for (bCurrentVolumes = 0; bCurrentVolumes < pVolumeCOPs.length; ++bCurrentVolumes) {
                Vector<CIMArgument> mInParams = new Vector<CIMArgument>();
                Vector mOutParams = new Vector();
                mInParams.add(new CIMArgument("ProtocolController", new CIMValue((Object)pProtocolController.getProtocolController(), CIMDataType.getPredefinedType((int)14))));
                mInParams.add(new CIMArgument("Device", new CIMValue((Object)pVolumeCOPs[bCurrentVolumes], CIMDataType.getPredefinedType((int)14))));
                if (this.cCapablities.getClntSelctblDevno() == 1 && pDeviceNumbers != null) {
                    mInParams.add(new CIMArgument("DeviceNumber", new CIMValue((Object)pDeviceNumbers[bCurrentVolumes], CIMDataType.getPredefinedType((int)8))));
                }
                this.invokeCIMMethod(this.getControllerConfigurationService(), "AttachDevice", mInParams, mOutParams);
                for (int j = 0; j < mOutParams.size(); ++j) {
                    CIMArgument bOut = (CIMArgument)mOutParams.get(j);
                    if (bOut.getName().compareTo("DeviceNumber") != 0) continue;
                    mDeviceNumbers[bCurrentVolumes] = (String)bOut.getValue().getValue();
                }
            }
            mNewVolumeAssignments.addAll(ConfigurationResultHelper.createMappingResults(pProtocolController.getPrivilegeToWWPNs(), pVolumeIDs, mDeviceNumbers, mFCPortWWPNs, pProtocolController.getProtocolController(), this.cToken));
            pParams.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)pParams.getAsyncResult(), mNewVolumeAssignments, (String)pParams.getAPIMethodName()));
        }
        catch (ServerException e) {
            mLTH.traceError("Internal error: ServerException", (Throwable)e);
            if (bCurrentVolumes != 0) {
                ConfigurationResultHelper.processPartialMappingFailure(pProtocolController, pParams, mNewVolumeAssignments, bCurrentVolumes - 1, pVolumeIDs, pDeviceNumbers, mFCPortWWPNs, e, this.cToken);
            }
            throw e;
        }
        finally {
            mLTH.exit(mNewVolumeAssignments);
        }
        return mNewVolumeAssignments;
    }

    public ArrayList detachDevices(ProtocolControllerToPrivileges pProtocolController, CIMObjectPath[] pVolumeCOPs, String[] pVolumeIDs, AssignmentParameter pParams) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"detachDevices", (Object[])new Object[]{pProtocolController, pVolumeCOPs, pVolumeIDs, pParams});
        ArrayList mNewVolumeAssignments = new ArrayList();
        int bCurrentVolumes = 0;
        try {
            for (bCurrentVolumes = 0; bCurrentVolumes < pVolumeCOPs.length; ++bCurrentVolumes) {
                Vector<CIMArgument> bInParams = new Vector<CIMArgument>();
                Vector bOutParams = new Vector();
                bInParams.add(new CIMArgument("ProtocolController", new CIMValue((Object)pProtocolController.getProtocolController(), CIMDataType.getPredefinedType((int)14))));
                bInParams.add(new CIMArgument("Device", new CIMValue((Object)pVolumeCOPs[bCurrentVolumes], CIMDataType.getPredefinedType((int)14))));
                this.invokeCIMMethod(this.getControllerConfigurationService(), "DetachDevice", bInParams, bOutParams);
            }
            mNewVolumeAssignments.addAll(ConfigurationResultHelper.createUnMappingResults(pProtocolController.getPrivilegeToWWPNs(), pVolumeIDs, this.cToken));
            pParams.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)pParams.getAsyncResult(), mNewVolumeAssignments, (String)pParams.getAPIMethodName()));
        }
        catch (ServerException e) {
            mLTH.traceError("Internal error: ServerException", (Throwable)e);
            ConfigurationResultHelper.processPartialUnmaskingFailure(pProtocolController.getPrivilegeToWWPNs(), pParams, mNewVolumeAssignments, bCurrentVolumes - 1, pVolumeIDs, e, this.cToken);
            throw e;
        }
        finally {
            mLTH.exit(mNewVolumeAssignments);
        }
        return mNewVolumeAssignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMObjectPath createProtocolControllerWithPorts(AssignStorageVolumesParameter pParams, CIMObjectPath pInitiator, CIMObjectPath pPrivilege) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createProtocolControllerWithPorts", (Object[])new Object[]{pParams, pInitiator, pPrivilege});
        CIMObjectPath mProtocolController = null;
        Vector<CIMArgument> mInParams = new Vector<CIMArgument>();
        Vector mOutParams = new Vector();
        try {
            mInParams.add(new CIMArgument("ElementName", new CIMValue((Object)IDGenerator.generateUniqueNumericString((int)-1), CIMDataType.getPredefinedType((int)8))));
            mInParams.add(new CIMArgument("Protocol", new CIMValue((Object)new UnsignedInt16(2), CIMDataType.getPredefinedType((int)2))));
            if (this.cCapablities.getPortsPerView() != 4 && pParams.getTargetPortCOPs() != null && pParams.getTargetPortCOPs().length != 0) {
                String[] bFCPorts = this.putCOPsIntoString(pParams.getTargetPortCOPs());
                mInParams.add(new CIMArgument("Ports", new CIMValue((Object)bFCPorts, CIMDataType.getPredefinedType((int)24))));
            }
            if (pParams.getCapability().getControllerReqIdentity() == 1) {
                mInParams.add(new CIMArgument("Identity", new CIMValue((Object)pInitiator, CIMDataType.getPredefinedType((int)14))));
                if (pPrivilege != null) {
                    mInParams.add(new CIMArgument("Privilege", new CIMValue((Object)pPrivilege, CIMDataType.getPredefinedType((int)14))));
                }
            }
            this.invokeCIMMethod(this.getControllerConfigurationService(), "CreateProtocolControllerWithPorts", mInParams, mOutParams);
            for (int i = 0; i < mOutParams.size(); ++i) {
                CIMArgument bOut = (CIMArgument)mOutParams.get(i);
                if (bOut.getName().compareTo("ProtocolController") != 0) continue;
                mProtocolController = (CIMObjectPath)bOut.getValue().getValue();
            }
        }
        finally {
            mLTH.exit(mProtocolController);
        }
        return mProtocolController;
    }

    protected String[] putCOPsIntoString(CIMObjectPath[] pCOPs) {
        String[] bCOPStrings = new String[pCOPs.length];
        for (int i = 0; i < bCOPStrings.length; ++i) {
            bCOPStrings[i] = pCOPs[i].toString();
        }
        return bCOPStrings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList deleteProtocolController(ProtocolControllerToPrivileges pProtocolController, String[] pVolumeIDs, AssignmentParameter pParams) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"deleteProtocolController", (Object[])new Object[]{pProtocolController});
        ArrayList mNewVolumeAssignments = new ArrayList();
        try {
            Vector<CIMArgument> bInParams = new Vector<CIMArgument>();
            Vector bOutParams = new Vector();
            bInParams.add(new CIMArgument("DeleteChildrenProtocolControllers", new CIMValue((Object)new Boolean(false), CIMDataType.getPredefinedType((int)9))));
            bInParams.add(new CIMArgument("DeleteLogicalUnits", new CIMValue((Object)new Boolean(false), CIMDataType.getPredefinedType((int)9))));
            bInParams.add(new CIMArgument("ProtocolController", new CIMValue((Object)pProtocolController.getProtocolController(), CIMDataType.getPredefinedType((int)14))));
            this.invokeCIMMethod(this.getControllerConfigurationService(), "DeleteProtocolController", bInParams, bOutParams);
            mNewVolumeAssignments.addAll(ConfigurationResultHelper.createUnMappingResults(pProtocolController.getPrivilegeToWWPNs(), pParams.getVolumeIDs(), this.cToken));
            pParams.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)pParams.getAsyncResult(), mNewVolumeAssignments, (String)pParams.getAPIMethodName()));
        }
        finally {
            mLTH.exit(mNewVolumeAssignments);
        }
        return mNewVolumeAssignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList retrieveProtocolControllersForMappings(ArrayList pStorageHardwareIDs, ArrayList pStorageHardwareIDsWithoutProtocolController, CIMObjectPath[] pVolumeCOPs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveProtocolControllersForMappings", (Object[])new Object[]{pStorageHardwareIDs, pStorageHardwareIDsWithoutProtocolController, pVolumeCOPs});
        ArrayList mProtocolControllers = null;
        try {
            mProtocolControllers = this.retrieveProtocolControllersForStorageHardwareIDs(pStorageHardwareIDs, pStorageHardwareIDsWithoutProtocolController);
        }
        finally {
            mLTH.exit((Object)mProtocolControllers);
        }
        return mProtocolControllers;
    }

    public ArrayList retrieveProtocolControllersForUnmapping(ArrayList pStorageHardwareIDs, CIMObjectPath[] pVolumeCOPs) throws ServerException {
        return this.retrieveProtocolControllersForMappings(pStorageHardwareIDs, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolControllerToPrivileges[] createProtocolControllers(ArrayList pStorageHardwareIDs, ConfigurationParameter pParams) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createProtocolControllers", (Object[])new Object[]{pStorageHardwareIDs, pParams});
        ProtocolControllerToPrivileges[] mProtocolControllers = new ProtocolControllerToPrivileges[pStorageHardwareIDs.size()];
        try {
            if (pStorageHardwareIDs.size() != 0) {
                CIMObjectPath bPrivilege = null;
                if (((AssignmentParameter)this.cPlugin.getParams()).getCapability().getControllerReqIdentity() == 1) {
                    bPrivilege = this.cPlugin.getPrivilegeManagement().getPrivilege();
                }
                for (int i = 0; i < pStorageHardwareIDs.size(); ++i) {
                    CIMObjectPath bProtocolControllerCOP = this.createProtocolControllerWithPorts((AssignStorageVolumesParameter)pParams, ((StorageHardwareID)pStorageHardwareIDs.get(i)).getStorageHardwareIDCOP(), bPrivilege);
                    mProtocolControllers[i] = new ProtocolControllerToPrivileges(bProtocolControllerCOP, new PrivilegeToWWPNs(null, (StorageHardwareID)pStorageHardwareIDs.get(i)));
                }
            }
        }
        finally {
            mLTH.exit((Object)mProtocolControllers);
        }
        return mProtocolControllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getProtocolControllersForMappings(ArrayList pStorageHardwareIDs, ArrayList pNewStorageHardwareIDs, AssignStorageVolumesParameter pParams) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getProtocolControllersForMappings", (Object[])new Object[]{pStorageHardwareIDs, pNewStorageHardwareIDs, pParams});
        ArrayList mExistingProtocolControllers = null;
        try {
            ArrayList mOldStorageHardwareIDs = (ArrayList)pStorageHardwareIDs.clone();
            ArrayList<StorageHardwareID> mNewStorageHardwareIDs = new ArrayList<StorageHardwareID>();
            if (!pNewStorageHardwareIDs.isEmpty()) {
                for (int i = 0; i < pNewStorageHardwareIDs.size(); ++i) {
                    StorageHardwareID mSHID = (StorageHardwareID)pNewStorageHardwareIDs.get(i);
                    mNewStorageHardwareIDs.add(mSHID);
                    mOldStorageHardwareIDs.remove(mSHID);
                }
            }
            ArrayList<StorageHardwareID> mStorageHardwareIDsWithoutPCs = new ArrayList<StorageHardwareID>();
            mExistingProtocolControllers = this.retrieveProtocolControllersForMappings(mOldStorageHardwareIDs, mStorageHardwareIDsWithoutPCs, pParams.getVolumeCOPs());
            mStorageHardwareIDsWithoutPCs.addAll(mNewStorageHardwareIDs);
            ProtocolControllerToPrivileges[] mNewProtocolControllers = this.createProtocolControllers(mStorageHardwareIDsWithoutPCs, pParams);
            for (int i = 0; i < mNewProtocolControllers.length; ++i) {
                mExistingProtocolControllers.add(mNewProtocolControllers[i]);
            }
        }
        catch (Throwable throwable) {
            mLTH.exit(mExistingProtocolControllers);
            throw throwable;
        }
        mLTH.exit((Object)mExistingProtocolControllers);
        return mExistingProtocolControllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmapVolumesFromPorts(ArrayList pProtocolControllers, AssignmentParameter pParams, ArrayList pStorageHardwareIDs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"unmapVolumesFromPorts", (Object[])new Object[]{pProtocolControllers, pParams, pStorageHardwareIDs});
        try {
            this.deleteMappings(pProtocolControllers, pParams, pStorageHardwareIDs);
        }
        finally {
            DBHelperCreateAndUpdate mDBHelper = new DBHelperCreateAndUpdate(this.cToken);
            mDBHelper.deleteMappings(pParams.getAsyncResult(), pParams);
            mDBHelper.close();
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList deleteMappings(ArrayList pProtocolControllers, AssignmentParameter pParams, ArrayList pStorageHardwareIDs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"deleteMappings", (Object[])new Object[]{pProtocolControllers, pParams, pStorageHardwareIDs});
        ArrayList<ArrayList> mNewVolumeAssignments = new ArrayList<ArrayList>();
        int h = 0;
        try {
            for (h = 0; h < pProtocolControllers.size(); ++h) {
                ProtocolControllerToPrivileges bProtocolController = (ProtocolControllerToPrivileges)pProtocolControllers.get(h);
                ArrayList bAllVolumesOfPC = this.cPlugin.getVolumeManagement().retrieveVolumesOfProtocolController(bProtocolController.getProtocolController());
                CIMObjectPath[] volumesToUnmap = this.checkVolumesOfPC(pParams.getVolumeCOPs(), bAllVolumesOfPC);
                String[] bVolumeKeys = pParams.getVolumeIDsForCOPs(volumesToUnmap);
                if (bAllVolumesOfPC.size() == volumesToUnmap.length) {
                    mNewVolumeAssignments.add(this.deleteProtocolController(bProtocolController, bVolumeKeys, pParams));
                    continue;
                }
                mNewVolumeAssignments.add(this.detachDevices(bProtocolController, volumesToUnmap, bVolumeKeys, pParams));
            }
        }
        finally {
            mLTH.exit(mNewVolumeAssignments);
        }
        return mNewVolumeAssignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapVolumesToPorts(ArrayList pProtocolControllers, AssignStorageVolumesParameter pParams) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"mapVolumesToPorts", (Object[])new Object[]{pProtocolControllers, pParams});
        try {
            ArrayList mNewVolumeAssignments = this.createMapping(pProtocolControllers, pParams);
        }
        finally {
            DBHelperCreateAndUpdate mDBHelper = new DBHelperCreateAndUpdate(this.cToken);
            mDBHelper.createMappings(pParams.getAsyncResult(), pParams);
            mDBHelper.close();
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList createMapping(ArrayList pProtocolControllerToPrivileges, AssignStorageVolumesParameter pParams) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createMapping", (Object[])new Object[]{pProtocolControllerToPrivileges, pParams});
        ArrayList mNewVolumeAssignments = new ArrayList();
        int i = 0;
        try {
            for (i = 0; i < pProtocolControllerToPrivileges.size(); ++i) {
                ProtocolControllerToPrivileges bProtocolController = (ProtocolControllerToPrivileges)pProtocolControllerToPrivileges.get(i);
                mNewVolumeAssignments = this.attachDevices(bProtocolController, pParams.getVolumeCOPs(), pParams.getVolumeIDs(), pParams.getDeviceNumbers(), pParams);
            }
        }
        finally {
            mLTH.exit(mNewVolumeAssignments);
        }
        return mNewVolumeAssignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createMappingExposePathsWithoutProtocolController(AssignStorageVolumesParameter pParams, ArrayList pNewVolumeAssignments, ArrayList pWWPNsWithPC) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createMappingExposePathsWithoutProtocolController", (Object[])new Object[]{pParams, pNewVolumeAssignments, pWWPNsWithPC});
        try {
            ArrayList<String> mWWPNsWithoutPC = new ArrayList<String>();
            for (int i = 0; i < pParams.getInitiatorWWPNsArray().length; ++i) {
                if (pWWPNsWithPC.contains(pParams.getInitiatorWWPNsArray()[i])) continue;
                mWWPNsWithoutPC.add(pParams.getInitiatorWWPNsArray()[i]);
            }
            if (mWWPNsWithoutPC.size() != 0) {
                CIMObjectPath[] mCreatedPCs = this.exposePaths(pParams.getCapability(), null, pParams.getVolumeNames(), pParams.getInitiatorWWPNsArray(), pParams.getTargetPortWWPNs(), pParams.getDeviceNumbers());
                for (int i = 0; i < mCreatedPCs.length; ++i) {
                    String[] mDeviceNumbers = this.getDeviceNumbers(mCreatedPCs[i], pParams.getVolumeCOPs());
                    String[] mFCPortWWPNs = this.getFCPortWWPNs(mCreatedPCs[i]);
                    ArrayList bStorageHardwareIds = this.cPlugin.getHardwareIDManagement().retrieveStorageHardwareIDs(mWWPNsWithoutPC, true);
                    pNewVolumeAssignments.addAll(ConfigurationResultHelper.createMappingResultsForStorageHardwareIDs(mFCPortWWPNs, bStorageHardwareIds, pParams.getVolumeIDs(), mDeviceNumbers, pParams, this.cPlugin.getHardwareIDManagement(), mCreatedPCs[i], this.cToken));
                    pParams.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)pParams.getAsyncResult(), (ArrayList)pNewVolumeAssignments, (String)pParams.getAPIMethodName()));
                }
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMObjectPath getControllerConfigurationService() throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getControllerConfigurationService", (Object[])new Object[]{null});
        try {
            if (this.cControllerConfigurationService == null) {
                this.retrieveAssociatedControllerConfigurationService();
            }
        }
        finally {
            mLTH.exit((Object)this.cControllerConfigurationService);
        }
        return this.cControllerConfigurationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFCPortWWPNs(CIMObjectPath pProtocolController) throws ServerException {
        String[] mWWPNs;
        LogTraceHelper mLTH;
        block4: {
            mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getFCPortWWPNs", (Object[])new Object[]{pProtocolController});
            mWWPNs = null;
            mWWPNs = (String[])this.cFCPortsOfProtocolController.get(pProtocolController);
            if (mWWPNs == null || mWWPNs.length <= 0) break block4;
            String[] stringArray = mWWPNs;
            mLTH.exit((Object)mWWPNs);
            return stringArray;
        }
        try {
            ArrayList mFCPorts = this.retrieveFCPortsOfProtocolController(pProtocolController);
            mWWPNs = new String[mFCPorts.size()];
            for (int i = 0; i < mFCPorts.size(); ++i) {
                mWWPNs[i] = (String)((CIMInstance)mFCPorts.get(i)).getProperty("PermanentAddress").getValue().getValue();
            }
            this.cFCPortsOfProtocolController.put(pProtocolController, mWWPNs);
        }
        catch (Throwable throwable) {
            mLTH.exit(mWWPNs);
            throw throwable;
        }
        mLTH.exit((Object)mWWPNs);
        return mWWPNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getDeviceNumbersOfProtocolController(CIMObjectPath pProtocolController) {
        ArrayList<Object> mDeviceNumbers;
        LogTraceHelper mLTH;
        block5: {
            mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getDeviceNumbersOfProtocolController", (Object[])new Object[]{pProtocolController});
            mDeviceNumbers = null;
            mDeviceNumbers = (ArrayList<Object>)this.cDeviceNumbersOfProtocolController.get(pProtocolController);
            if (mDeviceNumbers == null) break block5;
            ArrayList<Object> arrayList = mDeviceNumbers;
            mLTH.exit((Object)mDeviceNumbers);
            return arrayList;
        }
        try {
            ArrayList mProtocolControllerForUnit = this.retrieveProtocolControllerForUnit(pProtocolController);
            mDeviceNumbers = new ArrayList<Object>();
            for (int i = 0; i < mProtocolControllerForUnit.size(); ++i) {
                mDeviceNumbers.add(((CIMInstance)mProtocolControllerForUnit.get(i)).getProperty("DeviceNumber").getValue().getValue());
            }
            this.cDeviceNumbersOfProtocolController.put(pProtocolController, mDeviceNumbers);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            mLTH.exit(mDeviceNumbers);
        }
        return mDeviceNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getDeviceNumbersForVolumesToAttach(AssignStorageVolumesParameter pParams, CIMObjectPath[] pVolumesToAttach) {
        String[] stringArray;
        String[] mLUNs;
        LogTraceHelper mLTH;
        block5: {
            mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getDeviceNumbersForVolumesToAttach", (Object[])new Object[]{pParams, pVolumesToAttach});
            mLUNs = null;
            if (pParams.getDeviceNumbers() != null) break block5;
            String[] stringArray2 = mLUNs = new String[pVolumesToAttach.length];
            mLTH.exit((Object)mLUNs);
            return stringArray2;
        }
        try {
            mLUNs = new String[pVolumesToAttach.length];
            for (int i = 0; i < pVolumesToAttach.length; ++i) {
                for (int j = 0; j < pParams.getVolumeCOPs().length; ++j) {
                    if (!pParams.getVolumeCOPs()[j].equals((Object)pVolumesToAttach[i])) continue;
                    mLUNs[i] = pParams.getDeviceNumbers()[j];
                }
            }
            stringArray = mLUNs;
        }
        catch (Throwable throwable) {
            mLTH.exit(mLUNs);
            throw throwable;
        }
        mLTH.exit((Object)mLUNs);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CIMObjectPath[] checkVolumesOfPC(CIMObjectPath[] pVolumeCOPs, ArrayList pAllVolumesOfPC) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"checkVolumesOfPC", (Object[])new Object[]{pVolumeCOPs, pAllVolumesOfPC});
        try {
            if (pAllVolumesOfPC.size() == pVolumeCOPs.length) {
                for (int i = 0; i < pVolumeCOPs.length; ++i) {
                    if (pAllVolumesOfPC.contains(pVolumeCOPs[i])) continue;
                    ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021617E", (Object)this.cPlugin.getParams().getStorageSubsystemID(), (LogTraceHelper)mLTH);
                    mLTH.traceError("Volumes mapped differ from expected volumes", (Throwable)bEx);
                    throw bEx;
                }
            }
            if (pAllVolumesOfPC.size() < pVolumeCOPs.length) {
                ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021617E", (Object)this.cPlugin.getParams().getStorageSubsystemID(), (LogTraceHelper)mLTH);
                mLTH.traceError("Less Volumes mapped than expected", (Throwable)bEx);
                throw bEx;
            }
            CIMObjectPath[] cIMObjectPathArray = pVolumeCOPs;
            return cIMObjectPathArray;
        }
        finally {
            mLTH.exit((Object)pVolumeCOPs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] checkWWPNsOfPC(String[] pWWPNsToTest, ArrayList pAllWWPNsOfPC) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"checkWWPNsOfPC", (Object[])new Object[]{pWWPNsToTest, pAllWWPNsOfPC});
        try {
            if (pAllWWPNsOfPC.size() == pWWPNsToTest.length) {
                for (int i = 0; i < pWWPNsToTest.length; ++i) {
                    if (pAllWWPNsOfPC.contains(pWWPNsToTest[i])) continue;
                    ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021617E", (Object)this.cPlugin.getParams().getStorageSubsystemID(), (LogTraceHelper)mLTH);
                    mLTH.traceError("Initiator ports mapped differ from expected WWPNs", (Throwable)bEx);
                    throw bEx;
                }
            }
            if (pAllWWPNsOfPC.size() < pWWPNsToTest.length) {
                ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021617E", (Object)this.cPlugin.getParams().getStorageSubsystemID(), (LogTraceHelper)mLTH);
                mLTH.traceError("Less InitiatorPorts mapped than expected", (Throwable)bEx);
                throw bEx;
            }
            String[] stringArray = pWWPNsToTest;
            return stringArray;
        }
        finally {
            mLTH.exit((Object)pWWPNsToTest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkModifiedProtocolControllers(ProtocolControllerToPrivileges pProtocolController, CIMObjectPath[] pModifiedPCs) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"checkModifiedProtocolControllers", (Object[])new Object[]{pProtocolController, pModifiedPCs});
        try {
            if (pModifiedPCs.length != 1 || !pModifiedPCs[0].toString().equals(pProtocolController.getProtocolController().toString())) {
                ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021529E", (Object)this.cCimClient.toString(), (LogTraceHelper)mLTH);
                mLTH.traceError("ExposePaths returned unexpected number of ProtocolControllers. Expected 1, returned: " + pModifiedPCs.length, (Throwable)bEx);
                throw bEx;
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    public CIMObjectPath validateProtocolController(CIMObjectPath mCOP) {
        return mCOP;
    }
}

