/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.ArrayList;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.MappingManagementMultiplePortSMIS11;
import org.eclipse.aperi.disk.common.CIM.PrivilegeManagement;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationResultHelper;
import org.eclipse.aperi.disk.control.util.ProtocolControllerToPrivileges;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.sblim.wbem.cim.CIMObjectPath;

public class MappingManagementFAStT11
extends MappingManagementMultiplePortSMIS11 {
    private static String cLUNUsed = "the logical unit number (LUN) is already in use by the Access Volume";
    private static String cInvalidParam = "INVALID PARAMETER";

    public MappingManagementFAStT11(StorageConfigurationPlugin pPlugin, CIMClientWrapper pCIMClient, CIMObjectPath pStorageSystem, CapabilityData pCapablities, String pStorageSystemID, Token pToken) {
        super(pPlugin, pCIMClient, pStorageSystem, pCapablities, pStorageSystemID, pToken);
    }

    public CIMObjectPath validateProtocolController(CIMObjectPath mCOP) {
        if (this.cPlugin.getParams().getAPIMethodName().equalsIgnoreCase("unassignStorageVolumesFromWWPNs")) {
            return mCOP;
        }
        String mDeviceID = (String)CIMInstanceHelper.getCIMKeyValue((CIMObjectPath)mCOP, (String)"DeviceID");
        if (!mDeviceID.matches("0*")) {
            return mCOP;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList attachDevices(ProtocolControllerToPrivileges pProtocolController, CIMObjectPath[] pVolumeCOPs, String[] pVolumeIDs, String[] pDeviceNumbers, AssignStorageVolumesParameter pParams) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"attachDevices", (Object[])new Object[]{pProtocolController, pVolumeCOPs, pVolumeIDs, pDeviceNumbers});
        ArrayList mNewVolumeAssignments = new ArrayList();
        try {
            if (pVolumeCOPs.length > 0) {
                String[] mFCPortWWPNs = this.getFCPortWWPNs(pProtocolController.getProtocolController());
                String[] mDeviceNumbers = pDeviceNumbers;
                int mRetries = DiskManagerConfigSvc.getIntConfigValue((String)"Configuration.FAStTAssignRetries", (int)2);
                int mDeviceNumberOffset = DiskManagerConfigSvc.getIntConfigValue((String)"Configuration.FAStTAssignDeviceNumberOffset", (int)0);
                boolean mSuccess = false;
                while (!mSuccess) {
                    try {
                        CIMObjectPath[] mModifiedPCs = this.exposePaths(pParams.getCapability(), pProtocolController.getProtocolController(), pParams.getVolumeNamesForCOPs(pVolumeCOPs), null, null, mDeviceNumbers);
                        mSuccess = true;
                        this.checkModifiedProtocolControllers(pProtocolController, mModifiedPCs);
                        String[] mAssignedDeviceNumbers = this.getDeviceNumbers(pProtocolController.getProtocolController(), pParams.getVolumeCOPs());
                        mNewVolumeAssignments.addAll(ConfigurationResultHelper.createMappingResults(pProtocolController.getPrivilegeToWWPNs(), pVolumeIDs, mAssignedDeviceNumbers, mFCPortWWPNs, pProtocolController.getProtocolController(), this.cToken));
                        pParams.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)pParams.getAsyncResult(), mNewVolumeAssignments, (String)pParams.getAPIMethodName()));
                    }
                    catch (ServerException e) {
                        if (mRetries <= 0) {
                            throw e;
                        }
                        mDeviceNumbers = this.setDeviceNumbers(pProtocolController, pVolumeIDs, mDeviceNumberOffset, e);
                        --mRetries;
                        ++mDeviceNumberOffset;
                    }
                }
            }
        }
        finally {
            mLTH.exit(mNewVolumeAssignments);
        }
        return mNewVolumeAssignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList retrieveProtocolControllersForStorageHardwareIDs(ArrayList pStorageHardwareIDs, ArrayList pStorageHardwareIDsWithoutProtocolController) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveProtocolControllersForStorageHardwareIDs", (Object[])new Object[]{pStorageHardwareIDs, pStorageHardwareIDsWithoutProtocolController});
        ArrayList mProtocolControllers = null;
        try {
            int i;
            PrivilegeManagement mPrivilegeManagement = this.cPlugin.getPrivilegeManagement();
            ArrayList bPrivileges = mPrivilegeManagement.retrievePrivilegesForInitiators(pStorageHardwareIDs, pStorageHardwareIDsWithoutProtocolController);
            ArrayList mPrivilegesWithoutPC = new ArrayList();
            boolean mFailIfNotFound = false;
            if (pStorageHardwareIDsWithoutProtocolController == null) {
                mFailIfNotFound = true;
            }
            mProtocolControllers = this.retrieveProtocolControllersForPrivileges(bPrivileges, mPrivilegesWithoutPC);
            ArrayList mWWPNsWithPC = new ArrayList();
            for (i = 0; i < mProtocolControllers.size(); ++i) {
                ProtocolControllerToPrivileges bControllerToPrivileges = (ProtocolControllerToPrivileges)mProtocolControllers.get(i);
                mWWPNsWithPC.addAll(bControllerToPrivileges.getWWPNs());
            }
            for (i = 0; i < pStorageHardwareIDs.size(); ++i) {
                if (mWWPNsWithPC.contains(((StorageHardwareID)pStorageHardwareIDs.get(i)).getWWPN())) continue;
                if (mFailIfNotFound) {
                    ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021614E", (Object)((StorageHardwareID)pStorageHardwareIDs.get(i)).getWWPN(), (Object)this.cPlugin.getParams().getStorageSubsystemID(), (LogTraceHelper)mLTH);
                    throw bEx;
                }
                pStorageHardwareIDsWithoutProtocolController.add(((StorageHardwareID)pStorageHardwareIDs.get(i)).getWWPN());
            }
        }
        catch (Throwable throwable) {
            mLTH.exit(mProtocolControllers);
            throw throwable;
        }
        mLTH.exit((Object)mProtocolControllers);
        return mProtocolControllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createMappingExposePathsWithoutProtocolController(AssignStorageVolumesParameter pParams, ArrayList pNewVolumeAssignments, ArrayList pWWPNsWithPC) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createMappingExposePathsWithoutProtocolController", (Object[])new Object[]{pParams, pNewVolumeAssignments, pWWPNsWithPC});
        try {
            ArrayList<String> mWWPNsWithoutPC = new ArrayList<String>();
            for (int i = 0; i < pParams.getInitiatorWWPNsArray().length; ++i) {
                if (pWWPNsWithPC.contains(pParams.getInitiatorWWPNsArray()[i])) continue;
                mWWPNsWithoutPC.add(pParams.getInitiatorWWPNsArray()[i]);
            }
            if (mWWPNsWithoutPC.size() != 0) {
                int mRetries = DiskManagerConfigSvc.getIntConfigValue((String)"Configuration.FAStTAssignRetries", (int)2);
                int mDeviceNumberOffset = DiskManagerConfigSvc.getIntConfigValue((String)"Configuration.FAStTAssignDeviceNumberOffset", (int)0);
                String[] mDeviceNumbers = pParams.getDeviceNumbers();
                boolean mSuccess = false;
                while (!mSuccess) {
                    try {
                        CIMObjectPath[] mCreatedPCs = this.exposePaths(pParams.getCapability(), null, pParams.getVolumeNames(), pParams.getInitiatorWWPNsArray(), pParams.getTargetPortWWPNs(), mDeviceNumbers);
                        mSuccess = true;
                        for (int i = 0; i < mCreatedPCs.length; ++i) {
                            String[] bDeviceNumbers = this.getDeviceNumbers(mCreatedPCs[i], pParams.getVolumeCOPs());
                            String[] bFCPortWWPNs = this.getFCPortWWPNs(mCreatedPCs[i]);
                            ArrayList bStorageHardwareIds = this.cPlugin.getHardwareIDManagement().retrieveStorageHardwareIDs(mWWPNsWithoutPC, true);
                            pNewVolumeAssignments.addAll(ConfigurationResultHelper.createMappingResultsForStorageHardwareIDs(bFCPortWWPNs, bStorageHardwareIds, pParams.getVolumeIDs(), bDeviceNumbers, pParams, this.cPlugin.getHardwareIDManagement(), mCreatedPCs[i], this.cToken));
                            pParams.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)pParams.getAsyncResult(), (ArrayList)pNewVolumeAssignments, (String)pParams.getAPIMethodName()));
                        }
                    }
                    catch (ServerException e) {
                        if (mRetries <= 0) {
                            throw e;
                        }
                        mDeviceNumbers = this.setDeviceNumbers(null, pParams.getVolumeNames(), mDeviceNumberOffset, e);
                        ++mDeviceNumberOffset;
                        --mRetries;
                    }
                }
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] setDeviceNumbers(ProtocolControllerToPrivileges pProtocolController, String[] pVolumeIDs, int pDeviceNumberOffset, ServerException pException) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"setDeviceNumbers", (Object[])new Object[]{pProtocolController, pVolumeIDs, new Integer(pDeviceNumberOffset), pException});
        String[] mDeviceNumbers = new String[pVolumeIDs.length];
        try {
            if (pException.getSRMMessage().getMsgId() == "HWN021515E" && (pException.getCause().toString().toUpperCase().indexOf(cInvalidParam) != -1 || pException.getCause().toString().toUpperCase().indexOf(cLUNUsed.toUpperCase()) != -1)) {
                ArrayList bExistingDeviceNumbers = new ArrayList();
                if (pProtocolController != null) {
                    bExistingDeviceNumbers = this.getDeviceNumbersOfProtocolController(pProtocolController.getProtocolController());
                }
                int bNumberToTest = 0;
                for (int i = 0; i < mDeviceNumbers.length; ++i) {
                    for (int j = 0; j < 256; ++j) {
                        if (!bExistingDeviceNumbers.contains(Integer.toString(bNumberToTest)) && !bExistingDeviceNumbers.contains(Integer.toString(bNumberToTest + pDeviceNumberOffset))) {
                            mDeviceNumbers[i] = Integer.toString(bNumberToTest + pDeviceNumberOffset);
                            break;
                        }
                        ++bNumberToTest;
                    }
                    if (mDeviceNumbers[i] != null) continue;
                    ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021503E", null, (LogTraceHelper)mLTH);
                    mLTH.traceError("All possible 255 DeviceNumbers are already used", (Throwable)bEx);
                    throw bEx;
                }
            } else {
                throw pException;
            }
            String[] stringArray = mDeviceNumbers;
            return stringArray;
        }
        finally {
            mLTH.exit((Object)mDeviceNumbers);
        }
    }
}

