/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.ArrayList;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.MappingManagement;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.control.util.PrivilegeToWWPNs;
import org.eclipse.aperi.disk.control.util.ProtocolControllerToPrivileges;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.sblim.wbem.cim.CIMObjectPath;

public class MappingManagementMultiplePort
extends MappingManagement {
    protected ArrayList cStorageHardwareIDsWithoutProtocolController;
    protected ArrayList cVolumeCOPsWithoutProtocolController;
    protected boolean cNeedToCreatePC = true;

    public MappingManagementMultiplePort(StorageConfigurationPlugin pPlugin, CIMClientWrapper pCIMClient, CIMObjectPath pStorageSystem, CapabilityData pCapablities, String pStorageSystemID, Token pToken) {
        super(pPlugin, pCIMClient, pStorageSystem, pCapablities, pStorageSystemID, pToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList retrieveProtocolControllersForMappings(ArrayList pStorageHardwareIDs, ArrayList pStorageHardwareIDsWithoutProtocolController, CIMObjectPath[] pVolumeCOPs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveProtocolControllersForMappings", (Object[])new Object[]{pStorageHardwareIDs, pStorageHardwareIDsWithoutProtocolController, pVolumeCOPs});
        ArrayList mPCsOfHardwareIDs = null;
        try {
            mPCsOfHardwareIDs = this.retrieveProtocolControllersForStorageHardwareIDs(pStorageHardwareIDs, pStorageHardwareIDsWithoutProtocolController);
            if (mPCsOfHardwareIDs.size() > 1) {
                String[] mWWPNs = new String[pStorageHardwareIDs.size()];
                for (int i = 0; i < pStorageHardwareIDs.size(); ++i) {
                    mWWPNs[i] = ((StorageHardwareID)pStorageHardwareIDs.get(i)).getWWPN();
                }
                ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021615E", (Object)mWWPNs, (Object)this.cStorageSystemID, (LogTraceHelper)mLTH);
                mLTH.traceError("There are several ProtocolControllers mapped to the HardwareIDs. This will prevent mapping creation for all StorageHardwareIDs" + pStorageHardwareIDs, (Throwable)bEx);
                throw bEx;
            }
            this.cVolumeCOPsWithoutProtocolController = new ArrayList();
            ArrayList mPCsOfVolumes = this.retrieveProtocolControllersForVolumes(pVolumeCOPs, this.cVolumeCOPsWithoutProtocolController);
            if (mPCsOfVolumes.size() > 1) {
                ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021616E", (Object)this.cPlugin.getParams().getVolumeIDsForCOPs(pVolumeCOPs), (Object)this.cStorageSystemID, (LogTraceHelper)mLTH);
                mLTH.traceError("There are several ProtocolControllers mapped to the Volumes. This will prevent mapping creation for all Volumes" + pVolumeCOPs, (Throwable)bEx);
                throw bEx;
            }
            for (int i = 0; i < mPCsOfVolumes.size(); ++i) {
                if (mPCsOfHardwareIDs.contains(mPCsOfVolumes.get(0))) continue;
                mPCsOfHardwareIDs.add(mPCsOfVolumes.get(0));
            }
            if (mPCsOfHardwareIDs.size() > 1) {
                String[] mWWPNs = new String[pStorageHardwareIDs.size()];
                for (int i = 0; i < pStorageHardwareIDs.size(); ++i) {
                    mWWPNs[i] = ((StorageHardwareID)pStorageHardwareIDs.get(i)).getWWPN();
                }
                ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021530E", (Object)this.cPlugin.getParams().getVolumeIDsForCOPs(pVolumeCOPs), (Object)mWWPNs, (LogTraceHelper)mLTH);
                mLTH.traceError("There are different ProtocolControllers mapped to the Volumes and HardwareIDs. The mapping can not be created as specified." + pVolumeCOPs, (Throwable)bEx);
                throw bEx;
            }
            if (mPCsOfHardwareIDs.size() == 1) {
                this.cNeedToCreatePC = false;
            }
        }
        finally {
            mLTH.exit((Object)mPCsOfHardwareIDs);
        }
        return mPCsOfHardwareIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList retrieveProtocolControllersForUnmapping(ArrayList pStorageHardwareIDs, CIMObjectPath[] pVolumeCOPs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveProtocolControllersForUnmapping", (Object[])new Object[]{pStorageHardwareIDs, pVolumeCOPs});
        ArrayList mMappingPCs = new ArrayList();
        try {
            ArrayList mPCsOfHardwareIDs = this.retrieveProtocolControllersForStorageHardwareIDs(pStorageHardwareIDs, null);
            for (int h = 0; h < pVolumeCOPs.length; ++h) {
                ArrayList mPCsOfVolumes = this.retrieveProtocolControllersForVolumes(new CIMObjectPath[]{pVolumeCOPs[h]}, null);
                int bPCsNumber = mMappingPCs.size();
                for (int j = 0; j < mPCsOfVolumes.size(); ++j) {
                    int bIndex = mPCsOfHardwareIDs.indexOf(mPCsOfVolumes.get(j));
                    if (bIndex < 0) continue;
                    mMappingPCs.add(mPCsOfHardwareIDs.get(bIndex));
                }
                if (mMappingPCs.size() > bPCsNumber) continue;
                String[] mWWPNs = new String[pStorageHardwareIDs.size()];
                for (int i = 0; i < pStorageHardwareIDs.size(); ++i) {
                    mWWPNs[i] = ((StorageHardwareID)pStorageHardwareIDs.get(i)).getWWPN();
                }
                ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021522E", (Object)mWWPNs, (Object)this.cPlugin.getParams().getVolumeIDsForCOPs(new CIMObjectPath[]{pVolumeCOPs[h]}), (LogTraceHelper)mLTH);
                mLTH.traceError("There is no ProtocolController mapped to the HardwareIDs and this volume.", (Throwable)bEx);
                throw bEx;
            }
            if (mMappingPCs.size() > 1) {
                mLTH.traceWarning("There are several ProtocolControllers mapped to the Volumes and HardwareIDs. This might cause problems in further processing.");
            }
        }
        finally {
            mLTH.exit(mMappingPCs);
        }
        return mMappingPCs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolControllerToPrivileges[] createProtocolControllers(ArrayList pStorageHardwareIDs, ConfigurationParameter pParams) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createProtocolControllers", (Object[])new Object[]{pStorageHardwareIDs, pParams});
        ProtocolControllerToPrivileges[] mProtocolControllers = new ProtocolControllerToPrivileges[]{};
        try {
            this.cStorageHardwareIDsWithoutProtocolController = pStorageHardwareIDs;
            if (this.cNeedToCreatePC) {
                mProtocolControllers = new ProtocolControllerToPrivileges[1];
                if (!(pParams instanceof AssignStorageVolumesParameter)) {
                    throw new ServerException(new SRMMessage("HWN020003E", new String[]{pParams.getClass().getName()}));
                }
                CIMObjectPath bProtocolControllerCOP = this.createProtocolControllerWithPorts((AssignStorageVolumesParameter)pParams, null, null);
                mProtocolControllers[0] = new ProtocolControllerToPrivileges(bProtocolControllerCOP, new PrivilegeToWWPNs(null));
            }
        }
        finally {
            mLTH.exit((Object)mProtocolControllers);
        }
        return mProtocolControllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList createMapping(ArrayList pProtocolControllerToPrivileges, AssignStorageVolumesParameter pParams) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createMapping", (Object[])new Object[]{pProtocolControllerToPrivileges, pParams});
        ArrayList bNewVolumeAssignments = new ArrayList();
        try {
            CIMObjectPath[] mVolumesToAttach = this.getVolumeCOPsWithoutProtocolController();
            String[] mLUNs = this.getDeviceNumbersForVolumesToAttach(pParams, mVolumesToAttach);
            String[] bVolumeKeys = pParams.getVolumeIDsForCOPs(mVolumesToAttach);
            ProtocolControllerToPrivileges bProtocolController = (ProtocolControllerToPrivileges)pProtocolControllerToPrivileges.get(0);
            bNewVolumeAssignments = this.attachDevices(bProtocolController, mVolumesToAttach, bVolumeKeys, mLUNs, pParams);
            bNewVolumeAssignments.addAll(this.cPlugin.getPrivilegeManagement().assignAccess(bProtocolController, this.cStorageHardwareIDsWithoutProtocolController, pParams));
        }
        catch (Throwable throwable) {
            mLTH.exit(bNewVolumeAssignments);
            throw throwable;
        }
        mLTH.exit((Object)bNewVolumeAssignments);
        return bNewVolumeAssignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList deleteMappings(ArrayList pProtocolControllers, AssignmentParameter pParams, ArrayList pStorageHardwareIDs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"deleteMappings", (Object[])new Object[]{pProtocolControllers, pParams, pStorageHardwareIDs});
        ArrayList mNewVolumeAssignments = new ArrayList();
        try {
            ProtocolControllerToPrivileges bProtocolController = (ProtocolControllerToPrivileges)pProtocolControllers.get(0);
            if (pParams.getMappingMode() == AssignmentParameter.MASK_AND_MAP) {
                this.deleteProtocolController(bProtocolController, pParams.getVolumeIDs(), pParams);
                ArrayList arrayList = mNewVolumeAssignments;
                return arrayList;
            }
            if (pParams.getMappingMode() == AssignmentParameter.MAP) {
                ArrayList bAllVolumesOfPC = this.cPlugin.getVolumeManagement().retrieveVolumesOfProtocolController(bProtocolController.getProtocolController());
                CIMObjectPath[] bVolumesToDetach = this.checkVolumesOfPC(pParams.getVolumeCOPs(), bAllVolumesOfPC);
                String[] bVolumeKeys = pParams.getVolumeIDsForCOPs(bVolumesToDetach);
                if (bAllVolumesOfPC.size() == bVolumesToDetach.length) {
                    this.deleteProtocolController(bProtocolController, pParams.getVolumeIDs(), pParams);
                } else {
                    this.detachDevices(bProtocolController, bVolumesToDetach, bVolumeKeys, pParams);
                }
                ArrayList arrayList = mNewVolumeAssignments;
                return arrayList;
            }
            if (pParams.getMappingMode() == AssignmentParameter.MASK) {
                String[] bWWPNsToRemove = this.checkWWPNsOfPC(pParams.getInitiatorWWPNsArray(), ((ProtocolControllerToPrivileges)pProtocolControllers.get(0)).getWWPNs());
                if (bWWPNsToRemove.length == ((ProtocolControllerToPrivileges)pProtocolControllers.get(0)).getWWPNs().size()) {
                    this.deleteProtocolController(bProtocolController, pParams.getVolumeIDs(), pParams);
                } else {
                    this.cPlugin.getPrivilegeManagement().removeAccess(bProtocolController, pStorageHardwareIDs, pParams);
                }
            }
            ArrayList arrayList = mNewVolumeAssignments;
            return arrayList;
        }
        finally {
            mLTH.exit(mNewVolumeAssignments);
        }
    }

    protected CIMObjectPath[] getVolumeCOPsWithoutProtocolController() {
        return this.cVolumeCOPsWithoutProtocolController.toArray(new CIMObjectPath[0]);
    }
}

