/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.ArrayList;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.MappingManagementMultiplePort;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationResultHelper;
import org.eclipse.aperi.disk.control.util.ProtocolControllerToPrivileges;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.sblim.wbem.cim.CIMObjectPath;

public class MappingManagementMultiplePortSMIS11
extends MappingManagementMultiplePort {
    public MappingManagementMultiplePortSMIS11(StorageConfigurationPlugin pPlugin, CIMClientWrapper pCIMClient, CIMObjectPath pStorageSystem, CapabilityData pCapablities, String pStorageSystemID, Token pToken) {
        super(pPlugin, pCIMClient, pStorageSystem, pCapablities, pStorageSystemID, pToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList attachDevices(ProtocolControllerToPrivileges pProtocolController, CIMObjectPath[] pVolumeCOPs, String[] pVolumeIDs, String[] pDeviceNumbers, AssignStorageVolumesParameter pParams) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"attachDevices", (Object[])new Object[]{pProtocolController, pVolumeCOPs, pVolumeIDs, pDeviceNumbers});
        ArrayList mNewVolumeAssignments = new ArrayList();
        String[] mFCPortWWPNs = null;
        try {
            if (pVolumeCOPs.length <= 0) {
                ArrayList arrayList = mNewVolumeAssignments;
                return arrayList;
            }
            mFCPortWWPNs = this.getFCPortWWPNs(pProtocolController.getProtocolController());
            CIMObjectPath[] mModifiedPCs = this.exposePaths(pParams.getCapability(), pProtocolController.getProtocolController(), pParams.getVolumeNamesForCOPs(pVolumeCOPs), null, null, pDeviceNumbers);
            this.checkModifiedProtocolControllers(pProtocolController, mModifiedPCs);
            String[] mDeviceNumbers = this.getDeviceNumbers(pProtocolController.getProtocolController(), pParams.getVolumeCOPs());
            mNewVolumeAssignments.addAll(ConfigurationResultHelper.createMappingResults(pProtocolController.getPrivilegeToWWPNs(), pVolumeIDs, mDeviceNumbers, mFCPortWWPNs, pProtocolController.getProtocolController(), this.cToken));
            pParams.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)pParams.getAsyncResult(), mNewVolumeAssignments, (String)pParams.getAPIMethodName()));
        }
        finally {
            mLTH.exit(mNewVolumeAssignments);
        }
        return mNewVolumeAssignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList detachDevices(ProtocolControllerToPrivileges pProtocolController, CIMObjectPath[] pVolumeCOPs, String[] pVolumeIDs, AssignmentParameter pParams) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"detachDevices", (Object[])new Object[]{pProtocolController, pVolumeCOPs, pVolumeIDs, pParams});
        ArrayList mNewVolumeAssignments = new ArrayList();
        try {
            CIMObjectPath[] mModifiedPCs = this.hidePaths(new CIMObjectPath[]{pProtocolController.getProtocolController()}, pParams.getCapability(), pParams.getVolumeNamesForCOPs(pVolumeCOPs), null, null);
            mNewVolumeAssignments.addAll(ConfigurationResultHelper.createUnMappingResults(pProtocolController.getPrivilegeToWWPNs(), pVolumeIDs, this.cToken));
            pParams.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)pParams.getAsyncResult(), mNewVolumeAssignments, (String)pParams.getAPIMethodName()));
        }
        finally {
            mLTH.exit(mNewVolumeAssignments);
        }
        return mNewVolumeAssignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList createMapping(ArrayList pProtocolControllerToPrivileges, AssignStorageVolumesParameter pParams) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createMapping", (Object[])new Object[]{pProtocolControllerToPrivileges, pParams});
        ArrayList bNewVolumeAssignments = new ArrayList();
        try {
            if (pProtocolControllerToPrivileges.size() == 1) {
                CIMObjectPath[] mVolumesToAttach = this.getVolumeCOPsWithoutProtocolController();
                String[] mLUNs = this.getDeviceNumbersForVolumesToAttach(pParams, mVolumesToAttach);
                String[] bVolumeKeys = pParams.getVolumeIDsForCOPs(mVolumesToAttach);
                ProtocolControllerToPrivileges bProtocolController = (ProtocolControllerToPrivileges)pProtocolControllerToPrivileges.get(0);
                bNewVolumeAssignments = this.attachDevices(bProtocolController, mVolumesToAttach, bVolumeKeys, mLUNs, pParams);
                for (int i = 0; i < pParams.getInitiatorWWPNs().size(); ++i) {
                    StorageHardwareID bStoHWID = new StorageHardwareID(pParams.getInitiatorWWPNsArray()[i]);
                    if (bProtocolController.getWWPNs().contains(pParams.getInitiatorWWPNsArray()[i]) || this.cStorageHardwareIDsWithoutProtocolController.contains(bStoHWID)) continue;
                    this.cStorageHardwareIDsWithoutProtocolController.add(bStoHWID);
                }
                bNewVolumeAssignments.addAll(this.cPlugin.getPrivilegeManagement().assignAccess(bProtocolController, this.cStorageHardwareIDsWithoutProtocolController, pParams));
            } else {
                this.createMappingExposePathsWithoutProtocolController(pParams, bNewVolumeAssignments, new ArrayList());
            }
        }
        finally {
            mLTH.exit(bNewVolumeAssignments);
        }
        return bNewVolumeAssignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList retrieveProtocolControllersForMappings(ArrayList pStorageHardwareIDs, ArrayList pStorageHardwareIDsWithoutProtocolController, CIMObjectPath[] pVolumeCOPs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveProtocolControllersForMappings", (Object[])new Object[]{pStorageHardwareIDs, pStorageHardwareIDsWithoutProtocolController, pVolumeCOPs});
        ArrayList mPCsOfHardwareIDs = null;
        try {
            mPCsOfHardwareIDs = super.retrieveProtocolControllersForMappings(pStorageHardwareIDs, pStorageHardwareIDsWithoutProtocolController, pVolumeCOPs);
            for (int i = 0; i < ((AssignmentParameter)this.cPlugin.getParams()).getInitiatorWWPNs().size(); ++i) {
                if (this.cStorageHardwareIDsWithoutProtocolController == null) {
                    this.cStorageHardwareIDsWithoutProtocolController = new ArrayList();
                }
                if (pStorageHardwareIDs.contains(new StorageHardwareID((String)((AssignmentParameter)this.cPlugin.getParams()).getInitiatorWWPNs().get(i)))) continue;
                this.cStorageHardwareIDsWithoutProtocolController.add(new StorageHardwareID(((AssignmentParameter)this.cPlugin.getParams()).getInitiatorWWPNsArray()[i]));
            }
        }
        catch (Throwable throwable) {
            mLTH.exit(mPCsOfHardwareIDs);
            throw throwable;
        }
        mLTH.exit((Object)mPCsOfHardwareIDs);
        return mPCsOfHardwareIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList deleteMappings(ArrayList pProtocolControllers, AssignmentParameter pParams, ArrayList pStorageHardwareIDs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"deleteMappings", (Object[])new Object[]{pProtocolControllers, pParams, pStorageHardwareIDs});
        ArrayList mNewVolumeAssignments = new ArrayList();
        try {
            ProtocolControllerToPrivileges bProtocolController = (ProtocolControllerToPrivileges)pProtocolControllers.get(0);
            if (pParams.getMappingMode() == AssignmentParameter.MASK_AND_MAP) {
                ArrayList bAllVolumesOfPC = this.cPlugin.getVolumeManagement().retrieveVolumesOfProtocolController(bProtocolController.getProtocolController());
                CIMObjectPath[] bVolumesToDetach = this.checkVolumesOfPC(pParams.getVolumeCOPs(), bAllVolumesOfPC);
                String[] bVolumeKeys = pParams.getVolumeIDsForCOPs(bVolumesToDetach);
                this.detachDevices(bProtocolController, bVolumesToDetach, bVolumeKeys, pParams);
                this.cPlugin.getPrivilegeManagement().removeAccess(bProtocolController, pStorageHardwareIDs, pParams);
                this.deleteProtocolController(bProtocolController, pParams.getVolumeIDs(), pParams);
                ArrayList arrayList = mNewVolumeAssignments;
                return arrayList;
            }
            if (pParams.getMappingMode() == AssignmentParameter.MAP) {
                ArrayList bAllVolumesOfPC = this.cPlugin.getVolumeManagement().retrieveVolumesOfProtocolController(bProtocolController.getProtocolController());
                CIMObjectPath[] bVolumesToDetach = this.checkVolumesOfPC(pParams.getVolumeCOPs(), bAllVolumesOfPC);
                String[] bVolumeKeys = pParams.getVolumeIDsForCOPs(bVolumesToDetach);
                this.detachDevices(bProtocolController, bVolumesToDetach, bVolumeKeys, pParams);
                ArrayList arrayList = mNewVolumeAssignments;
                return arrayList;
            }
            if (pParams.getMappingMode() == AssignmentParameter.MASK) {
                this.cPlugin.getPrivilegeManagement().removeAccess(bProtocolController, pStorageHardwareIDs, pParams);
            }
            ArrayList arrayList = mNewVolumeAssignments;
            return arrayList;
        }
        finally {
            mLTH.exit(mNewVolumeAssignments);
        }
    }
}

