/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.api.DiskManagerMessages;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyPort;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyVolume;
import org.eclipse.aperi.infrastructure.database.objects.ClientSettingData;
import org.eclipse.aperi.infrastructure.database.objects.IoGroup;
import org.eclipse.aperi.infrastructure.database.objects.MaskingInfo;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.sblim.wbem.cim.CIMObjectPath;

public class DBHelper
implements DiskManagerMessages {
    protected DBConnection cDBConnection = ServiceUtils.getConnection();
    protected Token cToken;

    public DBHelper() {
        this.cToken = null;
    }

    public DBHelper(Token pToken) {
        this.cToken = pToken;
    }

    public void close() {
        if (this.cDBConnection != null) {
            LogTraceHelper mLTH = null;
            try {
                this.cDBConnection.close();
            }
            catch (SQLException e) {
                mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"close", null);
                mLTH.traceError("Internal error: SQLException", (Throwable)e);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
            }
            finally {
                if (mLTH != null) {
                    mLTH.exit(null);
                }
            }
        }
    }

    public ConfigurationParameter getStorageVolumesAndSubsystemObjects(ConfigurationParameter pParams, String[] pStorageVolumeIDs) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getStorageVolumesAndSubsystemObjects", (Object[])new Object[]{pParams, pStorageVolumeIDs});
        try {
            StorageSubsystem[] mStorageSubsystems = new StorageSubsystem[pStorageVolumeIDs.length];
            StorageVolume[] mStorageVolumes = new StorageVolume[pStorageVolumeIDs.length];
            String[] mStorageVolumeNames = new String[pStorageVolumeIDs.length];
            for (int i = 0; i < pStorageVolumeIDs.length; ++i) {
                String storageSubsystemKey = ExternalKeyConverter.frameKeyStorageSubsystemFromVolume((String)pStorageVolumeIDs[i], (LogTraceHelper)mLTH);
                mStorageSubsystems[i] = ExternalKeyManager.getStorageSubsystem((String)storageSubsystemKey, (DBConnection)this.cDBConnection);
                if (mStorageSubsystems[i] == null) {
                    throw DiskMessageHelper.getServerException((String)"HWN021655E", (Object)pStorageVolumeIDs[i], (LogTraceHelper)mLTH);
                }
                mStorageVolumes[i] = ExternalKeyManager.getStorageVolume((String)pStorageVolumeIDs[i], (int)mStorageSubsystems[i].getSubsystemId(), (DBConnection)this.cDBConnection);
                if (mStorageVolumes[i] == null) {
                    throw DiskMessageHelper.getServerException((String)"HWN021655E", (Object)pStorageVolumeIDs[i], (LogTraceHelper)mLTH);
                }
                mStorageVolumeNames[i] = mStorageVolumes[i].getName();
            }
            pParams.setStorageSubsystemsForSorting(mStorageSubsystems);
            pParams.setVolumeIDs(pStorageVolumeIDs);
            pParams.setVolumes(mStorageVolumes);
            pParams.setVolumeNames(mStorageVolumeNames);
        }
        catch (IDParseException mEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)mEx, (LogTraceHelper)mLTH);
        }
        catch (EntityNotFoundException mEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)mEx, (LogTraceHelper)mLTH);
        }
        finally {
            this.commit();
            mLTH.exit((Object)pParams);
        }
        return pParams;
    }

    public Port[] getPortObjects(ConfigurationParameter pParams, String[] pPortIDs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getPortObjects", (Object[])new Object[]{pParams, pPortIDs});
        Port[] mPorts = new Port[pPortIDs.length];
        int i = 0;
        try {
            for (i = 0; i < pPortIDs.length; ++i) {
                mPorts[i] = ExternalKeyManager.getPort((String)pPortIDs[i], (int)pParams.getStorageSubsystem().getSubsystemId(), (DBConnection)this.cDBConnection);
                if (mPorts[i] != null) continue;
                throw DiskMessageHelper.getServerException((String)"HWN021608E", (Object)pPortIDs[i], (Object)pParams.getStorageSubsystemID(), (Object)pParams.getVolumeIDs(), (LogTraceHelper)mLTH);
            }
        }
        catch (EntityNotFoundException e) {
            throw DiskMessageHelper.getServerException((String)"HWN021608E", (Object)pPortIDs[i], (Object)pParams.getStorageSubsystemID(), (Object)pParams.getVolumeIDs(), (LogTraceHelper)mLTH);
        }
        finally {
            this.commit();
            mLTH.exit((Object)mPorts);
        }
        return mPorts;
    }

    public IoGroup getIOGroupObject(int pIOGroupID) {
        IoGroup ioGroup;
        block6: {
            LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getIOGroupObject", (Object[])new Object[]{Integer.toString(pIOGroupID)});
            ioGroup = new IoGroup();
            IoGroup.IoGroupCursor mCursor = null;
            try {
                Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
                ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(IoGroup.class, (String)"IO_GROUP_ID", (LogTraceHelper)mLTH);
                mWhereClause.put(mInfo, Integer.toString(pIOGroupID));
                mCursor = IoGroup.getCursor((DBConnection)this.cDBConnection, mWhereClause, null);
                if (mCursor.next()) {
                    ioGroup = mCursor.getObject();
                    mCursor.close();
                    break block6;
                }
                mCursor.close();
                throw DiskMessageHelper.getServerException((String)"HWN021504E", (Object)Integer.toString(pIOGroupID), (LogTraceHelper)mLTH);
            }
            catch (SQLException e) {
                mLTH.traceError("Internal error: SQLException", (Throwable)e);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
            }
            finally {
                this.commit();
                mLTH.exit((Object)ioGroup);
            }
        }
        return ioGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Port[] getInitiatorPortObjects(ConfigurationParameter pParams, String[] pPortIDs) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getPortObjects", (Object[])new Object[]{pParams, pPortIDs});
        Port[] mPorts = new Port[pPortIDs.length];
        try {
            for (int i = 0; i < pPortIDs.length; ++i) {
                try {
                    mPorts[i] = ExternalKeyManager.getPort((String)pPortIDs[i], (int)-1, (DBConnection)this.cDBConnection);
                    continue;
                }
                catch (EntityNotFoundException e) {
                    mPorts[i] = null;
                }
            }
        }
        finally {
            this.commit();
            mLTH.exit((Object)mPorts);
        }
        return mPorts;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMObjectPath[] getVolumeAndSubsystemCOPs(CIMOMSelector.SubsystemConnectionData pCIMConnectionData, ConfigurationParameter pParams) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getVolumeCOPs", (Object[])new Object[]{pCIMConnectionData, pParams});
        CIMObjectPath[] mVolumeCOPs = null;
        try {
            String[] mVolumeIDs = pParams.getVolumeIDs();
            pParams.setStorageSubsystemCOP(pCIMConnectionData.getSubsystemCop());
            pParams.setStorageSubsystemID(ExternalKeyConverter.frameKeyStorageSubsystemFromVolume((String)mVolumeIDs[0], (LogTraceHelper)mLTH));
            StorageVolume[] mVolumes = pParams.getVolumes();
            mVolumeCOPs = new CIMObjectPath[mVolumeIDs.length];
            for (int i = 0; i < mVolumeIDs.length; ++i) {
                CimkeyVolume bVolumeCIM = ExternalKeyManager.getStorageVolumeCIM((int)mVolumes[i].getSvid(), (int)pCIMConnectionData.getCimNamespaceID(), (DBConnection)this.cDBConnection);
                mVolumeCOPs[i] = ExternalKeyManager.getCIMObjectPath((CimkeyVolume)bVolumeCIM, (String)pCIMConnectionData.getCimNamespace());
            }
            this.commit();
        }
        catch (IDParseException mEx) {
            try {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)mEx, (LogTraceHelper)mLTH);
                catch (EntityNotFoundException mEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)mEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                this.commit();
                mLTH.exit(mVolumeCOPs);
                throw throwable;
            }
        }
        mLTH.exit((Object)mVolumeCOPs);
        return mVolumeCOPs;
    }

    public CIMObjectPath[] getTargetPortCOPs(CIMOMSelector.SubsystemConnectionData pCIMConnectionData, String[] pPortIDs, Port[] pPorts) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getTargetPortCOPs", (Object[])new Object[]{pCIMConnectionData, pPortIDs, pPorts});
        CIMObjectPath[] mPortCOPs = new CIMObjectPath[pPortIDs.length];
        try {
            for (int i = 0; i < pPortIDs.length; ++i) {
                CimkeyPort bPortCIM = ExternalKeyManager.getPortCIM((int)pPorts[i].getPortId(), (int)pCIMConnectionData.getCimNamespaceID(), (DBConnection)this.cDBConnection);
                mPortCOPs[i] = ExternalKeyManager.getCIMObjectPath((CimkeyPort)bPortCIM, (String)pCIMConnectionData.getCimNamespace());
            }
        }
        catch (EntityNotFoundException mEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)mEx, (LogTraceHelper)mLTH);
        }
        finally {
            this.commit();
            mLTH.exit((Object)mPortCOPs);
        }
        return mPortCOPs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaskingInfo getMaskingInfo(String pHostID, int pSubsystemID) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getMaskingInfo", (Object[])new Object[]{pHostID, new Integer(pSubsystemID)});
        MaskingInfo mMaskingInfo = null;
        try {
            Hashtable<ColumnInfo, String> mFilterHash = new Hashtable<ColumnInfo, String>();
            ColumnInfo mColumnInfo = MaskingInfo.getColumnInfo((String)"HOST_ID");
            mFilterHash.put(mColumnInfo, pHostID);
            mColumnInfo = MaskingInfo.getColumnInfo((String)"SUBSYSTEM_ID");
            mFilterHash.put(mColumnInfo, new Integer(pSubsystemID).toString());
            MaskingInfo.MaskingInfoCursor mCursor = MaskingInfo.getCursor((DBConnection)this.cDBConnection, mFilterHash, null);
            if (mCursor.next()) {
                mMaskingInfo = mCursor.getObject();
            }
            mCursor.close();
            this.commit();
        }
        catch (Throwable throwable) {
            this.commit();
            mLTH.exit(mMaskingInfo);
            throw throwable;
        }
        mLTH.exit((Object)mMaskingInfo);
        return mMaskingInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMObjectPath getClientSettingDataCOP(CIMOMSelector.SubsystemConnectionData pCIMConnectionData, int pSubsystemId, int pClientType, String pClientDescription, ConfigurationParameter pParams) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getClientSettingDataCOP", (Object[])new Object[]{pCIMConnectionData, new Integer(pSubsystemId), new Integer(pClientType), pClientDescription, pParams});
        CIMObjectPath mClientSettingDataCOP = null;
        try {
            ClientSettingData mClientSettingData = this.getClientSettingDataObjects(pSubsystemId, pClientType, pClientDescription, pParams);
            mClientSettingDataCOP = ExternalKeyManager.getCIMObjectPath((ClientSettingData)mClientSettingData, (String)pCIMConnectionData.getCimNamespace());
            this.commit();
        }
        catch (Throwable throwable) {
            this.commit();
            mLTH.exit(mClientSettingDataCOP);
            throw throwable;
        }
        mLTH.exit((Object)mClientSettingDataCOP);
        return mClientSettingDataCOP;
    }

    public ClientSettingData getClientSettingDataObjects(int pSubsystemId, int pClientType, String pClientDescription, ConfigurationParameter pParams) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getClientSettingDataObjects", (Object[])new Object[]{new Integer(pSubsystemId), new Integer(pClientType), pClientDescription, pParams});
        ClientSettingData mClientSettingData = null;
        try {
            ClientSettingData.ClientSettingDataCursor mCursor;
            Hashtable<ColumnInfo, String> mFilterHash = new Hashtable<ColumnInfo, String>();
            ColumnInfo mColumnInfo = ClientSettingData.getColumnInfo((String)"SUBSYSTEM_ID");
            mFilterHash.put(mColumnInfo, new Integer(pSubsystemId).toString());
            String mClientType = "[" + new Integer(pClientType).toString() + "]";
            mColumnInfo = ClientSettingData.getColumnInfo((String)"CLIENT_TYPES");
            mFilterHash.put(mColumnInfo, mClientType);
            if (pClientDescription != null) {
                mColumnInfo = ClientSettingData.getColumnInfo((String)"CLIENT_TYPE_DESCRIPTIONS");
                mFilterHash.put(mColumnInfo, "[" + pClientDescription + "]");
            }
            if ((mCursor = ClientSettingData.getCursor((DBConnection)this.cDBConnection, mFilterHash, null)).next()) {
                mClientSettingData = mCursor.getObject();
            }
            if (mCursor.next()) {
                mCursor.close();
                ServerException mEx = DiskMessageHelper.getServerException((String)"HWN021670E", (Object)new Integer(pClientType), (Object)pClientDescription, (Object)pParams.getCIMClientWrapper().toString(), (Object)pParams.getStorageSubsystemID(), (Object)pParams.getVolumeIDs(), (LogTraceHelper)mLTH);
                mLTH.traceError("Several ClientSettingData objects found that match the input criteria", (Throwable)mEx);
                throw mEx;
            }
            if (mClientSettingData == null) {
                mCursor.close();
                ServerException mEx = DiskMessageHelper.getServerException((String)"HWN021607E", (Object)new Integer(pClientType), (Object)pClientDescription, (Object)pParams.getCIMClientWrapper().toString(), (Object)pParams.getStorageSubsystemID(), (Object)pParams.getVolumeIDs(), (LogTraceHelper)mLTH);
                mLTH.traceError("No ClientSettingData object found that match the input criteria", (Throwable)mEx);
                throw mEx;
            }
            mCursor.close();
            this.commit();
        }
        catch (SQLException e) {
            try {
                mLTH.traceError("Internal error: SQLException", (Throwable)e);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
            }
            catch (Throwable throwable) {
                this.commit();
                mLTH.exit(mClientSettingData);
                throw throwable;
            }
        }
        mLTH.exit((Object)mClientSettingData);
        return mClientSettingData;
    }

    protected void commit() {
        if (this.cDBConnection != null) {
            LogTraceHelper mLTH = null;
            try {
                this.cDBConnection.commit();
            }
            catch (SQLException e) {
                mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"commit", null);
                mLTH.traceError("Internal error: SQLException", (Throwable)e);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
            }
            finally {
                if (mLTH != null) {
                    mLTH.exit(null);
                }
            }
        }
    }

    public static void putObjectIntoHashtable(Hashtable pHashtable, Object pKey, Object pObject) {
        if (pObject != null) {
            if (!(pObject instanceof String)) {
                pObject = pObject.toString();
            }
            pHashtable.put(pKey, pObject);
        }
    }

    public StoragePool getStoragePool(StorageVolume stgVol) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getStoragePool", (Object[])new Object[]{stgVol});
        StoragePool mPool = null;
        try {
            if (stgVol != null) {
                int bStoragePoolID = stgVol.getPoolId();
                Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
                ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(StoragePool.class, (String)"POOL_ID", (LogTraceHelper)mLTH);
                mWhereClause.put(mInfo, String.valueOf(bStoragePoolID));
                StoragePool.StoragePoolCursor mCursor = StoragePool.getCursor((DBConnection)this.cDBConnection, mWhereClause, null);
                if (!mCursor.next()) {
                    mCursor.close();
                    mLTH.traceError("Internal error: SQLException", null);
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, null, (LogTraceHelper)mLTH);
                }
                mPool = mCursor.getObject();
                mCursor.close();
            }
        }
        catch (SQLException e) {
            mLTH.traceError("Internal error: SQLException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            this.commit();
            mLTH.exit(mPool);
        }
        return mPool;
    }
}

