/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.disk.common.util.DBHelper;
import org.eclipse.aperi.disk.common.util.ParameterHelper;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;

public class DiskParameterHelper
extends ParameterHelper {
    public static Collection combineConfigurationParametersByStorageSystem(ConfigurationParameter pParams) {
        StorageSubsystem[] mStorageSubsystems = pParams.getStorageSubsystemsForSorting();
        HashMap<Integer, ConfigurationParameter> mParamsHash = new HashMap<Integer, ConfigurationParameter>();
        for (int mIdx = 0; mIdx < mStorageSubsystems.length; ++mIdx) {
            ConfigurationParameter bNewConfigurationParameter = mParamsHash.containsKey(new Integer(mStorageSubsystems[mIdx].getSubsystemId())) ? (ConfigurationParameter)mParamsHash.get(new Integer(mStorageSubsystems[mIdx].getSubsystemId())) : DiskParameterHelper.createConfigurationParameter(pParams, mStorageSubsystems[mIdx]);
            bNewConfigurationParameter.addParameters(pParams, mIdx);
            mParamsHash.put(new Integer(mStorageSubsystems[mIdx].getSubsystemId()), bNewConfigurationParameter);
        }
        return mParamsHash.values();
    }

    private static ConfigurationParameter createConfigurationParameter(ConfigurationParameter pParameter, StorageSubsystem pStorageSubsystem) {
        if (pParameter instanceof AssignStorageVolumesParameter) {
            return new AssignStorageVolumesParameter(pStorageSubsystem, null);
        }
        if (pParameter instanceof AssignmentParameter) {
            return new AssignmentParameter(pStorageSubsystem, null);
        }
        return null;
    }

    public static void getTargetPorts(DBHelper pHelper, CIMOMSelector.SubsystemConnectionData pCIMConnectionData, String[] pSubsystemPortIDs, AssignStorageVolumesParameter pParams) {
        pParams.setTargetPortIDs(pSubsystemPortIDs);
        Port[] mPorts = pHelper.getPortObjects(pParams, pSubsystemPortIDs);
        pParams.setTargetPorts(mPorts);
        pParams.setTargetPortCOPs(pHelper.getTargetPortCOPs(pCIMConnectionData, pSubsystemPortIDs, mPorts));
        String[] bPortWWPNs = new String[mPorts.length];
        for (int j = 0; j < mPorts.length; ++j) {
            bPortWWPNs[j] = mPorts[j].getName();
        }
        pParams.setTargetPortWWPNs(bPortWWPNs);
    }
}

