/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.interfaces.NotAvailableException;
import org.eclipse.aperi.disk.api.VolumeID;
import org.eclipse.aperi.disk.collection.SubsystemPostCollectionProcess;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.HardwareIDMangement;
import org.eclipse.aperi.disk.common.CIM.MappingManagement;
import org.eclipse.aperi.disk.common.CIM.PrivilegeManagement;
import org.eclipse.aperi.disk.common.CIM.VolumeManagement;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.control.IStorageConfigurationManagementPlugin;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationResultHelper;
import org.eclipse.aperi.disk.control.util.CreateSVCStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.CreateStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.DeleteStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.ModifyStoragePoolParameter;
import org.eclipse.aperi.disk.control.util.ModifyStorageVolumeParameter;
import org.eclipse.aperi.disk.control.util.VolumeAssignmentModifyParams;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.tables.TResDataPathTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.sblim.wbem.cim.CIMObjectPath;

public class StorageConfigurationPlugin
implements IStorageConfigurationManagementPlugin {
    protected ConfigurationParameter cParams = null;
    protected VolumeManagement cVolumeManagement = null;
    protected HardwareIDMangement cHardwareIDManagement = null;
    protected PrivilegeManagement cPrivilegeManagement = null;
    protected MappingManagement cMappingManagement = null;
    protected final long VOLUME_CREATION_TIMEOUT = 1200000L;

    public ConfigurationParameter getParams() {
        return this.cParams;
    }

    public void setParams(ConfigurationParameter pParams) {
        this.cParams = pParams;
    }

    public VolumeManagement getVolumeManagement() {
        if (this.cVolumeManagement == null) {
            this.cVolumeManagement = new VolumeManagement(this, this.cParams.getCIMClientWrapper(), this.cParams.getStorageSubsystemCIMOP(), this.cParams.getStorageSubsystemID(), this.cParams.getToken());
        }
        return this.cVolumeManagement;
    }

    public HardwareIDMangement getHardwareIDManagement() {
        if (this.cHardwareIDManagement == null) {
            this.cHardwareIDManagement = new HardwareIDMangement(this, this.cParams.getCIMClientWrapper(), this.cParams.getStorageSubsystemCIMOP(), this.cParams.getStorageSubsystemID(), this.cParams.getToken());
        }
        return this.cHardwareIDManagement;
    }

    public PrivilegeManagement getPrivilegeManagement() {
        if (this.cPrivilegeManagement == null) {
            this.cPrivilegeManagement = new PrivilegeManagement(this, this.cParams.getCIMClientWrapper(), this.cParams.getStorageSubsystemCIMOP(), this.cParams.getStorageSubsystemID(), this.cParams.getToken());
        }
        return this.cPrivilegeManagement;
    }

    public MappingManagement getMappingManagement() {
        if (this.cMappingManagement == null) {
            this.cMappingManagement = new MappingManagement(this, this.cParams.getCIMClientWrapper(), this.cParams.getStorageSubsystemCIMOP(), this.cParams.getCapability(), this.cParams.getStorageSubsystemID(), this.cParams.getToken());
        }
        return this.cMappingManagement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult[] createStorageVolumes(CreateStorageVolumesParameter pParam) throws NotAvailableException, Exception {
        Vector<AsyncResult> mResult;
        LogTraceHelper mLTH;
        block16: {
            mLTH = LogTraceHelper.entry((Token)pParam.getToken(), (Object)this, (String)"createStorageVolumes", (Object[])new Object[]{pParam});
            mResult = new Vector<AsyncResult>();
            CIMObjectPath[] mStoragePoolCIMOPs = null;
            StoragePool[] mStoragePools = null;
            String[] mVolumeNames = null;
            long[] mSizes = null;
            CIMClientWrapper bCimClient = null;
            int idx = 0;
            try {
                mStoragePoolCIMOPs = pParam.getStoragePoolCIMOPs();
                mStoragePools = pParam.getStoragePools();
                mVolumeNames = pParam.getVolumeNames();
                mSizes = pParam.getSizes();
                bCimClient = CIMClientPool.getClient((String)pParam.getCimom().getUserId(), (String)pParam.getCimom().getPassword(), (String)pParam.getCimom().getServiceUrl(), (String)pParam.getCimom().getInteropSchemaNamespace());
                bCimClient.setTimeout(1200000L);
                pParam.setCIMClientWrapper(bCimClient);
                for (idx = 0; idx < mStoragePoolCIMOPs.length; ++idx) {
                    DiskMessageHelper.getSRMMessage((String)"HWN021675I", (Object)new Long(pParam.getSizes()[idx]), (Object)pParam.getStoragePools()[idx].getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
                    AsyncResult bAsyncRes = new AsyncResult(-1, -1);
                    long[] bSizesSupported = this.getDefaultSupportedVolumeSizeRange(pParam.getStoragePools()[idx], mStoragePoolCIMOPs[idx]);
                    String storagePoolID = (String)ExternalKeyConverter.getStoragePoolKey((StoragePool)mStoragePools[idx], (StorageSubsystem)pParam.getStorageSubsystem());
                    if (bSizesSupported[0] == -1L || bSizesSupported[1] == -1L || bSizesSupported[2] == -1L) {
                        mLTH.traceInfo("getSupportedSizeRage returned an invalid value");
                        ServerException bException = this.setVolumeCreationSubjobFailed(bAsyncRes, storagePoolID, mLTH);
                        mResult.add(bAsyncRes);
                        throw bException;
                    }
                    if (bSizesSupported[2] == 0L) {
                        bSizesSupported[2] = 1L;
                    }
                    long bFinalSize = this.checkVolumeSize(mSizes[idx], bSizesSupported, mResult, bAsyncRes, storagePoolID, ExternalKeyConverter.frameKeyStorageSubsystemFromPool((String)storagePoolID, (LogTraceHelper)mLTH), pParam.getToken());
                    bAsyncRes = this.getVolumeManagement().createStorageVolume(storagePoolID, pParam.getCapability(), pParam.getStorageSubsystem(), pParam.getCimom(), mStoragePoolCIMOPs[idx], mVolumeNames[idx], bFinalSize);
                    if (bAsyncRes.getRc() == 0) {
                        DiskMessageHelper.getSRMMessage((String)"HWN021676I", (Object)pParam.getVolumeElementName(), (Object)new Long(pParam.getSizes()[idx]), (Object)pParam.getStoragePools()[idx].getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
                    } else {
                        DiskMessageHelper.getSRMMessage((String)"HWN021677E", (Object)new Long(pParam.getSizes()[idx]), (Object)pParam.getStoragePools()[idx].getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
                    }
                    mResult.add(bAsyncRes);
                }
                if (bCimClient == null) break block16;
            }
            catch (Exception e) {
                block17: {
                    try {
                        int i;
                        DiskMessageHelper.getSRMMessage((String)"HWN021677E", (Object)new Long(pParam.getSizes()[idx]), (Object)pParam.getStoragePools()[idx].getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
                        AsyncResult bResult = new AsyncResult();
                        ServerException bException = null;
                        int bRC = 10001;
                        for (i = 0; i < mResult.size(); ++i) {
                            AsyncResult bFailureResult = (AsyncResult)mResult.elementAt(i);
                            if (bFailureResult.getReturnException() == null) continue;
                            bException = (ServerException)((Object)bFailureResult.getReturnException());
                            bRC = bFailureResult.getRc();
                            break;
                        }
                        for (i = mResult.size(); i < mStoragePools.length; ++i) {
                            String storagePoolID = (String)ExternalKeyConverter.getStoragePoolKey((StoragePool)mStoragePools[i], (StorageSubsystem)pParam.getStorageSubsystem());
                            if (bException != null) {
                                this.setVolumeCreationSubjobFailed(bResult, storagePoolID, bException, bRC, mLTH);
                            } else if (e instanceof ServerException) {
                                this.setVolumeCreationSubjobFailed(bResult, storagePoolID, (ServerException)((Object)e), 10001, mLTH);
                            } else {
                                this.setVolumeCreationSubjobFailed(bResult, storagePoolID, mLTH);
                            }
                            mResult.add(bResult);
                        }
                        if (bCimClient == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (bCimClient != null) {
                            CIMClientPool.returnClient(bCimClient);
                            bCimClient = null;
                        }
                        mLTH.exit(mResult);
                        throw throwable;
                    }
                    CIMClientPool.returnClient((CIMClientWrapper)bCimClient);
                    bCimClient = null;
                }
                mLTH.exit(mResult);
            }
            CIMClientPool.returnClient((CIMClientWrapper)bCimClient);
            bCimClient = null;
        }
        mLTH.exit(mResult);
        return mResult.toArray(new AsyncResult[mResult.size()]);
    }

    protected void setVolumeCreationSubjobFailed(AsyncResult pAsyncRes, String pStoragePoolID, ServerException pServerException, int pRC, LogTraceHelper mLTH) {
        pAsyncRes.setRc(pRC);
        VolumeID bVolumeID = new VolumeID();
        bVolumeID.setStoragePoolID(pStoragePoolID);
        pAsyncRes.setResults(new Object[]{bVolumeID});
        pAsyncRes.setStatus(0);
        pAsyncRes.setReturnException((Exception)((Object)pServerException));
        pAsyncRes.setSRMMessage(pServerException.getSRMMessage());
        pAsyncRes.setRc(10001);
    }

    protected ServerException setVolumeCreationSubjobFailed(AsyncResult pAsyncRes, String pStoragePoolID, LogTraceHelper mLTH) {
        ServerException bException = DiskMessageHelper.getServerException((String)"HWN021503E", null, (LogTraceHelper)mLTH);
        this.setVolumeCreationSubjobFailed(pAsyncRes, pStoragePoolID, bException, 10001, mLTH);
        return bException;
    }

    protected long checkVolumeSize(long pSize, long[] pSizesSupported, Vector pResults, AsyncResult pAsyncRes, String pStoragePoolID, String pStorageSystemID, Token pToken) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)pToken, (Object)this, (String)"checkVolumeSize", (Object[])new Object[]{new Long(pSize), pSizesSupported, pResults, pAsyncRes, pStoragePoolID, pToken});
        try {
            if (pSize >= pSizesSupported[0] && pSize <= pSizesSupported[1]) {
                if (pSizesSupported[2] != -2L) {
                    long bFinalSize;
                    if (pSize % pSizesSupported[2] == 0L) {
                        long l = pSize;
                        return l;
                    }
                    pSize = bFinalSize = (pSize + (pSizesSupported[2] - 1L)) / pSizesSupported[2] * pSizesSupported[2];
                    long l = bFinalSize;
                    return l;
                }
                long[] bSupportedSizes = new long[pSizesSupported.length - 3];
                System.arraycopy(pSizesSupported, 3, bSupportedSizes, 0, bSupportedSizes.length);
                Arrays.sort(bSupportedSizes);
                for (int i = 0; i < bSupportedSizes.length; ++i) {
                    if (bSupportedSizes[i] < pSize) continue;
                    long l = bSupportedSizes[i];
                    return l;
                }
            }
            if (pSizesSupported[0] == pSizesSupported[1]) {
                long bSupportedSizes = pSizesSupported[0];
                return bSupportedSizes;
            }
            VolumeID mVolumeID = new VolumeID();
            mVolumeID.setStoragePoolID(pStoragePoolID);
            pAsyncRes.setResults(new Object[]{mVolumeID});
            pAsyncRes.setStatus(0);
            ServerException bException = null;
            if (pSize > pSizesSupported[1]) {
                bException = DiskMessageHelper.getServerException((String)"HWN021535E", (Object)pStoragePoolID, (Object)pStorageSystemID, (Object)new Long(pSize), (LogTraceHelper)mLTH);
                pAsyncRes.setRc(10004);
            } else {
                bException = DiskMessageHelper.getServerException((String)"HWN021610E", (Object)new Long(pSize), (Object)pStoragePoolID, (Object)new Long(pSizesSupported[2]), (Object)new Long(pSizesSupported[0]), (Object)new Long(pSizesSupported[1]), (LogTraceHelper)mLTH);
                pAsyncRes.setRc(10005);
            }
            pAsyncRes.setReturnException((Exception)((Object)bException));
            pAsyncRes.setSRMMessage(bException.getSRMMessage());
            pResults.add(pAsyncRes);
            throw bException;
        }
        finally {
            mLTH.exit((Object)new Long(pSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult[] deleteStorageVolumes(DeleteStorageVolumesParameter pParam) throws NotAvailableException, Exception {
        DBConnection mDBConnection;
        Vector<AsyncResult> mAllResults;
        LogTraceHelper mLTH;
        block24: {
            mLTH = LogTraceHelper.entry((Token)pParam.getToken(), (Object)this, (String)"deleteStorageVolumes", (Object[])new Object[]{pParam});
            String OPERATION = "deleteStorageVolumes";
            mAllResults = new Vector<AsyncResult>();
            CIMClientWrapper bCimClient = null;
            int idx = 0;
            mDBConnection = null;
            boolean mVolUpdate = false;
            boolean mPoolUpdate = false;
            try {
                mDBConnection = ServiceUtils.getConnection();
                HashMap mTouchedEntities = new HashMap();
                CIMObjectPath[] mStorageVolumeCIMOPs = pParam.getStorageVolumeCIMOPs();
                StorageVolume[] mStorageVolumes = pParam.getStorageVolumes();
                bCimClient = CIMClientPool.getClient((String)pParam.getCimom().getUserId(), (String)pParam.getCimom().getPassword(), (String)pParam.getCimom().getServiceUrl(), (String)pParam.getCimom().getInteropSchemaNamespace());
                bCimClient.setTimeout(1200000L);
                pParam.setCIMClientWrapper(bCimClient);
                for (idx = 0; idx < mStorageVolumeCIMOPs.length; ++idx) {
                    DiskMessageHelper.getSRMMessage((String)"HWN021684I", (Object)pParam.getStorageVolumes()[idx].getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
                    String storageVolumeID = (String)ExternalKeyConverter.getStorageVolumeKey((StorageVolume)mStorageVolumes[idx], (String)pParam.getStorageSubsystemID(), (LogTraceHelper)mLTH);
                    AsyncResult mResult = new AsyncResult(-1, -1);
                    VolumeID mRes = new VolumeID();
                    mRes.setStorageVolumeID(storageVolumeID);
                    mResult.setResults((Object[])new VolumeID[]{mRes});
                    this.getVolumeManagement().deleteStorageVolume(storageVolumeID, mStorageVolumeCIMOPs[idx], mStorageVolumes[idx]);
                    mVolUpdate = this.getVolumeManagement().removeVolumeFromDB(mStorageVolumes[idx], mTouchedEntities, mDBConnection);
                    mPoolUpdate = this.getVolumeManagement().updatePool(pParam, mStorageVolumes[idx], mStorageVolumeCIMOPs[idx], mTouchedEntities);
                    if (mVolUpdate && mPoolUpdate) {
                        mResult.setSRMMessage("HWN020001I", new String[]{"deleteStorageVolumes"});
                        mResult.setRc(0);
                        mResult.setStatus(1);
                    } else {
                        mResult.setSRMMessage("HWN021693W", new String[0]);
                        mResult.setRc(-10001);
                        mResult.setStatus(3);
                    }
                    mAllResults.add(mResult);
                    DiskMessageHelper.getSRMMessage((String)"HWN021685I", (Object)pParam.getStorageVolumes()[idx].getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
                }
                if (mVolUpdate && mPoolUpdate) {
                    this.doSubsystemPostCollection(pParam, mTouchedEntities);
                    this.getVolumeManagement().processChangeDetection(mDBConnection, mTouchedEntities);
                }
                if (bCimClient == null) break block24;
            }
            catch (Exception e) {
                block25: {
                    try {
                        DiskMessageHelper.getSRMMessage((String)"HWN021686E", (Object)pParam.getStorageVolumes()[idx].getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
                        AsyncResult bResult = new AsyncResult();
                        ServerException bException = null;
                        int bRC = 10001;
                        for (int i = 0; i < mAllResults.size(); ++i) {
                            AsyncResult bFailureResult = (AsyncResult)mAllResults.elementAt(i);
                            if (bFailureResult == null || bFailureResult.getReturnException() == null) continue;
                            bException = (ServerException)((Object)bFailureResult.getReturnException());
                            bRC = bFailureResult.getRc();
                            break;
                        }
                        for (int k = mAllResults.size(); k < pParam.getStorageVolumes().length; ++k) {
                            String bVolumeID = (String)ExternalKeyConverter.getStorageVolumeKey((StorageVolume)pParam.getStorageVolumes()[k], (String)pParam.getStorageSubsystemID(), (LogTraceHelper)mLTH);
                            if (bException != null) {
                                this.setVolumeDeletionSubjobFailed(bResult, null, bVolumeID, bException, bRC, mLTH);
                            } else if (e instanceof ServerException) {
                                this.setVolumeDeletionSubjobFailed(bResult, null, bVolumeID, (ServerException)((Object)e), 10001, mLTH);
                            } else {
                                this.setVolumeDeletionSubjobFailed(bResult, null, bVolumeID, mLTH);
                            }
                            mAllResults.add(bResult);
                        }
                        if (bCimClient == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (bCimClient != null) {
                            CIMClientPool.returnClient(bCimClient);
                            bCimClient = null;
                        }
                        if (mDBConnection != null) {
                            try {
                                mDBConnection.close();
                            }
                            catch (SQLException e2) {
                                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e2, (LogTraceHelper)mLTH);
                            }
                        }
                        mLTH.exit(mAllResults);
                        throw throwable;
                    }
                    CIMClientPool.returnClient((CIMClientWrapper)bCimClient);
                    bCimClient = null;
                }
                if (mDBConnection != null) {
                    try {
                        mDBConnection.close();
                    }
                    catch (SQLException e3) {
                        throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e3, (LogTraceHelper)mLTH);
                    }
                }
                mLTH.exit(mAllResults);
            }
            CIMClientPool.returnClient((CIMClientWrapper)bCimClient);
            bCimClient = null;
        }
        if (mDBConnection != null) {
            try {
                mDBConnection.close();
            }
            catch (SQLException e) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
            }
        }
        mLTH.exit(mAllResults);
        return mAllResults.toArray(new AsyncResult[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSubsystemPostCollection(DeleteStorageVolumesParameter pParam, HashMap pTouchedEntities) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)pParam.getToken(), (Object)this, (String)"doSubsystemPostCollection", (Object[])new Object[]{pParam});
        boolean mSuccess = false;
        try {
            HashMap<String, String> mParameters = new HashMap<String, String>();
            mParameters.put("DEVICEID", String.valueOf(pParam.getStorageSubsystem().getSubsystemId()));
            mParameters.put("SUBSYSTEMID", pParam.getStorageSubsystemID());
            SubsystemPostCollectionProcess mProcess = new SubsystemPostCollectionProcess();
            mProcess.process(null, mParameters);
            LinkedList<String> list = new LinkedList<String>();
            list.add(String.valueOf(pParam.getStorageSubsystem().getSubsystemId()));
            pTouchedEntities.put(TResStorageSubsystemTable.getTablename(), list);
            mSuccess = true;
        }
        catch (Exception e) {
            DiskMessageHelper.getServerException((String)"HWN021693W", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit((Object)new Boolean(mSuccess));
        }
        return mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult assignStorageVolumesToWWPNs(AssignStorageVolumesParameter pParams) throws NotAvailableException, ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)pParams.getToken(), (Object)this, (String)"assignStorageVolumesToWWPNs", (Object[])new Object[]{pParams});
        pParams.setAsyncResult(new AsyncResult());
        pParams.getAsyncResult().setSubJobResults(new AsyncResult[0]);
        try {
            pParams.setAPIMethodName("assignStorageVolumesToWWPNs");
            this.validateAssignAccess(pParams);
            this.logAssignmentMessage("HWN021678I", pParams, mLTH);
            ArrayList mNewHardwareIDs = new ArrayList();
            ArrayList mStorageHardwareIDs = this.getHardwareIDManagement().getStorageHardwareIDs(pParams.getInitiatorWWPNs(), pParams.getHostNames(), pParams.getClientSettingDataCOP(), mNewHardwareIDs);
            ArrayList mProtocolControllers = this.getMappingManagement().getProtocolControllersForMappings(mStorageHardwareIDs, mNewHardwareIDs, pParams);
            this.cMappingManagement.mapVolumesToPorts(mProtocolControllers, pParams);
            this.logAssignmentMessage("HWN021679I", pParams, mLTH);
        }
        catch (ServerException e) {
            mLTH.traceError("Internal error: ServerException", (Throwable)e);
            ArrayList bResults = ConfigurationResultHelper.createEmptyMappingResultsForMissingMappings(pParams.getAsyncResult(), pParams.getVolumeIDs(), pParams.getInitiatorWWPNsArray(), pParams.getStorageSubsystemID(), "HWN021679I", "HWN021680E", pParams.getToken());
            ResultHelper.addAsyncSubResultsException((AsyncResult)pParams.getAsyncResult(), (ArrayList)bResults, (int)-1, (SRMMessage)e.getSRMMessage(), (Exception)((Object)e));
            pParams.getAsyncResult().setReturnException((Exception)((Object)e));
        }
        catch (Exception e) {
            mLTH.traceError("Internal error: Exception", (Throwable)e);
            ArrayList bResults = ConfigurationResultHelper.createEmptyMappingResultsForMissingMappings(pParams.getAsyncResult(), pParams.getVolumeIDs(), pParams.getInitiatorWWPNsArray(), pParams.getStorageSubsystemID(), "HWN021679I", "HWN021680E", pParams.getToken());
            SRMMessage bMsg = new SRMMessage("HWN021503E", new String[0]);
            ResultHelper.addAsyncSubResultsException((AsyncResult)pParams.getAsyncResult(), (ArrayList)bResults, (int)-1, (SRMMessage)bMsg, (Exception)e);
            pParams.getAsyncResult().setReturnException(e);
        }
        finally {
            mLTH.exit((Object)pParams.getAsyncResult());
        }
        return pParams.getAsyncResult();
    }

    protected void logAssignmentMessage(String pMessageID, AssignmentParameter pParams, LogTraceHelper pLTH) {
        if (pParams.getMappingsToModify() != null && pParams.getMappingsToModify().size() > 0) {
            if (pMessageID.equalsIgnoreCase("HWN021678I")) {
                pMessageID = "HWN021622I";
            } else if (pMessageID.equalsIgnoreCase("HWN021679I")) {
                pMessageID = "HWN021623I";
            } else if (pMessageID.equalsIgnoreCase("HWN021680E")) {
                pMessageID = "HWN021624E";
            }
            VolumeAssignmentModifyParams[] bModifyMappings = null;
            for (int i = 0; i < pParams.getVolumeIDs().length; ++i) {
                for (int j = 0; j < pParams.getInitiatorWWPNs().size(); ++j) {
                    bModifyMappings = VolumeAssignmentModifyParams.getAssignmentsOfInitiatorPortAndVolume(pParams.getMappingsToModify(), pParams.getInitiatorWWPNsArray()[j], pParams.getVolumeIDs()[i]);
                    DiskMessageHelper.getSRMMessage((String)pMessageID, (Object)pParams.getVolumes()[i].getDisplayName(), (Object)pParams.getStorageSubsystem().getDisplayName(), pParams.getInitiatorWWPNs().get(j), (Object)bModifyMappings[0].getTargetPortsToAddWWPNs(), (Object)bModifyMappings[0].getTargetPortsToRemoveWWPNs(), (LogTraceHelper)pLTH);
                }
            }
        } else {
            for (int i = 0; i < pParams.getVolumeIDs().length; ++i) {
                for (int j = 0; j < pParams.getInitiatorWWPNs().size(); ++j) {
                    DiskMessageHelper.getSRMMessage((String)pMessageID, (Object)pParams.getVolumes()[i].getDisplayName(), (Object)pParams.getStorageSubsystem().getDisplayName(), pParams.getInitiatorWWPNs().get(j), (LogTraceHelper)pLTH);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult unassignStorageVolumesFromWWPNs(AssignmentParameter pParams) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)pParams.getToken(), (Object)this, (String)"unassignStorageVolumesFromWWPNs", (Object[])new Object[]{pParams});
        try {
            pParams.setAsyncResult(new AsyncResult());
            pParams.getAsyncResult().setSubJobResults(new AsyncResult[0]);
            pParams.setAPIMethodName("unassignStorageVolumesFromWWPNs");
            this.validateUnAssignAccess(pParams);
            this.logAssignmentMessage("HWN021681I", pParams, mLTH);
            ArrayList mHardwareIDs = this.getHardwareIDManagement().retrieveStorageHardwareIDs(pParams.getInitiatorWWPNs(), true);
            ArrayList mProtocolControllers = this.getMappingManagement().retrieveProtocolControllersForUnmapping(mHardwareIDs, pParams.getVolumeCOPs());
            this.cMappingManagement.unmapVolumesFromPorts(mProtocolControllers, pParams, mHardwareIDs);
            this.logAssignmentMessage("HWN021682I", pParams, mLTH);
        }
        catch (ServerException e) {
            mLTH.traceError("Internal error: ServerException", (Throwable)e);
            ArrayList bResults = ConfigurationResultHelper.createEmptyMappingResultsForMissingMappings(pParams.getAsyncResult(), pParams.getVolumeIDs(), pParams.getInitiatorWWPNsArray(), pParams.getStorageSubsystemID(), "HWN021682I", "HWN021683E", pParams.getToken());
            ResultHelper.addAsyncSubResultsException((AsyncResult)pParams.getAsyncResult(), (ArrayList)bResults, (int)-1, (SRMMessage)e.getSRMMessage(), (Exception)((Object)e));
            pParams.getAsyncResult().setReturnException((Exception)((Object)e));
        }
        catch (Exception e) {
            mLTH.traceError("Internal error: Exception", (Throwable)e);
            ArrayList bResults = ConfigurationResultHelper.createEmptyMappingResultsForMissingMappings(pParams.getAsyncResult(), pParams.getVolumeIDs(), pParams.getInitiatorWWPNsArray(), pParams.getStorageSubsystemID(), "HWN021682I", "HWN021683E", pParams.getToken());
            SRMMessage bMsg = new SRMMessage("HWN021503E", new String[0]);
            ResultHelper.addAsyncSubResultsException((AsyncResult)pParams.getAsyncResult(), (ArrayList)bResults, (int)-1, (SRMMessage)bMsg, (Exception)e);
            pParams.getAsyncResult().setReturnException(e);
        }
        finally {
            mLTH.exit((Object)pParams.getAsyncResult());
        }
        return pParams.getAsyncResult();
    }

    public AsyncResult[] createSVCVDisks(CreateSVCStorageVolumesParameter pParam) throws NotAvailableException, Exception {
        return null;
    }

    public AsyncResult modifyStoragePoolSize(ModifyStoragePoolParameter pParam) throws NotAvailableException, Exception {
        return null;
    }

    public AsyncResult modifyStorageVolumeSize(ModifyStorageVolumeParameter pParam) throws NotAvailableException, Exception {
        return this.getVolumeManagement().modifyStorageVolumeSize(pParam);
    }

    public long[] getSupportedVolumeSizeRange(StoragePool pStoragePool, CIMObjectPath pStoragePoolCIMOP, int pDataRedundancy, int pPackageRedundancy, int pDeltaReservation) throws ServerException, InvalidParameterException, MissingParameterException {
        try {
            return this.getVolumeManagement().getSupportedSizeRange(pStoragePoolCIMOP, pDataRedundancy, pPackageRedundancy, (short)pDeltaReservation);
        }
        catch (ServerException e) {
            if (e.getSRMMessage().getMsgId().compareTo("HWN021514E") == 0 && e.getSRMMessage().getMsgInserts()[2].compareTo("2") == 0) {
                throw e;
            }
            return this.getVolumeManagement().getSupportedSizes(pStoragePoolCIMOP, null);
        }
    }

    public long[] getDefaultSupportedVolumeSizeRange(StoragePool pStoragePoolOP, CIMObjectPath pStoragePoolCIMOP) throws ServerException, InvalidParameterException, MissingParameterException {
        try {
            return this.getVolumeManagement().getSupportedSizeRange(pStoragePoolCIMOP, null);
        }
        catch (ServerException e) {
            if (e.getSRMMessage().getMsgId().compareTo("HWN021514E") == 0 && e.getSRMMessage().getMsgInserts()[2].compareTo("2") == 0) {
                return this.getDefaultSupportedVolumeSizes(pStoragePoolCIMOP);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getDefaultSupportedVolumeSizes(CIMObjectPath pStoragePoolCIMOP) throws ServerException, InvalidParameterException, MissingParameterException {
        long[] lArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.getParams().getToken(), (Object)this, (String)"getDefaultSupportedVolumeSizes", (Object[])new Object[]{pStoragePoolCIMOP});
        long[] mResult = null;
        try {
            ArrayList mCapabilitiesOfPool = this.getVolumeManagement().getCapabilitiesOfPool(pStoragePoolCIMOP);
            CIMObjectPath mSetting = this.getVolumeManagement().getSetting((CIMObjectPath)mCapabilitiesOfPool.get(0));
            lArray = mResult = this.getVolumeManagement().getSupportedSizes(pStoragePoolCIMOP, mSetting);
        }
        catch (Throwable throwable) {
            mLTH.exit(mResult);
            throw throwable;
        }
        mLTH.exit((Object)mResult);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateAssignAccess(AssignStorageVolumesParameter pParam) throws ServerException {
        String methodName = "validateAssignAccess";
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)pParam.getToken(), (Object)this, (String)methodName, (Object[])new Object[]{pParam});
        try {
            StorageVolume[] mStorageVols = pParam.getVolumes();
            Port[] mTargetPortInput = pParam.getTargetPorts();
            Port[] mSrcPorts = pParam.getInitiatorPorts();
            try {
                DBConnection con = ServiceUtils.getConnection();
                try {
                    for (int idx = 0; idx < mStorageVols.length; ++idx) {
                        Hashtable<ColumnInfo, String> bDataPathInfo = new Hashtable<ColumnInfo, String>();
                        bDataPathInfo.put(TResDataPathTable.getColumnInfo((String)"VOLUME_ID"), String.valueOf(mStorageVols[idx].getSvid()));
                        for (int idx2 = 0; idx2 < mSrcPorts.length; ++idx2) {
                            if (mSrcPorts[idx2] == null) continue;
                            bDataPathInfo.put(TResDataPathTable.getColumnInfo((String)"INITIATOR_PORT_ID"), String.valueOf(mSrcPorts[idx2].getPortId()));
                            DataPath.DataPathCursor cursor = DataPath.getCursor((DBConnection)con, bDataPathInfo, null);
                            if (cursor.next()) {
                                if (mTargetPortInput == null) {
                                    cursor.close();
                                    throw DiskMessageHelper.getServerException((String)"HWN021612E", (Object)mStorageVols[idx].getDisplayName(), (Object)mSrcPorts[idx2].getName(), (LogTraceHelper)mLTH);
                                }
                                if (pParam.getCapability().getPortsPerView() != 3 || pParam.getCapability().getSmisVersion().startsWith("1.0.")) {
                                    cursor.close();
                                    throw DiskMessageHelper.getServerException((String)"HWN021618E", (Object)pParam.getStorageSubsystemID(), (LogTraceHelper)mLTH);
                                }
                                this.checkForTargetPortChanges(pParam, cursor, mTargetPortInput, mStorageVols[idx], pParam.getVolumeIDs()[idx], mSrcPorts[idx2], con);
                            } else if (!pParam.getMappingsToModify().isEmpty()) {
                                cursor.close();
                                throw DiskMessageHelper.getServerException((String)"HWN021621E", (Object)pParam.getMappingsToModify(), (LogTraceHelper)mLTH);
                            }
                            cursor.close();
                        }
                    }
                    if (!pParam.getMappingsToModify().isEmpty()) {
                        Hashtable<ColumnInfo, String> bDataPathInfo = new Hashtable<ColumnInfo, String>();
                        for (int i = 0; i < mSrcPorts.length; ++i) {
                            VolumeAssignmentModifyParams[] mMappingsToModify = VolumeAssignmentModifyParams.getAssignmentsOfInitiatorPort(pParam.getMappingsToModify(), String.valueOf(mSrcPorts[i].getName()));
                            bDataPathInfo.put(TResDataPathTable.getColumnInfo((String)"INITIATOR_PORT_ID"), String.valueOf(mSrcPorts[i].getPortId()));
                            bDataPathInfo.put(TResDataPathTable.getColumnInfo((String)"SUBSYSTEM_ID"), String.valueOf(pParam.getStorageSubsystem().getSubsystemId()));
                            DataPath.DataPathCursor cursor = DataPath.getCursor((DBConnection)con, bDataPathInfo, null);
                            ArrayList<String> bAllVolumes = new ArrayList<String>();
                            while (cursor.next()) {
                                if (bAllVolumes.contains(String.valueOf(cursor.getObject().getVolumeId()))) continue;
                                bAllVolumes.add(String.valueOf(cursor.getObject().getVolumeId()));
                            }
                            cursor.close();
                            ArrayList mVolumesToModify = VolumeAssignmentModifyParams.getVolumeSVIDs(mMappingsToModify);
                            ArrayList mColleteralVolumes = new ArrayList();
                            if (bAllVolumes.size() <= mMappingsToModify.length) continue;
                            for (int j = 0; j < bAllVolumes.size(); ++j) {
                                if (mVolumesToModify.contains(bAllVolumes.get(j))) continue;
                                mColleteralVolumes.add(bAllVolumes.get(j));
                            }
                            throw DiskMessageHelper.getServerException((String)"HWN021619E", (Object)pParam.getMappingsToModify(), (LogTraceHelper)mLTH);
                        }
                    }
                    if (mTargetPortInput != null) {
                        StorageSubsystem mStgSubsystem = pParam.getStorageSubsystem();
                        for (int idx = 0; idx < mTargetPortInput.length; ++idx) {
                            if (mTargetPortInput[idx].getSubsystemId() == mStgSubsystem.getSubsystemId()) continue;
                            throw DiskMessageHelper.getServerException((String)"HWN021608E", null, (LogTraceHelper)mLTH);
                        }
                    }
                }
                finally {
                    if (con != null) {
                        con.close();
                    }
                }
            }
            catch (SQLException sqlEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sqlEx.getMessage(), (LogTraceHelper)mLTH);
            }
            catch (EntityNotFoundException e) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (LogTraceHelper)mLTH);
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForTargetPortChanges(AssignStorageVolumesParameter pParams, DataPath.DataPathCursor pCursor, Port[] pTargetPortInput, StorageVolume pStorageVol, String pVolumeID, Port pSrcPort, DBConnection pDBConnection) throws SQLException, EntityNotFoundException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"checkForTargetPortChanges", (Object[])new Object[0]);
        try {
            int i;
            ArrayList<String> mTargetPortIDs = new ArrayList<String>();
            ArrayList<Port> mTargetPortsMapped = new ArrayList<Port>();
            ArrayList<Port> mTargetPortsNotMapped = new ArrayList<Port>();
            ArrayList<String> mTargetPortsMappedIDs = new ArrayList<String>();
            ArrayList<Port> mTargetPortsToRemove = new ArrayList<Port>();
            mTargetPortIDs.add(String.valueOf(pCursor.getObject().getTargetPortId()));
            while (pCursor.next()) {
                mTargetPortIDs.add(String.valueOf(pCursor.getObject().getTargetPortId()));
            }
            for (i = 0; i < pTargetPortInput.length; ++i) {
                if (mTargetPortIDs.contains(String.valueOf(pTargetPortInput[i].getPortId()))) {
                    mTargetPortsMapped.add(pTargetPortInput[i]);
                    mTargetPortsMappedIDs.add(String.valueOf(pTargetPortInput[i].getPortId()));
                    continue;
                }
                mTargetPortsNotMapped.add(pTargetPortInput[i]);
            }
            for (i = 0; i < mTargetPortIDs.size(); ++i) {
                String mPortID = (String)mTargetPortIDs.get(i);
                if (mTargetPortsMappedIDs.contains(mPortID)) continue;
                Port bPort = ExternalKeyManager.getPort((String)mPortID, (DBConnection)pDBConnection);
                mTargetPortsToRemove.add(bPort);
            }
            if (mTargetPortsNotMapped.isEmpty() && mTargetPortsToRemove.isEmpty()) {
                pCursor.close();
                throw DiskMessageHelper.getServerException((String)"HWN021612E", (Object)pStorageVol.getDisplayName(), (Object)pSrcPort.getName(), (LogTraceHelper)mLTH);
            }
            VolumeAssignmentModifyParams mMapping = new VolumeAssignmentModifyParams(pVolumeID, pStorageVol, pSrcPort.getName());
            mMapping.setTargetPortsToAdd(mTargetPortsNotMapped);
            mMapping.setTargetPortsToRemove(mTargetPortsToRemove);
            pParams.addMappingsToModify(mMapping);
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateUnAssignAccess(AssignmentParameter pParam) throws ServerException {
        String methodName = "validateUnAssignAccess";
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)methodName, (Object[])new Object[]{pParam});
        try {
            try {
                DBConnection mConnection = ServiceUtils.getConnection();
                try {
                    StorageVolume[] mStorageVols = pParam.getVolumes();
                    Port[] mSrcPorts = this.setInitiatorPorts(pParam, mConnection, mLTH);
                    boolean alreadyAssigned = false;
                    block8: for (int idx = 0; idx < mStorageVols.length; ++idx) {
                        Hashtable<ColumnInfo, String> bDataPathInfo = new Hashtable<ColumnInfo, String>();
                        bDataPathInfo.put(TResDataPathTable.getColumnInfo((String)"VOLUME_ID"), String.valueOf(mStorageVols[idx].getSvid()));
                        for (int idx2 = 0; idx2 < mSrcPorts.length; ++idx2) {
                            if (mSrcPorts[idx2] == null) continue;
                            bDataPathInfo.put(TResDataPathTable.getColumnInfo((String)"INITIATOR_PORT_ID"), String.valueOf(mSrcPorts[idx2].getPortId()));
                            DataPath.DataPathCursor cursor = DataPath.getCursor((DBConnection)mConnection, bDataPathInfo, null);
                            if (!cursor.next()) continue;
                            alreadyAssigned = true;
                            continue block8;
                        }
                    }
                    if (!alreadyAssigned) {
                        ArrayList<String> bDisplayName = new ArrayList<String>();
                        for (int i = 0; i < pParam.getVolumes().length; ++i) {
                            bDisplayName.add(pParam.getVolumes()[i].getDisplayName());
                        }
                        throw DiskMessageHelper.getServerException((String)"HWN021522E", (Object)pParam.getInitiatorWWPNs(), bDisplayName, (LogTraceHelper)mLTH);
                    }
                }
                finally {
                    if (mConnection != null) {
                        mConnection.close();
                    }
                }
            }
            catch (SQLException sqlEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sqlEx.getMessage(), (LogTraceHelper)mLTH);
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    protected void setVolumeDeletionSubjobFailed(AsyncResult pAsyncRes, String pStoragePoolID, String pStorageVolumelID, ServerException pServerException, int pRC, LogTraceHelper mLTH) {
        pAsyncRes.setRc(pRC);
        VolumeID bVolumeID = new VolumeID();
        bVolumeID.setStoragePoolID(pStoragePoolID);
        bVolumeID.setStorageVolumeID(pStorageVolumelID);
        pAsyncRes.setResults(new Object[]{bVolumeID});
        pAsyncRes.setStatus(0);
        pAsyncRes.setReturnException((Exception)((Object)pServerException));
        pAsyncRes.setSRMMessage(pServerException.getSRMMessage());
        pAsyncRes.setRc(10001);
    }

    protected ServerException setVolumeDeletionSubjobFailed(AsyncResult pAsyncRes, String pStoragePoolID, String pStorageVolumeID, LogTraceHelper mLTH) {
        ServerException bException = DiskMessageHelper.getServerException((String)"HWN021503E", null, (LogTraceHelper)mLTH);
        this.setVolumeDeletionSubjobFailed(pAsyncRes, pStoragePoolID, pStorageVolumeID, bException, 10001, mLTH);
        return bException;
    }

    private Port[] setInitiatorPorts(AssignmentParameter pParam, DBConnection pConnection, LogTraceHelper pLTH) throws SQLException {
        if (pParam.getInitiatorPorts() == null) {
            ArrayList mInitiatorWWPNs = pParam.getInitiatorWWPNs();
            ArrayList<Port> mPorts = new ArrayList<Port>(mInitiatorWWPNs.size());
            for (int i = 0; i < mInitiatorWWPNs.size(); ++i) {
                String mWWPN = (String)mInitiatorWWPNs.get(i);
                Port mPort = new Port();
                mPort.setName(mWWPN);
                mPort.setNameFormat((short)1);
                if (mPort.retrieve(pConnection)) {
                    mPorts.add(mPort);
                    continue;
                }
                pLTH.traceInfo("No port found in db for WWPN " + mWWPN);
            }
            pParam.setInitiatorPorts(mPorts);
        }
        return pParam.getInitiatorPorts();
    }

    protected List extractUniquePorts(List pPrimary, List pSecondary) {
        ArrayList mResult = new ArrayList();
        for (int i = 0; i < pSecondary.size(); ++i) {
            for (int k = 0; k < pPrimary.size() && !((Port)pPrimary.get(k)).getName().equals(((Port)pSecondary.get(i)).getName()); ++k) {
                if (k != pPrimary.size() - 1) continue;
                mResult.add(pSecondary.get(i));
            }
        }
        return mResult;
    }

    protected List extractUnique(List pPrimary, List pSecondary, Comparator pComparator) {
        ArrayList mResult = new ArrayList();
        for (int i = 0; i < pSecondary.size(); ++i) {
            for (int k = 0; k < pPrimary.size() && pComparator.compare(pPrimary.get(k), pSecondary.get(i)) != 0; ++k) {
                if (k != pPrimary.size() - 1) continue;
                mResult.add(pSecondary.get(i));
            }
        }
        return mResult;
    }

    protected String[] convertPortListToStringArray(List pPortList) {
        String[] mInitiatorPortsFinalStr = new String[pPortList.size()];
        for (int i = 0; i < mInitiatorPortsFinalStr.length; ++i) {
            mInitiatorPortsFinalStr[i] = String.valueOf(((Port)pPortList.get(i)).getName());
        }
        return mInitiatorPortsFinalStr;
    }
}

