/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control.util;

import java.util.ArrayList;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;

public class VolumeAssignmentModifyParams {
    private String cVolumeKey;
    private StorageVolume cVolume;
    private String cInitiatorPortWWPN;
    private ArrayList cTargetPortsToAdd;
    private ArrayList cTargetPortsToRemove;

    public VolumeAssignmentModifyParams(String pVolumeID, StorageVolume pVolume, String pInitiatorPortWWPN) {
        this.cVolumeKey = pVolumeID;
        this.cVolume = pVolume;
        this.cInitiatorPortWWPN = pInitiatorPortWWPN;
    }

    public static VolumeAssignmentModifyParams[] getAssignmentsOfInitiatorPort(ArrayList mMappings, String pWWPN) {
        ArrayList mMappingsFound = new ArrayList();
        for (int i = 0; i < mMappings.size(); ++i) {
            if (!pWWPN.equalsIgnoreCase(((VolumeAssignmentModifyParams)mMappings.get(i)).getInitiatorPortWWPN())) continue;
            mMappingsFound.add(mMappings.get(i));
        }
        return mMappingsFound.toArray(new VolumeAssignmentModifyParams[0]);
    }

    public static VolumeAssignmentModifyParams[] getAssignmentsOfInitiatorPortAndVolume(ArrayList mMappings, String pWWPN, String pVolumeKey) {
        ArrayList mMappingsFound = new ArrayList();
        for (int i = 0; i < mMappings.size(); ++i) {
            if (!pWWPN.equalsIgnoreCase(((VolumeAssignmentModifyParams)mMappings.get(i)).getInitiatorPortWWPN()) || !pVolumeKey.equalsIgnoreCase(((VolumeAssignmentModifyParams)mMappings.get(i)).getVolumeKey())) continue;
            mMappingsFound.add(mMappings.get(i));
        }
        return mMappingsFound.toArray(new VolumeAssignmentModifyParams[0]);
    }

    public static ArrayList getVolumeSVIDs(VolumeAssignmentModifyParams[] mMappings) {
        ArrayList<String> mVolumeSVIDs = new ArrayList<String>();
        for (int i = 0; i < mMappings.length; ++i) {
            mVolumeSVIDs.add(String.valueOf(mMappings[i].getVolume().getSvid()));
        }
        return mVolumeSVIDs;
    }

    public String getInitiatorPortWWPN() {
        return this.cInitiatorPortWWPN;
    }

    public String getVolumeKey() {
        return this.cVolumeKey;
    }

    public void setInitiatorPortWWPN(String pString) {
        this.cInitiatorPortWWPN = pString;
    }

    public void setVolumeID(String pString) {
        this.cVolumeKey = pString;
    }

    public String[] getTargetPortsToAddWWPNs() {
        String[] mWWPNs = new String[this.cTargetPortsToAdd.size()];
        for (int i = 0; i < mWWPNs.length; ++i) {
            mWWPNs[i] = ((Port)this.cTargetPortsToAdd.get(i)).getName();
        }
        return mWWPNs;
    }

    public String[] getTargetPortsToRemoveWWPNs() {
        String[] mWWPNs = new String[this.cTargetPortsToRemove.size()];
        for (int i = 0; i < mWWPNs.length; ++i) {
            mWWPNs[i] = ((Port)this.cTargetPortsToRemove.get(i)).getName();
        }
        return mWWPNs;
    }

    public void setTargetPortsToAdd(ArrayList pList) {
        this.cTargetPortsToAdd = pList;
    }

    public void setTargetPortsToRemove(ArrayList pList) {
        this.cTargetPortsToRemove = pList;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("InitiatorPort: " + this.cInitiatorPortWWPN);
        sb.append("- Volume: " + this.cVolume.getDisplayName());
        return sb.toString();
    }

    public StorageVolume getVolume() {
        return this.cVolume;
    }

    public void setVolume(StorageVolume pVolume) {
        this.cVolume = pVolume;
    }
}

