/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.CIMExceptionResponse;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.ParameterHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerRTException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.discovery.Capabilities;
import org.eclipse.aperi.disk.discovery.DiscoveryException;
import org.eclipse.aperi.disk.discovery.DiscoveryProcessPlugin;
import org.eclipse.aperi.disk.discovery.StorageDeviceData;
import org.eclipse.aperi.disk.util.DiscoveryMessageHelper;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.ConfigData;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.sblim.wbem.cim.CIMAuthenticationException;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMTransportException;
import org.sblim.wbem.cim.UnsignedInt16;

public abstract class ProcessPlugin
implements DiscoveryProcessPlugin,
DiscoveryConstants,
CIMNames {
    protected MapperRouter cMapperRouter = null;
    protected Request cRequest = null;
    protected Map cParameters = null;
    protected static final String SEPARATOR = ",";
    protected JobInfo cObjectJob = null;
    protected String cCIMOMExclusions = null;
    protected DiskCIMProcessor cDiskCimProcessor = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessPlugin() {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"ProcessPlugin", null);
        try {
            mLTH.objectCreation(ProcessPlugin.class.getName());
            mLTH.objectCreation(ProcessPlugin.class.getName());
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRequest(Request pRequest, Map pParameters, DiskCIMProcessor pDiskCIMProcessor) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)pRequest, (Object)this, (String)"ProcessPlugin", (Object[])new Object[]{pRequest, pParameters});
        try {
            this.cRequest = pRequest;
            this.cParameters = pParameters;
            this.cDiskCimProcessor = pDiskCIMProcessor;
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getStorageProfiles() throws DiscoveryException {
        String mMethodName = "getStorageProfiles";
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)mMethodName, (Object[])new Object[0]);
        Vector<CIMInstance> mList = new Vector<CIMInstance>();
        try {
            String[] mRegProfiles = Router.getRouter().perform("RegisteredProfile", this.cParameters, new Integer(this.cRequest.getId()).toString());
            Router.getRouter().waitTilComplete(mRegProfiles);
            JobInfo mJob = (JobInfo)JobEngine.getInstance().getJobs(mRegProfiles[1]).get(0);
            if (!mJob.isSuccessful()) {
                mLTH.traceInfo(mMethodName + " returns false");
                Vector<CIMInstance> vector = mList;
                return vector;
            }
            Response mResponse = mJob.getResponse();
            if (mResponse instanceof Response) {
                Enumeration mRegProfEnum = (Enumeration)mResponse.getData();
                while (mRegProfEnum.hasMoreElements()) {
                    CIMInstance mProfInst = (CIMInstance)mRegProfEnum.nextElement();
                    mList.add(mProfInst);
                }
            }
            Vector<CIMInstance> vector = mList;
            return vector;
        }
        finally {
            mLTH.exit(mList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getSystemsForProfile(CIMInstance pProfile) throws DiscoveryException {
        String mMethodName = "getSystemsForProfile";
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)mMethodName, (Object[])new Object[]{pProfile});
        Vector<CIMInstance> mList = new Vector<CIMInstance>();
        try {
            CIMInstance mInstance = null;
            this.cParameters.put("IN_SYSTEM_COMPUTERSYSTEM", pProfile);
            String[] mObjectManager = Router.getRouter().perform("COMPUTERSYSTEM", this.cParameters, new Integer(this.cRequest.getId()).toString());
            Router.getRouter().waitTilComplete(mObjectManager);
            JobInfo mObjectJob = (JobInfo)JobEngine.getInstance().getJobs(mObjectManager[1]).get(0);
            if (!mObjectJob.isSuccessful()) {
                this.checkJobSuccessful(mMethodName, mLTH, mObjectJob, "COMPUTERSYSTEM");
            }
            Response mResponse = mObjectJob.getResponse();
            Enumeration mObjMgrEnum = (Enumeration)mResponse.getData();
            while (mObjMgrEnum.hasMoreElements()) {
                mInstance = (CIMInstance)mObjMgrEnum.nextElement();
                mList.add(mInstance);
            }
            Vector<CIMInstance> vector = mList;
            return vector;
        }
        finally {
            mLTH.exit(mList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getProductOfSystem(CIMInstance pSystem, StorageDeviceData pDeviceData, boolean pSerialnumber) throws DiscoveryException {
        String mMethodName = "getProductOfSystem";
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)mMethodName, (Object[])new Object[]{pSystem, pDeviceData});
        try {
            Response mResponse;
            Enumeration mObjMgrEnum;
            CIMInstance mInstance = pDeviceData.getInstance("product");
            if (mInstance != null) {
                return;
            }
            this.cParameters.put("IN_SYSTEM_PHYSICALPACKAGING", pSystem);
            String[] mProductManager = null;
            Response mProductResponse = null;
            String[] mManager = Router.getRouter().perform("PHYSICALPACKAGING", this.cParameters, new Integer(this.cRequest.getId()).toString());
            Router.getRouter().waitTilComplete(mManager);
            JobInfo mObjectJob = (JobInfo)JobEngine.getInstance().getJobs(mManager[1]).get(0);
            if (!mObjectJob.isSuccessful()) {
                this.checkJobSuccessful(mMethodName, mLTH, mObjectJob, "PHYSICALPACKAGING");
            }
            if ((mObjMgrEnum = (Enumeration)(mResponse = mObjectJob.getResponse()).getData()).hasMoreElements()) {
                Enumeration mProductEnum;
                mInstance = (CIMInstance)mObjMgrEnum.nextElement();
                if (pDeviceData.getInstance("physicalpackage") == null && pSerialnumber) {
                    pDeviceData.setDataFromInstance("physicalpackage", mInstance, mLTH);
                }
                this.cParameters.put("IN_SYSTEM_product", mInstance);
                mProductManager = Router.getRouter().perform("product", this.cParameters, new Integer(this.cRequest.getId()).toString());
                Router.getRouter().waitTilComplete(mProductManager);
                JobInfo mProductJob = (JobInfo)JobEngine.getInstance().getJobs(mProductManager[1]).get(0);
                if (!mProductJob.isSuccessful()) {
                    this.checkJobSuccessful(mMethodName, mLTH, mObjectJob, "product");
                }
                if ((mProductEnum = (Enumeration)(mProductResponse = mProductJob.getResponse()).getData()).hasMoreElements()) {
                    CIMInstance mProductInstance = (CIMInstance)mProductEnum.nextElement();
                    pDeviceData.setDataFromInstance("product", mProductInstance, mLTH);
                }
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getNodesOfCluster(CIMInstance pDevice) throws DiscoveryException {
        String mMethodName = "getNodesOfCluster";
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)mMethodName, (Object[])new Object[]{pDevice});
        CIMInstance mInstance = null;
        Vector<CIMInstance> mList = new Vector<CIMInstance>();
        try {
            this.cParameters.put("IN_SYSTEM_NOTESOFCLUSTER", pDevice);
            String[] mManager = Router.getRouter().perform("NOTESOFCLUSTER", this.cParameters, new Integer(this.cRequest.getId()).toString());
            Router.getRouter().waitTilComplete(mManager);
            JobInfo mObjectJob = (JobInfo)JobEngine.getInstance().getJobs(mManager[1]).get(0);
            if (!mObjectJob.isSuccessful()) {
                this.checkJobSuccessful(mMethodName, mLTH, mObjectJob, "NOTESOFCLUSTER");
            }
            Response mResponse = mObjectJob.getResponse();
            Enumeration mObjMgrEnum = (Enumeration)mResponse.getData();
            while (mObjMgrEnum.hasMoreElements()) {
                mInstance = (CIMInstance)mObjMgrEnum.nextElement();
                mList.add(mInstance);
            }
            Vector<CIMInstance> vector = mList;
            return vector;
        }
        finally {
            mLTH.exit(mList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getSoftwareOfDevice(CIMInstance pDevice, StorageDeviceData pDeviceData) throws DiscoveryException {
        String mMethodName = "getSoftwareOfDevice";
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)mMethodName, (Object[])new Object[]{pDevice, pDeviceData});
        CIMInstance mInstance = null;
        try {
            if (!this.supportsSubProfile(pDeviceData.getSubProfile(), "Software")) {
                mLTH.traceInfo("Device does not support software subprofile");
                return;
            }
            this.cParameters.put("IN_SYSTEM_SOFTWAREIDENTITY", pDevice);
            String[] mManager = Router.getRouter().perform("SOFTWAREIDENTITY", this.cParameters, new Integer(this.cRequest.getId()).toString());
            Router.getRouter().waitTilComplete(mManager);
            JobInfo mObjectJob = (JobInfo)JobEngine.getInstance().getJobs(mManager[1]).get(0);
            if (!mObjectJob.isSuccessful()) {
                this.checkJobSuccessful(mMethodName, mLTH, mObjectJob, "SOFTWAREIDENTITY");
            }
            Response mResponse = mObjectJob.getResponse();
            Enumeration mObjMgrEnum = (Enumeration)mResponse.getData();
            while (mObjMgrEnum.hasMoreElements()) {
                mInstance = (CIMInstance)mObjMgrEnum.nextElement();
                pDeviceData.setDataFromInstance("software", mInstance, mLTH);
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSubProfileString(CIMInstance pProfile) throws DiscoveryException {
        String mMethodName = "getSubProfileString";
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)mMethodName, (Object[])new Object[]{pProfile});
        String mReturn = null;
        try {
            if (pProfile != null) {
                CIMInstance mInstance = null;
                StringBuffer mBuffer = new StringBuffer();
                this.cParameters.put("IN_SYSTEM_SUBPROFILE", pProfile);
                String[] mManager = Router.getRouter().perform("SUBPROFILE", this.cParameters, new Integer(this.cRequest.getId()).toString());
                Router.getRouter().waitTilComplete(mManager);
                JobInfo mObjectJob = (JobInfo)JobEngine.getInstance().getJobs(mManager[1]).get(0);
                if (!mObjectJob.isSuccessful()) {
                    this.checkJobSuccessful(mMethodName, mLTH, mObjectJob, "SUBPROFILE");
                }
                Response mResponse = mObjectJob.getResponse();
                Enumeration mObjMgrEnum = (Enumeration)mResponse.getData();
                while (mObjMgrEnum.hasMoreElements()) {
                    mInstance = (CIMInstance)mObjMgrEnum.nextElement();
                    String mValue = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"RegisteredName");
                    mValue = mValue.replaceAll(SEPARATOR, "");
                    mBuffer.append(mValue + SEPARATOR);
                }
                mReturn = mBuffer.toString();
                mReturn = mReturn.endsWith(SEPARATOR) ? mReturn.toString().substring(0, mReturn.length() - 1) : mReturn;
            }
            String string = mReturn;
            return string;
        }
        finally {
            mLTH.exit(mReturn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getSAPForSystem(CIMInstance pSystem, StorageDeviceData pDeviceData) throws DiscoveryException {
        String mMethodName = "getSAPForSystem";
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)mMethodName, (Object[])new Object[]{pSystem, pDeviceData});
        try {
            if (!this.supportsSubProfile(pDeviceData.getSubProfile(), "Access Point") && !this.supportsSubProfile(pDeviceData.getSubProfile(), "Access Points")) {
                mLTH.traceInfo("Device does not support remote service access point subprofile");
                return;
            }
            CIMInstance mInstance = null;
            this.cParameters.put("IN_SYSTEM_REMOTESERVICE", pSystem);
            String[] mManager = Router.getRouter().perform("REMOTESERVICE", this.cParameters, new Integer(this.cRequest.getId()).toString());
            Router.getRouter().waitTilComplete(mManager);
            JobInfo mObjectJob = (JobInfo)JobEngine.getInstance().getJobs(mManager[1]).get(0);
            if (!mObjectJob.isSuccessful()) {
                this.checkJobSuccessful(mMethodName, mLTH, mObjectJob, "REMOTESERVICE");
            }
            Response mResponse = mObjectJob.getResponse();
            Enumeration mObjMgrEnum = (Enumeration)mResponse.getData();
            while (mObjMgrEnum.hasMoreElements()) {
                mInstance = (CIMInstance)mObjMgrEnum.nextElement();
                pDeviceData.setDataFromInstance("accessPoint", mInstance, mLTH);
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    public List collectDeviceData(String pObjectManagerID, String pCIMOMVersion) throws DiscoveryException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleComputerSystem(List mDeviceList, CIMInstance mProfileInstance, String mSubProfile, List mSystemList) throws DiscoveryException {
        LogTraceHelper mLTH;
        block6: {
            mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)"handleComputerSystem", (Object[])new Object[]{mDeviceList, mProfileInstance, mSubProfile, mSystemList});
            boolean mHasDevices = false;
            try {
                for (CIMInstance mComputerSystem : mSystemList) {
                    if (mSubProfile == null || mSubProfile.length() <= 0) {
                        mSubProfile = this.getSubProfileString(mProfileInstance);
                    }
                    mSubProfile = this.correctSubProfileString(mSubProfile);
                    StorageDeviceData mDeviceData = new StorageDeviceData();
                    mDeviceData.setDataFromInstance("", mComputerSystem, mLTH);
                    mDeviceList.add(new Object[]{mDeviceData, mComputerSystem});
                    mDeviceData.setSubProfile(mSubProfile);
                    mDeviceData.setNameSpace(mComputerSystem.getObjectPath().getNameSpace());
                    Capabilities mCap = null;
                    if (mProfileInstance != null) {
                        mDeviceData.setSMISVersion((String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mProfileInstance, (String)"RegisteredVersion"));
                        String mProfile = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mProfileInstance, (String)"RegisteredName");
                        mDeviceData.setProfile(mProfile);
                        mCap = mDeviceData.getCapabilities();
                        mCap.checkSubProfile(mSubProfile);
                        mCap.setSMISProfile(mProfile);
                    }
                    mDeviceData.setCapabilities(mCap);
                    mLTH.traceInfo("New StorageDevice for :" + CIMInstanceHelper.getCIMProperyValue((CIMInstance)mComputerSystem, (String)"Name"));
                    mHasDevices = true;
                }
                if (mHasDevices) break block6;
            }
            catch (Throwable throwable) {
                if (!mHasDevices) {
                    mLTH.logMsg("HWN021726I", new Object[]{((String[])this.cParameters.get("CIMOM"))[0]});
                }
                mLTH.exit(null);
                throw throwable;
            }
            mLTH.logMsg("HWN021726I", new Object[]{((String[])this.cParameters.get("CIMOM"))[0]});
        }
        mLTH.exit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable saveNameSpace(LogTraceHelper pLTH, MapperRouter pMapperRouter, String pScannID, String pNameSpace, String pCIMOMVersion) throws SQLException {
        Hashtable<String, String> mParam = new Hashtable<String, String>();
        Hashtable mKeyReferences = new Hashtable();
        MapperResult mResult = null;
        try {
            if (pNameSpace != null) {
                String[] mCIMOM = (String[])this.cParameters.get("CIMOM");
                mParam.put("ref_serviceurl", mCIMOM[0]);
                mParam.put("namespace", pNameSpace);
                if (pCIMOMVersion != null) {
                    mParam.put("software_level", pCIMOMVersion);
                }
                this.cDiskCimProcessor.setSMISVersion("");
                this.cDiskCimProcessor.setInstrumentationVersion("");
                mResult = this.cDiskCimProcessor.handleEntity("", "SLP", mParam);
                mKeyReferences = mResult.getKeyReferences();
                pLTH.traceInfo("saveNamespace");
            }
        }
        catch (org.eclipse.aperi.discovery.interfaces.DiscoveryException pEx) {
            if (pEx.getCause() instanceof SQLException) {
                throw (SQLException)pEx.getCause();
            }
            pLTH.traceInfo("not handeled " + pEx.getCause().getMessage());
        }
        finally {
            return mKeyReferences;
        }
    }

    protected MapperRouter getMapperRouter() {
        if (this.cMapperRouter == null) {
            this.cMapperRouter = MapperRouter.getMapperRouter();
        }
        return this.cMapperRouter;
    }

    protected void saveSoftware(Object[] pArray, LogTraceHelper pLTH, MapperRouter pMapperRouter, String pScannID, Hashtable pReturnValue) throws SQLException {
        Hashtable mParam = null;
        try {
            CIMInstance mInstance = ((StorageDeviceData)pArray[0]).getInstance("software");
            if (mInstance != null) {
                mParam = CIMInstanceHelper.changeCIMInstanceToHashtable((CIMInstance)mInstance);
                mParam.putAll(pReturnValue);
                this.cDiskCimProcessor.setSMISVersion(((StorageDeviceData)pArray[0]).getSMISVersion());
                this.cDiskCimProcessor.setInstrumentationVersion(((String[])this.cParameters.get("CIMOM"))[5]);
                mParam.put("originalcimclassname", "CIM_SoftwareIdentity");
                this.cDiskCimProcessor.handleEntity("", mInstance.getClassName(), mParam);
            } else {
                pLTH.traceInfo("No Software found");
            }
        }
        catch (org.eclipse.aperi.discovery.interfaces.DiscoveryException pEx) {
            if (pEx.getCause() instanceof SQLException) {
                throw (SQLException)pEx.getCause();
            }
            pLTH.traceInfo("not handeled " + pEx.getCause().getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveCapabilities(Object[] pArray, MapperRouter pMapperRouter, String pScannID, Hashtable pReturnValue) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)"saveCapabilities", (Object[])new Object[]{pMapperRouter, pScannID, pReturnValue});
        try {
            Hashtable mParam = null;
            StorageDeviceData mStorDevData = (StorageDeviceData)pArray[0];
            if (!("Array".equalsIgnoreCase(mStorDevData.getProfile()) || "In Band Virtualization".equalsIgnoreCase(mStorDevData.getProfile()) || "Storage Library".equalsIgnoreCase(mStorDevData.getProfile()))) {
                return;
            }
            Capabilities mCapab = mStorDevData.getCapabilities();
            if (mCapab.getSMISVersion() == null || mCapab.getSMISVersion().length() == 0) {
                mCapab.setSMISVersion(mStorDevData.getSMISVersion());
            }
            mParam = mCapab.toHashtable(mLTH);
            mParam.putAll(pReturnValue);
            this.cDiskCimProcessor.setSMISVersion(((StorageDeviceData)pArray[0]).getSMISVersion());
            this.cDiskCimProcessor.setInstrumentationVersion(((String[])this.cParameters.get("CIMOM"))[5]);
            String mType = "CapabilityData";
            if ("Storage Library".equalsIgnoreCase(((StorageDeviceData)pArray[0]).getProfile())) {
                mType = mType + "SML";
            }
            this.cDiskCimProcessor.handleEntity("", mType, mParam);
            mLTH.traceInfo("saveCapabilities");
        }
        catch (org.eclipse.aperi.discovery.interfaces.DiscoveryException pEx) {
            if (pEx.getCause() instanceof SQLException) {
                throw (SQLException)pEx.getCause();
            }
            mLTH.traceInfo("not handeled " + pEx.getCause().getMessage());
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveNodes(Object[] pArray, LogTraceHelper pLTH, MapperRouter pMapperRouter, String pScannID, Hashtable pReturnValue) throws SQLException {
        Hashtable mParam = null;
        try {
            int mLoop = 1;
            CIMInstance mInstance = ((StorageDeviceData)pArray[0]).getInstance("node_" + mLoop);
            while (mInstance != null) {
                mParam = CIMInstanceHelper.changeCIMInstanceToHashtable((CIMInstance)mInstance);
                mParam.putAll(pReturnValue);
                Vector mDedVector = (Vector)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"Dedicated");
                String mDed = null;
                mDed = mDedVector != null ? mDedVector.toString() : "0";
                this.cDiskCimProcessor.setSMISVersion(((StorageDeviceData)pArray[0]).getSMISVersion());
                this.cDiskCimProcessor.setInstrumentationVersion(((String[])this.cParameters.get("CIMOM"))[5]);
                this.cDiskCimProcessor.setDedicated(mDed);
                mParam.put("originalcimclassname", "CIM_ComputerSystem");
                this.cDiskCimProcessor.handleEntity("", mInstance.getClassName(), mParam);
                pLTH.traceInfo("saveNode " + mLoop);
                mInstance = ((StorageDeviceData)pArray[0]).getInstance("node_" + ++mLoop);
            }
        }
        catch (org.eclipse.aperi.discovery.interfaces.DiscoveryException pEx) {
            if (pEx.getCause() instanceof SQLException) {
                throw (SQLException)pEx.getCause();
            }
            pLTH.traceInfo("not handeled " + pEx.getCause().getMessage());
        }
        finally {
            this.cDiskCimProcessor.setDedicated(null);
        }
    }

    protected void saveProduct(Object[] pArray, LogTraceHelper pLTH, MapperRouter pMapperRouter, String pScannID, Hashtable pReturnValue) throws SQLException {
        Hashtable mParam = null;
        try {
            CIMInstance mInstance = ((StorageDeviceData)pArray[0]).getInstance("product");
            if (mInstance != null) {
                mParam = CIMInstanceHelper.changeCIMInstanceToHashtable((CIMInstance)mInstance);
                mParam.putAll(pReturnValue);
                this.cDiskCimProcessor.setSMISVersion(((StorageDeviceData)pArray[0]).getSMISVersion());
                this.cDiskCimProcessor.setInstrumentationVersion(((String[])this.cParameters.get("CIMOM"))[5]);
                mParam.put("originalcimclassname", "CIM_Product");
                this.cDiskCimProcessor.handleEntity("", mInstance.getClassName(), mParam);
                pLTH.traceInfo("saveProduct");
            } else {
                pLTH.traceInfo("No product available!");
            }
        }
        catch (org.eclipse.aperi.discovery.interfaces.DiscoveryException pEx) {
            if (pEx.getCause() instanceof SQLException) {
                throw (SQLException)pEx.getCause();
            }
            pLTH.traceInfo("not handeled " + pEx.getCause().getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable saveSubSystem(Object[] pArray, LogTraceHelper pLTH, MapperRouter pMapperRouter, String pScannID, Hashtable pSlpKeyReferences) throws SQLException {
        Hashtable mReturn = null;
        try {
            CIMInstance mInstance = ((StorageDeviceData)pArray[0]).getInstance("");
            String mName = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"Name") + "/" + (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"ElementName");
            mReturn = new Hashtable();
            if (mInstance != null) {
                String mSerialNumber;
                Hashtable mParam = CIMInstanceHelper.changeCIMInstanceToHashtable((CIMInstance)mInstance);
                mParam.putAll(pSlpKeyReferences);
                CIMInstance mPhyPackage = ((StorageDeviceData)pArray[0]).getInstance("physicalpackage");
                if (mPhyPackage != null && (mSerialNumber = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mPhyPackage, (String)"SerialNumber")) != null) {
                    mParam.put("SerialNumber", mSerialNumber);
                }
                pLTH.traceInfo("SaveSubSystem Name: " + mName + " SMIS:" + ((StorageDeviceData)pArray[0]).getSMISVersion() + " CIMOM Version:" + ((String[])this.cParameters.get("CIMOM"))[5]);
                ((StorageDeviceData)pArray[0]).addAccessInfo(mParam);
                this.cDiskCimProcessor.setSMISVersion(((StorageDeviceData)pArray[0]).getSMISVersion());
                this.cDiskCimProcessor.setInstrumentationVersion(((String[])this.cParameters.get("CIMOM"))[5]);
                mParam.put("originalcimclassname", "CIM_ComputerSystem");
                Object mDedObj = CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"Dedicated");
                if (mDedObj != null) {
                    String mDedicated = mDedObj.toString();
                    this.cDiskCimProcessor.setDedicated(mDedicated);
                    MapperResult mResult = this.cDiskCimProcessor.handleEntity("", mInstance.getClassName(), mParam);
                    mReturn = mResult.getKeyReferences();
                    pLTH.traceInfo("saveProduct");
                    pLTH.logMsg("HWN021725I", new Object[]{mName, ((String[])this.cParameters.get("CIMOM"))[0]});
                } else {
                    pLTH.traceInfo("No dedicated field available!");
                }
            } else {
                pLTH.traceInfo("No Subsystem available!");
            }
        }
        catch (org.eclipse.aperi.discovery.interfaces.DiscoveryException pEx) {
            if (pEx.getCause() instanceof SQLException) {
                throw (SQLException)pEx.getCause();
            }
            pLTH.traceInfo("not handeled " + pEx.getCause().getMessage());
        }
        finally {
            this.cDiskCimProcessor.setDedicated(null);
        }
        return mReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getCapabilitiesOfDevice(CIMInstance pInstance, StorageDeviceData pData) throws DiscoveryException {
        String mMethodName = "getCapabilitiesOfDevice";
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)mMethodName, (Object[])new Object[]{pInstance, pData});
        CIMInstance mInstance = null;
        try {
            if ("Array".equalsIgnoreCase(pData.getProfile()) || "In Band Virtualization".equalsIgnoreCase(pData.getProfile())) {
                Response mResponse;
                Enumeration mObjMgrEnum;
                this.cParameters.put("IN_SYSTEM_CAPABILITIES", pInstance);
                String[] mManager = Router.getRouter().perform("CAPABILITIES", this.cParameters, new Integer(this.cRequest.getId()).toString());
                Router.getRouter().waitTilComplete(mManager);
                JobInfo mObjectJob = (JobInfo)JobEngine.getInstance().getJobs(mManager[1]).get(0);
                if (!mObjectJob.isSuccessful()) {
                    this.checkJobSuccessful(mMethodName, mLTH, mObjectJob, "CONFIGURATIONSERVICE");
                }
                if ((mObjMgrEnum = (Enumeration)(mResponse = mObjectJob.getResponse()).getData()).hasMoreElements()) {
                    mInstance = (CIMInstance)mObjMgrEnum.nextElement();
                    Capabilities mCap = pData.getCapabilities();
                    mCap.insertCapabilities(mInstance, this.cRequest);
                    pData.setCapabilities(mCap);
                    if (pData.getSMISVersion().compareToIgnoreCase("1.1.0") == 0) {
                        mLTH.traceInfo("Capabilities for 1.1.0");
                        pData.setCapabilities(this.getCapabilitiesOfDeviceFor_110(pInstance, mCap));
                    }
                }
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    public void checkJobSuccessful(String pMethodName, LogTraceHelper pLTH, JobInfo pObjectJob, String pType) throws DiscoveryException {
        DiscoveryException mEx = null;
        Throwable bEx = null;
        Object mObject = pObjectJob.getResponse().getData();
        if (mObject instanceof CIMException) {
            bEx = (Throwable)((CIMExceptionResponse)pObjectJob.getResponse()).getData();
        } else if (mObject instanceof DiskManagerRTException) {
            Throwable bExRt = (Throwable)((CIMExceptionResponse)pObjectJob.getResponse()).getData();
            while (bExRt.getCause() != null) {
                if ((bExRt = bExRt.getCause()) instanceof CIMException) {
                    bEx = bExRt;
                    break;
                }
                bEx = null;
            }
        } else {
            pLTH.traceInfo("No instance of CIMException");
            bEx = null;
        }
        if (bEx != null && bEx instanceof CIMTransportException || bEx != null && bEx instanceof CIMException && bEx.getMessage().indexOf("UNABLE_TO_CONNECT") > 0) {
            pLTH.traceError("CIMOM connection Failure", bEx);
            mEx = DiscoveryMessageHelper.getDiscoveryException((String)(pMethodName + pType), (String)"HWN021537E", (String[])new String[]{((String[])this.cParameters.get("CIMOM"))[0], bEx.getMessage()}, (JobInfo)pObjectJob, (LogTraceHelper)pLTH);
        } else if (bEx != null && bEx instanceof CIMAuthenticationException) {
            pLTH.traceError("CIMOM authentication Failure", bEx);
            mEx = DiscoveryMessageHelper.getDiscoveryException((String)(pMethodName + pType), (String)"HWN021538E", (String[])new String[]{(String)this.cParameters.get("USERID"), ((String[])this.cParameters.get("CIMOM"))[0], bEx.getMessage()}, (JobInfo)pObjectJob, (LogTraceHelper)pLTH);
        } else if (bEx != null && bEx instanceof CIMException && bEx.getMessage().indexOf("ERR_TIME_OUT") > 0) {
            pLTH.traceError("CIMOM timout Failure", bEx);
            mEx = DiscoveryMessageHelper.getDiscoveryException((String)(pMethodName + pType), (String)"HWN021650E", (String[])new String[]{((String[])this.cParameters.get("CIMOM"))[0]}, (JobInfo)pObjectJob, (LogTraceHelper)pLTH);
        } else if (mObject != null && mObject instanceof DiskManagerTimeoutException) {
            pLTH.traceError("CIMOM timout Failure", bEx);
            mEx = DiscoveryMessageHelper.getDiscoveryException((String)(pMethodName + pType), (String)"HWN021650E", (String[])new String[]{((String[])this.cParameters.get("CIMOM"))[0]}, (JobInfo)pObjectJob, (LogTraceHelper)pLTH);
        } else if (bEx != null && bEx instanceof CIMException) {
            pLTH.traceError("CIMOM timout Failure", bEx);
            mEx = DiscoveryMessageHelper.getDiscoveryException((String)(pMethodName + pType), (String)"HWN021529E", (String[])new String[]{((String[])this.cParameters.get("CIMOM"))[0]}, (JobInfo)pObjectJob, (LogTraceHelper)pLTH);
        } else {
            mEx = DiscoveryMessageHelper.getDiscoveryException((String)(pMethodName + pType), (String)"HWN021503E", (String[])new String[0], (JobInfo)pObjectJob, (LogTraceHelper)pLTH);
        }
        throw mEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Capabilities getCapabilitiesOfDeviceFor_110(CIMInstance pInstance, Capabilities pCap) throws DiscoveryException {
        String mMethodName = "getCapabilitiesOfDeviceFor_110";
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)mMethodName, (Object[])new Object[]{pInstance, pCap});
        try {
            Response mResponse;
            Enumeration mObjMgrEnum;
            CIMInstance mInstance = null;
            this.cParameters.put("IN_SYSTEM_CONFIGURATIONSERVICE", pInstance);
            String[] mManager = Router.getRouter().perform("CONFIGURATIONSERVICE", this.cParameters, new Integer(this.cRequest.getId()).toString());
            Router.getRouter().waitTilComplete(mManager);
            JobInfo mObjectJob = (JobInfo)JobEngine.getInstance().getJobs(mManager[1]).get(0);
            if (!mObjectJob.isSuccessful()) {
                this.checkJobSuccessful(mMethodName, mLTH, mObjectJob, "CONFIGURATIONSERVICE");
            }
            if ((mObjMgrEnum = (Enumeration)(mResponse = mObjectJob.getResponse()).getData()).hasMoreElements()) {
                mInstance = (CIMInstance)mObjMgrEnum.nextElement();
                this.cParameters.put("IN_SYSTEM_CONFIGURATIONCAPABILITIES", mInstance);
                mManager = Router.getRouter().perform("CONFIGURATIONCAPABILITIES", this.cParameters, new Integer(this.cRequest.getId()).toString());
                Router.getRouter().waitTilComplete(mManager);
                mObjectJob = (JobInfo)JobEngine.getInstance().getJobs(mManager[1]).get(0);
                if (!mObjectJob.isSuccessful()) {
                    this.checkJobSuccessful(mMethodName, mLTH, mObjectJob, "CONFIGURATIONCAPABILITIES");
                }
                mResponse = mObjectJob.getResponse();
                mObjMgrEnum = (Enumeration)mResponse.getData();
                while (mObjMgrEnum.hasMoreElements()) {
                    Vector mASSA;
                    Vector mSSA;
                    mInstance = (CIMInstance)mObjMgrEnum.nextElement();
                    Vector mSSPF = (Vector)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"SupportedStoragePoolFeatures");
                    if (mSSPF == null) {
                        mSSPF = new Vector();
                    }
                    if ((mSSA = (Vector)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"SupportedSynchronousActions")) == null) {
                        mSSA = new Vector();
                    }
                    if ((mASSA = (Vector)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"SupportedAsynchronousActions")) != null) {
                        mSSA.addAll(mASSA);
                    }
                    if (mSSPF.contains(new UnsignedInt16(3)) || mSSA.contains(new UnsignedInt16(5))) {
                        pCap.setVolumeCreationSupported(true);
                        mLTH.traceInfo("Capabilities set volumecreation true");
                    } else {
                        pCap.setVolumeCreationSupported(false);
                        mLTH.traceInfo("Capabilities set volumecreation false");
                    }
                    if (mSSA.contains(new UnsignedInt16(6))) {
                        pCap.setVolumeDeletionSupported(true);
                        mLTH.traceInfo("Capabilities set volume deletion true");
                        continue;
                    }
                    pCap.setVolumeDeletionSupported(false);
                    mLTH.traceInfo("Capabilities set volume deletion false");
                }
            }
        }
        finally {
            mLTH.exit((Object)pCap);
        }
        return pCap;
    }

    protected void getSpecificDataForDevice(CIMInstance pInstance, StorageDeviceData pData) throws DiscoveryException {
    }

    protected void getSpecificDataForNode(CIMInstance pInstance, StorageDeviceData pData) throws DiscoveryException {
    }

    protected void saveSpecificData(StorageDeviceData pData, LogTraceHelper pLTH, MapperRouter pMapperRouter, String pSMISVersion, String pScannID, Hashtable pReturnValue) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUsedProfile(CIMInstance mProfileInstance) {
        String mText;
        String mType;
        String mName;
        LogTraceHelper mLTH;
        block5: {
            block4: {
                boolean bl;
                mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)"isUsedProfile", (Object[])new Object[]{mProfileInstance});
                mName = null;
                mType = null;
                mText = null;
                try {
                    if (mProfileInstance != null) break block4;
                    mText = " CIMInstance was null!  ";
                    bl = false;
                }
                catch (Throwable throwable) {
                    mLTH.exit((Object)(mName + mText + mType));
                    throw throwable;
                }
                mLTH.exit((Object)(mName + mText + mType));
                return bl;
            }
            mName = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mProfileInstance, (String)"RegisteredName");
            mType = (String)this.cParameters.get("Type");
            if ((mName.indexOf("Array") < 0 && mName.indexOf("In Band Virtualization") < 0 || !this.isComputersystemType() && !this.isAllType()) && (mName.indexOf("Switch") < 0 || !this.isSwitchType() && !this.isAllType()) && (mName.indexOf("Storage Library") < 0 || !this.isTapeLibraryType() && !this.isAllType())) break block5;
            mText = " is used for type ";
            boolean bl = true;
            mLTH.exit((Object)(mName + mText + mType));
            return bl;
        }
        mText = " is not used for type ";
        boolean bl = false;
        mLTH.exit((Object)(mName + mText + mType));
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean supportsSubProfile(String pSource, String pSubProfileName) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)"supportsSubProfile", (Object[])new Object[]{pSource, pSubProfileName});
        boolean mReturn = false;
        try {
            mReturn = pSource != null && pSource.indexOf(pSubProfileName) >= 0;
            boolean bl = mReturn;
            return bl;
        }
        finally {
            mLTH.exit((Object)new Boolean(mReturn));
        }
    }

    protected Capabilities correctCapabilities(StorageDeviceData pData) {
        return pData.getCapabilities();
    }

    protected String correctSubProfileString(String pData) {
        return pData;
    }

    public final boolean isTapeLibraryType() {
        String mType = (String)this.cParameters.get("Type");
        return mType.equals("ToplevelLibrary");
    }

    public final boolean isAllType() {
        String mType = (String)this.cParameters.get("Type");
        return mType.equals("ToplevelALL");
    }

    public final boolean isComputersystemType() {
        String mType = (String)this.cParameters.get("Type");
        return mType.equals("ToplevelStorageSubsystem");
    }

    public final boolean isSwitchType() {
        String mType = (String)this.cParameters.get("Type");
        return mType.equals("ToplevelSwitch");
    }

    protected boolean checkCIMOMVersion(String pCIMOMVersion) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)"ProcessPlugin.checkCIMOMVersion", (Object[])new Object[]{pCIMOMVersion});
        boolean mReturn = true;
        mLTH.exit((Object)new Boolean(mReturn));
        return mReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readRegExForCIMOMExclusion(String pType, LogTraceHelper pLTH) {
        String mReturn = null;
        DBConnection mConn = null;
        try {
            mConn = ServiceUtils.getConnection();
            ConfigData mConfigData = ParameterHelper.readConfigData((DBConnection)mConn, (String)pType, (LogTraceHelper)pLTH);
            if (mConfigData != null) {
                mReturn = mConfigData.getValue();
            }
            pLTH.traceInfo("readRegExForCIMOMExclusion is not used for type :" + pType);
        }
        finally {
            if (mConn != null) {
                try {
                    mConn.close();
                }
                catch (SQLException pEx1) {}
            }
            return mReturn;
        }
    }

    protected String readCimomExclusion(LogTraceHelper pLTH) {
        return "";
    }
}

