/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.DiskDriveIndicationHandler;
import org.eclipse.aperi.disk.monitor.DiskMonitorHelper;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetection;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMInstance;

public class DiskDriveModificationHandler
extends DiskDriveIndicationHandler
implements ICIMIndicationHandler {
    public static CIMIndicationHandler.RegistrationData[] getRegistrationData() {
        CIMIndicationHandler.RegistrationData mR1 = new CIMIndicationHandler.RegistrationData("CIM_DiskDrive", "CIM_InstModification");
        return new CIMIndicationHandler.RegistrationData[]{mR1};
    }

    public DiskDriveModificationHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        super(pIndicationClassname, pCIMClassname, pEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlingResult handle(LogTraceHelper pLTH, String pProcessID) {
        CIMInstance mToplevelSystem;
        CIMInstance mDiskDrive;
        try {
            mDiskDrive = this.getEvent().getSourceInstance();
            mToplevelSystem = this.getTopLevelSystemInstance(mDiskDrive);
        }
        catch (DiskManagerTimeoutException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MapperRouter mRouter = MapperRouter.getMapperRouter();
        Hashtable mParamsToplevelSystem = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)mToplevelSystem);
        String mServiceUrl = this.getEvent().getCIMOM().getServiceUrl();
        mParamsToplevelSystem.put("ref_serviceurl", mServiceUrl);
        mParamsToplevelSystem.put("ref_namespace", mToplevelSystem.getObjectPath().getNameSpace());
        Hashtable mParamsDiskDrive = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)mDiskDrive);
        mParamsDiskDrive.put("ref_serviceurl", mServiceUrl);
        mParamsDiskDrive.put("ref_namespace", mDiskDrive.getObjectPath().getNameSpace());
        IDBAttributeMapper mToplevelSystemMapper = mRouter.findMapper(mToplevelSystem.getClassName(), "1.0.2", null, null, "15", "CIM_ComputerSystem");
        IDBAttributeMapper mDiskDriveMapper = mRouter.findMapper(this.getCIMClassname(), "1.0.2", null, null, null, "CIM_DiskDrive");
        try {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            ChangeDetection mChangeDetection = null;
            try {
                mChangeDetection = new ChangeDetection(mConnection);
                try {
                    HashMap mTouchedEntities = new HashMap();
                    MapperResult mMapperResult = mToplevelSystemMapper.persist(mConnection, mParamsToplevelSystem, pProcessID);
                    DiskMonitorHelper.addEntriesToInternalList(mTouchedEntities, MapperResult.convertRowsToIdentifiers((Map)mMapperResult.getInsertedRows()));
                    DiskMonitorHelper.addEntriesToInternalList(mTouchedEntities, MapperResult.convertRowsToIdentifiers((Map)mMapperResult.getUpdatedRows()));
                    mParamsDiskDrive.putAll(mMapperResult.getKeyReferences());
                    mDiskDriveMapper.persist(mConnection, mParamsDiskDrive, pProcessID);
                    DiskMonitorHelper.addEntriesToInternalList(mTouchedEntities, MapperResult.convertRowsToIdentifiers((Map)mMapperResult.getInsertedRows()));
                    DiskMonitorHelper.addEntriesToInternalList(mTouchedEntities, MapperResult.convertRowsToIdentifiers((Map)mMapperResult.getUpdatedRows()));
                    mConnection.commit();
                    mChangeDetection.complete(mConnection, mTouchedEntities, pProcessID);
                    mConnection.commit();
                    Processor.getEventMonitorProxy().handleModelUpdate(pProcessID);
                }
                catch (Exception e) {
                    try {
                        pLTH.traceError("Database update failed, calling rollback()", (Throwable)e);
                        mConnection.rollback();
                    }
                    finally {
                        mChangeDetection.cancel();
                    }
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return HandlingResult.SUCCESS;
    }
}

