/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.DiskEventQueue;
import org.eclipse.aperi.disk.monitor.DiskIndicationHandlerFactory;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class DiskWorkerThread
extends Thread {
    private volatile boolean cShutdown = false;
    private Thread cThread = null;
    private DiskEventQueue cWorkerQueue = null;

    public DiskWorkerThread(DiskEventQueue pWorkerQueue) {
        this.cWorkerQueue = pWorkerQueue;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"run", null);
        try {
            this.cThread = Thread.currentThread();
            while (!this.cShutdown) {
                try {
                    CIMIndicationEvent bIndication = this.cWorkerQueue.remove();
                    mLTH.traceInfo("DiskWorkerThread is processing new indication");
                    this.processIndication(bIndication);
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    try {
                        mLTH.traceError("Exception in DiskWorkerThread", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                }
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIndication(CIMIndicationEvent pIndication) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"processIndication", (Object[])new Object[]{pIndication});
        try {
            CIMInstance mIndicationInstance = pIndication.getCIMInstance();
            String mIndicationClassname = mIndicationInstance.getClassName();
            String mIndicationTime = mIndicationInstance.getProperty("IndicationTime").getValue().toString();
            CIMObjectPath mSourceCop = pIndication.getSourceCop();
            if (mSourceCop != null) {
                String mSourceClassname = mSourceCop.getObjectName();
                mLTH.traceAlways("disk worker thread identified indication as " + mIndicationClassname + " for " + mSourceCop.toString() + " issued on" + mIndicationTime);
                ICIMIndicationHandler bHandler = DiskIndicationHandlerFactory.getInstance().getHandler(mIndicationClassname, mSourceClassname, pIndication);
                HandlingResult bHandlingResult = bHandler.handleCIMIndication();
            } else {
                mLTH.traceWarning("disk worker thread identified indication as " + mIndicationClassname + " issued on" + mIndicationTime + "; no action taken");
            }
        }
        catch (Exception e) {
            mLTH.traceError("Exception caught in processIndication()", (Throwable)e);
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"shutdown", null);
        try {
            this.cShutdown = true;
            if (this.cThread != null) {
                try {
                    this.cThread.interrupt();
                    this.cThread.join(30000L);
                    this.cThread = null;
                }
                catch (Exception pEx) {
                    mLTH.traceError("DiskWorkerThread got a " + pEx.getMessage() + " while shutting down", (Throwable)pEx);
                }
            }
        }
        finally {
            mLTH.exit(null);
        }
    }
}

