/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.ESSPhysicalPackageIndicationHandler;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.DiskGroup;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.database.tables.TResDiskGroupTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalVolumeTable;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMObjectPath;

public class ESSPhysicalPackageDeletionHandler
extends ESSPhysicalPackageIndicationHandler
implements ICIMIndicationHandler {
    public static CIMIndicationHandler.RegistrationData[] getRegistrationData() {
        CIMIndicationHandler.RegistrationData mR1 = new CIMIndicationHandler.RegistrationData("IBMTSESS_PhysicalPackage", "CIM_InstDeletion");
        return new CIMIndicationHandler.RegistrationData[]{mR1};
    }

    public ESSPhysicalPackageDeletionHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        super(pIndicationClassname, pCIMClassname, pEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlingResult handle(LogTraceHelper pLTH, String pProcessID) {
        block11: {
            CIMObjectPath mCop = this.getEvent().getSourceCop();
            String mInstanceId = (String)mCop.getKey("Tag").getValue().getValue();
            String mCimomId = this.getEvent().getCIMOM().getServiceId();
            String mNamespace = this.getEvent().getCIMNameSpace();
            try {
                DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                try {
                    DiskGroup mDiskGroup = this.getDiskGroup(mConnection, mInstanceId);
                    if (mDiskGroup == null) break block11;
                    PhysicalVolume[] mAffectedPhysicalVolumes = this.getAffectedPhysicalVolumes(mConnection, mDiskGroup.getDiskGroupId());
                    try {
                        ArrayList<String> mVolumeIds = new ArrayList<String>();
                        for (int bI = 0; bI < mAffectedPhysicalVolumes.length; ++bI) {
                            mAffectedPhysicalVolumes[bI].delete(mConnection);
                            mVolumeIds.add(Integer.toString(mAffectedPhysicalVolumes[bI].getPhysicalVolumeId()));
                        }
                        mDiskGroup.delete(mConnection);
                        LinkedList<String> mDiskGroupIds = new LinkedList<String>();
                        mDiskGroupIds.add(Integer.toString(mDiskGroup.getDiskGroupId()));
                        mConnection.commit();
                        HashMap<String, AbstractList> mTouchedEntities = new HashMap<String, AbstractList>();
                        mTouchedEntities.put(TResDiskGroupTable.getTablename(), mDiskGroupIds);
                        mTouchedEntities.put(TResPhysicalVolumeTable.getTablename(), mVolumeIds);
                        Processor.getEventMonitorProxy().handleDeviceStateChange(pProcessID, DiskGroup.getTablename(), Integer.toString(mDiskGroup.getDiskGroupId()), 1, 0);
                        Processor.getEventMonitorProxy().handleModelUpdate(pProcessID);
                    }
                    catch (Exception e) {
                        pLTH.traceError("Database update failed, calling rollback()", (Throwable)e);
                        mConnection.rollback();
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    if (mConnection != null) {
                        mConnection.close();
                    }
                }
            }
            catch (SQLException pE) {
                throw new RuntimeException(pE);
            }
        }
        return HandlingResult.SUCCESS;
    }
}

