/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.discovery.parser.AlertProcessor;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.PoolIndicationHandler;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;

public class PoolCreationHandler
extends PoolIndicationHandler
implements ICIMIndicationHandler {
    public static CIMIndicationHandler.RegistrationData[] getRegistrationData() {
        CIMIndicationHandler.RegistrationData mR1 = new CIMIndicationHandler.RegistrationData("CIM_StoragePool", "CIM_InstCreation");
        CIMIndicationHandler.RegistrationData mR2 = new CIMIndicationHandler.RegistrationData("IBMTSESS_VolumeSpace", "CIM_InstCreation");
        CIMIndicationHandler.RegistrationData mR3 = new CIMIndicationHandler.RegistrationData("IBMTSSVC_StoragePool", "CIM_InstCreation");
        return new CIMIndicationHandler.RegistrationData[]{mR1, mR2, mR3};
    }

    public PoolCreationHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        super(pIndicationClassname, pCIMClassname, pEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlingResult handle(LogTraceHelper pLTH, String pProcessID) {
        CIMInstance mStorageSystem;
        CIMInstance mPool;
        try {
            mPool = this.getEvent().getSourceInstance();
            mStorageSystem = this.getTopLevelSystemInstance(mPool);
        }
        catch (CIMException e) {
            throw new RuntimeException(e);
        }
        catch (DiskManagerTimeoutException e) {
            throw new RuntimeException(e);
        }
        IDBAttributeMapper mAttributeMapperStorageSubsystem = MapperRouter.getMapperRouter().findMapper(mStorageSystem.getClassName(), "1.0.2", null, null, "15", "CIM_ComputerSystem");
        IDBAttributeMapper mAttributeMapperPool = MapperRouter.getMapperRouter().findMapper(this.getCIMClassname(), "1.0.2", null, null, null, "CIM_StoragePool");
        String mServiceUrl = this.getEvent().getCIMOM().getServiceUrl();
        Hashtable mParamsStorageSystem = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)mStorageSystem);
        mParamsStorageSystem.put("ref_serviceurl", mServiceUrl);
        mParamsStorageSystem.put("ref_namespace", mStorageSystem.getObjectPath().getNameSpace());
        Hashtable mParamsPool = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)mPool);
        mParamsPool.put("ref_serviceurl", mServiceUrl);
        mParamsPool.put("ref_namespace", mPool.getObjectPath().getNameSpace());
        mParamsPool.put("ref_classname", this.getCIMClassname());
        try {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                try {
                    MapperResult mMapperResult = mAttributeMapperStorageSubsystem.persist(mConnection, mParamsStorageSystem, pProcessID);
                    mParamsPool.putAll(mMapperResult.getKeyReferences());
                    mMapperResult = mAttributeMapperPool.persist(mConnection, mParamsPool, pProcessID);
                    mConnection.commit();
                    AlertProcessor.processAlerts((String)pProcessID, (MapperResult)mMapperResult, new Hashtable(), new Hashtable());
                    Processor.getEventMonitorProxy().handleModelUpdate(pProcessID);
                }
                catch (Exception e) {
                    mConnection.rollback();
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return HandlingResult.SUCCESS;
    }
}

