/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.discovery.parser.AlertProcessor;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.api.impl.DiskManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.VolumeIndicationHandler;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;

public class VolumeCreationHandler
extends VolumeIndicationHandler
implements ICIMIndicationHandler {
    public static CIMIndicationHandler.RegistrationData[] getRegistrationData() {
        CIMIndicationHandler.RegistrationData mR1 = new CIMIndicationHandler.RegistrationData("CIM_StorageVolume", "CIM_InstCreation");
        CIMIndicationHandler.RegistrationData mR2 = new CIMIndicationHandler.RegistrationData("IBMTSESS_Volume", "CIM_InstCreation");
        CIMIndicationHandler.RegistrationData mR3 = new CIMIndicationHandler.RegistrationData("IBMTSSVC_StorageVolume", "CIM_InstCreation");
        return new CIMIndicationHandler.RegistrationData[]{mR1, mR2, mR3};
    }

    public VolumeCreationHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        super(pIndicationClassname, pCIMClassname, pEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlingResult handle(LogTraceHelper pLTH, String pProcessID) {
        HandlingResult handlingResult;
        block10: {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                MapperResult mMapperResult;
                CIMInstance mEntityInstance = this.getEvent().getSourceInstance();
                CIMInstance mStorageSystemInstance = this.getTopLevelSystemInstance(mEntityInstance);
                CIMInstance mStoragePoolInstance = this.getPoolInstance(mEntityInstance);
                String mServiceUrl = this.getEvent().getCIMOM().getServiceUrl();
                String mEntityNamespace = mEntityInstance.getObjectPath().getNameSpace();
                String mStorageSystemNamespace = mStorageSystemInstance.getObjectPath().getNameSpace();
                String mName = (String)mStorageSystemInstance.getProperty("Name").getValue().getValue();
                short mNameFormat = Short.parseShort(DBConstants.getValueFromKey((String)"SMISName_Format", (String)((String)mStorageSystemInstance.getProperty("NameFormat").getValue().getValue()).toLowerCase()));
                StorageSubsystem mStorageSystem = new StorageSubsystem();
                mStorageSystem.setName(mName);
                mStorageSystem.setNameFormat(mNameFormat);
                mStorageSystem.retrieve(mConnection);
                Hashtable mParamsStorageSystem = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)mStorageSystemInstance);
                mParamsStorageSystem.put("ref_serviceurl", mServiceUrl);
                mParamsStorageSystem.put("ref_namespace", mStorageSystemNamespace);
                Hashtable mParamsStoragePool = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)mStoragePoolInstance);
                mParamsStoragePool.put("ref_serviceurl", mServiceUrl);
                mParamsStoragePool.put("ref_namespace", mEntityNamespace);
                mParamsStoragePool.put("ref_classname", mStoragePoolInstance.getClassName());
                Hashtable mParamsEntity = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)mEntityInstance);
                mParamsEntity.put("ref_serviceurl", mServiceUrl);
                mParamsEntity.put("ref_namespace", mEntityNamespace);
                MapperRouter mMapperRouter = MapperRouter.getMapperRouter();
                IDBAttributeMapper mMapperStorageSystem = mMapperRouter.findMapper(mStorageSystemInstance.getClassName(), "1.0.2", null, null, "15", "CIM_ComputerSystem");
                IDBAttributeMapper mMapperStoragePool = mMapperRouter.findMapper(mStoragePoolInstance.getClassName(), "1.0.2", null, null, null, "CIM_StoragePool");
                IDBAttributeMapper mMapperVolume = mMapperRouter.findMapper(this.getCIMClassname(), "1.0.2", null, null, null, "CIM_StorageVolume");
                try {
                    mMapperResult = mMapperStorageSystem.persist(mConnection, mParamsStorageSystem, pProcessID);
                    mParamsEntity.putAll(mMapperResult.getKeyReferences());
                    mParamsStoragePool.putAll(mMapperResult.getKeyReferences());
                    mMapperResult = mMapperStoragePool.persist(mConnection, mParamsStoragePool, pProcessID);
                    mParamsEntity.putAll(mMapperResult.getKeyReferences());
                    mMapperResult = mMapperVolume.persist(mConnection, mParamsEntity, pProcessID);
                    mConnection.commit();
                    AlertProcessor.processAlerts((String)pProcessID, (MapperResult)mMapperResult, new Hashtable(), new Hashtable());
                    Processor.getEventMonitorProxy().handleModelUpdate(pProcessID);
                }
                catch (Exception e) {
                    pLTH.traceError("Database update failed, calling rollback()", (Throwable)e);
                    mConnection.rollback();
                    throw new RuntimeException(e);
                }
                Hashtable mAllRows = mMapperResult.getAllRows();
                Hashtable mStorageVolumeRow = (Hashtable)mAllRows.get(StorageVolume.getTablename());
                String mVolumeName = (String)mStorageVolumeRow.get(StorageVolume.getColumnInfo((String)"NAME"));
                String mVolumeNameFormat = (String)mStorageVolumeRow.get(StorageVolume.getColumnInfo((String)"NAME_FORMAT"));
                String mVolumeId = ExternalKeyConverter.frameKeyStorageVolume((String)mVolumeName, (short)Short.parseShort(mVolumeNameFormat), (String)mStorageSystem.getName(), (short)mStorageSystem.getNameFormat());
                DiskManager.getInstance().probeStorageVolume(String.valueOf(mStorageSystem.getName() + "+" + String.valueOf(mStorageSystem.getNameFormat())), mVolumeId, 2);
                handlingResult = HandlingResult.SUCCESS;
                if (mConnection == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (mConnection != null) {
                        mConnection.close();
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                catch (CIMException e) {
                    throw new RuntimeException(e);
                }
                catch (DiskManagerTimeoutException e) {
                    throw new RuntimeException(e);
                }
            }
            mConnection.close();
        }
        return handlingResult;
    }
}

