/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi;

import java.util.Map;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.DiscoveryActivator;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.interfaces.DiscoverRequest;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMTransportException;

public abstract class DiscoverProcess
implements Cloneable,
IDiscoverProcess {
    private DiscoverRequest cRequest = null;
    private String cDescription = null;
    private boolean cIsMainProcess = false;

    public DiscoverProcess(String pDescription, boolean pIsMainProcess, String[] pParameters, String[] pParameterTypes) {
        this.cRequest = new DiscoverRequest(pDescription, pParameters, pParameterTypes);
        this.cDescription = pDescription;
        this.cIsMainProcess = pIsMainProcess;
    }

    protected IDiscoverRouterService getDiscoverRouterService() {
        return (IDiscoverRouterService)DiscoveryActivator._serviceHelper.bindLocalOSGiService(IDiscoverRouterService.class.getName());
    }

    public DiscoverRequest getRequest() {
        return this.cRequest;
    }

    public boolean isMainProcess() {
        return this.cIsMainProcess;
    }

    public String getDescription() {
        return this.cDescription;
    }

    public String[] getParameterNames() {
        Map mParameters = this.cRequest.getParameters();
        return mParameters.keySet().toArray(new String[mParameters.size()]);
    }

    public String getParameterType(String pParameter) {
        return this.cRequest.getParameterType(pParameter);
    }

    public abstract Result process(Request var1, Map var2) throws ParameterException, Exception;

    public Object getParameter(String pParameter) {
        return this.cRequest.getParameter(pParameter);
    }

    public static Object getParameter(Map pParameters, String pParameter, String pClass) throws ParameterException {
        Object mObj = pParameters.get(pParameter);
        if (mObj == null) {
            throw new ParameterException("Parameter " + pParameter + " is missing.");
        }
        try {
            if (!Class.forName(pClass).isInstance(mObj)) {
                throw new ParameterException("Parameter " + pParameter + "(" + mObj.getClass().getName() + ") is not of type " + pClass);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new ParameterException("Class named " + pClass + " is not defined");
        }
        return mObj;
    }

    public boolean checkParameters(Map pParameters) throws ParameterException {
        Map mParameters = this.cRequest.getParameters();
        if (mParameters.size() != pParameters.size()) {
            throw new ParameterException("Not all parameters are specified.");
        }
        for (String bName : pParameters.keySet()) {
            String bType = (String)pParameters.get(bName);
            DiscoverProcess.getParameter(pParameters, bName, bType);
        }
        return true;
    }

    public String toString() {
        StringBuffer mBuffer = new StringBuffer();
        mBuffer.append("DiscoverProcess: " + this.cDescription + "\n");
        Map mParameters = this.cRequest.getParameters();
        for (String bName : mParameters.keySet()) {
            String bType = (String)mParameters.get(bName);
            mBuffer.append("   " + bName + " of type " + bType + "\n");
        }
        return mBuffer.toString();
    }

    public String getScannerId(Map pProperties) throws ParameterException {
        return null;
    }

    public int getAuthoritativeReferenceType(Map pProperties) throws ParameterException {
        return -1;
    }

    public int getAuthoritativeReferenceId(Map pProperties) throws ParameterException {
        return -1;
    }

    public String getProcessInfoForJobLog(Map parameters) {
        return null;
    }

    public String getComputerForJobLog(Map parameters) {
        return null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public void checkException(Throwable pEx, LogTraceHelper pLTH, Map pParameters) {
        if (pEx != null) {
            if (pEx instanceof CIMException) {
                if (pEx.getMessage().indexOf("ERR_TIME_OUT") > 0) {
                    pLTH.traceError("CIMOM timout Failure", pEx);
                    pLTH.logMsg("HWN021650E", new Object[]{((String[])pParameters.get("CIMOM"))[0]});
                } else if (pEx instanceof CIMTransportException) {
                    pLTH.traceError("CIMOM Connection Failure", pEx);
                    pLTH.logMsg("HWN021537E", new Object[]{((String[])pParameters.get("CIMOM"))[0], pEx.getMessage()});
                } else {
                    pLTH.traceError("CIMOM Exception", pEx);
                    pLTH.logMsg("HWN021529E", new Object[]{((String[])pParameters.get("CIMOM"))[0]});
                }
            } else if (pEx instanceof DiskManagerTimeoutException) {
                pLTH.traceError("CIMOM timout Failure", pEx);
                pLTH.logMsg("HWN021650E", new Object[]{((String[])pParameters.get("CIMOM"))[0]});
            } else {
                Throwable bCauseEx;
                Throwable bInnerCause;
                for (bInnerCause = bCauseEx = pEx.getCause(); bInnerCause != null && !(bInnerCause instanceof CIMException); bInnerCause = bInnerCause.getCause()) {
                }
                if (bInnerCause != null) {
                    bCauseEx = bInnerCause;
                }
                if (bCauseEx != null) {
                    if (bCauseEx instanceof CIMException) {
                        if (pEx.getMessage().indexOf("ERR_TIME_OUT") > 0) {
                            pLTH.traceError("CIMOM timout Failure", bCauseEx);
                            pLTH.logMsg("HWN021650E", new Object[]{((String[])pParameters.get("CIMOM"))[0]});
                        } else if (pEx.getMessage().indexOf("EXT_ERR_UNABLE_TO_CONNECT") > 0) {
                            pLTH.traceError("CIMOM connection Failure", bCauseEx);
                            pLTH.logMsg("HWN021537E", new Object[]{((String[])pParameters.get("CIMOM"))[0], bCauseEx.getMessage()});
                        } else if (bCauseEx instanceof CIMTransportException) {
                            pLTH.traceError("CIMOM Connection Failure", bCauseEx);
                            pLTH.logMsg("HWN021537E", new Object[]{((String[])pParameters.get("CIMOM"))[0], bCauseEx.getMessage()});
                        } else {
                            pLTH.traceError("CIMOM Exception", bCauseEx);
                            pLTH.logMsg("HWN021529E", new Object[]{((String[])pParameters.get("CIMOM"))[0]});
                        }
                    } else if (bCauseEx instanceof DiskManagerTimeoutException) {
                        pLTH.traceError("CIMOM timout Failure", bCauseEx);
                        pLTH.logMsg("HWN021650E", new Object[]{((String[])pParameters.get("CIMOM"))[0]});
                    } else {
                        pLTH.traceError("Unexpected error ", bCauseEx);
                        pLTH.logMsg("HWN021503E", null);
                    }
                } else {
                    pLTH.traceError("Unexpected error ", pEx);
                    pLTH.logMsg("HWN021503E", null);
                }
            }
        }
    }

    public static class RegistrationData {
        private String mName;
        private String mSmisVersion;
        private String mProfile;
        private String mVendor;
        private String mModel;
        private String mInstrumentationVersion;

        public RegistrationData(String aName, String aSmis, String aProfile, String aVendor, String aModel, String aInstrumentation) {
            if (aName == null || aName.trim().length() == 0) {
                throw new NullPointerException("Name must be neither null nor whitespace only.");
            }
            this.mName = aName;
            this.mSmisVersion = aSmis;
            this.mProfile = aProfile;
            this.mVendor = aVendor;
            this.mModel = aModel;
            this.mInstrumentationVersion = aInstrumentation;
        }

        public String getInstrumentationVersion() {
            return this.mInstrumentationVersion;
        }

        public String getModel() {
            return this.mModel;
        }

        public String getName() {
            return this.mName;
        }

        public String getProfile() {
            return this.mProfile;
        }

        public String getSmisVersion() {
            return this.mSmisVersion;
        }

        public String getVendor() {
            return this.mVendor;
        }

        public boolean equals(Object aObj) {
            if (aObj instanceof RegistrationData) {
                RegistrationData rhs = (RegistrationData)aObj;
                return this.mName.equals(rhs.mName) && this.mSmisVersion.equals(rhs.mSmisVersion) && this.mProfile.equals(rhs.mProfile) && this.mVendor.equals(rhs.mVendor) && this.mModel.equals(rhs.mModel) && this.mInstrumentationVersion.equals(rhs.mInstrumentationVersion);
            }
            return false;
        }
    }
}

