/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.discovery.DiscoveryActivator;
import org.eclipse.aperi.discovery.IProgressLogger;
import org.eclipse.aperi.discovery.NullProgressLogger;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.sblim.wbem.util.GlobalProperties;

public class DiscoverStep
implements IStep {
    public static final String MESSAGE_NAME = "aperi.logger.message.DiscoverProcess";
    public static final String TRACE_NAME = "aperi.logger.trace.DiscoverProcess";
    protected static String className = DiscoverStep.class.getName();
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;
    private String cmd = null;
    private String instanceName = null;
    private boolean fetchAll = false;
    private CIMProcessor processor = null;
    private ArrayList steps = new ArrayList();
    private IProgressLogger progressLogger;
    private static IConfigService configServiceProxy;
    public static final String PROPERTY_FETCH_ENABLED = "CIM.fetchAll";
    public static final String PROPERTY_GROUP = "DiscoverService";
    private static Boolean fetchAllEnabled;
    private LogTraceHelper cLTH = null;

    public DiscoverStep(String cmd, String instanceName, CIMProcessor processor) {
        this.cmd = cmd;
        this.instanceName = instanceName;
        this.processor = processor;
        this.progressLogger = NullProgressLogger.NULL_LOGGER;
    }

    public DiscoverStep(String cmd, String instanceName, CIMProcessor processor, boolean fetchAll) {
        this.cmd = cmd;
        this.instanceName = instanceName;
        this.processor = processor;
        this.progressLogger = NullProgressLogger.NULL_LOGGER;
        if (fetchAll) {
            this.fetchAll = DiscoverStep.isFetchAllEnabled() && GlobalProperties.getXmlParser() == 0;
        }
    }

    public DiscoverStep(String cmd, String instanceName, CIMProcessor processor, LogTraceHelper pLTH) {
        this.cmd = cmd;
        this.instanceName = instanceName;
        this.processor = processor;
        this.progressLogger = NullProgressLogger.NULL_LOGGER;
        if (pLTH != null) {
            this.cLTH = pLTH;
        }
    }

    public DiscoverStep(String pCmd, String pInstanceName, CIMProcessor pProcessor, IProgressLogger pProgressLogger) {
        this.cmd = pCmd;
        this.instanceName = pInstanceName;
        this.processor = pProcessor;
        this.progressLogger = pProgressLogger != null ? pProgressLogger : NullProgressLogger.NULL_LOGGER;
    }

    public void setProgressLogger(IProgressLogger pProgressLogger) {
        this.progressLogger = pProgressLogger != null ? pProgressLogger : NullProgressLogger.NULL_LOGGER;
    }

    public void addNextStep(IStep step) {
        this.steps.add(step);
    }

    /*
     * Exception decompiling
     */
    public boolean process(String discoverRequest, Map parameters) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getCmd() {
        return this.cmd;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String toString() {
        return (this.cmd != null ? this.cmd : "null") + "/" + (this.instanceName != null ? this.instanceName : "null") + (this.steps != null ? this.steps.toString() : "[]");
    }

    public static boolean isFetchAllEnabled() {
        if (fetchAllEnabled == null) {
            fetchAllEnabled = new Boolean(true);
            String property = DiscoverStep.getConfigServiceProxy().getProperty(PROPERTY_FETCH_ENABLED, PROPERTY_GROUP);
            if (property != null) {
                try {
                    fetchAllEnabled = Boolean.valueOf(property);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return fetchAllEnabled;
    }

    public static IConfigService getConfigServiceProxy() {
        if (configServiceProxy == null) {
            configServiceProxy = (IConfigService)DiscoveryActivator._serviceHelper.bindLocal("ConfigService");
        }
        return configServiceProxy;
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        configServiceProxy = null;
        fetchAllEnabled = null;
    }
}

