/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.interfaces.DiscoverRequest;
import org.eclipse.aperi.interfaces.EnumeratedResponse;
import org.eclipse.aperi.interfaces.ParameterException;

public class EnumeratedResponseCollaterStep
implements IStep {
    private ArrayList keyNames_ = new ArrayList();
    private ArrayList keyTypes_ = new ArrayList();
    public static final String ENUMRESPONSE = "ENUMERATE RESPONSE";
    public static final int TPCASYNCRESULT_DEFAULT_RC = 0;
    public static final int ENUM_RESPONSE_DEFAULT_SIZE = 10;

    public EnumeratedResponseCollaterStep(Object[] keyNames, Object[] keyTypes) {
        this.keyNames_.addAll(Arrays.asList(keyNames));
        this.keyTypes_.addAll(Arrays.asList(keyTypes));
    }

    public EnumeratedResponseCollaterStep(Object[] keyNames) {
        this.keyNames_.addAll(Arrays.asList(keyNames));
    }

    public void addNextStep(IStep step) {
    }

    public boolean process(String discoverRequest, Map parameters) {
        ArrayList retList = new ArrayList(this.keyNames_.size());
        EnumeratedResponse eResponse = null;
        boolean noErrorsOccured = true;
        try {
            eResponse = EnumeratedResponseCollaterStep.retrieveEnumeratedResponse(parameters);
            String keyName2 = null;
            int count = 0;
            for (String keyName2 : this.keyNames_) {
                retList.add(parameters.get(keyName2));
                ++count;
            }
        }
        catch (ParameterException e) {
            e.printStackTrace();
            noErrorsOccured = false;
        }
        catch (NullPointerException np) {
            np.printStackTrace();
            noErrorsOccured = false;
        }
        eResponse.add(retList);
        eResponse.readyForNext();
        return noErrorsOccured;
    }

    public static EnumeratedResponse allocateReturnArea(Request request) {
        AsyncResult asyncResult = new AsyncResult(0, 2);
        EnumeratedResponse enumResponse = EnumeratedResponseCollaterStep.allocateReturnArea(asyncResult);
        ServiceUtils.activeJobs.put(request.getDeviceServerRunNumber(), asyncResult);
        return enumResponse;
    }

    public static EnumeratedResponse allocateReturnArea(AsyncResult asyncResult) {
        EnumeratedResponse enumResponse = new EnumeratedResponse(asyncResult, 10);
        asyncResult.setResults(new Object[]{enumResponse});
        return enumResponse;
    }

    public static void placeEnumeratedResponse(EnumeratedResponse enumeratedResponse, Map parameters) {
        parameters.put(ENUMRESPONSE, enumeratedResponse);
    }

    public static EnumeratedResponse retrieveEnumeratedResponse(Map parameters) throws ParameterException {
        EnumeratedResponse eResponse = (EnumeratedResponse)DiscoverRequest.getParameter((Map)parameters, (String)ENUMRESPONSE, (String)EnumeratedResponse.class.getName());
        return eResponse;
    }
}

